/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.containerview;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.TextFieldCompletionProvider;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.debugger.ArrayChunk;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.PyFrameAccessor;
import com.jetbrains.python.debugger.array.AsyncArrayTableModel;
import com.jetbrains.python.debugger.array.JBTableWithRowHeaders;
import com.jetbrains.python.debugger.containerview.ColoredCellRenderer;
import com.jetbrains.python.debugger.containerview.DataViewStrategy;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyDataViewerPanel
extends JPanel {
    private static final Logger LOG = Logger.getInstance(PyDataViewerPanel.class);
    private final Project myProject;
    @NotNull
    private final PyFrameAccessor myFrameAccessor;
    private EditorTextField mySliceTextField;
    private JBTableWithRowHeaders myTable;
    private EditorTextField myFormatTextField;
    private JPanel myMainPanel;
    private JBLabel myErrorLabel;
    private JBScrollPane myScrollPane;
    private boolean myColored;
    List<Listener> myListeners;

    public PyDataViewerPanel(@NotNull Project project, @NotNull PyFrameAccessor frameAccessor) {
        if (project == null) {
            PyDataViewerPanel.$$$reportNull$$$0(0);
        }
        if (frameAccessor == null) {
            PyDataViewerPanel.$$$reportNull$$$0(1);
        }
        super(new BorderLayout());
        this.myProject = project;
        this.myFrameAccessor = frameAccessor;
        this.$$$setupUI$$$();
        this.myErrorLabel.setVisible(false);
        this.myErrorLabel.setForeground((Color)JBColor.RED);
        this.myMainPanel.setBorder(new EmptyBorder(20, 20, 20, 20));
        this.add((Component)this.myMainPanel, "Center");
        this.myColored = PropertiesComponent.getInstance((Project)this.myProject).getBoolean("python.debugger.dataview.coloredbydefault", true);
        this.myListeners = new CopyOnWriteArrayList<Listener>();
        this.setupChangeListener();
    }

    private void setupChangeListener() {
        this.myFrameAccessor.addFrameListener(() -> ApplicationManager.getApplication().executeOnPooledThread(() -> this.updateModel()));
    }

    private void updateModel() {
        AsyncArrayTableModel model = this.getModel();
        if (model == null) {
            return;
        }
        model.invalidateCache();
        this.updateDebugValue(model);
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.isShowing()) {
                model.fireTableDataChanged();
            }
        });
    }

    private void updateDebugValue(@NotNull AsyncArrayTableModel model) {
        PyDebugValue oldValue;
        if (model == null) {
            PyDataViewerPanel.$$$reportNull$$$0(2);
        }
        if (!(oldValue = model.getDebugValue()).isTemporary()) {
            return;
        }
        PyDebugValue newValue = this.getDebugValue(this.mySliceTextField.getText());
        if (newValue != null) {
            model.setDebugValue(newValue);
        }
    }

    @NotNull
    public PyFrameAccessor getFrameAccessor() {
        PyFrameAccessor pyFrameAccessor = this.myFrameAccessor;
        if (pyFrameAccessor == null) {
            PyDataViewerPanel.$$$reportNull$$$0(3);
        }
        return pyFrameAccessor;
    }

    public JBTable getTable() {
        return this.myTable;
    }

    public JPanel getMainPanel() {
        return this.myMainPanel;
    }

    protected void createUIComponents() {
        this.myFormatTextField = this.createEditorField();
        this.mySliceTextField = this.createEditorField();
        this.addCompletion();
        this.myTable = new JBTableWithRowHeaders(PropertiesComponent.getInstance((Project)this.myProject).getBoolean("python.debugger.dataview.autoresize", true));
        this.myScrollPane = this.myTable.getScrollPane();
    }

    private void addCompletion() {
        new PyDataViewCompletionProvider().apply(this.mySliceTextField);
    }

    @NotNull
    private EditorTextField createEditorField() {
        EditorTextField editorTextField = new EditorTextField(EditorFactory.getInstance().createDocument((CharSequence)""), this.myProject, (FileType)PythonFileType.INSTANCE, false, true){

            protected EditorEx createEditor() {
                EditorEx editor = super.createEditor();
                editor.getContentComponent().addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent e) {
                        if (e.getKeyCode() == 10) {
                            PyDataViewerPanel.this.apply(PyDataViewerPanel.this.mySliceTextField.getText());
                        }
                    }
                });
                return editor;
            }
        };
        if (editorTextField == null) {
            PyDataViewerPanel.$$$reportNull$$$0(4);
        }
        return editorTextField;
    }

    public void apply(String name) {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            PyDebugValue debugValue = this.getDebugValue(name);
            if (debugValue == null) {
                return;
            }
            ApplicationManager.getApplication().invokeLater(() -> this.apply(debugValue));
        });
    }

    public void apply(@NotNull PyDebugValue debugValue) {
        if (debugValue == null) {
            PyDataViewerPanel.$$$reportNull$$$0(5);
        }
        this.myErrorLabel.setVisible(false);
        String type = debugValue.getType();
        DataViewStrategy strategy = DataViewStrategy.getStrategy(type);
        if (strategy == null) {
            this.setError(type + " is not supported");
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (debugValue == null) {
                PyDataViewerPanel.$$$reportNull$$$0(12);
            }
            try {
                ArrayChunk arrayChunk = debugValue.getFrameAccessor().getArrayItems(debugValue, 0, 0, -1, -1, this.getFormat());
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (debugValue == null) {
                        PyDataViewerPanel.$$$reportNull$$$0(13);
                    }
                    this.updateUI(arrayChunk, debugValue, strategy);
                });
            }
            catch (PyDebuggerException e) {
                LOG.error((Throwable)e);
            }
        });
    }

    public void resize(boolean autoResize) {
        this.myTable.setAutoResize(autoResize);
        this.apply(this.getSliceTextField().getText());
    }

    private void updateUI(@NotNull ArrayChunk chunk, @NotNull PyDebugValue debugValue, @NotNull DataViewStrategy strategy) {
        if (chunk == null) {
            PyDataViewerPanel.$$$reportNull$$$0(6);
        }
        if (debugValue == null) {
            PyDataViewerPanel.$$$reportNull$$$0(7);
        }
        if (strategy == null) {
            PyDataViewerPanel.$$$reportNull$$$0(8);
        }
        AsyncArrayTableModel model = strategy.createTableModel(chunk.getRows(), chunk.getColumns(), this, debugValue);
        model.addToCache(chunk);
        UIUtil.invokeLaterIfNeeded(() -> {
            if (debugValue == null) {
                PyDataViewerPanel.$$$reportNull$$$0(9);
            }
            if (chunk == null) {
                PyDataViewerPanel.$$$reportNull$$$0(10);
            }
            if (strategy == null) {
                PyDataViewerPanel.$$$reportNull$$$0(11);
            }
            this.myTable.setModel(model);
            String text2 = debugValue.getName().equals(debugValue.getTempName()) ? chunk.getSlicePresentation() : debugValue.getName();
            this.mySliceTextField.setText(text2);
            if (this.mySliceTextField.getEditor() != null) {
                this.mySliceTextField.getCaretModel().moveToOffset(text2.length());
            }
            for (Listener listener2 : this.myListeners) {
                listener2.onNameChanged(text2);
            }
            this.myFormatTextField.setText(chunk.getFormat());
            ColoredCellRenderer cellRenderer = strategy.createCellRenderer(Double.MIN_VALUE, Double.MAX_VALUE, chunk);
            cellRenderer.setColored(this.myColored);
            ((AsyncArrayTableModel)this.myTable.getModel()).fireTableDataChanged();
            ((AsyncArrayTableModel)this.myTable.getModel()).fireTableCellUpdated(0, 0);
            if (this.myTable.getColumnCount() > 0) {
                this.myTable.setDefaultRenderer(this.myTable.getColumnClass(0), cellRenderer);
            }
            this.myTable.setShowColumns(strategy.showColumnHeader());
        });
    }

    private PyDebugValue getDebugValue(String expression) {
        try {
            PyDebugValue value = this.myFrameAccessor.evaluate(expression, false, true);
            if (value == null || value.isErrorOnEval()) {
                this.setError(value != null ? value.getValue() : "Failed to evaluate expression " + expression);
                return null;
            }
            return value;
        }
        catch (PyDebuggerException e) {
            this.setError(e.getTracebackError());
            return null;
        }
    }

    private void setError(String text2) {
        this.myErrorLabel.setVisible(true);
        this.myErrorLabel.setText(text2);
        this.myTable.setEmpty();
        for (Listener listener2 : this.myListeners) {
            listener2.onNameChanged("empty");
        }
    }

    public String getFormat() {
        String format = this.myFormatTextField.getText();
        return format.isEmpty() ? "%" : format;
    }

    public boolean isColored() {
        return this.myColored;
    }

    public void setColored(boolean state2) {
        this.myColored = state2;
        if (!this.myTable.isEmpty()) {
            ((ColoredCellRenderer)this.myTable.getDefaultRenderer(this.myTable.getColumnClass(0))).setColored(state2);
        }
    }

    public EditorTextField getSliceTextField() {
        return this.mySliceTextField;
    }

    @Nullable
    public AsyncArrayTableModel getModel() {
        TableModel model = this.myTable.getModel();
        if (model instanceof AsyncArrayTableModel) {
            return (AsyncArrayTableModel)this.myTable.getModel();
        }
        return null;
    }

    public void addListener(Listener listener2) {
        this.myListeners.add(listener2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameAccessor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/containerview/PyDataViewerPanel";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugValue";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunk";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/containerview/PyDataViewerPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrameAccessor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateDebugValue";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "updateUI";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$updateUI$7";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$apply$6";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$5";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBScrollPane jBScrollPane = this.myScrollPane;
        jBScrollPane.setHorizontalScrollBarPolicy(30);
        jBScrollPane.setVerticalScrollBarPolicy(20);
        jPanel.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 5, 0, 3, 3, 3, null, null, null));
        EditorTextField editorTextField = this.mySliceTextField;
        editorTextField.setToolTipText("Current slice.");
        jPanel.add((Component)editorTextField, new GridConstraints(2, 0, 1, 3, 2, 1, 6, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, true, false));
        jPanel.add((Component)jPanel2, new GridConstraints(2, 4, 1, 1, 2, 1, 3, 0, null, null, null, 0, true));
        JLabel jLabel = new JLabel();
        jLabel.setHorizontalAlignment(4);
        jLabel.setHorizontalTextPosition(4);
        jLabel.setText("Format:");
        jLabel.setVerticalAlignment(3);
        jLabel.setVerticalTextPosition(3);
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        EditorTextField editorTextField2 = this.myFormatTextField;
        editorTextField2.setToolTipText("Format");
        jPanel2.add((Component)editorTextField2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, new Dimension(70, -1), null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(3, 0, 1, 5, 0, 3, 0, 0, null, null, null));
        this.myErrorLabel = jBLabel = new JBLabel();
        jPanel3.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 0, new Dimension(-1, 20), new Dimension(-1, 20), new Dimension(-1, 20)));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private class PyDataViewCompletionProvider
    extends TextFieldCompletionProvider {
        private PyDataViewCompletionProvider() {
        }

        protected void addCompletionVariants(@NotNull String text2, int offset, @NotNull String prefix, @NotNull CompletionResultSet result) {
            if (text2 == null) {
                PyDataViewCompletionProvider.$$$reportNull$$$0(0);
            }
            if (prefix == null) {
                PyDataViewCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PyDataViewCompletionProvider.$$$reportNull$$$0(2);
            }
            List<PyDebugValue> values = this.getAvailableValues();
            Collections.sort(values, Comparator.comparing(XNamedValue::getName));
            for (int i = 0; i < values.size(); ++i) {
                PyDebugValue value = values.get(i);
                LookupElementBuilder element = LookupElementBuilder.create((String)value.getName()).withTypeText(value.getType(), true);
                result.addElement(PrioritizedLookupElement.withPriority((LookupElement)element, (double)(-i)));
            }
        }

        private List<PyDebugValue> getAvailableValues() {
            ArrayList<PyDebugValue> values = new ArrayList<PyDebugValue>();
            try {
                XValueChildrenList list = PyDataViewerPanel.this.myFrameAccessor.loadFrame();
                if (list == null) {
                    return values;
                }
                for (int i = 0; i < list.size(); ++i) {
                    PyDebugValue value = (PyDebugValue)list.getValue(i);
                    String type = value.getType();
                    if (DataViewStrategy.getStrategy(type) == null) continue;
                    values.add(value);
                }
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
            return values;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "prefix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/python/debugger/containerview/PyDataViewerPanel$PyDataViewCompletionProvider";
            objectArray[2] = "addCompletionVariants";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface Listener {
        public void onNameChanged(String var1);
    }
}

