/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap;

import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import javax.swing.KeyStroke;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;

public class MacKeymapUtil {
    public static final String ESCAPE = "\u238b";
    public static final String TAB = "\u21e5";
    public static final String TAB_BACK = "\u21e4";
    public static final String CAPS_LOCK = "\u21ea";
    public static final String SHIFT = "\u21e7";
    public static final String CONTROL = "\u2303";
    public static final String OPTION = "\u2325";
    public static final String APPLE = "\uf8ff";
    public static final String COMMAND = "\u2318";
    public static final String SPACE = "\u2423";
    public static final String RETURN = "\u23ce";
    public static final String BACKSPACE = "\u232b";
    public static final String DELETE = "\u2326";
    public static final String HOME = "\u2196";
    public static final String END = "\u2198";
    public static final String PAGE_UP = "\u21de";
    public static final String PAGE_DOWN = "\u21df";
    public static final String UP = "\u2191";
    public static final String DOWN = "\u2193";
    public static final String LEFT = "\u2190";
    public static final String RIGHT = "\u2192";
    public static final String CLEAR = "\u2327";
    public static final String NUMBER_LOCK = "\u21ed";
    public static final String ENTER = "\u2324";
    public static final String EJECT = "\u23cf";
    public static final String POWER3 = "\u233d";
    public static final String NUM_PAD = "\u2328";

    @NotNull
    static String getModifiersText(@JdkConstants.InputEventMask int modifiers) {
        StringBuilder buf = new StringBuilder();
        if ((modifiers & 2) != 0) {
            buf.append(MacKeymapUtil.get(CONTROL, "Ctrl+"));
        }
        if ((modifiers & 8) != 0) {
            buf.append(MacKeymapUtil.get(OPTION, "Alt+"));
        }
        if ((modifiers & 1) != 0) {
            buf.append(MacKeymapUtil.get(SHIFT, "Shift+"));
        }
        if ((modifiers & 0x20) != 0) {
            buf.append(Toolkit.getProperty("AWT.altGraph", "Alt Graph"));
        }
        if ((modifiers & 0x10) != 0) {
            buf.append(Toolkit.getProperty("AWT.button1", "Button1"));
        }
        if ((modifiers & 4) != 0) {
            buf.append(MacKeymapUtil.get(COMMAND, "Cmd+"));
        }
        String string = buf.toString();
        if (string == null) {
            MacKeymapUtil.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public static String getKeyText(int code) {
        switch (code) {
            case 8: {
                String string = MacKeymapUtil.get(BACKSPACE, "Backspace");
                if (string == null) {
                    MacKeymapUtil.$$$reportNull$$$0(1);
                }
                return string;
            }
            case 27: {
                String string = MacKeymapUtil.get(ESCAPE, "Escape");
                if (string == null) {
                    MacKeymapUtil.$$$reportNull$$$0(2);
                }
                return string;
            }
            case 20: {
                String string = MacKeymapUtil.get(CAPS_LOCK, "Caps Lock");
                if (string == null) {
                    MacKeymapUtil.$$$reportNull$$$0(3);
                }
                return string;
            }
            case 9: {
                String string = MacKeymapUtil.get(TAB, "Tab");
                if (string == null) {
                    MacKeymapUtil.$$$reportNull$$$0(4);
                }
                return string;
            }
            case 32: {
                if ("Space" == null) {
                    MacKeymapUtil.$$$reportNull$$$0(5);
                }
                return "Space";
            }
            case 127: {
                String string = MacKeymapUtil.get(DELETE, "Delete");
                if (string == null) {
                    MacKeymapUtil.$$$reportNull$$$0(6);
                }
                return string;
            }
            case 36: {
                String string = MacKeymapUtil.get(HOME, "Home");
                if (string == null) {
                    MacKeymapUtil.$$$reportNull$$$0(7);
                }
                return string;
            }
            case 35: {
                String string = MacKeymapUtil.get(END, "End");
                if (string == null) {
                    MacKeymapUtil.$$$reportNull$$$0(8);
                }
                return string;
            }
            case 33: {
                String string = MacKeymapUtil.get(PAGE_UP, "Page Up");
                if (string == null) {
                    MacKeymapUtil.$$$reportNull$$$0(9);
                }
                return string;
            }
            case 34: {
                String string = MacKeymapUtil.get(PAGE_DOWN, "Page Down");
                if (string == null) {
                    MacKeymapUtil.$$$reportNull$$$0(10);
                }
                return string;
            }
            case 38: {
                String string = MacKeymapUtil.get(UP, "Up Arrow");
                if (string == null) {
                    MacKeymapUtil.$$$reportNull$$$0(11);
                }
                return string;
            }
            case 40: {
                String string = MacKeymapUtil.get(DOWN, "Down Arrow");
                if (string == null) {
                    MacKeymapUtil.$$$reportNull$$$0(12);
                }
                return string;
            }
            case 37: {
                String string = MacKeymapUtil.get(LEFT, "Left Arrow");
                if (string == null) {
                    MacKeymapUtil.$$$reportNull$$$0(13);
                }
                return string;
            }
            case 39: {
                String string = MacKeymapUtil.get(RIGHT, "Right Arrow");
                if (string == null) {
                    MacKeymapUtil.$$$reportNull$$$0(14);
                }
                return string;
            }
            case 144: {
                String string = MacKeymapUtil.get(NUMBER_LOCK, "Num Lock");
                if (string == null) {
                    MacKeymapUtil.$$$reportNull$$$0(15);
                }
                return string;
            }
            case 10: {
                String string = MacKeymapUtil.get(RETURN, "Return");
                if (string == null) {
                    MacKeymapUtil.$$$reportNull$$$0(16);
                }
                return string;
            }
            case 520: {
                String string = MacKeymapUtil.get(NUM_PAD, "NumPad");
                if (string == null) {
                    MacKeymapUtil.$$$reportNull$$$0(17);
                }
                return string;
            }
            case 106: {
                String string = MacKeymapUtil.get(NUM_PAD, "NumPad") + " *";
                if (string == null) {
                    MacKeymapUtil.$$$reportNull$$$0(18);
                }
                return string;
            }
            case 109: {
                if ("-" == null) {
                    MacKeymapUtil.$$$reportNull$$$0(19);
                }
                return "-";
            }
            case 107: {
                if ("+" == null) {
                    MacKeymapUtil.$$$reportNull$$$0(20);
                }
                return "+";
            }
            case 45: {
                if ("-" == null) {
                    MacKeymapUtil.$$$reportNull$$$0(21);
                }
                return "-";
            }
            case 521: {
                if ("+" == null) {
                    MacKeymapUtil.$$$reportNull$$$0(22);
                }
                return "+";
            }
            case 111: {
                if ("NumPad /" == null) {
                    MacKeymapUtil.$$$reportNull$$$0(23);
                }
                return "NumPad /";
            }
            case 96: {
                if ("0" == null) {
                    MacKeymapUtil.$$$reportNull$$$0(24);
                }
                return "0";
            }
            case 97: {
                if ("1" == null) {
                    MacKeymapUtil.$$$reportNull$$$0(25);
                }
                return "1";
            }
            case 98: {
                if ("2" == null) {
                    MacKeymapUtil.$$$reportNull$$$0(26);
                }
                return "2";
            }
            case 99: {
                if ("3" == null) {
                    MacKeymapUtil.$$$reportNull$$$0(27);
                }
                return "3";
            }
            case 100: {
                if ("4" == null) {
                    MacKeymapUtil.$$$reportNull$$$0(28);
                }
                return "4";
            }
            case 101: {
                if ("5" == null) {
                    MacKeymapUtil.$$$reportNull$$$0(29);
                }
                return "5";
            }
            case 102: {
                if ("6" == null) {
                    MacKeymapUtil.$$$reportNull$$$0(30);
                }
                return "6";
            }
            case 103: {
                if ("7" == null) {
                    MacKeymapUtil.$$$reportNull$$$0(31);
                }
                return "7";
            }
            case 104: {
                if ("8" == null) {
                    MacKeymapUtil.$$$reportNull$$$0(32);
                }
                return "8";
            }
            case 105: {
                if ("9" == null) {
                    MacKeymapUtil.$$$reportNull$$$0(33);
                }
                return "9";
            }
            case 0: {
                if ("fn" == null) {
                    MacKeymapUtil.$$$reportNull$$$0(34);
                }
                return "fn";
            }
        }
        String string = KeyEvent.getKeyText(code);
        if (string == null) {
            MacKeymapUtil.$$$reportNull$$$0(35);
        }
        return string;
    }

    @NotNull
    public static String getKeyStrokeText(@NotNull KeyStroke keyStroke) {
        if (keyStroke == null) {
            MacKeymapUtil.$$$reportNull$$$0(36);
        }
        String modifiers = MacKeymapUtil.getModifiersText(keyStroke.getModifiers());
        String key = KeymapUtil.getKeyText(keyStroke.getKeyCode());
        String string = modifiers + key;
        if (string == null) {
            MacKeymapUtil.$$$reportNull$$$0(37);
        }
        return string;
    }

    @NotNull
    private static String get(@NotNull String value, @NotNull String replacement) {
        Font font;
        if (value == null) {
            MacKeymapUtil.$$$reportNull$$$0(38);
        }
        if (replacement == null) {
            MacKeymapUtil.$$$reportNull$$$0(39);
        }
        String string = (font = UIUtil.getLabelFont()) == null || font.canDisplayUpTo(value) == -1 ? value : replacement;
        if (string == null) {
            MacKeymapUtil.$$$reportNull$$$0(40);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 36: 
            case 38: 
            case 39: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 36: 
            case 38: 
            case 39: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/keymap/MacKeymapUtil";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyStroke";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiersText";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyText";
                break;
            }
            case 36: 
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/keymap/MacKeymapUtil";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyStrokeText";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getKeyStrokeText";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 36: 
            case 38: 
            case 39: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

