/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.GenerationType;
import org.hibernate.AssertionFailure;
import org.hibernate.FetchMode;
import org.hibernate.engine.spi.CascadeStyle;
import org.hibernate.engine.spi.CascadeStyles;
import org.hibernate.id.MultipleHiLoPerTableGenerator;
import org.hibernate.internal.util.collections.CollectionHelper;

public class EnumConversionHelper {
    private EnumConversionHelper() {
    }

    public static String generationTypeToGeneratorStrategyName(GenerationType generatorEnum, boolean useNewGeneratorMappings) {
        switch (generatorEnum) {
            case IDENTITY: {
                return "identity";
            }
            case AUTO: {
                return useNewGeneratorMappings ? "enhanced-sequence" : "native";
            }
            case TABLE: {
                return useNewGeneratorMappings ? "enhanced-table" : MultipleHiLoPerTableGenerator.class.getName();
            }
            case SEQUENCE: {
                return useNewGeneratorMappings ? "enhanced-sequence" : "seqhilo";
            }
        }
        throw new AssertionFailure("Unknown GeneratorType: " + (Object)((Object)generatorEnum));
    }

    public static CascadeStyle cascadeTypeToCascadeStyle(CascadeType cascadeType) {
        switch (cascadeType) {
            case ALL: {
                return CascadeStyles.ALL;
            }
            case PERSIST: {
                return CascadeStyles.PERSIST;
            }
            case MERGE: {
                return CascadeStyles.MERGE;
            }
            case REMOVE: {
                return CascadeStyles.DELETE;
            }
            case REFRESH: {
                return CascadeStyles.REFRESH;
            }
            case DETACH: {
                return CascadeStyles.EVICT;
            }
        }
        throw new AssertionFailure("Unknown cascade type");
    }

    public static FetchMode annotationFetchModeToHibernateFetchMode(org.hibernate.annotations.FetchMode annotationFetchMode) {
        switch (annotationFetchMode) {
            case JOIN: {
                return FetchMode.JOIN;
            }
            case SELECT: {
                return FetchMode.SELECT;
            }
            case SUBSELECT: {
                return FetchMode.SELECT;
            }
        }
        throw new AssertionFailure("Unknown fetch mode");
    }

    public static Set<CascadeStyle> cascadeTypeToCascadeStyleSet(Set<CascadeType> cascadeTypes) {
        if (CollectionHelper.isEmpty(cascadeTypes)) {
            return Collections.emptySet();
        }
        HashSet<CascadeStyle> cascadeStyleSet = new HashSet<CascadeStyle>();
        for (CascadeType cascadeType : cascadeTypes) {
            cascadeStyleSet.add(EnumConversionHelper.cascadeTypeToCascadeStyle(cascadeType));
        }
        return cascadeStyleSet;
    }
}

