/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.core.spi;

import java.io.IOException;
import java.util.Date;
import javax.swing.Action;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;

public interface VCSHistoryProvider {
    public HistoryEntry[] getHistory(VCSFileProxy[] var1, Date var2);

    public Action createShowHistoryAction(VCSFileProxy[] var1);

    public void addHistoryChangeListener(HistoryChangeListener var1);

    public void removeHistoryChangeListener(HistoryChangeListener var1);

    public static final class HistoryEvent {
        private final VCSFileProxy[] files;
        private final VCSHistoryProvider source;

        public HistoryEvent(VCSHistoryProvider source, VCSFileProxy[] files) {
            this.files = files;
            this.source = source;
        }

        public VCSFileProxy[] getFiles() {
            return this.files;
        }

        public VCSHistoryProvider getSource() {
            return this.source;
        }
    }

    public static interface ParentProvider {
        public HistoryEntry getParentEntry(VCSFileProxy var1);
    }

    public static interface RevisionProvider {
        public void getRevisionFile(VCSFileProxy var1, VCSFileProxy var2);
    }

    public static interface HistoryChangeListener {
        public void fireHistoryChanged(HistoryEvent var1);
    }

    public static interface MessageEditProvider {
        public void setMessage(String var1) throws IOException;
    }

    public static final class HistoryEntry {
        private Date dateTime;
        private String message;
        private VCSFileProxy[] files;
        private String usernameShort;
        private String username;
        private String revisionShort;
        private String revision;
        private Action[] actions;
        private RevisionProvider revisionProvider;
        private MessageEditProvider mep;
        private ParentProvider parentProvider;
        private Object[] lookupObjects;

        public HistoryEntry(VCSFileProxy[] files, Date dateTime, String message, String username, String usernameShort, String revision, String revisionShort, Action[] actions, RevisionProvider revisionProvider) {
            assert (files != null && files.length > 0) : "a history entry must have at least one file";
            assert (revision != null && revision != null) : "a history entry must have a revision";
            assert (dateTime != null) : "a history entry must have a date";
            assert (message != null) : "a history entry must have a message, at least empty string";
            this.files = files;
            this.dateTime = dateTime;
            this.message = message;
            this.username = username;
            this.usernameShort = usernameShort;
            this.revision = revision;
            this.revisionShort = revisionShort;
            this.actions = actions;
            this.revisionProvider = revisionProvider;
        }

        public HistoryEntry(VCSFileProxy[] files, Date dateTime, String message, String username, String usernameShort, String revision, String revisionShort, Action[] actions, RevisionProvider revisionProvider, MessageEditProvider messageEditProvider) {
            this(files, dateTime, message, username, usernameShort, revision, revisionShort, actions, revisionProvider);
            this.mep = messageEditProvider;
        }

        public HistoryEntry(VCSFileProxy[] files, Date dateTime, String message, String username, String usernameShort, String revision, String revisionShort, Action[] actions, RevisionProvider revisionProvider, MessageEditProvider messageEditProvider, ParentProvider parentProvider) {
            this(files, dateTime, message, username, usernameShort, revision, revisionShort, actions, revisionProvider, messageEditProvider);
            this.parentProvider = parentProvider;
        }

        public boolean canEdit() {
            return this.mep != null;
        }

        public Date getDateTime() {
            return this.dateTime;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) throws IOException {
            if (!this.canEdit()) {
                throw new IllegalStateException("This entry is read-only");
            }
            this.mep.setMessage(message);
            this.message = message;
        }

        public VCSFileProxy[] getFiles() {
            return this.files;
        }

        public String getUsername() {
            return this.username;
        }

        public String getUsernameShort() {
            return this.usernameShort;
        }

        public String getRevision() {
            return this.revision;
        }

        public String getRevisionShort() {
            return this.revisionShort;
        }

        public Action[] getActions() {
            return this.actions;
        }

        public void getRevisionFile(VCSFileProxy originalFile, VCSFileProxy revisionFile) {
            if (this.revisionProvider != null) {
                this.revisionProvider.getRevisionFile(originalFile, revisionFile);
            }
        }

        public HistoryEntry getParentEntry(VCSFileProxy file) {
            if (this.parentProvider != null) {
                return this.parentProvider.getParentEntry(file);
            }
            return null;
        }

        void setLookupObjects(Object[] lookupObjects) {
            this.lookupObjects = lookupObjects;
        }

        Object[] getLookupObjects() {
            return this.lookupObjects;
        }
    }
}

