/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.elements;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.NameKind;
import org.netbeans.modules.php.editor.api.PhpElementKind;
import org.netbeans.modules.php.editor.api.PhpModifiers;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.elements.InterfaceElement;
import org.netbeans.modules.php.editor.api.elements.NamespaceElement;
import org.netbeans.modules.php.editor.api.elements.TypeElement;
import org.netbeans.modules.php.editor.elements.FullyQualifiedElementImpl;
import org.netbeans.modules.php.editor.elements.IndexQueryImpl;
import org.netbeans.modules.php.editor.elements.PhpElementImpl;
import org.netbeans.modules.php.editor.elements.TypeElementImpl;
import org.netbeans.modules.php.editor.index.Signature;
import org.netbeans.modules.php.editor.model.impl.VariousUtils;
import org.netbeans.modules.php.editor.model.nodes.InterfaceDeclarationInfo;
import org.netbeans.modules.php.editor.parser.astnodes.InterfaceDeclaration;
import org.openide.util.Parameters;

public final class InterfaceElementImpl
extends TypeElementImpl
implements InterfaceElement {
    public static final String IDX_FIELD = "iface";

    private InterfaceElementImpl(QualifiedName qualifiedName, int offset, Set<QualifiedName> ifaceNames, Collection<QualifiedName> fqSuperInterfaces, String fileUrl, ElementQuery elementQuery, boolean isDeprecated) {
        super(qualifiedName, offset, ifaceNames, fqSuperInterfaces, PhpModifiers.noModifiers().toFlags(), fileUrl, elementQuery, isDeprecated);
    }

    public static Set<InterfaceElement> fromSignature(IndexQueryImpl indexScopeQuery, IndexResult indexResult) {
        return InterfaceElementImpl.fromSignature((NameKind)NameKind.empty(), indexScopeQuery, indexResult);
    }

    public static Set<InterfaceElement> fromSignature(NameKind query, IndexQueryImpl indexScopeQuery, IndexResult indexResult) {
        String[] values = indexResult.getValues(IDX_FIELD);
        HashSet<InterfaceElement> retval = values.length > 0 ? new HashSet<InterfaceElement>() : Collections.emptySet();
        for (String val : values) {
            InterfaceElement iface = InterfaceElementImpl.fromSignature(query, indexScopeQuery, Signature.get(val));
            if (iface == null) continue;
            retval.add(iface);
        }
        return retval;
    }

    private static InterfaceElement fromSignature(NameKind query, IndexQueryImpl indexScopeQuery, Signature signature) {
        Parameters.notNull((CharSequence)"query", (Object)query);
        InterfaceSignatureParser signParser = new InterfaceSignatureParser(signature);
        InterfaceElementImpl retval = null;
        if (InterfaceElementImpl.matchesQuery(query, signParser)) {
            retval = new InterfaceElementImpl(signParser.getQualifiedName(), signParser.getOffset(), signParser.getSuperInterfaces(), signParser.getFQSuperInterfaces(), signParser.getFileUrl(), indexScopeQuery, signParser.isDeprecated());
        }
        return retval;
    }

    public static InterfaceElement fromNode(NamespaceElement namespace, InterfaceDeclaration node, ElementQuery.File fileQuery) {
        Parameters.notNull((CharSequence)"node", (Object)node);
        Parameters.notNull((CharSequence)"fileQuery", (Object)fileQuery);
        InterfaceDeclarationInfo info = InterfaceDeclarationInfo.create(node);
        QualifiedName fullyQualifiedName = namespace != null ? namespace.getFullyQualifiedName() : QualifiedName.createForDefaultNamespaceName();
        return new InterfaceElementImpl(fullyQualifiedName.append(info.getName()), info.getRange().getStart(), info.getInterfaceNames(), Collections.emptySet(), fileQuery.getURL().toExternalForm(), fileQuery, VariousUtils.isDeprecatedFromPHPDoc(fileQuery.getResult().getProgram(), node));
    }

    private static boolean matchesQuery(NameKind query, InterfaceSignatureParser signParser) {
        Parameters.notNull((CharSequence)"query", (Object)query);
        return query instanceof NameKind.Empty || query.matchesName(InterfaceElement.KIND, signParser.getQualifiedName());
    }

    @Override
    public String getSignature() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName().toLowerCase()).append((Object)PhpElementImpl.Separator.SEMICOLON);
        sb.append(this.getName()).append((Object)PhpElementImpl.Separator.SEMICOLON);
        sb.append(this.getOffset()).append((Object)PhpElementImpl.Separator.SEMICOLON);
        StringBuilder ifaceSb = new StringBuilder();
        for (QualifiedName ifaceName : this.getSuperInterfaces()) {
            if (ifaceSb.length() > 0) {
                ifaceSb.append((Object)PhpElementImpl.Separator.COMMA);
            }
            ifaceSb.append(ifaceName.toString());
        }
        sb.append((CharSequence)ifaceSb);
        sb.append((Object)PhpElementImpl.Separator.SEMICOLON);
        QualifiedName namespaceName = this.getNamespaceName();
        sb.append(namespaceName.toString()).append((Object)PhpElementImpl.Separator.SEMICOLON);
        sb.append(this.isDeprecated() ? 1 : 0).append((Object)PhpElementImpl.Separator.SEMICOLON);
        sb.append(this.getFilenameUrl()).append((Object)PhpElementImpl.Separator.SEMICOLON);
        this.checkInterfaceSignature(sb);
        return sb.toString();
    }

    @Override
    public PhpElementKind getPhpElementKind() {
        return InterfaceElement.KIND;
    }

    @Override
    public String asString(TypeElement.PrintAs as) {
        StringBuilder retval = new StringBuilder();
        switch (as) {
            case NameAndSuperTypes: {
                retval.append(this.getName());
                this.printAsSuperTypes(retval);
                break;
            }
            case SuperTypes: {
                this.printAsSuperTypes(retval);
                break;
            }
            default: {
                assert (false) : as;
                break;
            }
        }
        return retval.toString();
    }

    private void printAsSuperTypes(StringBuilder sb) {
        Set<QualifiedName> superIfaces = this.getSuperInterfaces();
        if (!superIfaces.isEmpty()) {
            sb.append(" extends ");
        }
        StringBuilder ifacesBuffer = new StringBuilder();
        for (QualifiedName qualifiedName : superIfaces) {
            if (ifacesBuffer.length() > 0) {
                ifacesBuffer.append(", ");
            }
            ifacesBuffer.append(qualifiedName.getName());
        }
        sb.append((CharSequence)ifacesBuffer);
    }

    private void checkInterfaceSignature(StringBuilder sb) {
        boolean checkEnabled = false;
        if (!$assertionsDisabled) {
            checkEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (checkEnabled) {
            String retval = sb.toString();
            InterfaceSignatureParser parser = new InterfaceSignatureParser(Signature.get(retval));
            assert (this.getName().equals(parser.getQualifiedName().toName().toString()));
            assert (this.getNamespaceName().equals(parser.getQualifiedName().toNamespaceName()));
            assert (this.getOffset() == parser.getOffset());
            assert (this.getSuperInterfaces().size() == parser.getSuperInterfaces().size());
        }
    }

    private static class InterfaceSignatureParser {
        private final Signature signature;

        InterfaceSignatureParser(Signature signature) {
            this.signature = signature;
        }

        QualifiedName getQualifiedName() {
            return FullyQualifiedElementImpl.composeQualifiedName(this.signature.string(4), this.signature.string(1));
        }

        public Set<QualifiedName> getSuperInterfaces() {
            int index;
            Set<QualifiedName> ifaces = Collections.emptySet();
            String separatedIfaces = this.signature.string(3);
            if (separatedIfaces != null && separatedIfaces.length() > 0 && (index = separatedIfaces.indexOf(124)) > 0) {
                String[] ifaceNames;
                String field = separatedIfaces.substring(0, index);
                ifaces = new HashSet<QualifiedName>();
                for (String ifName : ifaceNames = field.split(PhpElementImpl.Separator.COMMA.toString())) {
                    ifaces.add(QualifiedName.create(ifName));
                }
            }
            return ifaces;
        }

        public Collection<QualifiedName> getFQSuperInterfaces() {
            int index;
            Collection<QualifiedName> retval = Collections.emptySet();
            String separatedIfaces = this.signature.string(3);
            if (separatedIfaces != null && (index = separatedIfaces.indexOf(124)) > 0) {
                String field = separatedIfaces.substring(index + 1);
                retval = new ArrayList();
                StringTokenizer st = new StringTokenizer(field, ",");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    retval.add(QualifiedName.create(token));
                }
            }
            return retval;
        }

        int getOffset() {
            return this.signature.integer(2);
        }

        boolean isDeprecated() {
            return this.signature.integer(5) == 1;
        }

        String getFileUrl() {
            return this.signature.string(6);
        }
    }
}

