/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.requirejs.editor;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.ImageIcon;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;

public class FSCompletionItem
implements CompletionProposal {
    private final FileObject file;
    private final ImageIcon icon;
    private final int anchor;
    private final String prefix;
    private final FSElementHandle element;
    private final boolean addExtension;

    public FSCompletionItem(FileObject file, String prefix, boolean addExtension, int anchor) throws IOException {
        this.file = file;
        this.element = new FSElementHandle(file);
        DataObject od = DataObject.find((FileObject)file);
        this.icon = new ImageIcon(od.getNodeDelegate().getIcon(1));
        this.anchor = anchor;
        this.addExtension = addExtension;
        this.prefix = prefix;
    }

    protected String getText() {
        return this.prefix + this.file.getNameExt() + (this.file.isFolder() ? "/" : "");
    }

    public int hashCode() {
        return this.getText().hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof FSCompletionItem)) {
            return false;
        }
        FSCompletionItem remote = (FSCompletionItem)o;
        return this.getFile().equals(remote.getFile());
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public int getAnchorOffset() {
        return this.anchor;
    }

    public ElementHandle getElement() {
        return this.element;
    }

    public String getName() {
        return this.element.getName();
    }

    public String getInsertPrefix() {
        return this.getName() + (this.file.isFolder() ? "/" : "");
    }

    public String getSortText() {
        return this.getName();
    }

    public String getLhsHtml(HtmlFormatter formatter) {
        return this.file.getNameExt() + " ";
    }

    public String getRhsHtml(HtmlFormatter formatter) {
        return "";
    }

    public ElementKind getKind() {
        return this.element.getKind();
    }

    public Set<Modifier> getModifiers() {
        return Collections.emptySet();
    }

    public boolean isSmart() {
        return false;
    }

    public int getSortPrioOverride() {
        return this.file.isFolder() ? -1001 : -1000;
    }

    public String getCustomInsertTemplate() {
        return this.prefix + (this.addExtension || this.file.isFolder() ? this.file.getNameExt() : this.file.getName()) + (this.file.isFolder() ? "/" : "");
    }

    public FileObject getFile() {
        return this.file;
    }

    public static class FSElementHandle
    implements ElementHandle {
        private final FileObject fo;
        private final Set<FileObject> representedFiles;

        public FSElementHandle(FileObject fo) {
            this.fo = fo;
            this.representedFiles = new HashSet<FileObject>(1);
            this.representedFiles.add(fo);
        }

        public FileObject getFileObject() {
            return this.fo;
        }

        public String getMimeType() {
            return this.fo.getMIMEType();
        }

        public String getName() {
            return this.fo.isFolder() ? this.fo.getNameExt() : this.fo.getName();
        }

        public String getIn() {
            return null;
        }

        public ElementKind getKind() {
            return ElementKind.FILE;
        }

        public Set<Modifier> getModifiers() {
            return Collections.EMPTY_SET;
        }

        public boolean signatureEquals(ElementHandle handle) {
            return this.fo.equals(handle.getFileObject());
        }

        public OffsetRange getOffsetRange(ParserResult result) {
            return OffsetRange.NONE;
        }

        public void addRepresentedFile(FileObject fo) {
            if (!this.representedFiles.contains(fo)) {
                this.representedFiles.add(fo);
            }
        }

        public Set<FileObject> getRepresentedFiles() {
            return this.representedFiles;
        }
    }
}

