/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.selenium2.webclient.mocha.preferences;

import java.io.File;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.selenium2.webclient.mocha.preferences.Bundle;
import org.netbeans.modules.web.common.api.ValidationResult;

public class MochaPreferencesValidator {
    private final ValidationResult result = new ValidationResult();

    public ValidationResult getResult() {
        return this.result;
    }

    public MochaPreferencesValidator validateMochaInstallFolder(String mochaInstallFolder) {
        String warning = MochaPreferencesValidator.validateMochaExec(Bundle.MochaPreferencesValidator_mocha_name(), mochaInstallFolder, false);
        if (warning != null) {
            this.result.addWarning(new ValidationResult.Message((Object)"path", warning));
        }
        return this;
    }

    @CheckForNull
    private static String validateMochaExec(String source, String filePath, boolean writable) {
        if (filePath == null || filePath.trim().isEmpty()) {
            return Bundle.ExternalExecutableValidator_validateFile_missing(source);
        }
        File file = new File(filePath + "/bin/mocha");
        if (!file.isAbsolute()) {
            return Bundle.ExternalExecutableValidator_validateFile_notAbsolute(source);
        }
        if (!file.isFile()) {
            return Bundle.ExternalExecutableValidator_validateFile_notFile(source);
        }
        if (!file.canRead()) {
            return Bundle.ExternalExecutableValidator_validateFile_notReadable(source);
        }
        if (writable && !file.canWrite()) {
            return Bundle.ExternalExecutableValidator_validateFile_notWritable(source);
        }
        return null;
    }
}

