/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.api.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.editor.indent.api.Reformat;
import org.netbeans.modules.php.api.util.Bundle;
import org.netbeans.modules.php.api.util.StringUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.Parameters;
import org.openide.util.UserQuestionException;
import org.openide.util.Utilities;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class FileUtils {
    static final Logger LOGGER = Logger.getLogger(FileUtils.class.getName());
    public static final String PHP_MIME_TYPE = "text/x-php5";
    private static final boolean IS_UNIX = Utilities.isUnix();
    private static final boolean IS_MAC = Utilities.isMac();
    private static final boolean IS_WINDOWS = Utilities.isWindows();
    private static final ZipEntryFilter DUMMY_ZIP_ENTRY_FILTER = new ZipEntryFilter(){

        @Override
        public boolean accept(ZipEntry zipEntry) {
            return true;
        }

        @Override
        public String getName(ZipEntry zipEntry) {
            return zipEntry.getName();
        }
    };

    private FileUtils() {
    }

    public static boolean isPhpFile(FileObject file) {
        Parameters.notNull((CharSequence)"file", (Object)file);
        return FileUtil.getMIMEType((FileObject)file, (String[])new String[]{PHP_MIME_TYPE, null}) != null;
    }

    public static List<String> findFileOnUsersPath(String filename) {
        Parameters.notNull((CharSequence)"filename", (Object)filename);
        return FileUtils.findFileOnUsersPath(new String[]{filename});
    }

    public static List<String> findFileOnUsersPath(String ... filenames) {
        Parameters.notNull((CharSequence)"filenames", (Object)filenames);
        String path = System.getenv("PATH");
        LOGGER.log(Level.FINE, "PATH: [{0}]", path);
        if (path == null) {
            return Collections.emptyList();
        }
        LinkedHashSet<String> dirs = new LinkedHashSet<String>(Arrays.asList(path.split(File.pathSeparator)));
        LOGGER.log(Level.FINE, "PATH dirs: {0}", dirs);
        ArrayList<String> found = new ArrayList<String>(dirs.size() * filenames.length);
        for (String filename : filenames) {
            Parameters.notNull((CharSequence)"filename", (Object)filename);
            for (String dir : dirs) {
                File file = new File(dir, filename);
                if (!file.isFile()) continue;
                String absolutePath = FileUtil.normalizeFile((File)file).getAbsolutePath();
                LOGGER.log(Level.FINE, "File ''{0}'' found", absolutePath);
                if (found.contains(absolutePath)) continue;
                LOGGER.log(Level.FINE, "File ''{0}'' added to found files", absolutePath);
                found.add(absolutePath);
            }
        }
        LOGGER.log(Level.FINE, "Found files: {0}", found);
        return found;
    }

    public static String getScriptExtension(boolean withDot) {
        StringBuilder sb = new StringBuilder(4);
        if (withDot) {
            sb.append(".");
        }
        if (IS_WINDOWS) {
            sb.append("bat");
        } else {
            sb.append("sh");
        }
        return sb.toString();
    }

    @CheckForNull
    public static FileObject getFileObject(Lookup context) {
        FileObject fo = (FileObject)context.lookup(FileObject.class);
        if (fo != null) {
            return fo;
        }
        DataObject d = (DataObject)context.lookup(DataObject.class);
        if (d != null) {
            return d.getPrimaryFile();
        }
        return null;
    }

    public static XMLReader createXmlReader() throws SAXException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(false);
        try {
            return factory.newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException ex) {
            throw new SAXException("Cannot create SAX parser", ex);
        }
    }

    @CheckForNull
    public static String validateFile(String filePath, boolean writable) {
        return FileUtils.validateFile(Bundle.FileUtils_validateFile_file(), filePath, writable);
    }

    @CheckForNull
    public static String validateFile(String source, String filePath, boolean writable) {
        if (!StringUtils.hasText(filePath)) {
            return Bundle.FileUtils_validateFile_missing(source);
        }
        File file = new File(filePath);
        if (!file.isAbsolute()) {
            return Bundle.FileUtils_validateFile_notAbsolute(source);
        }
        if (!file.isFile()) {
            return Bundle.FileUtils_validateFile_notFile(source);
        }
        if (!file.canRead()) {
            return Bundle.FileUtils_validateFile_notReadable(source);
        }
        if (writable && !file.canWrite()) {
            return Bundle.FileUtils_validateFile_notWritable(source);
        }
        return null;
    }

    @CheckForNull
    public static String validateDirectory(String dirPath, boolean writable) {
        return FileUtils.validateDirectory(Bundle.FileUtils_validateDirectory_directory(), dirPath, writable);
    }

    @CheckForNull
    public static String validateDirectory(String source, String dirPath, boolean writable) {
        if (!StringUtils.hasText(dirPath)) {
            return Bundle.FileUtils_validateDirectory_missing(source);
        }
        File dir = new File(dirPath);
        if (!dir.isAbsolute()) {
            return Bundle.FileUtils_validateDirectory_notAbsolute(source);
        }
        if (!dir.isDirectory()) {
            return Bundle.FileUtils_validateDirectory_notDir(source);
        }
        if (!dir.canRead()) {
            return Bundle.FileUtils_validateDirectory_notReadable(source);
        }
        if (writable && !FileUtils.isDirectoryWritable(dir)) {
            return Bundle.FileUtils_validateDirectory_notWritable(source);
        }
        return null;
    }

    public static boolean isDirectoryWritable(File directory) {
        if (!directory.isDirectory()) {
            LOGGER.log(Level.FINE, "{0} is not a folder", directory);
            return false;
        }
        boolean windows = IS_WINDOWS;
        LOGGER.log(Level.FINE, "On Windows: {0}", windows);
        boolean canWrite = directory.canWrite();
        LOGGER.log(Level.FINE, "Folder {0} is writable: {1}", new Object[]{directory, canWrite});
        if (!windows) {
            return canWrite;
        }
        LOGGER.fine("Trying to create temp file");
        try {
            File tmpFile = File.createTempFile("netbeans", null, directory);
            LOGGER.log(Level.FINE, "Temp file {0} created", tmpFile);
            if (!tmpFile.delete()) {
                tmpFile.deleteOnExit();
            }
            LOGGER.log(Level.FINE, "Temp file {0} deleted", tmpFile);
        }
        catch (IOException exc) {
            LOGGER.log(Level.FINE, exc.getMessage(), exc);
            return false;
        }
        return true;
    }

    public static boolean isDirectoryLink(File directory) {
        File canDirectory;
        Parameters.notNull((CharSequence)"directory", (Object)directory);
        if (!IS_UNIX && !IS_MAC) {
            return false;
        }
        if (!directory.isDirectory()) {
            return false;
        }
        try {
            canDirectory = directory.getCanonicalFile();
        }
        catch (IOException ioe) {
            return false;
        }
        String dirPath = directory.getAbsolutePath();
        String canDirPath = canDirectory.getAbsolutePath();
        return IS_MAC ? !dirPath.equalsIgnoreCase(canDirPath) : !dirPath.equals(canDirPath);
    }

    public static void reformatFile(@NonNull File file) throws IOException {
        Parameters.notNull((CharSequence)"file", (Object)file);
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject == null) {
            return;
        }
        FileUtils.reformatFile(DataObject.find((FileObject)fileObject));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reformatFile(final @NonNull DataObject dataObject) throws IOException {
        Parameters.notNull((CharSequence)"dataObject", (Object)dataObject);
        EditorCookie ec = (EditorCookie)dataObject.getLookup().lookup(EditorCookie.class);
        assert (ec != null) : "No editorcookie for " + dataObject;
        StyledDocument doc = ec.openDocument();
        assert (doc instanceof BaseDocument);
        final BaseDocument baseDoc = (BaseDocument)doc;
        final Reformat reformat = Reformat.get((Document)baseDoc);
        reformat.lock();
        try {
            baseDoc.runAtomic(new Runnable(){

                @Override
                public void run() {
                    try {
                        reformat.reformat(0, baseDoc.getLength());
                    }
                    catch (BadLocationException ex) {
                        LOGGER.log(Level.INFO, "Cannot reformat file " + dataObject.getName(), ex);
                    }
                }
            });
        }
        finally {
            reformat.unlock();
        }
        FileUtils.saveFile(dataObject);
    }

    public static void saveFile(@NonNull DataObject dataObject) {
        Parameters.notNull((CharSequence)"dataObject", (Object)dataObject);
        SaveCookie saveCookie = (SaveCookie)dataObject.getLookup().lookup(SaveCookie.class);
        if (saveCookie != null) {
            try {
                try {
                    saveCookie.save();
                }
                catch (UserQuestionException uqe) {
                    NotifyDescriptor.Confirmation desc = new NotifyDescriptor.Confirmation((Object)uqe.getLocalizedMessage(), 2);
                    if (DialogDisplayer.getDefault().notify((NotifyDescriptor)desc).equals(NotifyDescriptor.OK_OPTION)) {
                        uqe.confirmed();
                        saveCookie.save();
                    }
                }
            }
            catch (IOException ioe) {
                LOGGER.log(Level.WARNING, ioe.getLocalizedMessage(), ioe);
            }
        }
    }

    public static void saveFile(@NonNull FileObject fileObject) {
        Parameters.notNull((CharSequence)"fileObject", (Object)fileObject);
        try {
            DataObject dobj = DataObject.find((FileObject)fileObject);
            if (dobj != null) {
                FileUtils.saveFile(dobj);
            }
        }
        catch (DataObjectNotFoundException donfe) {
            LOGGER.log(Level.SEVERE, donfe.getLocalizedMessage(), donfe);
        }
    }

    public static void openFile(@NonNull File file) {
        Parameters.notNull((CharSequence)"file", (Object)file);
        FileUtils.openFile(file, -1);
    }

    public static void openFile(@NonNull File file, int line) {
        DataObject dataObject;
        Parameters.notNull((CharSequence)"file", (Object)file);
        FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
        if (fileObject == null) {
            LOGGER.log(Level.INFO, "FileObject not found for {0}", file);
            return;
        }
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException ex) {
            LOGGER.log(Level.INFO, "DataObject not found for {0}", file);
            return;
        }
        if (line == -1) {
            EditorCookie ec = (EditorCookie)dataObject.getLookup().lookup(EditorCookie.class);
            ec.open();
            return;
        }
        LineCookie lineCookie = (LineCookie)dataObject.getLookup().lookup(LineCookie.class);
        if (lineCookie == null) {
            LOGGER.log(Level.INFO, "LineCookie not found for {0}", file);
            return;
        }
        Line.Set lineSet = lineCookie.getLineSet();
        try {
            final Line currentLine = lineSet.getOriginal(line - 1);
            Mutex.EVENT.readAccess(new Runnable(){

                @Override
                public void run() {
                    currentLine.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
                }
            });
        }
        catch (IndexOutOfBoundsException exc) {
            LOGGER.log(Level.FINE, null, exc);
        }
    }

    public static void unzip(String zipPath, File targetDirectory, ZipEntryFilter zipEntryFilter) throws IOException {
        Parameters.notEmpty((CharSequence)"zipPath", (CharSequence)zipPath);
        Parameters.notNull((CharSequence)"targetDirectory", (Object)targetDirectory);
        if (zipEntryFilter == null) {
            zipEntryFilter = DUMMY_ZIP_ENTRY_FILTER;
        }
        try (ZipFile zipFile = new ZipFile(zipPath);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = entries.nextElement();
                if (!zipEntryFilter.accept(zipEntry)) continue;
                File destinationFile = new File(targetDirectory, zipEntryFilter.getName(zipEntry));
                FileUtils.ensureParentExists(destinationFile);
                FileUtils.copyZipEntry(zipFile, zipEntry, destinationFile);
            }
        }
    }

    @CheckForNull
    public static FileObject getCommonRoot(@NonNull FileObject fo1, @NonNull FileObject fo2) {
        Parameters.notNull((CharSequence)"fo1", (Object)fo1);
        Parameters.notNull((CharSequence)"fo2", (Object)fo2);
        for (FileObject tmp = fo1; tmp != null; tmp = tmp.getParent()) {
            if (!tmp.equals(fo2) && !FileUtil.isParentOf((FileObject)tmp, (FileObject)fo2)) continue;
            return tmp;
        }
        return null;
    }

    private static void ensureParentExists(File file) throws IOException {
        File parent = file.getParentFile();
        if (!parent.isDirectory() && !parent.mkdirs()) {
            throw new IOException("Cannot create parent directories for " + file.getAbsolutePath());
        }
    }

    private static void copyZipEntry(ZipFile zipFile, ZipEntry zipEntry, File destinationFile) throws IOException {
        if (zipEntry.isDirectory()) {
            return;
        }
        try (InputStream inputStream = zipFile.getInputStream(zipEntry);
             FileOutputStream outputStream = new FileOutputStream(destinationFile);){
            FileUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
    }

    public static interface ZipEntryFilter {
        public boolean accept(ZipEntry var1);

        public String getName(ZipEntry var1);
    }
}

