/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.doc.api;

import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.javascript2.doc.JsDocumentationFallbackSyntaxProvider;
import org.netbeans.modules.javascript2.doc.JsDocumentationResolver;
import org.netbeans.modules.javascript2.doc.spi.DocumentationContainer;
import org.netbeans.modules.javascript2.doc.spi.JsComment;
import org.netbeans.modules.javascript2.doc.spi.JsDocumentationHolder;
import org.netbeans.modules.javascript2.doc.spi.JsDocumentationProvider;
import org.netbeans.modules.javascript2.doc.spi.SyntaxProvider;
import org.netbeans.modules.javascript2.types.spi.ParserResult;

public final class JsDocumentationSupport {
    public static final String DOCUMENTATION_PROVIDER_PATH = "javascript/doc/providers";

    private JsDocumentationSupport() {
    }

    @NonNull
    public static JsDocumentationHolder getDocumentationHolder(ParserResult result) {
        DocumentationContainer c = (DocumentationContainer)result.getLookup().lookup(DocumentationContainer.class);
        if (c != null) {
            return c.getHolder(result);
        }
        JsDocumentationProvider p = JsDocumentationResolver.getDefault().getDocumentationProvider(result.getSnapshot());
        return p.createDocumentationHolder(result.getSnapshot());
    }

    @NonNull
    public static JsDocumentationProvider getDocumentationProvider(ParserResult result) {
        return JsDocumentationResolver.getDefault().getDocumentationProvider(result.getSnapshot());
    }

    @NonNull
    public static SyntaxProvider getSyntaxProvider(ParserResult parserResult) {
        SyntaxProvider syntaxProvider = JsDocumentationSupport.getDocumentationHolder(parserResult).getProvider().getSyntaxProvider();
        return syntaxProvider != null ? syntaxProvider : new JsDocumentationFallbackSyntaxProvider();
    }

    @CheckForNull
    public static JsComment getCommentForOffset(ParserResult result, int offset) {
        JsDocumentationHolder holder = JsDocumentationSupport.getDocumentationHolder(result);
        return holder.getCommentForOffset(offset, holder.getCommentBlocks());
    }
}

