/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.awt.Color;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.languages.Highlighting;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.windows.TopComponent;

public class HighlighterSupport {
    private Color color;
    private Highlighting.Highlight highlight;
    private AttributeSet highlightAS = null;

    public HighlighterSupport(Color c) {
        this.color = c;
    }

    public void highlight(Document doc, int start, int end) {
        this.removeHighlight();
        this.highlight = Highlighting.getHighlighting(doc).highlight(start, end, this.getHighlightAS());
        HighlighterSupport.refresh(doc, start);
    }

    private static void refresh(final Document doc, final int offset) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (TopComponent tc : TopComponent.getRegistry().getOpened()) {
                    JEditorPane[] eps;
                    EditorCookie ec = (EditorCookie)tc.getLookup().lookup(EditorCookie.class);
                    if (ec == null || (eps = ec.getOpenedPanes()) == null) continue;
                    int k = eps.length;
                    for (int i = 0; i < k; ++i) {
                        JEditorPane ep;
                        if (eps[i].getDocument() != doc || (ep = eps[i]) == null) continue;
                        try {
                            ep.scrollRectToVisible(ep.modelToView(offset));
                            continue;
                        }
                        catch (BadLocationException ex) {
                            ErrorManager.getDefault().notify((Throwable)ex);
                        }
                    }
                }
            }
        });
    }

    public void removeHighlight() {
        if (this.highlight == null) {
            return;
        }
        this.highlight.remove();
        this.highlight = null;
    }

    private AttributeSet getHighlightAS() {
        if (this.highlightAS == null) {
            SimpleAttributeSet as = new SimpleAttributeSet();
            as.addAttribute(StyleConstants.Background, this.color);
            this.highlightAS = as;
        }
        return this.highlightAS;
    }
}

