/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.nodejs.ui.customizer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javascript.nodejs.platform.NodeJsSupport;
import org.netbeans.modules.javascript.nodejs.preferences.NodeJsPreferences;
import org.netbeans.modules.javascript.nodejs.preferences.NodeJsPreferencesValidator;
import org.netbeans.modules.javascript.nodejs.ui.NodeJsPathPanel;
import org.netbeans.modules.web.common.api.ValidationResult;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class NodeJsCustomizerPanel
extends JPanel
implements HelpCtx.Provider {
    private final ProjectCustomizer.Category category;
    private final NodeJsPreferences preferences;
    final NodeJsPathPanel nodeJsPathPanel;
    private final SpinnerNumberModel debugPortModel;
    volatile boolean enabled;
    volatile boolean defaultNode;
    volatile String node;
    volatile int debugPort;
    volatile boolean syncChanges;
    private JButton configureNodeButton;
    private JRadioButton customNodeRadioButton;
    private JLabel debugPortLabel;
    private JSpinner debugPortSpinner;
    private JRadioButton defaultNodeRadioButton;
    private JCheckBox enabledCheckBox;
    private JLabel localDebugInfoLabel;
    private ButtonGroup nodeBbuttonGroup;
    private JPanel nodePathPanel;
    private JCheckBox syncCheckBox;

    public NodeJsCustomizerPanel(ProjectCustomizer.Category category, Project project) {
        assert (EventQueue.isDispatchThread());
        assert (category != null);
        assert (project != null);
        this.category = category;
        this.preferences = NodeJsSupport.forProject(project).getPreferences();
        this.nodeJsPathPanel = new NodeJsPathPanel();
        this.debugPortModel = new SpinnerNumberModel(65534, 1, 65534, 1);
        this.initComponents();
        this.init();
    }

    private void init() {
        this.nodePathPanel.add((Component)this.nodeJsPathPanel, "Center");
        this.enabled = this.preferences.isEnabled();
        this.enabledCheckBox.setSelected(this.enabled);
        this.node = this.preferences.getNode();
        this.nodeJsPathPanel.setNode(this.node);
        this.nodeJsPathPanel.setNodeSources(this.preferences.getNodeSources());
        this.defaultNode = this.preferences.isDefaultNode();
        if (this.defaultNode) {
            this.defaultNodeRadioButton.setSelected(true);
        } else {
            this.customNodeRadioButton.setSelected(true);
        }
        this.debugPortSpinner.setModel(this.debugPortModel);
        this.debugPort = this.preferences.getDebugPort();
        this.debugPortModel.setValue(this.debugPort);
        this.syncChanges = this.preferences.isSyncEnabled();
        this.syncCheckBox.setSelected(this.syncChanges);
        this.enableAllFields();
        this.validateData();
        DefaultItemListener defaultItemListener = new DefaultItemListener();
        this.category.setStoreListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NodeJsCustomizerPanel.this.saveData();
            }
        });
        this.enabledCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                NodeJsCustomizerPanel.this.enabled = e.getStateChange() == 1;
                NodeJsCustomizerPanel.this.validateData();
                NodeJsCustomizerPanel.this.enableAllFields();
            }
        });
        this.defaultNodeRadioButton.addItemListener(defaultItemListener);
        this.customNodeRadioButton.addItemListener(defaultItemListener);
        this.nodeJsPathPanel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                NodeJsCustomizerPanel.this.node = NodeJsCustomizerPanel.this.nodeJsPathPanel.getNode();
                NodeJsCustomizerPanel.this.validateData();
            }
        });
        this.debugPortModel.addChangeListener(new DefaultChangeListener());
        this.syncCheckBox.addItemListener(defaultItemListener);
    }

    void enableAllFields() {
        this.defaultNodeRadioButton.setEnabled(this.enabled);
        this.configureNodeButton.setEnabled(this.enabled && this.defaultNode);
        this.customNodeRadioButton.setEnabled(this.enabled);
        this.nodeJsPathPanel.enablePanel(this.enabled && !this.defaultNode);
        this.debugPortLabel.setEnabled(this.enabled);
        this.debugPortSpinner.setEnabled(this.enabled);
        this.localDebugInfoLabel.setEnabled(this.enabled);
        this.syncCheckBox.setEnabled(this.enabled);
    }

    void validateData() {
        ValidationResult result = new NodeJsPreferencesValidator().validateCustomizer(this.enabled, this.defaultNode, this.node, this.nodeJsPathPanel.getNodeSources(), this.debugPort).getResult();
        if (result.hasErrors()) {
            this.category.setErrorMessage(result.getFirstErrorMessage());
            this.category.setValid(false);
            return;
        }
        if (result.hasWarnings()) {
            this.category.setErrorMessage(result.getFirstWarningMessage());
            this.category.setValid(true);
            return;
        }
        this.category.setErrorMessage(null);
        this.category.setValid(true);
    }

    void saveData() {
        this.preferences.setEnabled(this.enabled);
        this.preferences.setNode(this.node);
        this.preferences.setNodeSources(this.nodeJsPathPanel.getNodeSources());
        this.preferences.setDefaultNode(this.defaultNode);
        this.preferences.setDebugPort(this.debugPort);
        this.preferences.setSyncEnabled(this.syncChanges);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.javascript.nodejs.ui.customizer.NodeJsCustomizerPanel");
    }

    private void initComponents() {
        this.nodeBbuttonGroup = new ButtonGroup();
        this.enabledCheckBox = new JCheckBox();
        this.configureNodeButton = new JButton();
        this.defaultNodeRadioButton = new JRadioButton();
        this.customNodeRadioButton = new JRadioButton();
        this.nodePathPanel = new JPanel();
        this.debugPortLabel = new JLabel();
        this.debugPortSpinner = new JSpinner();
        this.localDebugInfoLabel = new JLabel();
        this.syncCheckBox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.enabledCheckBox, (String)NbBundle.getMessage(NodeJsCustomizerPanel.class, (String)"NodeJsCustomizerPanel.enabledCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.configureNodeButton, (String)NbBundle.getMessage(NodeJsCustomizerPanel.class, (String)"NodeJsCustomizerPanel.configureNodeButton.text"));
        this.configureNodeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NodeJsCustomizerPanel.this.configureNodeButtonActionPerformed(evt);
            }
        });
        this.nodeBbuttonGroup.add(this.defaultNodeRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.defaultNodeRadioButton, (String)NbBundle.getMessage(NodeJsCustomizerPanel.class, (String)"NodeJsCustomizerPanel.defaultNodeRadioButton.text"));
        this.nodeBbuttonGroup.add(this.customNodeRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.customNodeRadioButton, (String)NbBundle.getMessage(NodeJsCustomizerPanel.class, (String)"NodeJsCustomizerPanel.customNodeRadioButton.text"));
        this.nodePathPanel.setLayout(new BorderLayout());
        this.debugPortLabel.setLabelFor(this.debugPortSpinner);
        Mnemonics.setLocalizedText((JLabel)this.debugPortLabel, (String)NbBundle.getMessage(NodeJsCustomizerPanel.class, (String)"NodeJsCustomizerPanel.debugPortLabel.text"));
        this.debugPortSpinner.setEditor(new JSpinner.NumberEditor(this.debugPortSpinner, "#"));
        Mnemonics.setLocalizedText((JLabel)this.localDebugInfoLabel, (String)NbBundle.getMessage(NodeJsCustomizerPanel.class, (String)"NodeJsCustomizerPanel.localDebugInfoLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.syncCheckBox, (String)NbBundle.getMessage(NodeJsCustomizerPanel.class, (String)"NodeJsCustomizerPanel.syncCheckBox.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.nodePathPanel, -1, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.defaultNodeRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.configureNodeButton)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.localDebugInfoLabel).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.enabledCheckBox).addComponent(this.customNodeRadioButton).addGroup(layout.createSequentialGroup().addComponent(this.debugPortLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.debugPortSpinner, -2, -1, -2)).addComponent(this.syncCheckBox)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.enabledCheckBox).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.defaultNodeRadioButton).addComponent(this.configureNodeButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.customNodeRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nodePathPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.debugPortLabel).addComponent(this.debugPortSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.localDebugInfoLabel).addGap(18, 18, 18).addComponent(this.syncCheckBox)));
    }

    private void configureNodeButtonActionPerformed(ActionEvent evt) {
        assert (EventQueue.isDispatchThread());
        OptionsDisplayer.getDefault().open("Html5/NodeJs");
    }

    private final class DefaultChangeListener
    implements ChangeListener {
        private DefaultChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            NodeJsCustomizerPanel.this.debugPort = NodeJsCustomizerPanel.this.debugPortModel.getNumber().intValue();
            NodeJsCustomizerPanel.this.validateData();
        }
    }

    private final class DefaultItemListener
    implements ItemListener {
        private DefaultItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            NodeJsCustomizerPanel.this.defaultNode = NodeJsCustomizerPanel.this.defaultNodeRadioButton.isSelected();
            NodeJsCustomizerPanel.this.syncChanges = NodeJsCustomizerPanel.this.syncCheckBox.isSelected();
            if (e.getStateChange() == 1) {
                NodeJsCustomizerPanel.this.enableAllFields();
                NodeJsCustomizerPanel.this.validateData();
            }
        }
    }
}

