/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.doctrine2.commands;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.modules.php.api.executable.InvalidPhpExecutableException;
import org.netbeans.modules.php.api.executable.PhpExecutable;
import org.netbeans.modules.php.api.executable.PhpExecutableValidator;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.api.util.UiUtils;
import org.netbeans.modules.php.doctrine2.commands.Bundle;
import org.netbeans.modules.php.doctrine2.commands.Doctrine2CommandVO;
import org.netbeans.modules.php.doctrine2.commands.Doctrine2CommandsXmlParser;
import org.netbeans.modules.php.doctrine2.options.Doctrine2Options;
import org.netbeans.modules.php.doctrine2.ui.options.Doctrine2OptionsPanelController;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.windows.InputOutput;

public final class Doctrine2Script {
    private static final Logger LOGGER = Logger.getLogger(Doctrine2Script.class.getName());
    public static final String SCRIPT_NAME = "doctrine";
    public static final String SCRIPT_NAME_LONG = "doctrine" + FileUtils.getScriptExtension((boolean)true);
    private static final String XML_CHARSET_NAME = "UTF-8";
    private static final List<String> DEFAULT_PARAMS = Collections.singletonList("--ansi");
    private static final List<String> LIST_PARAMS = Arrays.asList("list", "--format", "xml");
    private final String doctrine2Path;

    private Doctrine2Script(String doctrine2Path) {
        this.doctrine2Path = doctrine2Path;
    }

    public static Doctrine2Script getDefault() throws InvalidPhpExecutableException {
        String doctrine2Path = Doctrine2Options.getInstance().getScript();
        String error = Doctrine2Script.validate(doctrine2Path);
        if (error != null) {
            throw new InvalidPhpExecutableException(error);
        }
        return new Doctrine2Script(doctrine2Path);
    }

    public static String validate(String command) {
        return PhpExecutableValidator.validateCommand((String)command, (String)Bundle.Doctrine2Script_script_label());
    }

    public void runCommand(PhpModule phpModule, List<String> parameters, Runnable postExecution) {
        new PhpExecutable(this.doctrine2Path).workDir(FileUtil.toFile((FileObject)phpModule.getSourceDirectory())).displayName(this.getDisplayName(phpModule)).additionalParameters(this.getAllParameters(parameters)).run(this.getDescriptor(postExecution));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Doctrine2CommandVO> getCommands(PhpModule phpModule) {
        File tmpFile;
        try {
            tmpFile = File.createTempFile("nb-doctrine2-commands-", ".xml");
            tmpFile.deleteOnExit();
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, null, ex);
            return null;
        }
        Future result = new PhpExecutable(this.doctrine2Path).workDir(FileUtil.toFile((FileObject)phpModule.getSourceDirectory())).fileOutput(tmpFile, XML_CHARSET_NAME, true).additionalParameters(LIST_PARAMS).run(this.getSilentDescriptor());
        try {
            if (result == null || (Integer)result.get() != 0) {
                this.runCommand(phpModule, LIST_PARAMS);
                return null;
            }
        }
        catch (CancellationException ex) {
            return null;
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return null;
        }
        catch (ExecutionException ex) {
            UiUtils.processExecutionException((ExecutionException)ex, (String)"FrameworksAndTools/Doctrine2");
            return null;
        }
        ArrayList<Doctrine2CommandVO> commandsVO = new ArrayList<Doctrine2CommandVO>();
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(tmpFile), XML_CHARSET_NAME));
            Doctrine2CommandsXmlParser.parse(reader, commandsVO);
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, null, ex);
        }
        finally {
            if (!tmpFile.delete()) {
                LOGGER.info("Cannot delete temporary file");
            }
        }
        if (commandsVO.isEmpty()) {
            this.runCommand(phpModule, LIST_PARAMS);
            return null;
        }
        return commandsVO;
    }

    private void runCommand(PhpModule phpModule, List<String> parameters) {
        this.runCommand(phpModule, parameters, null);
    }

    private String getDisplayName(PhpModule phpModule) {
        return Bundle.Doctrine2Script_command_title(phpModule.getDisplayName());
    }

    private List<String> getAllParameters(List<String> params) {
        ArrayList<String> allParams = new ArrayList<String>(DEFAULT_PARAMS.size() + params.size());
        allParams.addAll(DEFAULT_PARAMS);
        allParams.addAll(params);
        return allParams;
    }

    private ExecutionDescriptor getDescriptor(Runnable postExecution) {
        ExecutionDescriptor executionDescriptor = PhpExecutable.DEFAULT_EXECUTION_DESCRIPTOR.optionsPath(Doctrine2OptionsPanelController.getOptionsPath()).inputVisible(false);
        if (postExecution != null) {
            executionDescriptor = executionDescriptor.postExecution(postExecution);
        }
        return executionDescriptor;
    }

    private ExecutionDescriptor getSilentDescriptor() {
        return new ExecutionDescriptor().inputOutput(InputOutput.NULL);
    }
}

