/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.session;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpSession;
import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.session.StandardManager;

public final class StandardSessionInterceptor
extends BaseInterceptor {
    int manager_note;
    static final char SESSIONID_ROUTE_SEP = '.';

    private StandardManager getManager(Context ctx) {
        return (StandardManager)ctx.getContainer().getNote(this.manager_note);
    }

    private void setManager(Context ctx, StandardManager sm) {
        ctx.getContainer().setNote(this.manager_note, sm);
    }

    public void engineInit(ContextManager cm) throws TomcatException {
        this.manager_note = cm.getNoteId(1, "tomcat.standardManager");
    }

    public int requestMap(Request request) {
        String requestedSessionID;
        String sessionId = null;
        HttpSession sess = null;
        Context ctx = request.getContext();
        StandardManager sM = this.getManager(ctx);
        if (ctx == null) {
            this.log("Configuration error in StandardSessionInterceptor - no context " + request);
        }
        if ((requestedSessionID = request.getRequestedSessionId()) != null) {
            if (this.debug > 0) {
                this.log("Found URL session ID: " + requestedSessionID);
            }
            if ((sess = sM.findSession(requestedSessionID)) != null) {
                if (this.debug > 0) {
                    this.log("The URL session ID is valid");
                }
                request.setSession(sess);
            }
        }
        int count = request.getCookieCount();
        int i = 0;
        while (i < count) {
            Cookie cookie = request.getCookie(i);
            if (cookie.getName().equals("JSESSIONID")) {
                sessionId = cookie.getValue();
                if (this.debug > 0) {
                    this.log("Found session id cookie " + sessionId);
                }
                request.setRequestedSessionId(sessionId);
                request.setSessionIdSource("cookie");
                sess = sM.findSession(sessionId);
                if (sess == null) break;
                request.setSession(sess);
                break;
            }
            ++i;
        }
        return 0;
    }

    public void reload(Request req, Context ctx) {
        ClassLoader newLoader = ctx.getServletLoader().getClassLoader();
        StandardManager sM = this.getManager(ctx);
        sM.handleReload(req, newLoader);
    }

    public int newSessionRequest(Request request, Response response) {
        Context ctx = request.getContext();
        if (ctx == null) {
            return 0;
        }
        StandardManager sM = this.getManager(ctx);
        if (request.getSession(false) != null) {
            return 0;
        }
        HttpSession newS = sM.getNewSession(request.getJvmRoute());
        request.setSession(newS);
        return 0;
    }

    public int postService(Request rrequest, Response response) {
        Context ctx = rrequest.getContext();
        if (ctx == null) {
            return 0;
        }
        StandardManager sm = this.getManager(ctx);
        HttpSession sess = rrequest.getSession(false);
        if (sess == null) {
            return 0;
        }
        sm.release(sess);
        return 0;
    }

    public void contextInit(Context ctx) throws TomcatException {
        StandardManager sm = this.getManager(ctx);
        if (sm == null) {
            sm = new StandardManager();
            this.setManager(ctx, sm);
        }
        sm.setSessionTimeOut(ctx.getSessionTimeOut());
        sm.setDistributable(ctx.isDistributable());
        try {
            sm.start();
        }
        catch (IllegalStateException ex) {
            throw new TomcatException(ex);
        }
    }

    public void contextShutdown(Context ctx) throws TomcatException {
        if (ctx.getDebug() > 0) {
            ctx.log("Removing sessions from " + ctx);
        }
        StandardManager sm = this.getManager(ctx);
        try {
            if (sm != null) {
                sm.stop();
            }
        }
        catch (IllegalStateException ex) {
            throw new TomcatException(ex);
        }
    }
}

