/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.service.http;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.tomcat.core.ResponseImpl;
import org.apache.tomcat.util.MimeHeaderField;

public class HttpResponseAdapter
extends ResponseImpl {
    protected OutputStream sout;
    protected static final int DEFAULT_HEAD_BUFFER_SIZE = 1024;
    protected byte[] buffer = new byte[1024];
    protected int bufferCount = 0;
    static final byte[] CRLF = new byte[]{13, 10};

    public void recycle() {
        super.recycle();
        this.bufferCount = 0;
    }

    public void setOutputStream(OutputStream os) {
        this.sout = os;
    }

    public void endHeaders() throws IOException {
        super.endHeaders();
        this.sendStatus(this.status, ResponseImpl.getMessage(this.status));
        int count = this.headers.size();
        int i = 0;
        while (i < count) {
            MimeHeaderField field = this.headers.getField(i);
            this.printHead(field.getName());
            this.printHead(": ");
            this.printHead(field.getValue());
            this.printHead("\r\n");
            ++i;
        }
        this.printHead("\r\n");
        this.sout.write(this.buffer, 0, this.bufferCount);
        this.sout.flush();
    }

    protected void sendStatus(int status, String message) throws IOException {
        this.printHead("HTTP/1.0 ");
        this.printHead(String.valueOf(status));
        if (message != null) {
            this.printHead(" ");
            this.printHead(message);
        }
        this.printHead("\r\n");
        MimeHeaderField dateH = this.headers.find("Date");
        if (dateH == null) {
            dateH = this.headers.putHeader();
            dateH.setName("Date");
            dateH.setDateValue(System.currentTimeMillis());
        }
        if (this.request.getContext() != null) {
            this.setHeader("Servlet-Engine", this.request.getContext().getEngineHeader());
        }
    }

    public void doWrite(byte[] buffer, int pos, int count) throws IOException {
        this.sout.write(buffer, pos, count);
    }

    protected void printHead(String s) {
        if (s == null) {
            s = "null";
        }
        int len = s.length();
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            if ((c & 0xFF00) != 0) {
                System.out.println("Header character is not iso8859_1, not supported yet: " + c);
            }
            if (this.bufferCount >= this.buffer.length) {
                byte[] bufferNew = new byte[this.buffer.length * 2];
                System.arraycopy(this.buffer, 0, bufferNew, 0, this.buffer.length);
                this.buffer = bufferNew;
            }
            this.buffer[this.bufferCount] = (byte)c;
            ++this.bufferCount;
            ++i;
        }
    }
}

