/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.api;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.ModuleInfoSupport;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.PluginPropertyUtils;

public final class ModuleInfoUtils {
    private static final String MODULE_INFO = "module-info.java";

    public static void addRequires(NbMavenProject project, Collection<? extends Artifact> artifacts) {
        ModuleInfoSupport.addRequires(project.getMavenProject(), (Collection<? extends Artifact>)artifacts.stream().filter(a -> "compile".equals(a.getScope()) || "test".equals(a.getScope())).collect(Collectors.toList()));
    }

    public static boolean checkModuleInfoAndCompilerFit(Project prj) {
        NbMavenProject nbprj = (NbMavenProject)prj.getLookup().lookup(NbMavenProject.class);
        if (nbprj == null) {
            return true;
        }
        if (!ModuleInfoUtils.hasModuleInfo(nbprj)) {
            return true;
        }
        String version = PluginPropertyUtils.getPluginVersion(nbprj.getMavenProject(), "org.apache.maven.plugins", "maven-compiler-plugin");
        if (version == null) {
            return true;
        }
        return new ComparableVersion(version).compareTo(new ComparableVersion("3.6")) >= 0;
    }

    private static boolean hasModuleInfo(NbMavenProject nbprj) {
        MavenProject mavenProject = nbprj.getMavenProject();
        return ModuleInfoUtils.hasModuleInfoInSourceRoot(mavenProject.getCompileSourceRoots()) || ModuleInfoUtils.hasModuleInfoInSourceRoot(mavenProject.getTestCompileSourceRoots());
    }

    private static boolean hasModuleInfoInSourceRoot(List<String> sourceRoots) {
        for (String sourceRoot : sourceRoots) {
            if (!new File(sourceRoot, MODULE_INFO).exists()) continue;
            return true;
        }
        return false;
    }
}

