/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.instrument.witness;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Arrays;
import org.logstash.instrument.witness.SerializableWitness;
import org.logstash.instrument.witness.pipeline.EventsWitness;
import org.logstash.instrument.witness.pipeline.PipelineWitness;
import org.logstash.instrument.witness.pipeline.PipelinesWitness;
import org.logstash.instrument.witness.pipeline.ReloadWitness;
import org.logstash.instrument.witness.process.ProcessWitness;
import org.logstash.instrument.witness.schedule.WitnessScheduler;

@JsonSerialize(using=Serializer.class)
public final class Witness
implements SerializableWitness {
    private final ReloadWitness reloadWitness = new ReloadWitness();
    private final EventsWitness eventsWitness = new EventsWitness();
    private final PipelinesWitness pipelinesWitness = new PipelinesWitness();
    private final ProcessWitness processWitness = new ProcessWitness();
    private final WitnessScheduler processWitnessScheduler = new WitnessScheduler(this.processWitness);
    private static Witness instance;

    public static synchronized void setInstance(Witness newInstance) {
        if (instance != null) {
            Witness.instance.processWitnessScheduler.shutdown();
        }
        if ((instance = newInstance) != null) {
            Witness.instance.processWitnessScheduler.schedule();
        }
    }

    public static Witness instance() {
        if (instance == null) {
            throw new IllegalStateException("The stats witness instance must be set before it used. Called from: " + Arrays.toString(new Throwable().getStackTrace()));
        }
        return instance;
    }

    public EventsWitness events() {
        return this.eventsWitness;
    }

    public ReloadWitness reloads() {
        return this.reloadWitness;
    }

    public PipelinesWitness pipelines() {
        return this.pipelinesWitness;
    }

    public ProcessWitness process() {
        return this.processWitness;
    }

    public PipelineWitness pipeline(String name) {
        return this.pipelinesWitness.pipeline(name);
    }

    @Override
    public void genJson(JsonGenerator gen, SerializerProvider provider) throws IOException {
        Serializer.innerSerialize(this, gen, provider);
    }

    public static final class Serializer
    extends StdSerializer<Witness> {
        private static final long serialVersionUID = 1L;

        public Serializer() {
            this(Witness.class);
        }

        private Serializer(Class<Witness> t) {
            super(t);
        }

        public void serialize(Witness witness, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeStartObject();
            Serializer.innerSerialize(witness, gen, provider);
            gen.writeEndObject();
        }

        static void innerSerialize(Witness witness, JsonGenerator gen, SerializerProvider provider) throws IOException {
            witness.process().genJson(gen, provider);
            witness.events().genJson(gen, provider);
            witness.reloads().genJson(gen, provider);
            witness.pipelinesWitness.genJson(gen, provider);
        }
    }
}

