/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventprocessorhost;

import com.microsoft.azure.eventprocessorhost.CloseReason;
import com.microsoft.azure.eventprocessorhost.HostContext;
import com.microsoft.azure.eventprocessorhost.Lease;
import com.microsoft.azure.eventprocessorhost.PartitionPump;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Pump {
    protected final HostContext hostContext;
    protected ConcurrentHashMap<String, PartitionPump> pumpStates;
    private static final Logger TRACE_LOGGER = LoggerFactory.getLogger(Pump.class);

    public Pump(HostContext hostContext) {
        this.hostContext = hostContext;
        this.pumpStates = new ConcurrentHashMap();
    }

    public void addPump(Lease lease) {
        PartitionPump capturedPump = this.pumpStates.get(lease.getPartitionId());
        if (capturedPump == null) {
            TRACE_LOGGER.info(this.hostContext.withHostAndPartition(lease, "creating new pump"));
            PartitionPump newPartitionPump = this.createNewPump(lease);
            this.pumpStates.put(lease.getPartitionId(), newPartitionPump);
            String capturedPartitionId = lease.getPartitionId();
            ((CompletableFuture)newPartitionPump.startPump().whenComplete((r, e) -> this.pumpStates.remove(capturedPartitionId))).whenComplete((r, e) -> this.removingPumpTestHook(capturedPartitionId, (Throwable)e));
        } else {
            TRACE_LOGGER.info(this.hostContext.withHostAndPartition(lease, "updating lease for pump"));
            capturedPump.setLease(lease);
        }
    }

    protected PartitionPump createNewPump(Lease lease) {
        return new PartitionPump(this.hostContext, lease);
    }

    public CompletableFuture<Void> removePump(String partitionId, CloseReason reason) {
        CompletableFuture<Object> retval = CompletableFuture.completedFuture(null);
        PartitionPump capturedPump = this.pumpStates.get(partitionId);
        if (capturedPump != null) {
            TRACE_LOGGER.info(this.hostContext.withHostAndPartition(partitionId, "closing pump for reason " + reason.toString()));
            retval = capturedPump.shutdown(reason);
        } else {
            TRACE_LOGGER.debug(this.hostContext.withHostAndPartition(partitionId, "no pump found to remove for partition " + partitionId));
        }
        return retval;
    }

    public CompletableFuture<?>[] removeAllPumps(CloseReason reason) {
        CompletableFuture[] futures = new CompletableFuture[this.pumpStates.size()];
        int i = 0;
        for (String partitionId : this.pumpStates.keySet()) {
            futures[i++] = this.removePump(partitionId, reason);
        }
        return futures;
    }

    protected void removingPumpTestHook(String partitionId, Throwable e) {
    }
}

