/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.flow.layoutprocessor;

import org.jfree.layouting.util.AttributeMap;
import org.jfree.report.DataSourceException;
import org.jfree.report.ReportDataFactoryException;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.data.ExpressionSlot;
import org.jfree.report.data.PrecomputeNodeKey;
import org.jfree.report.data.PrecomputedExpressionSlot;
import org.jfree.report.data.PrecomputedValueRegistry;
import org.jfree.report.data.RunningExpressionSlot;
import org.jfree.report.data.StaticExpressionRuntimeData;
import org.jfree.report.expressions.Expression;
import org.jfree.report.flow.FlowControlOperation;
import org.jfree.report.flow.FlowController;
import org.jfree.report.flow.LayoutExpressionRuntime;
import org.jfree.report.flow.ReportTarget;
import org.jfree.report.flow.layoutprocessor.LayoutController;
import org.jfree.report.flow.layoutprocessor.LayoutControllerUtil;
import org.jfree.report.structure.Element;

public abstract class ElementLayoutController
implements LayoutController {
    public static final int NOT_STARTED = 0;
    public static final int OPENED = 1;
    public static final int WAITING_FOR_JOIN = 2;
    public static final int FINISHING = 3;
    public static final int FINISHED = 4;
    private int processingState = 0;
    private FlowController flowController;
    private Element element;
    private LayoutController parent;
    private boolean precomputing;
    private AttributeMap attributeMap;
    private int expressionsCount;
    private int iterationCount;

    protected ElementLayoutController() {
    }

    public String toString() {
        return "ElementLayoutController{processingState=" + this.processingState + ", element=" + this.element + ", precomputing=" + this.precomputing + ", expressionsCount=" + this.expressionsCount + ", iterationCount=" + this.iterationCount + '}';
    }

    public LayoutController getParent() {
        return this.parent;
    }

    public void initialize(Object object, FlowController flowController, LayoutController layoutController) throws DataSourceException, ReportDataFactoryException, ReportProcessingException {
        if (this.processingState != 0) {
            throw new IllegalStateException();
        }
        this.element = (Element)object;
        this.flowController = flowController;
        this.parent = layoutController;
        this.iterationCount = -1;
    }

    public final LayoutController advance(ReportTarget reportTarget) throws DataSourceException, ReportProcessingException, ReportDataFactoryException {
        int n = this.getProcessingState();
        switch (n) {
            case 0: {
                return this.startElement(reportTarget);
            }
            case 1: {
                return this.processContent(reportTarget);
            }
            case 3: {
                return this.finishElement(reportTarget);
            }
        }
        throw new IllegalStateException();
    }

    protected LayoutController startElement(ReportTarget reportTarget) throws DataSourceException, ReportProcessingException, ReportDataFactoryException {
        Element element = this.getElement();
        FlowController flowController = this.getFlowController();
        flowController = this.startData(reportTarget, flowController);
        Expression[] expressionArray = element.getExpressions();
        flowController = this.performElementPrecomputation(expressionArray, flowController);
        if (!element.isVirtual()) {
            this.attributeMap = this.computeAttributes(flowController, element, reportTarget);
            reportTarget.startElement(this.attributeMap);
        }
        ElementLayoutController elementLayoutController = (ElementLayoutController)this.clone();
        elementLayoutController.setProcessingState(1);
        elementLayoutController.setFlowController(flowController);
        elementLayoutController.expressionsCount = expressionArray.length;
        elementLayoutController.attributeMap = this.attributeMap;
        ++elementLayoutController.iterationCount;
        return elementLayoutController;
    }

    public AttributeMap getAttributeMap() {
        return this.attributeMap;
    }

    public int getExpressionsCount() {
        return this.expressionsCount;
    }

    public int getIterationCount() {
        return this.iterationCount;
    }

    protected FlowController startData(ReportTarget reportTarget, FlowController flowController) throws DataSourceException, ReportProcessingException, ReportDataFactoryException {
        return flowController;
    }

    protected AttributeMap computeAttributes(FlowController flowController, Element element, ReportTarget reportTarget) throws DataSourceException {
        LayoutExpressionRuntime layoutExpressionRuntime = LayoutControllerUtil.getExpressionRuntime(flowController, element);
        return LayoutControllerUtil.processAttributes(element, reportTarget, layoutExpressionRuntime);
    }

    protected abstract LayoutController processContent(ReportTarget var1) throws DataSourceException, ReportProcessingException, ReportDataFactoryException;

    protected LayoutController finishElement(ReportTarget reportTarget) throws ReportProcessingException, DataSourceException, ReportDataFactoryException {
        FlowController flowController = this.handleDefaultEndElement(reportTarget);
        ElementLayoutController elementLayoutController = (ElementLayoutController)this.clone();
        elementLayoutController.setProcessingState(4);
        elementLayoutController.setFlowController(flowController);
        return elementLayoutController;
    }

    protected FlowController handleDefaultEndElement(ReportTarget reportTarget) throws ReportProcessingException, DataSourceException, ReportDataFactoryException {
        Element element = this.getElement();
        if (!element.isVirtual()) {
            reportTarget.endElement(this.getAttributeMap());
        }
        FlowController flowController = this.getFlowController();
        PrecomputedValueRegistry precomputedValueRegistry = flowController.getPrecomputedValueRegistry();
        int n = this.getExpressionsCount();
        if (n != 0) {
            ExpressionSlot[] expressionSlotArray = flowController.getActiveExpressions();
            for (int i = expressionSlotArray.length - n; i < expressionSlotArray.length; ++i) {
                ExpressionSlot expressionSlot = expressionSlotArray[i];
                precomputedValueRegistry.addFunction(expressionSlot.getName(), expressionSlot.getValue());
            }
            flowController = flowController.deactivateExpressions();
        }
        if (!this.isPrecomputing()) {
            precomputedValueRegistry.finishElement(new ElementPrecomputeKey(element));
        }
        return flowController;
    }

    public boolean isAdvanceable() {
        return this.processingState != 4;
    }

    public Element getElement() {
        return this.element;
    }

    public FlowController getFlowController() {
        return this.flowController;
    }

    public int getProcessingState() {
        return this.processingState;
    }

    public void setProcessingState(int n) {
        this.processingState = n;
    }

    public void setFlowController(FlowController flowController) {
        this.flowController = flowController;
    }

    public void setParent(LayoutController layoutController) {
        this.parent = layoutController;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("Clone must be supported.");
        }
    }

    public boolean isPrecomputing() {
        return this.precomputing;
    }

    protected FlowController performElementPrecomputation(Expression[] expressionArray, FlowController flowController) throws ReportProcessingException, ReportDataFactoryException, DataSourceException {
        Element element = this.getElement();
        PrecomputedValueRegistry precomputedValueRegistry = flowController.getPrecomputedValueRegistry();
        if (!this.isPrecomputing()) {
            precomputedValueRegistry.startElement(new ElementPrecomputeKey(element));
        }
        if (expressionArray.length > 0) {
            ExpressionSlot[] expressionSlotArray = new ExpressionSlot[expressionArray.length];
            StaticExpressionRuntimeData staticExpressionRuntimeData = LayoutControllerUtil.getStaticExpressionRuntime(flowController, element);
            for (int i = 0; i < expressionArray.length; ++i) {
                Expression expression = expressionArray[i];
                if (!this.isPrecomputing() && expression.isPrecompute()) {
                    Object object = LayoutControllerUtil.performPrecompute(i, new ElementPrecomputeKey(element), this, this.getFlowController());
                    expressionSlotArray[i] = new PrecomputedExpressionSlot(expression.getName(), object, expression.isPreserve());
                    continue;
                }
                expressionSlotArray[i] = new RunningExpressionSlot(expression, staticExpressionRuntimeData, precomputedValueRegistry.currentNode());
            }
            flowController = flowController.activateExpressions(expressionSlotArray);
        }
        return flowController;
    }

    protected FlowController tryRepeatingCommit(FlowController flowController) throws DataSourceException {
        if (!this.isPrecomputing()) {
            FlowController flowController2;
            boolean bl;
            boolean bl2 = flowController.isAdvanceRequested();
            boolean bl3 = flowController.getMasterRow().isAdvanceable();
            if (bl3 && bl2 && !(bl = LayoutControllerUtil.isGroupFinished(flowController2 = flowController.performOperation(FlowControlOperation.COMMIT), this.getElement()))) {
                return flowController2;
            }
        }
        return null;
    }

    public LayoutController createPrecomputeInstance(FlowController flowController) {
        ElementLayoutController elementLayoutController = (ElementLayoutController)this.clone();
        elementLayoutController.setFlowController(flowController);
        elementLayoutController.setParent(null);
        elementLayoutController.precomputing = true;
        return elementLayoutController;
    }

    public Object getNode() {
        return this.getElement();
    }

    protected static class ElementPrecomputeKey
    implements PrecomputeNodeKey {
        private String name;
        private String id;
        private String namespace;
        private String tagName;

        public ElementPrecomputeKey(Element element) {
            this.name = element.getName();
            this.tagName = element.getType();
            this.namespace = element.getNamespace();
            this.id = element.getId();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            ElementPrecomputeKey elementPrecomputeKey = (ElementPrecomputeKey)object;
            if (this.id != null ? !this.id.equals(elementPrecomputeKey.id) : elementPrecomputeKey.id != null) {
                return false;
            }
            if (this.name != null ? !this.name.equals(elementPrecomputeKey.name) : elementPrecomputeKey.name != null) {
                return false;
            }
            if (this.namespace != null ? !this.namespace.equals(elementPrecomputeKey.namespace) : elementPrecomputeKey.namespace != null) {
                return false;
            }
            return !(this.tagName != null ? !this.tagName.equals(elementPrecomputeKey.tagName) : elementPrecomputeKey.tagName != null);
        }

        public int hashCode() {
            int n = this.name != null ? this.name.hashCode() : 0;
            n = 29 * n + (this.id != null ? this.id.hashCode() : 0);
            n = 29 * n + (this.namespace != null ? this.namespace.hashCode() : 0);
            n = 29 * n + (this.tagName != null ? this.tagName.hashCode() : 0);
            return n;
        }

        public boolean equals(PrecomputeNodeKey precomputeNodeKey) {
            return false;
        }
    }
}

