/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.io.OsmWriter;
import org.openstreetmap.josm.io.OsmWriterFactory;
import org.openstreetmap.josm.tools.I18n;

public class OsmChangeBuilder {
    public static final String DEFAULT_API_VERSION = "0.6";
    private String currentMode;
    private final PrintWriter writer;
    private final StringWriter swriter;
    private final OsmWriter osmwriter;
    private String apiVersion = "0.6";
    private boolean prologWritten;

    public OsmChangeBuilder(Changeset changeset) {
        this(changeset, null);
    }

    public OsmChangeBuilder(Changeset changeset, String apiVersion) {
        this.apiVersion = apiVersion == null ? DEFAULT_API_VERSION : apiVersion;
        this.swriter = new StringWriter();
        this.writer = new PrintWriter(this.swriter);
        this.osmwriter = OsmWriterFactory.createOsmWriter(this.writer, false, apiVersion);
        this.osmwriter.setChangeset(changeset);
        this.osmwriter.setIsOsmChange(true);
    }

    protected void write(IPrimitive p) {
        if (p.isDeleted()) {
            this.switchMode("delete");
            this.osmwriter.setWithBody(false);
            p.accept(this.osmwriter);
        } else {
            this.switchMode(p.isNew() ? "create" : "modify");
            this.osmwriter.setWithBody(true);
            p.accept(this.osmwriter);
        }
    }

    private void switchMode(String newMode) {
        if (newMode != null && !newMode.equals(this.currentMode) || newMode == null && this.currentMode != null) {
            if (this.currentMode != null) {
                this.writer.print("</");
                this.writer.print(this.currentMode);
                this.writer.println(">");
            }
            if (newMode != null) {
                this.writer.print("<");
                this.writer.print(newMode);
                this.writer.println(">");
            }
            this.currentMode = newMode;
        }
    }

    public void start() {
        if (this.prologWritten) {
            throw new IllegalStateException(I18n.tr("Prolog of OsmChange document already written. Please write only once.", new Object[0]));
        }
        this.writer.print("<osmChange version=\"");
        this.writer.print(this.apiVersion);
        this.writer.println("\" generator=\"JOSM\">");
        this.prologWritten = true;
    }

    public void append(Collection<? extends IPrimitive> primitives) {
        if (primitives == null) {
            return;
        }
        this.checkProlog();
        for (IPrimitive iPrimitive : primitives) {
            this.write(iPrimitive);
        }
    }

    private void checkProlog() {
        if (!this.prologWritten) {
            throw new IllegalStateException(I18n.tr("Prolog of OsmChange document not written yet. Please write first.", new Object[0]));
        }
    }

    public void append(IPrimitive p) {
        if (p == null) {
            return;
        }
        this.checkProlog();
        this.write(p);
    }

    public void finish() {
        this.checkProlog();
        if (this.currentMode != null) {
            this.writer.print("</");
            this.writer.print(this.currentMode);
            this.writer.println(">");
        }
        this.writer.println("</osmChange>");
    }

    public String getDocument() {
        return this.swriter.toString();
    }
}

