/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.bsd;

import sun.jvm.hotspot.debugger.ThreadContext;
import sun.jvm.hotspot.debugger.bsd.BsdDebugger;
import sun.jvm.hotspot.debugger.bsd.amd64.BsdAMD64ThreadContext;
import sun.jvm.hotspot.debugger.bsd.ppc64.BsdPPC64ThreadContext;
import sun.jvm.hotspot.debugger.bsd.x86.BsdX86ThreadContext;

class BsdThreadContextFactory {
    BsdThreadContextFactory() {
    }

    static ThreadContext createThreadContext(BsdDebugger dbg) {
        String cpu = dbg.getCPU();
        if (cpu.equals("x86")) {
            return new BsdX86ThreadContext(dbg);
        }
        if (cpu.equals("amd64") || cpu.equals("x86_64")) {
            return new BsdAMD64ThreadContext(dbg);
        }
        if (cpu.equals("ppc64")) {
            return new BsdPPC64ThreadContext(dbg);
        }
        throw new RuntimeException("cpu " + cpu + " is not yet supported");
    }
}

