/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.sampled;

import gnu.classpath.ServiceFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.sound.sampled.spi.AudioFileReader;
import javax.sound.sampled.spi.AudioFileWriter;
import javax.sound.sampled.spi.FormatConversionProvider;
import javax.sound.sampled.spi.MixerProvider;

public class AudioSystem {
    public static final int NOT_SPECIFIED = -1;

    private AudioSystem() {
    }

    public static AudioFileFormat getAudioFileFormat(File f) throws UnsupportedAudioFileException, IOException {
        Iterator<AudioFileReader> i = ServiceFactory.lookupProviders(AudioFileReader.class);
        while (i.hasNext()) {
            AudioFileReader reader = i.next();
            try {
                return reader.getAudioFileFormat(f);
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {}
        }
        throw new UnsupportedAudioFileException("file type not recognized");
    }

    public static AudioFileFormat getAudioFileFormat(InputStream is) throws UnsupportedAudioFileException, IOException {
        Iterator<AudioFileReader> i = ServiceFactory.lookupProviders(AudioFileReader.class);
        while (i.hasNext()) {
            AudioFileReader reader = i.next();
            try {
                return reader.getAudioFileFormat(is);
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {}
        }
        throw new UnsupportedAudioFileException("input stream type not recognized");
    }

    public static AudioFileFormat getAudioFileFormat(URL url) throws UnsupportedAudioFileException, IOException {
        Iterator<AudioFileReader> i = ServiceFactory.lookupProviders(AudioFileReader.class);
        while (i.hasNext()) {
            AudioFileReader reader = i.next();
            try {
                return reader.getAudioFileFormat(url);
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {}
        }
        throw new UnsupportedAudioFileException("URL type not recognized");
    }

    public static AudioFileFormat.Type[] getAudioFileTypes() {
        HashSet<AudioFileFormat.Type> result = new HashSet<AudioFileFormat.Type>();
        Iterator<AudioFileWriter> i = ServiceFactory.lookupProviders(AudioFileWriter.class);
        while (i.hasNext()) {
            AudioFileWriter writer = i.next();
            AudioFileFormat.Type[] types = writer.getAudioFileTypes();
            int j = 0;
            while (j < types.length) {
                result.add(types[j]);
                ++j;
            }
        }
        return result.toArray(new AudioFileFormat.Type[result.size()]);
    }

    public static AudioFileFormat.Type[] getAudioFileTypes(AudioInputStream ais) {
        HashSet<AudioFileFormat.Type> result = new HashSet<AudioFileFormat.Type>();
        Iterator<AudioFileWriter> i = ServiceFactory.lookupProviders(AudioFileWriter.class);
        while (i.hasNext()) {
            AudioFileWriter writer = i.next();
            AudioFileFormat.Type[] types = writer.getAudioFileTypes(ais);
            int j = 0;
            while (j < types.length) {
                result.add(types[j]);
                ++j;
            }
        }
        return result.toArray(new AudioFileFormat.Type[result.size()]);
    }

    public static AudioInputStream getAudioInputStream(AudioFormat.Encoding targ, AudioInputStream ais) {
        Iterator<FormatConversionProvider> i = ServiceFactory.lookupProviders(FormatConversionProvider.class);
        while (i.hasNext()) {
            FormatConversionProvider prov = i.next();
            if (!prov.isConversionSupported(targ, ais.getFormat())) continue;
            return prov.getAudioInputStream(targ, ais);
        }
        throw new IllegalArgumentException("encoding not supported for stream");
    }

    public static AudioInputStream getAudioInputStream(AudioFormat targ, AudioInputStream ais) {
        Iterator<FormatConversionProvider> i = ServiceFactory.lookupProviders(FormatConversionProvider.class);
        while (i.hasNext()) {
            FormatConversionProvider prov = i.next();
            if (!prov.isConversionSupported(targ, ais.getFormat())) continue;
            return prov.getAudioInputStream(targ, ais);
        }
        throw new IllegalArgumentException("format not supported for stream");
    }

    public static AudioInputStream getAudioInputStream(File f) throws UnsupportedAudioFileException, IOException {
        Iterator<AudioFileReader> i = ServiceFactory.lookupProviders(AudioFileReader.class);
        while (i.hasNext()) {
            AudioFileReader reader = i.next();
            try {
                return reader.getAudioInputStream(f);
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {}
        }
        throw new UnsupportedAudioFileException("file type not recognized");
    }

    public static AudioInputStream getAudioInputStream(InputStream is) throws UnsupportedAudioFileException, IOException {
        Iterator<AudioFileReader> i = ServiceFactory.lookupProviders(AudioFileReader.class);
        while (i.hasNext()) {
            AudioFileReader reader = i.next();
            try {
                return reader.getAudioInputStream(is);
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {}
        }
        throw new UnsupportedAudioFileException("input stream type not recognized");
    }

    public static AudioInputStream getAudioInputStream(URL url) throws UnsupportedAudioFileException, IOException {
        Iterator<AudioFileReader> i = ServiceFactory.lookupProviders(AudioFileReader.class);
        while (i.hasNext()) {
            AudioFileReader reader = i.next();
            try {
                return reader.getAudioInputStream(url);
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {}
        }
        throw new UnsupportedAudioFileException("URL type not recognized");
    }

    public static Clip getClip() throws LineUnavailableException {
        Mixer.Info[] infos = AudioSystem.getMixerInfo();
        int i = 0;
        while (i < infos.length) {
            Mixer mix = AudioSystem.getMixer(infos[i]);
            Line[] lines = mix.getSourceLines();
            int j = 0;
            while (j < lines.length) {
                if (lines[j] instanceof Clip) {
                    return (Clip)lines[j];
                }
                ++j;
            }
            ++i;
        }
        throw new LineUnavailableException("no Clip available");
    }

    public static Clip getClip(Mixer.Info info) throws LineUnavailableException {
        Mixer mix = AudioSystem.getMixer(info);
        Line[] lines = mix.getSourceLines();
        int j = 0;
        while (j < lines.length) {
            if (lines[j] instanceof Clip) {
                return (Clip)lines[j];
            }
            ++j;
        }
        throw new LineUnavailableException("no Clip available");
    }

    public static Line getLine(Line.Info info) throws LineUnavailableException {
        Mixer.Info[] infos = AudioSystem.getMixerInfo();
        int i = 0;
        while (i < infos.length) {
            Mixer mix = AudioSystem.getMixer(infos[i]);
            try {
                return mix.getLine(info);
            }
            catch (LineUnavailableException lineUnavailableException) {
                ++i;
            }
        }
        throw new LineUnavailableException("no Clip available");
    }

    public static Mixer getMixer(Mixer.Info info) {
        Iterator<MixerProvider> i = ServiceFactory.lookupProviders(MixerProvider.class);
        while (i.hasNext()) {
            MixerProvider prov = i.next();
            if (!prov.isMixerSupported(info)) continue;
            return prov.getMixer(info);
        }
        throw new IllegalArgumentException("mixer not found");
    }

    public static Mixer.Info[] getMixerInfo() {
        HashSet<Mixer.Info> result = new HashSet<Mixer.Info>();
        Iterator<MixerProvider> i = ServiceFactory.lookupProviders(MixerProvider.class);
        while (i.hasNext()) {
            MixerProvider prov = i.next();
            Mixer.Info[] is = prov.getMixerInfo();
            int j = 0;
            while (j < is.length) {
                result.add(is[j]);
                ++j;
            }
        }
        return result.toArray(new Mixer.Info[result.size()]);
    }

    public static SourceDataLine getSourceDataLine(AudioFormat fmt) throws LineUnavailableException {
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, fmt);
        Mixer.Info[] mixers = AudioSystem.getMixerInfo();
        int i = 0;
        while (i < mixers.length) {
            Mixer mix = AudioSystem.getMixer(mixers[i]);
            if (mix.isLineSupported(info)) {
                return (SourceDataLine)mix.getLine(info);
            }
            ++i;
        }
        throw new LineUnavailableException("source data line not found");
    }

    public static SourceDataLine getSourceDataLine(AudioFormat fmt, Mixer.Info mixer) throws LineUnavailableException {
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, fmt);
        Mixer mix = AudioSystem.getMixer(mixer);
        if (mix.isLineSupported(info)) {
            return (SourceDataLine)mix.getLine(info);
        }
        throw new LineUnavailableException("source data line not found");
    }

    public static Line.Info[] getSourceLineInfo(Line.Info info) {
        HashSet<Line.Info> result = new HashSet<Line.Info>();
        Mixer.Info[] infos = AudioSystem.getMixerInfo();
        int i = 0;
        while (i < infos.length) {
            Mixer mix = AudioSystem.getMixer(infos[i]);
            Line.Info[] srcs = mix.getSourceLineInfo(info);
            int j = 0;
            while (j < srcs.length) {
                result.add(srcs[j]);
                ++j;
            }
            ++i;
        }
        return result.toArray(new Line.Info[result.size()]);
    }

    public static TargetDataLine getTargetDataLine(AudioFormat fmt) throws LineUnavailableException {
        DataLine.Info info = new DataLine.Info(TargetDataLine.class, fmt);
        Mixer.Info[] mixers = AudioSystem.getMixerInfo();
        int i = 0;
        while (i < mixers.length) {
            Mixer mix = AudioSystem.getMixer(mixers[i]);
            if (mix.isLineSupported(info)) {
                return (TargetDataLine)mix.getLine(info);
            }
            ++i;
        }
        throw new LineUnavailableException("target data line not found");
    }

    public static TargetDataLine getTargetDataLine(AudioFormat fmt, Mixer.Info mixer) throws LineUnavailableException {
        DataLine.Info info = new DataLine.Info(TargetDataLine.class, fmt);
        Mixer mix = AudioSystem.getMixer(mixer);
        if (mix.isLineSupported(info)) {
            return (TargetDataLine)mix.getLine(info);
        }
        throw new LineUnavailableException("target data line not found");
    }

    public static AudioFormat.Encoding[] getTargetEncodings(AudioFormat.Encoding source) {
        HashSet<AudioFormat.Encoding> result = new HashSet<AudioFormat.Encoding>();
        Iterator<FormatConversionProvider> i = ServiceFactory.lookupProviders(FormatConversionProvider.class);
        while (i.hasNext()) {
            FormatConversionProvider prov = i.next();
            if (!prov.isSourceEncodingSupported(source)) continue;
            AudioFormat.Encoding[] es = prov.getTargetEncodings();
            int j = 0;
            while (j < es.length) {
                result.add(es[j]);
                ++j;
            }
        }
        return result.toArray(new AudioFormat.Encoding[result.size()]);
    }

    public static AudioFormat.Encoding[] getTargetEncodings(AudioFormat source) {
        HashSet<AudioFormat.Encoding> result = new HashSet<AudioFormat.Encoding>();
        Iterator<FormatConversionProvider> i = ServiceFactory.lookupProviders(FormatConversionProvider.class);
        while (i.hasNext()) {
            FormatConversionProvider prov = i.next();
            AudioFormat.Encoding[] es = prov.getTargetEncodings(source);
            int j = 0;
            while (j < es.length) {
                result.add(es[j]);
                ++j;
            }
        }
        return result.toArray(new AudioFormat.Encoding[result.size()]);
    }

    public static AudioFormat[] getTargetFormats(AudioFormat.Encoding encoding, AudioFormat sourceFmt) {
        HashSet<AudioFormat> result = new HashSet<AudioFormat>();
        Iterator<FormatConversionProvider> i = ServiceFactory.lookupProviders(FormatConversionProvider.class);
        while (i.hasNext()) {
            FormatConversionProvider prov = i.next();
            AudioFormat[] es = prov.getTargetFormats(encoding, sourceFmt);
            int j = 0;
            while (j < es.length) {
                result.add(es[j]);
                ++j;
            }
        }
        return result.toArray(new AudioFormat[result.size()]);
    }

    public static Line.Info[] getTargetLineInfo(Line.Info info) {
        HashSet<Line.Info> result = new HashSet<Line.Info>();
        Mixer.Info[] infos = AudioSystem.getMixerInfo();
        int i = 0;
        while (i < infos.length) {
            Mixer mix = AudioSystem.getMixer(infos[i]);
            Line.Info[] targs = mix.getTargetLineInfo(info);
            int j = 0;
            while (j < targs.length) {
                result.add(targs[j]);
                ++j;
            }
            ++i;
        }
        return result.toArray(new Line.Info[result.size()]);
    }

    public static boolean isConversionSupported(AudioFormat.Encoding targ, AudioFormat source) {
        Iterator<FormatConversionProvider> i = ServiceFactory.lookupProviders(FormatConversionProvider.class);
        while (i.hasNext()) {
            FormatConversionProvider prov = i.next();
            if (!prov.isConversionSupported(targ, source)) continue;
            return true;
        }
        return false;
    }

    public static boolean isConversionSupported(AudioFormat targ, AudioFormat source) {
        Iterator<FormatConversionProvider> i = ServiceFactory.lookupProviders(FormatConversionProvider.class);
        while (i.hasNext()) {
            FormatConversionProvider prov = i.next();
            if (!prov.isConversionSupported(targ, source)) continue;
            return true;
        }
        return false;
    }

    private static boolean isFileTypeSupported(AudioFileFormat.Type[] types, AudioFileFormat.Type type) {
        int i = 0;
        while (i < types.length) {
            if (types[i].equals(type)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isFileTypeSupported(AudioFileFormat.Type type) {
        return AudioSystem.isFileTypeSupported(AudioSystem.getAudioFileTypes(), type);
    }

    public static boolean isFileTypeSupported(AudioFileFormat.Type type, AudioInputStream ais) {
        return AudioSystem.isFileTypeSupported(AudioSystem.getAudioFileTypes(ais), type);
    }

    public static boolean isLineSupported(Line.Info info) {
        Mixer.Info[] infos = AudioSystem.getMixerInfo();
        int i = 0;
        while (i < infos.length) {
            if (AudioSystem.getMixer(infos[i]).isLineSupported(info)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static int write(AudioInputStream ais, AudioFileFormat.Type type, File out) throws IOException {
        Iterator<AudioFileWriter> i = ServiceFactory.lookupProviders(AudioFileWriter.class);
        while (i.hasNext()) {
            AudioFileWriter w = i.next();
            if (!w.isFileTypeSupported(type, ais)) continue;
            return w.write(ais, type, out);
        }
        throw new IllegalArgumentException("file type not supported by system");
    }

    public static int write(AudioInputStream ais, AudioFileFormat.Type type, OutputStream os) throws IOException {
        Iterator<AudioFileWriter> i = ServiceFactory.lookupProviders(AudioFileWriter.class);
        while (i.hasNext()) {
            AudioFileWriter w = i.next();
            if (!w.isFileTypeSupported(type, ais)) continue;
            return w.write(ais, type, os);
        }
        throw new IllegalArgumentException("file type not supported by system");
    }
}

