/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.generator;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.logging.Logger;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.EuropeanNationType;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianNationType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.LandMap;
import net.sf.freecol.common.model.LostCityRumour;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.NationType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovement;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.option.FileOption;
import net.sf.freecol.common.option.IntegerOption;
import net.sf.freecol.common.option.OptionGroup;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.common.util.RandomChoice;
import net.sf.freecol.common.util.RandomUtils;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.generator.MapGenerator;
import net.sf.freecol.server.generator.TerrainGenerator;
import net.sf.freecol.server.model.ServerBuilding;
import net.sf.freecol.server.model.ServerColony;
import net.sf.freecol.server.model.ServerIndianSettlement;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.model.ServerRegion;
import net.sf.freecol.server.model.ServerUnit;

public class SimpleMapGenerator
implements MapGenerator {
    private static final Logger logger = Logger.getLogger(SimpleMapGenerator.class.getName());
    private static final float MIN_DISTANCE_FROM_POLE = 0.3f;
    private final Game game;
    private final Random random;
    private OptionGroup mapOptions;
    private Specification spec;
    private Game importGame;

    public SimpleMapGenerator(Game game, Random random) {
        this.game = game;
        this.random = random;
    }

    private void recache(boolean checkImport) {
        this.mapOptions = this.game.getMapGeneratorOptions();
        this.spec = this.game.getSpecification();
        File importFile = checkImport ? ((FileOption)this.mapOptions.getOption("model.option.importFile")).getValue() : null;
        this.importGame = importFile == null ? null : FreeColServer.readGame(importFile, this.spec, null);
    }

    private int getApproximateLandCount() {
        return this.mapOptions.getInteger("model.option.mapWidth") * this.mapOptions.getInteger("model.option.mapHeight") * this.mapOptions.getInteger("model.option.landMass") / 100;
    }

    private void makeLostCityRumours(Map map, LogBuilder lb) {
        boolean importRumours = this.mapOptions.getBoolean("model.option.importRumours");
        if (this.importGame != null && importRumours) {
            int nLCRs = 0;
            for (Tile importTile : this.importGame.getMap().getAllTiles()) {
                int y;
                int x;
                LostCityRumour rumour = importTile.getLostCityRumour();
                if (rumour == null || !map.isValid(x = importTile.getX(), y = importTile.getY())) continue;
                Tile t = map.getTile(x, y);
                rumour.setLocation(t);
                t.addLostCityRumour(rumour);
                ++nLCRs;
            }
            if (nLCRs > 0) {
                lb.add("Imported ", nLCRs, " lost city rumours.\n");
                return;
            }
        }
        int rumourNumber = this.mapOptions.getInteger("model.option.rumourNumber");
        int number = this.getApproximateLandCount() / rumourNumber;
        int counter = 0;
        if (this.importGame != null) {
            number = map.getWidth() * map.getHeight() * 25 / 3500;
        }
        block1: for (int i = 0; i < number; ++i) {
            for (int tries = 0; tries < 100; ++tries) {
                Tile t = map.getRandomLandTile(this.random);
                if (t.isPolar() || !t.isLand() || t.hasLostCityRumour() || t.hasSettlement() || t.getUnitCount() != 0) continue;
                LostCityRumour r = new LostCityRumour(t.getGame(), t);
                if (r.chooseType(null, this.random) == LostCityRumour.RumourType.MOUNDS && t.getOwningSettlement() != null) {
                    r.setType(LostCityRumour.RumourType.MOUNDS);
                }
                t.addLostCityRumour(r);
                ++counter;
                continue block1;
            }
        }
        lb.add("Created ", counter, " lost city rumours of maximum ", number, ".\n");
    }

    private boolean importIndianSettlements(Map map, LogBuilder lb) {
        int nSettlements = 0;
        for (Player player : this.importGame.getLiveNativePlayers(null)) {
            Player indian = this.game.getPlayerByNationId(player.getNationId());
            if (indian == null) {
                Nation nation = this.spec.getNation(player.getNationId());
                if (nation == null) {
                    lb.add("Native nation ", player.getNationId(), " not found in spec.\n");
                    continue;
                }
                indian = new ServerPlayer(this.game, false, nation, null, null);
                lb.add("Imported new native nation ", player.getNationId(), ": ", indian.getId(), "\n");
                this.game.addPlayer(indian);
                continue;
            }
            lb.add("Found native nation ", player.getNationId(), " for import: ", indian.getId(), "\n");
        }
        for (Tile tile : this.importGame.getMap().getAllTiles()) {
            IndianSettlement is = tile.getIndianSettlement();
            if (is == null) continue;
            Player indian = this.game.getPlayerByNationId(is.getOwner().getNationId());
            ServerIndianSettlement settlement = new ServerIndianSettlement(this.game, indian, is.getName(), map.getTile(tile.getX(), tile.getY()), is.isCapital(), is.getLearnableSkill(), null);
            settlement.placeSettlement(false);
            for (Tile tile2 : is.getOwnedTiles()) {
                map.getTile(tile2.getX(), tile2.getY()).changeOwnership(indian, settlement);
            }
            List<Unit> units = is.getUnitList();
            if (units.isEmpty()) {
                settlement.addUnits(this.random);
            } else {
                for (Unit unit : units) {
                    UnitType t2 = this.spec.getUnitType(unit.getType().getId());
                    if (t2 == null) continue;
                    ServerUnit u = new ServerUnit(this.game, settlement, indian, t2);
                    settlement.add(u);
                    settlement.addOwnedUnit(u);
                }
            }
            List<Goods> list = is.getCompactGoods();
            if (list.isEmpty()) {
                settlement.addRandomGoods(this.random);
            } else {
                for (Goods g : list) {
                    GoodsType t = this.spec.getGoodsType(g.getType().getId());
                    if (t == null) continue;
                    settlement.addGoods(t, g.getAmount());
                }
            }
            settlement.setWantedGoods(is.getWantedGoods());
            indian.addSettlement(settlement);
            ++nSettlements;
        }
        if (nSettlements > 0) {
            for (Tile t : this.importGame.getMap().getAllTiles()) {
                Tile tile;
                Player owner;
                if (t.getOwner() == null || (owner = this.game.getPlayerByNationId(t.getOwner().getNationId())) == null || (tile = map.getTile(t.getX(), t.getY())) == null) continue;
                tile.setOwner(owner);
                if (tile.getOwningSettlement() == null) continue;
                String name = tile.getOwningSettlement().getName();
                Settlement is = this.game.getSettlementByName(name);
                tile.setOwningSettlement(is);
            }
        }
        lb.add("Imported ", nSettlements, " native settlements.\n");
        return nSettlements > 0;
    }

    private void makeNativeSettlements(Map map, LogBuilder lb) {
        boolean importSettlements = this.mapOptions.getBoolean("model.option.importSettlements");
        if (importSettlements && this.importGame != null && this.importIndianSettlements(map, lb)) {
            return;
        }
        Game game = map.getGame();
        float shares = 0.0f;
        ArrayList<IndianSettlement> settlements = new ArrayList<IndianSettlement>();
        ArrayList<Player> indians = new ArrayList<Player>();
        HashMap<String, Object> territoryMap = new HashMap<String, Object>();
        for (Player player : game.getLiveNativePlayers(null)) {
            switch (player.getNationType().getNumberOfSettlements()) {
                case HIGH: {
                    shares += 4.0f;
                    break;
                }
                case AVERAGE: {
                    shares += 3.0f;
                    break;
                }
                case LOW: {
                    shares += 2.0f;
                }
            }
            indians.add(player);
            List<String> regionKeys = ((IndianNationType)player.getNationType()).getRegionNames();
            Object territory = null;
            if (regionKeys == null || regionKeys.isEmpty()) {
                territory = new Territory(player, map.getRandomLandTile(this.random));
                territoryMap.put(player.getId(), territory);
                continue;
            }
            for (String key : regionKeys) {
                if (territoryMap.get(key) != null) continue;
                ServerRegion region = (ServerRegion)map.getRegionByKey(key);
                territory = region == null ? new Territory(player, map.getRandomLandTile(this.random)) : new Territory(player, region);
                territoryMap.put(key, territory);
                lb.add("Allocated region ", key, " for ", player, ".\n");
                break;
            }
            if (territory != null) continue;
            lb.add("Failed to allocate preferred region ", regionKeys.get(0), " for ", player.getNation(), "\n");
            block12: for (String key : regionKeys) {
                Territory otherTerritory = (Territory)territoryMap.get(key);
                for (String string : ((IndianNationType)otherTerritory.player.getNationType()).getRegionNames()) {
                    if (territoryMap.get(string) != null) continue;
                    ServerRegion foundRegion = otherTerritory.region;
                    otherTerritory.region = (ServerRegion)map.getRegionByKey(string);
                    territoryMap.put(string, otherTerritory);
                    territory = new Territory(player, foundRegion);
                    territoryMap.put(key, territory);
                    break block12;
                }
            }
            if (territory != null) continue;
            lb.add("Unable to find free region for ", player.getName(), "\n");
            territory = new Territory(player, map.getRandomLandTile(this.random));
            territoryMap.put(player.getId(), territory);
        }
        if (indians.isEmpty()) {
            return;
        }
        ArrayList<Tile> allTiles = new ArrayList<Tile>();
        for (Tile t2 : map.getAllTiles()) {
            allTiles.add(t2);
        }
        RandomUtils.randomShuffle(logger, "All tile shuffle", allTiles, this.random);
        int n = this.spec.getRangeOption("model.option.settlementNumber").getValue();
        ArrayList<Tile> settlementTiles = new ArrayList<Tile>();
        for (Tile tile : allTiles) {
            if (tile.isPolar() || !this.suitableForNativeSettlement(tile) || !CollectionUtils.none(settlementTiles, t -> t.getDistanceTo(tile) < minDistance)) continue;
            settlementTiles.add(tile);
        }
        RandomUtils.randomShuffle(logger, "Settlement tiles", settlementTiles, this.random);
        int settlementsToPlace = settlementTiles.size();
        float share = (float)settlementsToPlace / shares;
        if (settlementTiles.size() < indians.size()) {
            lb.add("There are only ", settlementTiles.size(), " settlement sites.\n", " This is smaller than ", indians.size(), " the number of tribes.\n");
        }
        ArrayList<Territory> territories = new ArrayList<Territory>(territoryMap.values());
        int settlementsPlaced = 0;
        for (Territory territory : territories) {
            int radius;
            IndianSettlement is;
            switch (territory.player.getNationType().getNumberOfSettlements()) {
                case HIGH: {
                    territory.numberOfSettlements = Math.round(4.0f * share);
                    break;
                }
                case AVERAGE: {
                    territory.numberOfSettlements = Math.round(3.0f * share);
                    break;
                }
                case LOW: {
                    territory.numberOfSettlements = Math.round(2.0f * share);
                }
            }
            if ((is = this.placeCapital(map, territory, radius = territory.player.getNationType().getCapitalType().getClaimableRadius(), new ArrayList<Tile>(settlementTiles), lb)) == null) continue;
            settlements.add(is);
            ++settlementsPlaced;
            settlementTiles.remove(is.getTile());
        }
        Collections.sort(settlementTiles, Tile.edgeDistanceComparator);
        while (!settlementTiles.isEmpty() && !territories.isEmpty()) {
            Tile tile = (Tile)settlementTiles.remove(0);
            if (tile.getOwner() != null) continue;
            Territory territory = this.getClosestTerritory(map, tile, territories);
            int radius = territory.player.getNationType().getSettlementType(false).getClaimableRadius();
            if (territory.player.getClaimableTiles(tile, radius).size() <= 2 * radius + 1) continue;
            String name = territory.region == null ? "default region" : territory.region.toString();
            lb.add("Placing a ", territory.player, " camp in region: ", name, " at tile: ", tile, "\n");
            settlements.add(this.placeIndianSettlement(territory.player, false, tile, map, lb));
            ++settlementsPlaced;
            --territory.numberOfSettlements;
            if (territory.numberOfSettlements > 0) continue;
            territories.remove(territory);
        }
        HashMap<UnitType, Object> skills = new HashMap<UnitType, Object>();
        RandomUtils.randomShuffle(logger, "Settlements", settlements, this.random);
        for (IndianSettlement is : settlements) {
            UnitType skill;
            Object isList;
            ArrayList<Tile> tiles = new ArrayList<Tile>();
            block19: for (Tile tile : is.getOwnedTiles()) {
                for (Tile t3 : tile.getSurroundingTiles(1)) {
                    if (t3.getOwningSettlement() != null) continue;
                    tiles.add(tile);
                    continue block19;
                }
            }
            RandomUtils.randomShuffle(logger, "Settlement tiles", tiles, this.random);
            int minGrow = is.getType().getMinimumGrowth();
            int maxGrow = is.getType().getMaximumGrowth();
            if (maxGrow > minGrow) {
                Tile tile;
                for (int i = RandomUtils.randomInt(logger, "Gdiff", this.random, maxGrow - minGrow) + minGrow; i > 0 && (tile = this.findFreeNeighbouringTile(is, tiles)) != null; --i) {
                    tile.changeOwnership(is.getOwner(), is);
                    tiles.add(tile);
                }
            }
            if ((isList = (ArrayList<IndianSettlement>)skills.get(skill = is.getLearnableSkill())) == null) {
                isList = new ArrayList<IndianSettlement>();
                isList.add(is);
                skills.put(skill, isList);
                continue;
            }
            isList.add(is);
        }
        ArrayList<UnitType> arrayList = new ArrayList<UnitType>();
        for (GoodsType goodsType : this.spec.getNewWorldGoodsTypeList()) {
            UnitType expert = this.spec.getExpertForProducing(goodsType);
            if (skills.containsKey(expert)) continue;
            arrayList.add(expert);
        }
        ArrayList isList = new ArrayList(skills.values());
        while (!arrayList.isEmpty()) {
            UnitType neededSkill = (UnitType)arrayList.remove(0);
            Collections.sort(isList, CollectionUtils.descendingListLengthComparator);
            List extras = (List)isList.remove(0);
            UnitType extraSkill = ((IndianSettlement)extras.get(0)).getLearnableSkill();
            ArrayList choices = new ArrayList();
            for (IndianSettlement is : extras) {
                IndianNationType nation = (IndianNationType)is.getOwner().getNationType();
                int cm = is.isCapital() ? 2 : 1;
                RandomChoice<IndianSettlement> rc = null;
                for (RandomChoice<UnitType> c : nation.generateSkillsForTile(is.getTile())) {
                    if (c.getObject() != neededSkill) continue;
                    rc = new RandomChoice<IndianSettlement>(is, c.getProbability() * cm);
                    break;
                }
                choices.add(rc != null ? rc : new RandomChoice<IndianSettlement>(is, 1));
            }
            if (!choices.isEmpty()) {
                IndianSettlement chose = (IndianSettlement)RandomChoice.getWeightedRandom(logger, "expert", choices, this.random);
                lb.add("At ", chose.getName(), " replaced ", extraSkill, " (one of ", extras.size(), ")", " by missing ", neededSkill, "\n");
                chose.setLearnableSkill(neededSkill);
                extras.remove(chose);
                isList.add(0, extras);
                ArrayList<IndianSettlement> neededList = new ArrayList<IndianSettlement>();
                neededList.add(chose);
                isList.add(neededList);
                continue;
            }
            lb.add("Game is missing skill: ", neededSkill, "\n");
        }
        lb.add("Settlement skills:");
        for (List iss : isList) {
            if (iss.isEmpty()) {
                lb.add("  0 x <none>");
                continue;
            }
            lb.add("  ", iss.size(), " x ", ((IndianSettlement)iss.get(0)).getLearnableSkill().getSuffix());
        }
        lb.add("\nCreated ", settlementsPlaced, " Indian settlements of maximum ", settlementsToPlace, ".\n");
    }

    private boolean suitableForNativeSettlement(Tile tile) {
        if (!tile.getType().canSettle()) {
            return false;
        }
        int good = 0;
        int n = 0;
        for (Tile t : tile.getSurroundingTiles(1)) {
            if (t.getType().canSettle()) {
                ++good;
            }
            ++n;
        }
        return good >= n / 2;
    }

    private Tile findFreeNeighbouringTile(IndianSettlement is, List<Tile> tiles) {
        for (Tile tile : tiles) {
            for (Direction d : Direction.getRandomDirections("freeTile", logger, this.random)) {
                Tile t = tile.getNeighbourOrNull(d);
                if (t == null || t.getOwningSettlement() != null || !is.getOwner().canClaimForSettlement(t)) continue;
                return t;
            }
        }
        return null;
    }

    private Territory getClosestTerritory(Map map, Tile tile, List<Territory> territories) {
        Territory result = null;
        int minimumDistance = Integer.MAX_VALUE;
        for (Territory territory : territories) {
            int distance = map.getDistance(tile, territory.getCenterTile(map));
            if (distance >= minimumDistance) continue;
            minimumDistance = distance;
            result = territory;
        }
        return result;
    }

    private IndianSettlement placeCapital(Map map, Territory territory, int radius, List<Tile> tiles, LogBuilder lb) {
        final Tile center = territory.getCenterTile(map);
        Collections.sort(tiles, new Comparator<Tile>(){

            @Override
            public int compare(Tile t1, Tile t2) {
                return t1.getDistanceTo(center) - t2.getDistanceTo(center);
            }
        });
        for (Tile t : tiles) {
            if (territory.player.getClaimableTiles(t, radius).size() < (2 * radius + 1) * (2 * radius + 1) / 2) continue;
            String name = territory.region == null ? "default region" : territory.region.toString();
            lb.add("Placing the ", territory.player, " capital in region: ", name, " at tile: ", t, "\n");
            IndianSettlement is = this.placeIndianSettlement(territory.player, true, t, map, lb);
            --territory.numberOfSettlements;
            territory.tile = t;
            return is;
        }
        return null;
    }

    private IndianSettlement placeIndianSettlement(Player player, boolean capital, Tile tile, Map map, LogBuilder lb) {
        String name = capital ? player.getCapitalName(this.random) : player.getSettlementName(this.random);
        UnitType skill = this.generateSkillForLocation(map, tile, player.getNationType());
        ServerIndianSettlement settlement = new ServerIndianSettlement(map.getGame(), player, name, tile, capital, skill, null);
        player.addSettlement(settlement);
        lb.add("Generated skill for ", settlement.getName(), ": ", settlement.getLearnableSkill().getSuffix(), "\n");
        settlement.placeSettlement(true);
        settlement.addRandomGoods(this.random);
        settlement.addUnits(this.random);
        return settlement;
    }

    private UnitType generateSkillForLocation(Map map, Tile tile, NationType nationType) {
        List<RandomChoice<UnitType>> skills = ((IndianNationType)nationType).getSkills();
        HashMap<GoodsType, Integer> scale = new HashMap<GoodsType, Integer>();
        for (RandomChoice<UnitType> randomChoice : skills) {
            scale.put(randomChoice.getObject().getExpertProduction(), 1);
        }
        for (Tile tile2 : tile.getSurroundingTiles(1)) {
            for (Map.Entry entry : scale.entrySet()) {
                GoodsType goodsType = (GoodsType)entry.getKey();
                scale.put(goodsType, (Integer)entry.getValue() + tile2.getPotentialProduction(goodsType, null));
            }
        }
        ArrayList scaledSkills = new ArrayList();
        for (RandomChoice<UnitType> randomChoice : skills) {
            UnitType unitType = randomChoice.getObject();
            int scaleValue = (Integer)scale.get(unitType.getExpertProduction());
            scaledSkills.add(new RandomChoice<UnitType>(unitType, randomChoice.getProbability() * scaleValue));
        }
        UnitType unitType = (UnitType)RandomChoice.getWeightedRandom(null, null, scaledSkills, this.random);
        if (unitType == null) {
            List<UnitType> list = map.getSpecification().getUnitTypesWithAbility("model.ability.expertScout");
            return RandomUtils.getRandomMember(logger, "Scout", list, this.random);
        }
        return unitType;
    }

    /*
     * WARNING - void declaration
     */
    private void createEuropeanUnits(Map map, List<Player> players, LogBuilder lb) {
        int width = map.getWidth();
        int height = map.getHeight();
        int poleDistance = (int)(0.3f * (float)height / 2.0f);
        ArrayList<Player> europeanPlayers = new ArrayList<Player>();
        for (Player player : players) {
            if (player.isREF()) {
                int x = width - 2;
                int y = RandomUtils.randomInt(logger, "Pole", this.random, height - 2 * poleDistance) + poleDistance;
                player.setEntryLocation(map.getTile(x, y));
                continue;
            }
            if (!player.isEuropean()) continue;
            europeanPlayers.add(player);
        }
        List<Map.Position> positions = this.generateStartingPositions(map, europeanPlayers);
        ArrayList<Tile> startingTiles = new ArrayList<Tile>();
        ArrayList<ServerUnit> carriers = new ArrayList<ServerUnit>();
        ArrayList<ServerUnit> passengers = new ArrayList<ServerUnit>();
        for (int index = 0; index < europeanPlayers.size(); ++index) {
            Player player = (Player)europeanPlayers.get(index);
            Map.Position position = positions.get(index);
            lb.add("Generating units for player ", player, ".\n");
            carriers.clear();
            passengers.clear();
            List<AbstractUnit> unitList = ((EuropeanNationType)player.getNationType()).getStartingUnits();
            for (AbstractUnit startingUnit : unitList) {
                UnitType type = startingUnit.getType(this.spec);
                Role role = startingUnit.getRole(this.spec);
                ServerUnit newUnit = new ServerUnit(this.game, null, player, type, role);
                newUnit.setName(player.getNameForUnit(type, this.random));
                if (newUnit.isNaval()) {
                    if (!newUnit.canCarryUnits()) continue;
                    newUnit.setState(Unit.UnitState.ACTIVE);
                    carriers.add(newUnit);
                    continue;
                }
                newUnit.setState(Unit.UnitState.SENTRY);
                passengers.add(newUnit);
            }
            boolean startAtSea = true;
            if (carriers.isEmpty()) {
                lb.add("No carriers defined for player ", player, ".\n");
                startAtSea = false;
            }
            Tile startTile = null;
            int x = position.getX();
            int y = position.getY();
            for (int i = 0; i < 2 * map.getHeight(); ++i) {
                int n = i % 2 == 0 ? i / 2 : -(1 + i / 2);
                int row = y + n;
                if (row < 0 || row >= map.getHeight() || (startTile = this.findTileFor(map, row, x, startAtSea, lb)) == null) continue;
                if (startingTiles.contains(startTile)) {
                    startTile = null;
                    continue;
                }
                startingTiles.add(startTile);
                break;
            }
            if (startTile == null) {
                void var21_31;
                LogBuilder lb2 = new LogBuilder(64);
                lb2.add("Failed to find start tile ", startAtSea ? "at sea" : "on land", " for player ", player, " from (", x, ",", y, ") avoiding:");
                for (Tile t : startingTiles) {
                    lb2.add(" ", t);
                }
                lb2.add(" with map: ");
                boolean bl = false;
                while (var21_31 < map.getWidth()) {
                    lb2.add(" ", map.getTile((int)var21_31, y));
                    ++var21_31;
                }
                throw new RuntimeException(lb2.toString());
            }
            player.setEntryLocation(startTile);
            if (startAtSea) {
                for (Unit unit : carriers) {
                    unit.setLocation(startTile);
                    ((ServerPlayer)player).exploreForUnit(unit);
                }
                block7: for (Unit unit : passengers) {
                    for (Unit unit2 : carriers) {
                        if (!unit2.canAdd(unit)) continue;
                        unit.setLocation(unit2);
                        continue block7;
                    }
                    unit.setLocation(player.getEurope());
                }
            } else {
                for (Unit unit : passengers) {
                    unit.setLocation(startTile);
                    ((ServerPlayer)player).exploreForUnit(unit);
                }
            }
            if (!FreeColDebugger.isInDebugMode(FreeColDebugger.DebugMode.INIT)) continue;
            this.createDebugUnits(map, player, startTile, lb);
            IntegerOption op = this.spec.getIntegerOption("model.option.startingMoney");
            if (op == null) continue;
            op.setValue(10000);
        }
    }

    private Tile findTileFor(Map map, int row, int start, boolean startAtSea, LogBuilder lb) {
        Tile tile = null;
        Tile seas = null;
        int offset = start == 0 ? 1 : -1;
        for (int x = start; 0 <= x && x < map.getWidth(); x += offset) {
            tile = map.getTile(x, row);
            if (tile.isDirectlyHighSeasConnected()) {
                seas = tile;
                continue;
            }
            if (!tile.isLand()) continue;
            return startAtSea ? seas : tile;
        }
        lb.add("No land in row ", row, ".\n");
        return null;
    }

    private void createDebugUnits(Map map, Player player, Tile startTile, LogBuilder lb) {
        UnitType unitType = this.spec.getUnitType("model.unit.galleon");
        ServerUnit unit4 = new ServerUnit(this.game, startTile, player, unitType);
        unitType = this.spec.getUnitType("model.unit.privateer");
        ServerUnit privateer = new ServerUnit(this.game, startTile, player, unitType);
        ((ServerPlayer)player).exploreForUnit(privateer);
        unitType = this.spec.getUnitType("model.unit.freeColonist");
        ServerUnit unit5 = new ServerUnit(this.game, unit4, player, unitType);
        unitType = this.spec.getUnitType("model.unit.veteranSoldier");
        ServerUnit unit6 = new ServerUnit(this.game, unit4, player, unitType);
        unitType = this.spec.getUnitType("model.unit.jesuitMissionary");
        ServerUnit unit7 = new ServerUnit(this.game, unit4, player, unitType);
        Tile colonyTile = null;
        for (Tile tempTile : map.getCircleTiles(startTile, true, Integer.MAX_VALUE)) {
            if (tempTile.isPolar() || !player.canClaimToFoundSettlement(tempTile)) continue;
            colonyTile = tempTile;
            break;
        }
        if (colonyTile == null) {
            lb.add("Could not find a debug colony site.\n");
            return;
        }
        colonyTile.setType(CollectionUtils.find(this.spec.getTileTypeList(), t -> !t.isWater()));
        unitType = this.spec.getUnitType("model.unit.expertFarmer");
        ServerUnit buildColonyUnit = new ServerUnit(this.game, colonyTile, player, unitType);
        String colonyName = Messages.message(player.getNationLabel()) + " " + Messages.message("Colony");
        ServerColony colony = new ServerColony(this.game, player, colonyName, colonyTile);
        player.addSettlement(colony);
        colony.placeSettlement(true);
        for (Tile tile : colonyTile.getSurroundingTiles(1)) {
            if (tile.hasSettlement() || tile.getOwner() != null && tile.getOwner().isEuropean()) continue;
            tile.changeOwnership(player, colony);
            if (!tile.hasLostCityRumour()) continue;
            tile.removeLostCityRumour();
        }
        buildColonyUnit.setLocation(colony);
        if (buildColonyUnit.getLocation() instanceof ColonyTile) {
            Tile ct = ((ColonyTile)buildColonyUnit.getLocation()).getWorkTile();
            for (TileType t2 : this.spec.getTileTypeList()) {
                if (t2.isWater()) continue;
                ct.setType(t2);
                TileImprovementType plowType = map.getSpecification().getTileImprovementType("model.improvement.plow");
                TileImprovement plow = new TileImprovement(this.game, ct, plowType);
                plow.setTurnsToComplete(0);
                ct.add(plow);
                break;
            }
        }
        BuildingType schoolType = this.spec.getBuildingType("model.building.schoolhouse");
        ServerBuilding serverBuilding = new ServerBuilding(this.game, colony, schoolType);
        colony.addBuilding(serverBuilding);
        unitType = this.spec.getUnitType("model.unit.elderStatesman");
        ServerUnit statesman = new ServerUnit(this.game, colonyTile, player, unitType);
        statesman.setLocation(colony.getWorkLocationFor(statesman, statesman.getType().getExpertProduction()));
        unitType = this.spec.getUnitType("model.unit.expertLumberJack");
        ServerUnit lumberjack = new ServerUnit(this.game, colony, player, unitType);
        if (lumberjack.getLocation() instanceof ColonyTile) {
            Tile lt = ((ColonyTile)lumberjack.getLocation()).getWorkTile();
            for (TileType t3 : this.spec.getTileTypeList()) {
                if (!t3.isForested()) continue;
                lt.setType(t3);
                break;
            }
            lumberjack.changeWorkType(lumberjack.getType().getExpertProduction());
        }
        unitType = this.spec.getUnitType("model.unit.masterCarpenter");
        ServerUnit carpenter = new ServerUnit(this.game, colony, player, unitType);
        unitType = this.spec.getUnitType("model.unit.seasonedScout");
        ServerUnit scout = new ServerUnit(this.game, colonyTile, player, unitType);
        ((ServerPlayer)player).exploreForUnit(scout);
        unitType = this.spec.getUnitType("model.unit.veteranSoldier");
        ServerUnit unit8 = new ServerUnit(this.game, colonyTile, player, unitType);
        ServerUnit unit9 = new ServerUnit(this.game, colonyTile, player, unitType);
        unitType = this.spec.getUnitType("model.unit.artillery");
        ServerUnit unit10 = new ServerUnit(this.game, colonyTile, player, unitType);
        ServerUnit unit11 = new ServerUnit(this.game, colonyTile, player, unitType);
        ServerUnit unit12 = new ServerUnit(this.game, colonyTile, player, unitType);
        unitType = this.spec.getUnitType("model.unit.treasureTrain");
        ServerUnit unit13 = new ServerUnit(this.game, colonyTile, player, unitType);
        unit13.setTreasureAmount(10000);
        unitType = this.spec.getUnitType("model.unit.wagonTrain");
        ServerUnit unit14 = new ServerUnit(this.game, colonyTile, player, unitType);
        GoodsType cigarsType = this.spec.getGoodsType("model.goods.cigars");
        Goods cigards = new Goods(this.game, unit14, cigarsType, 5);
        unit14.add(cigards);
        unitType = this.spec.getUnitType("model.unit.jesuitMissionary");
        ServerUnit unit15 = new ServerUnit(this.game, colonyTile, player, unitType);
        ServerUnit unit16 = new ServerUnit(this.game, colonyTile, player, unitType);
        ((ServerPlayer)player).exploreForSettlement(colony);
    }

    private List<Map.Position> generateStartingPositions(Map map, List<Player> players) {
        int number = players.size();
        ArrayList<Map.Position> positions = new ArrayList<Map.Position>(number);
        if (number > 0) {
            int west = 0;
            int east = map.getWidth() - 1;
            switch (this.spec.getInteger("model.option.startingPositions")) {
                case 0: {
                    int distance = map.getHeight() / number;
                    int row = distance / 2;
                    for (int index = 0; index < number; ++index) {
                        positions.add(new Map.Position(east, row));
                        row += distance;
                    }
                    RandomUtils.randomShuffle(logger, "Classic starting positions", positions, this.random);
                    break;
                }
                case 1: {
                    int distance = 2 * map.getHeight() / number;
                    int row = distance / 2;
                    for (int index = 0; index < number; ++index) {
                        if (index % 2 == 0) {
                            positions.add(new Map.Position(east, row));
                            continue;
                        }
                        positions.add(new Map.Position(west, row));
                        row += distance;
                    }
                    RandomUtils.randomShuffle(logger, "Random starting positions", positions, this.random);
                    break;
                }
                case 2: {
                    for (Player player : players) {
                        Nation nation = player.getNation();
                        positions.add(new Map.Position(nation.startsOnEastCoast() ? east : west, map.getRow(nation.getPreferredLatitude())));
                    }
                    break;
                }
            }
        }
        return positions;
    }

    @Override
    public Map createEmptyMap(int width, int height, LogBuilder lb) {
        this.recache(false);
        return new TerrainGenerator(this.game, null, this.random).createMap(new LandMap(width, height), lb);
    }

    @Override
    public Map createMap(LogBuilder lb) {
        this.recache(true);
        LandMap landMap = this.importGame != null ? new LandMap(this.importGame) : new LandMap(this.mapOptions, this.random);
        Map map = new TerrainGenerator(this.game, this.importGame, this.random).createMap(landMap, lb);
        this.makeNativeSettlements(map, lb);
        this.makeLostCityRumours(map, lb);
        this.createEuropeanUnits(map, this.game.getLiveEuropeanPlayers(null), lb);
        return map;
    }

    private static class Territory {
        public ServerRegion region;
        public Tile tile;
        public final Player player;
        public int numberOfSettlements;

        public Territory(Player player, Tile tile) {
            this.player = player;
            this.tile = tile;
        }

        public Territory(Player player, ServerRegion region) {
            this.player = player;
            this.region = region;
        }

        public Tile getCenterTile(Map map) {
            if (this.tile != null) {
                return this.tile;
            }
            int[] xy = this.region.getCenter();
            return map.getTile(xy[0], xy[1]);
        }

        public String toString() {
            return this.player + " territory at " + this.region;
        }
    }
}

