/*!
 * facette - Time series data visualization software
 * Website: https://facette.io/
 * License: BSD
 */
!function(){"use strict";function Chart(config,update){update="boolean"==typeof update&&update,this.loadConfig(config,update),this.updateData(),this.drawSVG(),this.drawBackgroundRect(),this.drawMain(),this.drawTitles(),this.drawAxis(),this.drawArea(),this.drawSeries(),this.drawZoomRect(),this.drawEventRect(),this.drawTooltip(),this.config.legend.enabled&&this.drawLegend()}function formatSize(value){if(0===value)return"0";var index=parseInt(Math.log(Math.abs(value))/Math.log(1024),10);return value/=Math.pow(1024,index),Math.round(100*value)/100+(index>0?sizeUnits[index]:"")}function timeToRange(duration){var seconds=Math.abs(duration),chunks=[];for(var unit in timeUnits){var count=Math.floor(seconds/timeUnits[unit]);count>0&&(chunks.push(count+unit),seconds%=timeUnits[unit])}var result=chunks.join(" ");return duration<0&&(result="-"+result),result}function slugify(input){return input.toLowerCase().replace(/[^\w\- ]+/g,"").replace(/ +/g,"-")}function parseFloatList(input){return $.map(input,function(x){return parseFloat(x)})}function apiTransformRequest(data){return delete data.type,delete data.normalize,JSON.stringify(data)}function apiInterceptList(data){return data.resource.$totalRecords=parseInt(data.headers("X-Total-Records"),10),data.resource}String.prototype.startsWith||(String.prototype.startsWith=function(string){return this.substr(0,string.length)===string}),String.prototype.endsWith||(String.prototype.endsWith=function(string){return this.substr(-string.length)===string}),String.prototype.matchAll||(String.prototype.matchAll=function(re){var match,str,idx,matches=[];for(re.global||(str=re.toString(),idx=str.lastIndexOf("/"),re=new RegExp(str.substr(str.indexOf("/")+1,idx-1),str.substr(idx+1)+"g"));match=re.exec(this);)0!==match.length&&matches.push(match[1]);return matches});var chart={fn:Chart.prototype,colors:["#7cb5ec","#434348","#90ed7d","#f7a35c","#8085e9","#f15c80","#e4d354","#8085e8","#8d4653","#91e8e1"]};chart.create=function(config){return new Chart(config,!1)},chart.update=function(config){return new Chart(config,!0)},chart.get=function(element){return element._chart},chart.fn.redraw=function(){var $$=this;$$.updateData(),$$.drawAxis(),$$.drawArea(),$$.drawSeries(),$$.drawZoomRect(),$$.drawEventRect()},chart.fn.loadConfig=function(config,update){update="boolean"==typeof update&&update;var $$=this;if($$.config=chart.utils.extend($$.getDefaultConfig(),config),update){var element=d3.select(config.bindTo).select("svg.chart").node();if(element){var configOld=chart.get(element).config||{},disableStates={};configOld.series.forEach(function(series){disableStates[series.name]=series.disabled||!1}),$$.config.series.forEach(function(series){disableStates[series.name]&&(series.disabled=disableStates[series.name])})}}$$.config.series.forEach(function(series,idx){series.color=series.color||$$.config.colors.series[idx%$$.config.colors.series.length]})},chart.fn.getDefaultConfig=function(){return{axis:{x:{max:null,min:null,tick:{count:10}},y:{label:null,max:null,min:null,tick:{count:10,format:d3.format("g")}}},colors:{series:chart.colors,lines:["#16a085","#27ae60","#2980b9","#8e44ad","#2c3e50","#f39c12","#d35400","#c0392b"]},constants:[],controls:{enabled:!0},events:{},legend:{enabled:!1},padding:24,series:[],subtitle:null,title:null,tooltip:{date:{format:null}},type:"area",zoom:{enabled:!1,onSelect:null}}},chart.fn.updateData=function(){var $$=this;if($$.dataSet=$$.config.series.map(function(series){return!series.points||series.disabled?[]:series.points.map(function(a){return{x:1e3*a[0],y1:a[1]}})}),$$.config.stack&&$$.dataSet.length>0){var stackData=new Array($$.dataSet[0].length),keys=[];$$.config.series.forEach(function(series){series.points||(series.points=[]),series.points.forEach(function(point,idx){stackData[idx]||(stackData[idx]={date:1e3*point[0]}),stackData[idx][series.name]=series.disabled?0:point[1]}),keys.push(series.name)}),"percent"==$$.config.stack&&stackData.forEach(function(entry){var sum=0;keys.forEach(function(key){sum+=entry[key]}),keys.forEach(function(key){0!==sum&&(entry[key]/=sum)})}),$$.stack=d3.stack().keys(keys),$$.config.stack&&$$.stack.order(d3.stackOrderReverse);var stackSet=new Array($$.dataSet.length).fill([]);$$.stack(stackData).forEach(function(entry,idx){stackSet[idx]=$$.config.series[idx].disabled?[]:entry.map(function(a){return{x:a.data.date,y0:a[0],y1:a[1]}})}),$$.dataSet=stackSet}},chart.fn.drawSVG=function(){var $$=this,element=d3.select($$.config.bindTo),elementOld=element.selectAll("svg.chart");elementOld.node()&&($$.config.legend.enabled=chart.get(elementOld.node()).config.legend.enabled,elementOld.remove(),element.selectAll(".chart-tooltip").remove()),$$.width=$$.config.bindTo.clientWidth,$$.height=$$.config.bindTo.clientHeight,$$.svg=element.append("svg").attr("class","chart").attr("width",$$.width).attr("height",$$.height),$$.svg.node()._chart=this},chart.fn.getSVG=function(){var node=this.svg.node(),clone=node.cloneNode(!0);return clone.setAttribute("version","1.1"),clone.setAttribute("xmlns","http://www.w3.org/2000/svg"),chart.utils.inlineStyles(node,clone),d3.select(clone).selectAll(".chart-cursor, .chart-event, .chart-zoom").remove(),(new XMLSerializer).serializeToString(clone)},chart.fn.drawBackgroundRect=function(){var $$=this;$$.bgRect=$$.svg.append("rect").attr("class","chart-background").attr("width",$$.width).attr("height",$$.height)},chart.fn.drawZoomRect=function(){var $$=this;$$.config.zoom.enabled&&($$.zoomRect=$$.areaGroup.append("rect").attr("class","chart-zoom").attr("width",0).attr("height",$$.height-($$.titleGroup?$$.titleGroup.node().getBBox().height:0)-2*$$.config.padding).style("display","none"),$$.zoomOrigin=null,$$.zoomActive=!1,$$.zoomCancelled=!1)},chart.fn.resetZoomRect=function(){var $$=this;d3.select(document.body).on("keydown",null),$$.zoomOrigin=null,$$.zoomActive=!1,$$.zoomCancelled=!1,$$.zoomRect.attr("x",0).attr("width",0).style("display","none"),$$.cursorLine.style("display","block")},chart.fn.drawEventRect=function(){var $$=this,dateBisect=d3.bisector(function(a){return 1e3*a[0]}).left,rectWidth=$$.areaGroup.node().getBBox().width,rectHeight=$$.height-($$.titleGroup?$$.titleGroup.node().getBBox().height:0)-2*$$.config.padding,tooltipPosYStick=!1,tooltipDelta=$$.yAxisGroup.node().getBBox().width+$$.config.padding;$$.areaGroup.append("rect").attr("class","chart-event").attr("fill","transparent").attr("width",rectWidth).attr("height",rectHeight).on("dragstart",function(){d3.event.preventDefault(),d3.event.stopPropagation()}).on("mouseout",function(){tooltipPosYStick=!1,$$.cursorLine.style("display","none"),$$.toggleTooltip(!1),$$.config.events.cursorMove&&$$.config.events.cursorMove(null)}).on("mousedown",function(){$$.config.zoom.onStart&&$$.config.zoom.onStart(),d3.select(document.body).on("keydown",function(){27==d3.event.which&&($$.zoomCancelled=!0,$$.resetZoomRect())}),$$.zoomOrigin=d3.mouse(this)[0],$$.zoomActive=!0,$$.zoomRect.style("display","block"),$$.cursorLine.style("display","none")}).on("mouseup",function(){if(!$$.zoomCancelled&&$$.config.zoom.onSelect){var start=$$.xScale.invert(parseInt($$.zoomRect.attr("x"),10)),end=$$.xScale.invert(parseInt($$.zoomRect.attr("x"),10)+parseInt($$.zoomRect.attr("width"),10)),startTime=start.getTime(),endTime=end.getTime();isNaN(startTime)||isNaN(endTime)||startTime===endTime||$$.config.zoom.onSelect(start,end)}$$.resetZoomRect()}).on("mousemove",function(){var mouse=d3.mouse(this);if($$.tooltipEnabled||$$.cursorLine.style("display","block"),$$.cursorLine.attr("x1",mouse[0]).attr("x2",mouse[0]),$$.config.events.cursorMove&&$$.config.events.cursorMove($$.xScale.invert(mouse[0])),!$$.tooltipLocked){var data={date:$$.xScale.invert(mouse[0]),values:[]};$$.config.series.forEach(function(series,idx){var idxPoints=series.points?dateBisect(series.points,data.date,1):-1;data.values[idx]={name:series.name,value:-1!=idxPoints?series.points[idxPoints]:null}}),$$.updateTooltip(data);var tooltipPosX=mouse[0]+tooltipDelta,tooltipPosXKey="left",tooltipPosY=tooltipPosYStick?0:rectHeight+$$.config.padding-mouse[1],tooltipPosYKey=tooltipPosYStick?"top":"bottom",tooltipWidth=$$.tooltipGroup.node().clientWidth;if($$.legendGroup&&(tooltipPosY+=$$.legendGroup.node().getBBox().height+$$.config.padding),$$.zoomActive&&$$.zoomRect.attr("x",Math.min($$.zoomOrigin,mouse[0])).attr("width",Math.abs(mouse[0]-$$.zoomOrigin)),$$.tooltipEnabled||$$.toggleTooltip(!0),tooltipPosX+tooltipWidth>rectWidth?(tooltipPosX=Math.abs(mouse[0]-rectWidth)+$$.config.padding,tooltipPosXKey="right",$$.tooltipGroup.style("left",null)):($$.yLegend&&(tooltipPosX+=$$.config.padding),$$.tooltipGroup.style("right",null)),!tooltipPosYStick){$$.tooltipGroup.node().getBoundingClientRect().top<0?(tooltipPosY=0,tooltipPosYKey="top",tooltipPosYStick=!0,$$.tooltipGroup.style("bottom",null)):$$.tooltipGroup.style("top",null)}$$.tooltipGroup.style(tooltipPosXKey,tooltipPosX+"px").style(tooltipPosYKey,tooltipPosY+"px")}})},chart.fn.drawMain=function(){var $$=this;$$.mainGroup=$$.svg.append("g").attr("transform","translate("+$$.config.padding+","+$$.config.padding+")")},chart.fn.drawTitles=function(){var $$=this;if($$.config.title||$$.config.subtitle){$$.titleGroup=$$.mainGroup.append("g").attr("transform","translate("+$$.width/2+",0)");var title,subtitle;$$.config.title&&(title=$$.titleGroup.append("text").attr("class","chart-title").attr("text-anchor","middle").text($$.config.title)),$$.config.subtitle&&(subtitle=$$.titleGroup.append("text").attr("class","chart-subtitle").attr("text-anchor","middle").text($$.config.subtitle),$$.config.title&&subtitle.attr("transform","translate(0,"+title.node().getBBox().height+")"))}},chart.fn.drawAxis=function(){var $$=this;$$.config.axis.y.label&&($$.yLegend=$$.mainGroup.append("text").attr("class","chart-axis-legend").attr("text-anchor","middle").attr("transform","translate(0,"+$$.height/2+") rotate(-90)").text($$.config.axis.y.label));var yAxisTop=$$.titleGroup?$$.titleGroup.node().getBBox().height:0,yAxisLeft=$$.yLegend?$$.yLegend.node().getBBox().height+$$.config.padding/2:0;$$.yScale=d3.scaleLinear().domain($$.getDomain("y","y1")).range([$$.height-yAxisTop-2*$$.config.padding,0]).nice(),$$.yFormat="percent"==$$.config.stack?d3.format(".0%"):$$.config.axis.y.tick.format,$$.yAxis=d3.axisLeft().scale($$.yScale).ticks($$.config.axis.y.tick.count).tickFormat($$.yFormat),$$.yAxisGroup&&$$.yAxisGroup.remove(),$$.yAxisGroup=$$.mainGroup.append("g").call($$.yAxis).attr("class","chart-axis chart-axis-y").attr("transform",function(a){return"translate("+(this.getBBox().width+yAxisLeft)+","+yAxisTop+")"}),$$.yLines={};var xAxisTop=$$.height-2*$$.config.padding,xAxisLeft=$$.yAxisGroup.node().getBBox().width,xAxisWidth=$$.width-xAxisLeft-2*$$.config.padding;if($$.yLegend){var xAxisDelta=$$.yLegend.node().getBBox().height+$$.config.padding/2;xAxisLeft+=xAxisDelta,xAxisWidth-=xAxisDelta}$$.xScale=d3.scaleTime().domain($$.getDomain("x","x")).range([0,xAxisWidth]),$$.xFormat=function(date){return(d3.timeSecond(date)<date?d3.timeFormat(".%L"):d3.timeMinute(date)<date?d3.timeFormat(":%S"):d3.timeHour(date)<date?d3.timeFormat("%H:%M"):d3.timeDay(date)<date?d3.timeFormat("%H:00"):d3.timeMonth(date)<date?d3.timeFormat("%a %d"):d3.timeYear(date)<date?d3.timeFormat("%B"):d3.timeFormat("%Y"))(date)},$$.xAxis=d3.axisBottom().scale($$.xScale).ticks($$.config.axis.x.tick.count).tickFormat($$.xFormat).tickSizeOuter(0),$$.xAxisGroup&&$$.xAxisGroup.remove(),$$.xAxisGroup=$$.mainGroup.append("g").call($$.xAxis).attr("class","chart-axis chart-axis-x").attr("transform",function(a){return"translate("+xAxisLeft+","+xAxisTop+")"})},chart.fn.getDomain=function(axis,dataKey){var min,max,$$=this;return null!==$$.config.axis[axis].min?min=$$.config.axis[axis].min:(min=d3.min($$.dataSet,function(a){return d3.min(a,function(b){return b[dataKey]})}))>0&&(min=0),max=null!==$$.config.axis[axis].max?$$.config.axis[axis].max:d3.max($$.dataSet,function(a){return d3.max(a,function(b){return b[dataKey]})}),"y"==axis&&min<0&&(max=Math.max(max,Math.abs(min)),min=-1*max),[min||0,max||1]},chart.fn.addYLine=function(name,value){var $$=this,xVal=$$.width-$$.yAxisGroup.node().getBBox().width-2*$$.config.padding,yVal=$$.yScale(value);return $$.yLines[name]=$$.areaGroup.append("line").attr("class","chart-line").attr("x1",0).attr("x2",xVal).attr("y1",yVal).attr("y2",yVal),$$.yLines[name]},chart.fn.removeYLine=function(name){var $$=this;$$.yLines[name].remove(),delete $$.yLines[name]},chart.fn.drawArea=function(){var $$=this,areaTop=$$.titleGroup?$$.titleGroup.node().getBBox().height:0,areaLeft=$$.yAxisGroup.node().getBBox().width;$$.yLegend&&(areaLeft+=$$.yLegend.node().getBBox().height+$$.config.padding/2),$$.area=d3.area().defined(function(a){return null!==a.y1&&void 0!==a.y1}).x(function(a){return $$.xScale(a.x)}).y0(function(a){return $$.yScale(a.y0||0)}).y1(function(a){return $$.yScale(a.y1)}),$$.line=d3.line().defined($$.area.defined()).x(function(a){return $$.xScale(a.x)}).y(function(a){return $$.yScale(a.y1)}),$$.areaGroup&&$$.areaGroup.remove(),$$.areaGroup=$$.mainGroup.insert("g","g.chart-axis").attr("class","chart-area").attr("transform","translate("+areaLeft+","+areaTop+")");var ticks=$$.yScale.ticks($$.config.axis.y.tick.count),xVal=$$.width-areaLeft-2*$$.config.padding;ticks.forEach(function(tick){var yVal=$$.yScale(tick);$$.areaGroup.append("line").attr("class","chart-grid").attr("x1",0).attr("x2",xVal).attr("y1",yVal).attr("y2",yVal)}),$$.cursorLine=$$.areaGroup.append("line").attr("class","chart-grid chart-cursor").attr("x1",0).attr("x2",0).attr("y1",0).attr("y2",$$.height-areaTop-2*$$.config.padding).style("display","none")},chart.fn.toggleCursor=function(time){var $$=this,domain=$$.xScale.domain();if(!time||time<domain[0]||time>domain[1])return void $$.cursorLine.style("display","none");var x=$$.xScale(time);$$.cursorLine.attr("x1",x).attr("x2",x).style("display","block")},chart.fn.drawSeries=function(){var $$=this,count=0;$$.config.series.map(function(a){!a.disabled&&a.points&&count++}),$$.tooltipLocked=0===count,$$.areaGroup.selectAll(".chart-series").remove();var data=$$.areaGroup.selectAll(".chart-series").data($$.dataSet),series=data.enter().insert("g","line.chart-cursor").attr("class","chart-series");"area"==$$.config.type&&series.append("path").attr("class","chart-area").attr("d",function(a){return $$.area(a)}).style("fill",function(a,i){return chart.utils.toRGBA($$.config.series[i].color,.65)}),series.append("path").attr("class","chart-line").attr("d",function(a){return $$.line(a)}).style("stroke",function(a,i){return $$.config.series[i].color}),$$.config.constants&&$$.config.constants.forEach(function(constant,idx){$$.addYLine("constant"+idx,constant).attr("class","chart-line chart-constant")})},chart.fn.toggleSeries=function(idx,state){var $$=this;$$.config.series[idx].disabled="boolean"==typeof state?state:!$$.config.series[idx].disabled,$$.redraw()},chart.fn.highlightSeries=function(idx,state){var $$=this;state="boolean"==typeof state&&state,$$.areaGroup.selectAll(".chart-series").classed("fade",!!state&&function(a,i){return i!==idx}).classed("highlight",!!state&&function(a,i){return i===idx})},chart.fn.drawTooltip=function(){var $$=this,container=d3.select($$.config.bindTo);container.selectAll(".chart-tooltip").remove(),$$.tooltipGroup=container.append("div").attr("class","chart-tooltip").style("display","none");var table=$$.tooltipGroup.append("table");$$.tooltipDate=table.append("thead").append("tr").append("th").attr("class","chart-tooltip-date").attr("colspan",2),$$.tooltipBody=table.append("tbody"),$$.tooltipEnabled=!1},chart.fn.toggleTooltip=function(state){var $$=this;$$.tooltipEnabled=state,this.tooltipGroup.style("display",$$.tooltipEnabled?"block":"none"),$$.tooltipEnabled||$$.tooltipBody.selectAll("tr").remove()},chart.fn.updateTooltip=function(data){var $$=this;$$.tooltipDate.text($$.config.tooltip.date.format?$$.config.tooltip.date.format(data.date):data.date),$$.tooltipBody.selectAll("tr").remove();var total=0;data.values.forEach(function(entry,idx){if(!$$.config.series[idx].disabled&&$$.config.series[idx].points&&0!==$$.config.series[idx].points.length){var row=$$.tooltipBody.append("tr"),cell=row.append("th");cell.append("span").attr("class","chart-tooltip-color").style("background-color",$$.config.series[idx].color),cell.append("span").text(entry.name);var isNull=void 0===entry.value||null===entry.value;isNull||(total+=entry.value[1]),row.append("td").classed("null",isNull).text(isNull?"null":$$.config.axis.y.tick.format(entry.value[1]))}});var row=$$.tooltipBody.append("tr");row.append("th").attr("class","total").text("Total"),row.append("td").text($$.config.axis.y.tick.format(total))},chart.fn.drawLegend=function(){function toggleSeries(idx){var parent=d3.select(this.parentNode),disabled=parent.classed("disabled");if(d3.event.shiftKey){var legend=d3.select(this.parentNode.parentNode);(!disabled&&1==legend.selectAll(".chart-legend-row.enabled").nodes().length||disabled&&1==legend.selectAll(".chart-legend-row.disabled").nodes().length)&&(disabled=!disabled),$$.config.series.forEach(function(series,i){$$.toggleSeries(i,i===idx?disabled:!disabled)}),legend.selectAll(".chart-legend-row").classed("enabled",disabled).classed("disabled",!disabled),parent.classed("enabled",!disabled).classed("disabled",disabled)}else $$.toggleSeries(idx),parent.classed("enabled",disabled).classed("disabled",!disabled)}function highlightSeries(idx){d3.select(this.parentNode).classed("disabled")||$$.highlightSeries(idx,"mouseenter"==d3.event.type)}function toggleLegendYLine(data){if(!d3.select(this.parentNode).classed("disabled")&&null!==$$.config.series[data[0]].summary[data[1]]){var name=data[1]+""+data[2],node=d3.select(this);if(node.classed("active"))return $$.removeYLine(name),void node.attr("fill","inherit").classed("active",!1);var line=$$.addYLine(name,data[2]),color=$$.config.colors.lines[Object.keys($$.yLines).indexOf(name)%$$.config.colors.lines.length];line.attr("stroke",color),node.attr("fill",color).classed("active",!0)}}var $$=this;if(0!==$$.config.series.length){var areaBBox=$$.areaGroup.node().getBBox(),legendTop=($$.titleGroup?$$.titleGroup.node().getBBox().height:0)+areaBBox.height+$$.xAxisGroup.node().getBBox().height+$$.config.padding/2,legendLeft=$$.yAxisGroup.node().getBBox().width,legendBoundary=legendLeft+areaBBox.width;$$.legendGroup=$$.mainGroup.append("g").attr("class","chart-legend").attr("transform","translate("+legendLeft+","+legendTop+")");var element,elementBBox,legendRows=[],legendColumns=[],columnLeft=0,filterKeys=function(a){return-1==graphSummaryBase.indexOf(a)};$$.config.series.forEach(function(series,idx){if(legendRows[idx]=$$.legendGroup.append("g").attr("class","chart-legend-row").attr("transform","translate(0,"+24*idx+")").classed("disabled",series.disabled||!1),legendRows[idx].append("rect").attr("class","chart-legend-color").attr("width",24*.65).attr("height",12).attr("rx",2).attr("ry",2).attr("y",4.5).attr("fill",series.color),series.points&&0!==series.points.length?legendRows[idx].classed("enabled",!0):(legendRows[idx].classed("error",!0),legendRows[idx].append("text").attr("class","chart-legend-icon").attr("x",3).attr("y",24/1.65).text("")),element=legendRows[idx].append("text").datum(idx).attr("class","chart-legend-name").attr("x",24).attr("y",12).text(series.name).on("click",toggleSeries).on("mouseenter",highlightSeries).on("mouseleave",highlightSeries),elementBBox=element.node().getBBox(),columnLeft=Math.max(columnLeft,elementBBox.x+elementBBox.width+24),series.summary){var keys=Object.keys(series.summary);keys.sort(),keys=graphSummaryBase.concat(keys.filter(filterKeys)),keys.forEach(function(key){-1==legendColumns.indexOf(key)&&legendColumns.push(key)})}});var rowDelta=0;legendColumns.forEach(function(key){var groupBBox,groupTop=24*rowDelta+12,keyLeft=columnLeft,valueLeft=0;$$.config.series.forEach(function(series,idx){var group=legendRows[idx].append("g").attr("class","chart-legend-group").attr("transform","translate("+keyLeft+","+groupTop+")");element=group.append("text").attr("class","chart-legend-key").text(key),0===valueLeft&&(valueLeft=group.node().getBBox().width+24*.35);var value=series.summary&&void 0!==series.summary[key]?series.summary[key]:null;element=group.append("text").datum([idx,key,value]).attr("class","chart-legend-value").attr("x",valueLeft).text(null===value?"null":$$.config.axis.y.tick.format(value)),null!==value&&element.on("click",toggleLegendYLine),groupBBox=group.node().getBBox(),(columnLeft=Math.max(columnLeft,keyLeft+groupBBox.x+groupBBox.width+24*.65))>legendBoundary&&(rowDelta+=1,groupTop=24*rowDelta+12,columnLeft=keyLeft=0,group.attr("transform","translate(0,"+groupTop+")"))})}),rowDelta>0&&legendRows.forEach(function(row,idx){if(0!==idx){var translate=chart.utils.translate(row.node());row.attr("transform","translate("+translate[0]+","+(translate[1]+idx*rowDelta*24)+")")}});var newHeight=$$.height+$$.legendGroup.node().getBBox().height+$$.config.padding;$$.svg.attr("height",newHeight),$$.bgRect.attr("height",newHeight)}},chart.fn.removeLegend=function(){var $$=this;$$.legendGroup.remove(),delete $$.legendGroup,$$.svg.attr("height",$$.height),$$.bgRect.attr("height",$$.height)},chart.fn.toggleLegend=function(state){var $$=this;$$.config.legend.enabled=state,state&&!$$.legendGroup?$$.drawLegend():!state&&$$.legendGroup&&$$.removeLegend()},chart.utils={},chart.utils.extend=function(dst,src){for(var key in src)src.hasOwnProperty(key)&&(null!==dst[key]&&"object"==typeof dst[key]&&"object"==typeof src[key]?dst[key]=chart.utils.extend(dst[key],src[key]):dst[key]=src[key]);return dst},chart.utils.toRGBA=function(color,opacity){var rgb=d3.rgb(color);return"rgba("+rgb.r+","+rgb.g+","+rgb.b+","+("number"==typeof opacity?opacity:1)+")"},chart.utils.stylesList=["fill","opacity","stroke","text-anchor"],chart.utils.inlineStyles=function(src,dst){for(var style=getComputedStyle(src,null),i=0,n=style.length;i<n;i++)-1!=chart.utils.stylesList.indexOf(style[i])&&(dst.style[style[i]]=style.getPropertyValue(style[i]));for(var i in src.childNodes)1==src.childNodes[i].nodeType&&chart.utils.inlineStyles(src.childNodes[i],dst.childNodes[i])},chart.utils.translate=function(element){if(0===element.transform.baseVal.length)return[0,0];var matrix=element.transform.baseVal.consolidate().matrix;return[matrix.e,matrix.f]};var filterActions=["discard","rewrite","sieve"],filterTargets=["all","metric","origin","source"],dialogTypeConfirm="confirm",graphPadding=24,graphTypeArea="area",graphYAxisUnitFixed="fixed",graphStackModeNone=null,timeRanges=["1h","3h","1d","3d","7d","1mo","3mo","1y"],graphSummaryBase=["min","avg","max","last"],groupPrefix="group:",timeFormatDisplay="MMMM D YYYY, HH:mm:ss",timeFormatRFC3339="YYYY-MM-DDTHH:mm:ss.SSSZ",templateRegexp=/\{\{\s*\.([a-z0-9]+)\s*\}\}/i,locales={en:"English",fr:"Français"},sizeUnits=["","k","M","G","T","P","E","Z","Y"],timeUnits={d:864e5,h:36e5,m:6e4,s:1e3},app=angular.module("facette",["angular-inview","angular-page-visibility","as.sortable","bw.paging","facette.ui.autocomplete","facette.ui.color","facette.ui.column","facette.ui.dialog","facette.ui.form","facette.ui.graph","facette.ui.include","facette.ui.list","facette.ui.menu","facette.ui.message","facette.ui.notify","facette.ui.pane","facette.ui.search","facette.ui.tab","facette.ui.tabindex","ngDialog","ngResource","ngRoute","ngSanitize","pascalprecht.translate","tooltips","ui.bootstrap.datetimepicker","ui.dateTimeInput","ui.select","ui.tree"]);app.config(function($httpProvider,$locationProvider,$resourceProvider,$routeProvider,$translateProvider,treeConfig){$locationProvider.html5Mode(!0).hashPrefix("!"),$routeProvider.when("/browse/",{templateUrl:"templates/browse/search.html",controller:"BrowseSearchController"}).when("/browse/:section/:id",{templateUrl:"templates/browse/graphs.html",controller:"BrowseGraphController",reloadOnSearch:!1}).when("/show/collections/:id/:index",{templateUrl:"templates/show/collections.html",controller:"ShowCollectionController"}).when("/show/graphs/:id",{templateUrl:"templates/show/graphs.html",controller:"ShowGraphController"}).when("/admin/info/",{templateUrl:"templates/admin/info.html",controller:"AdminInfoController"}).when("/admin/collections/",{templateUrl:"templates/admin/list-library.html",controller:"AdminListController",_type:"collections"}).when("/admin/collections/:id",{templateUrl:"templates/admin/edit-collections.html",controller:"AdminEditCollectionController"}).when("/admin/graphs/",{templateUrl:"templates/admin/list-library.html",controller:"AdminListController",_type:"graphs"}).when("/admin/graphs/:id",{templateUrl:"templates/admin/edit-graphs.html",controller:"AdminEditGraphController"}).when("/admin/sourcegroups/",{templateUrl:"templates/admin/list-library.html",controller:"AdminListController",_type:"sourcegroups"}).when("/admin/sourcegroups/:id",{templateUrl:"templates/admin/edit-groups.html",controller:"AdminEditGroupController",_type:"sourcegroups"}).when("/admin/metricgroups/",{templateUrl:"templates/admin/list-library.html",controller:"AdminListController",_type:"metricgroups"}).when("/admin/metricgroups/:id",{templateUrl:"templates/admin/edit-groups.html",controller:"AdminEditGroupController",_type:"metricgroups"}).when("/admin/providers/",{templateUrl:"templates/admin/list-providers.html",controller:"AdminListController",_type:"providers"}).when("/admin/providers/:id",{templateUrl:"templates/admin/edit-providers.html",controller:"AdminEditProviderController"}).when("/admin/origins/",{templateUrl:"templates/admin/list-catalog.html",controller:"AdminListController",_type:"origins"}).when("/admin/sources/",{templateUrl:"templates/admin/list-catalog.html",controller:"AdminListController",_type:"sources"}).when("/admin/metrics/",{templateUrl:"templates/admin/list-catalog.html",controller:"AdminListController",_type:"metrics"}).when("/admin/",{redirectTo:"/admin/collections/"}).when("/",{redirectTo:"/browse/"}).otherwise({templateUrl:"templates/error/404.html",controller:"ErrorController"}),$httpProvider.interceptors.push(function($q,$rootScope){return{request:function(config){return config},requestError:function(response){return $q.reject(response)},response:function(response){return response},responseError:function(response){return response.status>=400&&404!=response.status&&($rootScope.$emit("Notify",response.data&&response.data.message?response.data.message:"an unhandled error has occurred",{type:"error"}),403==response.status&&$rootScope.checkReadOnly()),$q.reject(response)}}}),$resourceProvider.defaults.stripTrailingSlashes=!1;var locale=localStorage.getItem("locale");$translateProvider.useMessageFormatInterpolation().useSanitizeValueStrategy(null).useStaticFilesLoader({prefix:"assets/js/locales/",suffix:".json"}).registerAvailableLanguageKeys(["en","fr"],{"en_*":"en","fr_*":"fr","*":"en"}),locale?$translateProvider.preferredLanguage(locale):$translateProvider.determinePreferredLanguage(),treeConfig.defaultCollapsed=!0}),app.run(function($anchorScroll,$browser,$location,$pageVisibility,$rootScope,$route,$timeout,$translate,$window,info,ngDialog,storage){function unloadFunc(){return"mesg.page_unload"}$rootScope.baseURL=$browser.baseHref(),$rootScope.title=null,$rootScope.hasFocus=!0,$rootScope.stateOK=1,$rootScope.stateLoading=2,$rootScope.stateError=3,$rootScope.locales=locales,$rootScope.changeLocale=function(locale){$translate.use(locale),localStorage.setItem("locale",locale)},$rootScope.setTitle=function(parts){if(!parts)return void($rootScope.title=null);$translate(parts).then(function(data){for(var title=[],i=0,n=parts.length;i<n;i++)title.push(data[parts[i]]);$rootScope.title=title.join(" – ")})},$rootScope.unique=function(idx,id){return idx+id},$rootScope.preventedUnload=!1,$rootScope.preventUnload=function(state){state!==$rootScope.preventedUnload&&($rootScope.preventedUnload=state,angular.element($window)[state?"on":"off"]("beforeunload",unloadFunc))},$rootScope.showModal=function(data,callback){ngDialog.open({template:"templates/common/dialog.html",controller:function($scope){$scope.data=data,$timeout(function(){var element=angular.element(".ngdialog-content input:first");element.length>0?element.select():angular.element(".ngdialog-content .validate").focus()},50)},showClose:!1}).closePromise.then(function(scope){scope.$dialog.remove(),-1==[void 0,"$document","$escape"].indexOf(scope.value)&&callback(scope.value)})},$rootScope.handleDatetimeKey=function(e){var element=angular.element(e.target);void 0!==element.attr("tabindex")&&element.trigger("click")},$rootScope.handleAlt=function(e){18==e.which&&($rootScope.altMode="keydown"==e.type)},$rootScope.sidebarCollapse=storage.get("global-sidebar","collapsed",!1),$rootScope.toggleSidebar=function(){$rootScope.sidebarCollapse=!$rootScope.sidebarCollapse,storage.set("global-sidebar","collapsed",$rootScope.sidebarCollapse),angular.element($window).trigger("resize")},$rootScope.resetLocalPrefs=function(){localStorage.clear(),location.reload()},$rootScope.readOnly=!1,$rootScope.checkReadOnly=function(){info.get(null,function(data){data.read_only&&($rootScope.readOnly=!0)})},$rootScope.checkReadOnly(),$location.skipReload=function(){var currentRoute=$route.current,unbind=$rootScope.$on("$locationChangeSuccess",function(e){$route.current=currentRoute,unbind()});return $location},$pageVisibility.$on("pageFocused",function(e){$rootScope.hasFocus=!0}),$pageVisibility.$on("pageBlurred",function(e){$rootScope.hasFocus=!1}),$rootScope.$on("$includeContentLoaded",function(e,src){src.endsWith("/layout.html")&&($anchorScroll.yOffset||($anchorScroll.yOffset=angular.element("article header").height()),$anchorScroll())}),$rootScope.$on("$locationChangeStart",function(e){if($rootScope.preventedUnload){var path=$location.path(),search=$location.search();e.preventDefault(),$rootScope.showModal({type:dialogTypeConfirm,message:"mesg.page_unload",labels:{validate:"label.leave_page"},danger:!0},function(data){void 0!==data&&($rootScope.preventUnload(!1),$location.path(path).search(search))})}}),$rootScope.$on("$routeChangeSuccess",function(){$rootScope.altMode=!1,$rootScope.inAdmin=$location.path().startsWith("/admin"),$rootScope.preventUnload(!1)}),$rootScope.$on("$translateLoadingEnd",function(){$rootScope.loaded=!0}),angular.element($window).on("resize",function(){$rootScope.resizeTimeout&&($timeout.cancel($rootScope.resizeTimeout),$rootScope.resizeTimeout=null),$rootScope.resizeTimeout=$timeout(function(){angular.element($window).width()<=768?$rootScope.sidebarCollapse||($rootScope.sidebarCollapse=!0,$rootScope.sidebarCollapseAuto=!0):$rootScope.sidebarCollapseAuto&&$rootScope.sidebarCollapse&&($rootScope.sidebarCollapse=!1,$rootScope.sidebarCollapseAuto=!1)},500)}),angular.element($window).trigger("resize")}),app.factory("bulk",function($resource){return $resource("api/v1/bulk",null,{exec:{method:"POST",isArray:!0,transformRequest:apiTransformRequest}})}),app.factory("catalog",function($resource){return $resource("api/v1/catalog/:type/:name",{type:"@type",name:"@name"},{list:{method:"GET",params:{type:"@type",name:null},isArray:!0,interceptor:{response:apiInterceptList}}})}),app.factory("info",function($resource){return $resource("api/v1/",null,{get:{method:"GET"}})}),app.factory("library",function($resource){return $resource("api/v1/library/:type/:id",{type:"@type",id:"@id"},{append:{method:"POST",params:{type:"@type",id:null},transformRequest:apiTransformRequest},collectionTree:{method:"GET",params:{type:"collections",id:"tree"},isArray:!0},delete:{method:"DELETE",params:{type:"@type",id:"@id"}},get:{method:"GET",params:{type:"@type",id:"@id"}},getPeek:{method:"HEAD",params:{type:"@type",id:"@id"}},list:{method:"GET",params:{type:"@type",id:null},isArray:!0,interceptor:{response:apiInterceptList}},listPeek:{method:"HEAD",params:{type:"@type",id:null},interceptor:{response:apiInterceptList}},update:{method:"PUT",params:{type:"@type",id:"@id"},
transformRequest:apiTransformRequest},search:{method:"POST",params:{type:"search",id:null,limit:"@limit"},isArray:!0,transformRequest:apiTransformRequest}})}),app.factory("libraryAction",function($resource){return $resource("api/v1/library/:action",{action:"@action"},{parse:{method:"POST",params:{action:"parse"},isArray:!0},search:{method:"POST",params:{action:"search"},isArray:!0}})}),app.factory("series",function($resource){return $resource("api/v1/series/:action",{action:"@action"},{expand:{method:"POST",params:{action:"expand"},isArray:!0,transformRequest:apiTransformRequest},points:{method:"POST",params:{action:"points",normalize:"@normalize"},transformRequest:apiTransformRequest}})}),app.factory("providers",function($resource){return $resource("api/v1/providers/:id",{id:"@id"},{append:{method:"POST",params:{id:null},transformRequest:apiTransformRequest},delete:{method:"DELETE",params:{id:"@id"}},get:{method:"GET",params:{id:"@id"}},list:{method:"GET",params:{id:null},isArray:!0},update:{method:"PATCH",params:{id:"@id"},transformRequest:apiTransformRequest}})}),app.factory("providersAction",function($resource){return $resource("api/v1/providers/:id/:action",{action:"@action"},{refresh:{method:"POST",params:{id:"@id",action:"refresh"}}})}),app.factory("storage",function(){var data={},service={get:function(namespace,key,fallback){return data[namespace]||service.load(namespace),data[namespace][key]?data[namespace][key]:fallback},set:function(namespace,key,value){data[namespace]||service.load(namespace),data[namespace][key]=value,service.save(namespace)},load:function(namespace){data[namespace]=JSON.parse(localStorage.getItem(namespace))||{}},save:function(namespace){localStorage.setItem(namespace,JSON.stringify(data[namespace]))}};return service}),angular.module("facette.ui.autocomplete",[]).directive("autocomplete",function(){return{restrict:"E",replace:!0,scope:{id:"@",delay:"@",allowOverride:"=?",source:"=",onSelect:"=?"},controller:"AutocompleteController",templateUrl:"templates/autocomplete.html"}}).controller("AutocompleteController",function($element,$sce,$scope,$timeout){function watchValue(){unwatchValue=$scope.$watch("value",function(newValue,oldValue){if(!newValue)return void delete $scope.entries;angular.equals(newValue,oldValue)||($scope.completeTimeout&&($timeout.cancel($scope.completeTimeout),$scope.completeTimeout=null),$scope.completeTimeout=$timeout(function(){$scope.selected=!1,$scope.activate(0),$scope.source(newValue).then(function(data){$scope.entries=data})},$scope.delay))})}$scope.selected=!0,angular.isDefined($scope.delay)||($scope.delay=250),$scope.activate=function(idx){$scope.index=idx},$scope.handleFocus=function(e){$scope.focus="focus"==e.type,"blur"==e.type&&($scope.allowOverride&&!$scope.selected?$scope.select(e,{label:e.target.value,value:e.target.value}):delete $scope.entries)},$scope.handleKey=function(e){switch(e.which){case 13:void 0!==$scope.entries?$scope.select(e,$scope.entries[$scope.index]):$scope.allowOverride&&!$scope.selected&&$scope.select(e,{label:e.target.value,value:e.target.value});break;case 27:delete $scope.entries;break;case 38:case 40:e.preventDefault(),38==e.which&&$scope.index>0?$scope.index--:40==e.which&&$scope.index<$scope.entries.length-1&&$scope.index++,$timeout(function(){var row=$element.find(".autocomplete-row.active"),position=row.position(),container=row.parent();position.top+row.outerHeight(!0)>container.innerHeight()?container.scrollTop(container.scrollTop()+position.top-container.innerHeight()+row.outerHeight(!0)+(container.outerHeight()-container.innerHeight())):position.top<0&&container.scrollTop(container.scrollTop()+position.top)},0)}},$scope.highlight=function(input,value){try{return $sce.trustAsHtml(input.replace(new RegExp("("+value+")","gi"),"<mark>$1</mark>"))}catch(e){return input}},$scope.select=function(e,data){unwatchValue(),$scope.value=data.label,watchValue(),angular.isDefined($scope.onSelect)&&$scope.onSelect(e,data.value),$scope.selected=!0,delete $scope.entries};var unwatchValue;watchValue()}),angular.module("facette.ui.color",["colorpicker.module"]).directive("colorpicker",function(){return{restrict:"E",replace:!0,scope:{position:"@",value:"=?"},controller:"ColorController",templateUrl:"templates/color.html"}}).controller("ColorController",function($scope,$element){$scope.handleKey=function(e){switch(e.which){case 8:"keypress"==e.type&&($element.find("button.close").trigger("click"),$scope.value=null,e.preventDefault());break;case 27:"keydown"==e.type&&$element.find(".colorpicker-visible").length>0&&($element.find("button.close").trigger("click"),e.stopPropagation());break;case 13:case 32:"keypress"==e.type?$element.find("[colorpicker]").trigger("click"):"keydown"==e.type&&13==e.which&&("INPUT"==e.target.tagName&&($element.find("button.close").trigger("click"),e.preventDefault()),e.stopPropagation())}}}),angular.module("facette.ui.column",[]).directive("columns",function(){return{restrict:"E",replace:!0,transclude:!0,scope:{},template:'<div class="columns" ng-transclude=""></div>'}}).directive("column",function(){return{require:"^columns",restrict:"E",replace:!0,transclude:!0,scope:{},template:'<div class="column" ng-transclude=""></div>'}}),angular.module("facette.ui.dialog",[]).directive("dialog",function(){return{restrict:"E",replace:!0,transclude:!0,scope:{},controller:"DialogController",templateUrl:"templates/dialog.html"}}).controller("DialogController",function($scope,$element){$scope.handleMouse=function(e){angular.element(e.target).hasClass("dialog")&&$scope.$applyAsync(function(){$element.find(".actions :input.cancel").trigger("click")})}}),angular.module("facette.ui.form",[]).directive("ngEntersubmit",function(){return{restrict:"A",scope:{ngEntersubmit:"&"},controller:function($scope,$element){$element.on("keypress",function(e){13==e.which&&($scope.ngEntersubmit(),$scope.$apply())})}}}),angular.module("facette.ui.graph",[]).directive("graph",function(){return{restrict:"E",replace:!0,scope:{index:"@",graphId:"@",def:"=?",options:"=?",attributes:"=?",controls:"@",frame:"@"},link:function(scope,element,attrs){attrs.$observe("controls",function(){scope.controls=scope.$eval(attrs.controls)}),attrs.$observe("frame",function(){scope.frame=scope.$eval(attrs.frame)})},controller:"GraphController",templateUrl:"templates/graph.html"}}).controller("GraphController",function($scope,$rootScope,$element,$pageVisibility,$timeout,$window,series){function applyOptions(options,force){force="boolean"==typeof force&&force;var optionsOrig=angular.copy($scope.options),optionsNew=angular.copy($scope.options),embeddablePath=null;angular.extend(optionsNew,options),options.start_time||options.end_time?(delete optionsNew.time,delete optionsNew.range,$scope.options.embeddable_path&&(embeddablePath=$scope.options.embeddable_path+"?start="+encodeURIComponent(moment(options.start_time).format(timeFormatRFC3339))+"&end="+encodeURIComponent(moment(options.end_time).format(timeFormatRFC3339)))):options.time||options.range?(delete optionsNew.start_time,delete optionsNew.end_time,$scope.options.embeddable_path&&(embeddablePath=$scope.options.embeddable_path+"?",options.time&&(embeddablePath+="time="+encodeURIComponent(moment(options.time).format(timeFormatRFC3339))),options.range&&(embeddablePath+=(options.time?"&":"")+"range="+options.range))):(delete optionsNew.time,delete optionsNew.range,delete optionsNew.start_time,delete optionsNew.end_time,$scope.options.embeddable_path&&(embeddablePath=$scope.options.embeddable_path)),embeddablePath&&($scope.embeddablePath=embeddablePath),$scope.options=optionsNew,angular.equals(optionsNew,optionsOrig)&&force&&updateGraph(optionsNew,null)}function draw(){if($scope.data){var element=$element.children(".graph-container")[0],startTime=moment($scope.data.start),endTime=moment($scope.data.end),chartCfg={axis:{x:{min:startTime.toDate(),max:endTime.toDate(),tick:{count:Math.max(Math.floor($element.width()/80),2)}},y:{label:$scope.data.options.yaxis_label||null,tick:{count:3}}},bindTo:element,padding:graphPadding,series:[],constants:$scope.data.options.constants||[],stack:$scope.data.options.stack_mode,title:$scope.data.options&&$scope.data.options.title?$scope.data.options.title:null,subtitle:startTime.format(timeFormatDisplay)+" — "+endTime.format(timeFormatDisplay),tooltip:{date:{format:function(date){return moment(date).format(timeFormatDisplay)}}},type:$scope.data.options.type,zoom:{enabled:!0,onStart:function(){$scope.zooming=!0,$scope.$apply()},onSelect:function(start,end){var startTime=moment(start);applyOptions({time:startTime.format(timeFormatRFC3339),range:timeToRange(moment(end).diff(startTime))}),$scope.zooming=!1,$scope.$apply()}},events:{cursorMove:function(time){$rootScope.$emit("PropagateCursorPosition",time,$scope)}}};switch($scope.data.options.yaxis_unit){case"metric":chartCfg.axis.y.tick.format=d3.format(".2s");break;case"binary":chartCfg.axis.y.tick.format=function(value){return formatSize(value)};break;default:chartCfg.axis.y.tick.format=d3.format(".2r")}angular.forEach($scope.data.series,function(series){null===series.points&&($scope.partial=!0);var entry={name:series.name,points:series.points,summary:series.summary};series.options&&series.options.color&&(entry.color=series.options.color),chartCfg.series.push(entry)}),elementLeft=void 0,elementWidth=void 0;try{$scope.chart=chart[$scope.chart?"update":"create"](chartCfg),$scope.$parent.$emit("GraphLoaded",$scope.index,$scope.graphId)}catch(e){console.error("Failed to render graph: "+e.name+(e.message?": "+e.message:""))}}}function fetchData(){if(!$scope.paused&&!$scope.folded){if(!$scope.inView||!$rootScope.hasFocus)return void($scope.deferred=!0);$scope.loading=!0,$scope.empty=!1,$scope.partial=!1,$scope.error=!1,$scope.summary={};var query={normalize:1};if(angular.forEach(["start_time","end_time","time","range"],function(key){$scope.options[key]&&(query[key]=$scope.options[key])}),$scope.graphId)query.id=$scope.graphId;else{if(!$scope.def)return $scope.loading=!1,void($scope.empty=!0);query.graph=$scope.def,query.graph.options&&(query.graph.options.range&&(query.range=query.graph.options.range),query.graph.options.sample&&(query.sample=query.graph.options.sample))}$scope.attributes&&(query.attributes=$scope.attributes),$scope.timeout&&($timeout.cancel($scope.timeout),$scope.timeout=null),series.points(query,function(data){data.options=angular.extend({type:graphTypeArea,stack_mode:null,yaxis_unit:graphYAxisUnitFixed},data.options),$scope.data=data,$scope.loading=!1,draw(),$scope.options.refresh_interval||data.options.refresh_interval?($scope.refreshInterval=$scope.options.refresh_interval||data.options.refresh_interval,registerNextDraw()):$scope.refreshInterval=0},function(){$scope.data=null,$scope.loading=!1,$scope.partial=!1,$scope.error=!0,$element.find(".graph-container svg").remove()})}}function emitChange(){$scope.$parent.$emit("GraphChanged",$scope.index,$scope.graphId,{folded:$scope.folded,legendActive:$scope.legendActive})}function resetLink(){$scope.exportLinks&&angular.forEach($scope.exportLinks,function(link){link.removeAttr("download").removeAttr("href")})}function registerNextDraw(){$scope.refreshInterval&&($scope.timeout&&($timeout.cancel($scope.timeout),$scope.timeout=null),$scope.timeout=$timeout(fetchData,1e3*$scope.refreshInterval))}function updateGraph(newValue,oldValue){angular.equals(newValue,oldValue)||($scope.modified=!angular.equals($scope.options,$scope.optionsRef),resetLink(),fetchData())}$scope.graph=null,angular.isDefined($scope.options)||($scope.options={}),$scope.optionsRef=angular.copy($scope.options),$scope.embeddablePath=$scope.options.embeddable_path||null,$scope.startTime=null,$scope.endTime=null,$scope.time=null,$scope.range=null,$scope.loading=!1,$scope.empty=!1,$scope.partial=!1,$scope.error=!1,$scope.modified=!1,$scope.paused=!1,$scope.timeout=null,$scope.refreshInterval=0,$scope.stepActive=null,$scope.folded="boolean"==typeof $scope.options.folded&&$scope.options.folded,$scope.legendActive=!1,$scope.zooming=!1,$scope.exportLinks={};var elementLeft=$element.offset().left,elementTop=$element.offset().top,elementWidth=$element.width();$scope.export=function(e,type){if($scope.chart&&($scope.exportLinks[type]=angular.element(e.target).closest("a"),!$scope.exportLinks[type].attr("href")))switch(type){case"png":var context,data=$scope.chart.getSVG(),canvas=document.createElement("canvas");if(canvas.setAttribute("width",$scope.chart.svg.attr("width")),canvas.setAttribute("height",$scope.chart.svg.attr("height")),!canvas.getContext||!(context=canvas.getContext("2d")))return void console.error("Your browser doesn’t support mandatory Canvas feature");var name=slugify($scope.chart.config.title)+"_"+moment($scope.data.start).format("YYYYMMDDHHmmss")+"_"+moment($scope.data.end).format("YYYYMMDDHHmmss")+".png",image=new Image,svg=new Blob([data],{type:"image/svg+xml;charset=utf-8"}),url=URL.createObjectURL(svg);image.onload=function(){context.drawImage(image,0,0);var png=canvas.toDataURL("image/png");$scope.exportLinks[type].attr("download",name).attr("href",png.replace("image/png","image/octet-stream")).get(0).click(),URL.revokeObjectURL(png)},image.src=url;break;case"summary_csv":case"summary_json":var hrefData,summary,name=slugify($scope.chart.config.title)+"_"+moment($scope.data.start).format("YYYYMMDDHHmmss")+"_"+moment($scope.data.end).format("YYYYMMDDHHmmss")+"_"+type.replace("_",".");"summary_csv"==type?(summary="",angular.forEach($scope.data.series,function(series,idx){var keys=Object.keys(series.summary);0===idx&&(summary+="name,"+keys.join(",")+"\n"),summary+='"'+series.name+'",'+keys.map(function(x){return series.summary[x]}).join(",")+"\n"}),hrefData="data:text/csv;charset=utf-8,"+encodeURIComponent(summary)):(summary={},angular.forEach($scope.data.series,function(series){summary[series.name]=series.summary}),hrefData="data:text/json;charset=utf-8,"+encodeURIComponent(JSON.stringify(summary,null,"\t"))),$timeout(function(){$scope.exportLinks[type].attr("download",name).attr("href",hrefData).get(0).click()},0)}},$scope.moveStep=function(forward){forward="boolean"==typeof forward&&forward;var startTime=moment($scope.data.start),delta=moment($scope.data.end).diff(startTime)/4;forward?$scope.options.range&&!$scope.options.range.startsWith("-")&&($scope.options.range="-"+$scope.options.range):delta*=-1,applyOptions({time:moment(startTime).add(delta).format(timeFormatRFC3339),range:($scope.options.range||"-1h").replace(/^-/,"")})},$scope.propagate=function(){var options={};$scope.options.start_time||$scope.options.end_time?(options.start_time=$scope.options.start_time,options.end_time=$scope.options.end_time):$scope.options.time||$scope.options.range?(options.time=$scope.options.time,options.range=$scope.options.range):options.start_time=options.end_time=options.time=options.range=null,$rootScope.$emit("ApplyGraphOptions",options,!0)},$scope.reset=function(){$scope.options=angular.copy($scope.optionsRef)},$scope.refresh=function(){fetchData()},$scope.setRange=function(range){if("custom"!=range)return void applyOptions({range:"-"+range});$rootScope.$emit("PromptTimeRange",function(startTime,endTime,time,range){$scope.startTime=startTime,$scope.endTime=endTime,$scope.time=time,$scope.range=range,applyOptions(startTime&&endTime?{start_time:startTime,end_time:endTime}:{time:time,range:range})},{start:$scope.startTime,end:$scope.endTime,time:$scope.time,range:$scope.range})},$scope.toggleFold=function(state){$scope.folded=state,state?$scope.data={}:fetchData(),emitChange()},$scope.toggleLegend=function(state){$scope.chart&&($scope.legendActive=state,$scope.chart.toggleLegend(state),resetLink(),emitChange())},$scope.zoom=function(zoomIn){zoomIn="boolean"!=typeof zoomIn||zoomIn;var range,startTime=moment($scope.data.start),delta=moment($scope.data.end).diff(startTime);zoomIn?(range=timeToRange(delta/2),delta/=4):(range=timeToRange(2*delta),delta=delta/2*-1),applyOptions({time:moment(startTime).add(delta).format(timeFormatRFC3339),range:range})},$scope.handleView=function(inView,info){$scope.inView=inView,inView&&info.changed&&$scope.deferred&&($scope.deferred=!1,fetchData())},$scope.$watch("graphId",updateGraph,!0),$scope.$watch("options",updateGraph,!0),$scope.$watch("def",updateGraph,!0);var unregisterCallbacks=[];unregisterCallbacks.push($rootScope.$on("ApplyGraphOptions",function(e,options,force){applyOptions(options,force)})),unregisterCallbacks.push($rootScope.$on("PropagateCursorPosition",function(e,time,origScope){$scope.chart&&$scope!==origScope&&$scope.chart.toggleCursor(time)})),unregisterCallbacks.push($rootScope.$on("ResetTimeRange",function(){$scope.reset()})),unregisterCallbacks.push($rootScope.$on("RedrawGraph",function(){draw()})),unregisterCallbacks.push($rootScope.$on("RefreshGraph",function(){fetchData()})),unregisterCallbacks.push($rootScope.$on("PauseGraphDraw",function(e,id,state){id===$scope.graphId&&(state||registerNextDraw(),$scope.paused=state)})),unregisterCallbacks.push($rootScope.$on("ToggleGraphLegend",function(e,idx,id,state){idx&&idx!==$scope.index||id&&id!==$scope.graphId||$scope.toggleLegend(state)})),$scope.$on("$destroy",function(){$scope.timeout&&($timeout.cancel($scope.timeout),$scope.timeout=null),angular.forEach(unregisterCallbacks,function(callback){callback()})}),$pageVisibility.$on("pageFocused",function(e){$scope.deferred&&($scope.deferred=!1,fetchData())}),angular.element($window).on("resize",function(){$scope.resizeTimeout&&($timeout.cancel($scope.resizeTimeout),$scope.resizeTimeout=null),$scope.resizeTimeout=$timeout(draw,50)}),$element.on("mousemove",function(e){if(!$scope.zooming){if(void 0===elementLeft||void 0===elementTop||void 0===elementWidth){var elementOffset=$element.offset();elementLeft=elementOffset.left,elementTop=elementOffset.top,elementWidth=$element.width()}var changed=!1,relX=e.pageX-elementLeft,relY=e.pageY-elementTop,delta=2*graphPadding;!$scope.stepActive&&relX<=delta?($scope.stepActive="backward",changed=!0):!$scope.stepActive&&relX>=elementWidth-delta?($scope.stepActive="forward",changed=!0):null!==$scope.stepActive&&relX>delta&&relX<elementWidth-delta&&($scope.stepActive=null,changed=!0),!$scope.foldActive&&relY<=delta?($scope.foldActive=!0,changed=!0):$scope.foldActive&&relY>delta&&($scope.foldActive=!1,changed=!0),changed&&$scope.$apply()}}),$scope.rangeValues=timeRanges,fetchData()}),angular.module("facette.ui.include",[]).directive("ngIncludeReplace",function(){return{require:"ngInclude",restrict:"A",link:function(scope,element){element.replaceWith(element.children())}}}),angular.module("facette.ui.list",[]).directive("list",function(){return{restrict:"E",replace:!0,transclude:!0,scope:{},templateUrl:"templates/list.html"}}).directive("listrow",function(){return{require:"^list",restrict:"E",replace:!0,transclude:!0,scope:{href:"@"},templateUrl:"templates/listrow.html"}}).directive("listcolumn",function(){return{require:"^listrow",restrict:"E",replace:!0,transclude:!0,scope:{},templateUrl:"templates/listcolumn.html"}}),angular.module("facette.ui.menu",[]).directive("menu",function(){return{restrict:"E",replace:!0,transclude:!0,scope:{},controller:"MenuController",templateUrl:"templates/menu.html"}}).controller("MenuController",function($scope){$scope.items=[],this.append=function(item){$scope.items.push(item)},this.select=function(item){angular.forEach($scope.items,function(entry){entry.active=!1}),item.active=!0}}).directive("menuitem",function($location,$timeout){return{require:"^menu",restrict:"E",replace:!0,transclude:!0,scope:{href:"@",target:"@",icon:"@",badge:"@",label:"@",name:"@",info:"@",infoDirection:"@",type:"@",selectable:"=?"},link:function(scope,element,attrs,controller,transcludeFn){transcludeFn(function(clone){scope.hasContent=clone.length>0}),void 0===scope.selectable&&(scope.selectable=!0),void 0===scope.infoDirection&&(scope.infoDirection="bottom"),element.find(".subcontent").html()||element.find(".subcontent").remove(),attrs.href&&(scope.active=scope.selectable&&attrs.href&&$location.path()==attrs.href),scope.$watch("active",function(active){active&&controller.select(scope)}),scope.select=function(){scope.active=!0},scope.handleFocus=function(e){if("focus"==e.type)element.siblings(".focus").removeClass("focus"),scope.hasContent&&element.addClass("focus");else if("blur"==e.type){var parentElement=element.parent().closest(".has-content"),nextElement=angular.element(e.originalEvent.relatedTarget);0!==parentElement.length||0!==nextElement.length&&0!==nextElement.closest(".has-content").length?nextElement.parents(".has-content").is(parentElement)||parentElement.removeClass("focus"):element.removeClass("focus")}},scope.handleKey=function(e){13==e.which&&$timeout(function(){element.trigger("click")})},controller.append(scope)},templateUrl:"templates/menuitem.html"}}),angular.module("facette.ui.message",[]).directive("message",function(){return{restrict:"E",replace:!0,transclude:!0,scope:{icon:"@",type:"@"},templateUrl:"templates/message.html"}}),angular.module("facette.ui.notify",[]).directive("notify",function(){return{restrict:"E",replace:!0,scope:{},controller:"NotifyController",templateUrl:"templates/notify.html"}}).controller("NotifyController",function($rootScope,$scope,$timeout){$scope.active=!1,$scope.message=null,$scope.type=null,$scope.icon=null,$scope.reset=function(){$scope.active=!1,$timeout(function(){$scope.message=null,$scope.type=null,$scope.icon=null},250)},$rootScope.$on("Notify",function(e,message,options){options=options||{},$scope.active=!0,$scope.message=message,$scope.type=options.type||null,$scope.icon=options.icon||null,$timeout(function(){$scope.reset()},5e3)})}),angular.module("facette.ui.pane",[]).directive("ngPane",function(){return{restrict:"A",scope:{},controller:"PaneController"}}).controller("PaneController",function($scope,$rootScope,$element){$rootScope.steps={},$rootScope.switch=function(step){angular.element('[ng-pane-step="'+step+'"]').show().siblings("[ng-pane-step]").hide(),$rootScope.step=$scope.$parent.step=step},$element.addClass("pane"),$scope.$evalAsync(function(){$rootScope.switch(1)})}).directive("ngPaneStep",function($rootScope){return{require:"^ngPane",restrict:"A",scope:{},link:function(scope,element,attrs){$rootScope.steps[attrs.ngPaneStep]=element}}}),angular.module("facette.ui.search",[]).directive("search",function(){return{restrict:"E",replace:!0,scope:{name:"@",icon:"@",placeholder:"@",ngModel:"="},controller:"SearchController",templateUrl:"templates/search.html"}}).controller("SearchController",function($scope){$scope.hasFocus=!1,$scope.handleFocus=function(e){$scope.hasFocus="focus"==e.type},$scope.handleKey=function(e){27==e.which&&(e.target.value?$scope.ngModel="":$scope.$evalAsync(function(){e.target.blur()}),e.preventDefault())}}),angular.module("facette.ui.tab",[]).directive("tabset",function(){return{restrict:"E",replace:!0,transclude:!0,scope:{},controller:"TabController",templateUrl:"templates/tabset.html"}}).controller("TabController",function($scope){$scope.tabs=[],this.append=function(tab){$scope.tabs.push(tab)},this.select=function(tab){angular.forEach($scope.tabs,function(entry,idx){entry.active=angular.equals(entry,tab)})}}).directive("tab",function($timeout){return{require:"^tabset",restrict:"E",replace:!0,scope:{active:"=?",label:"@",href:"@"},link:function(scope,element,attrs,controller){scope.$watch("active",function(active){active&&controller.select(scope)}),scope.select=function(){scope.active=!0},scope.handleKey=function(e){13==e.which&&(e.stopPropagation(),$timeout(function(){element.trigger("click")},0))},controller.append(scope)},templateUrl:"templates/tab.html"}}),angular.module("facette.ui.tabindex",[]).directive("tabindex",function(){return{restrict:"A",link:function(scope,element){0!==element.closest("label").length&&element.on("keypress",function(e){13!=e.which&&32!=e.which||(angular.element("#"+element.attr("for")).trigger("click"),e.preventDefault())})}}}),app.controller("ErrorController",function($rootScope,$scope){$rootScope.setTitle(["label.error"]),$rootScope.loaded=!0}),app.factory("browseCollection",function($location,$routeParams,$timeout,library,storage){return{getGlobalOptions:function(scope){var options={};return angular.forEach($routeParams,function(value,key){switch(key){case"start":case"end":case"range":case"time":"start"!=key&&"end"!=key||(key+="_time"),options[key]=value,scope&&(scope[key]=options[key]);break;case"refresh":options.refresh_interval=parseInt(value,10),scope&&(scope.refreshInterval=options.refresh_interval)}}),options},injectTree:function(scope){function applyState(base){base=base||angular.element("#collections-tree");var state=storage.get("browse-collection_tree","state",{});state&&base.find(".treelabel").each(function(index,item){var label=angular.element(item),href=label.attr("href");!0===state[href.substr(href.lastIndexOf("/")+1)]&&$timeout(function(){label.children(".toggle").trigger("click"),applyState(label.next(".tree"))},0)})}var data=storage.get("browse-collection_tree","cache-"+$location.url());data&&(scope.collections=data,scope.collectionsLoaded=!0),library.collectionTree({parent:scope.id||null},function(data){scope.collections=data,scope.collectionsLoaded=!0,storage.set("browse-collection_tree","cache-"+$location.url(),data),scope.$applyAsync(function(){applyState()})})},saveTreeState:function(){var state=storage.get("browse-collection_tree","state",{});angular.element("#collections-tree [collapsed]").each(function(index,item){var href=angular.element(item).children(".treelabel").attr("href"),id=href.substr(href.lastIndexOf("/")+1),collapsed="true"==item.getAttribute("collapsed");!state[id]&&collapsed||(state[id]=!collapsed)}),storage.set("browse-collection_tree","state",state)},watchGraphOptions:function(scope,key){scope.$watch(key,function(newValue,oldValue){angular.equals(newValue,oldValue)||$location.skipReload().search("start",newValue.start_time||null).search("end",newValue.end_time||null).search("time",newValue.time||null).search("range",newValue.range||null).replace()},!0)}}}),app.factory("timeRange",function($timeout,ngDialog){return{prompt:function(callback,data){ngDialog.open({template:"templates/common/timerange.html",controller:function($scope){function resetDatetime(){$scope.datetime={time:!1,start:!1,end:!1}}$scope.data={},$scope.switchAbsolute=function(data,state){data.absolute=state,$scope.$applyAsync(function(){angular.element(".ngdialog-content :input:visible:first").select()})},$scope.hideDatetime=function(e){0===angular.element(e.target).closest(".datetimepicker, .datetimepicker-holder").length&&resetDatetime()},$scope.toggleDatetime=function(name,state){angular.forEach(Object.keys($scope.datetime),function(entry){$scope.datetime[entry]=entry===name&&state})},resetDatetime(),angular.forEach(data,function(value,key){$scope.data[key]=value}),$scope.data.absolute=Boolean($scope.data.start||$scope.data.end)},showClose:!1}).closePromise.then(function(scope){scope.$dialog.remove(),-1==[void 0,"$document","$escape"].indexOf(scope.value)&&(scope.value.absolute?callback(scope.value.start,scope.value.end,null,null):callback(null,null,scope.value.time,scope.value.range))})}}}),app.controller("BrowseGraphController",function($location,$rootScope,$routeParams,$scope,$timeout,$window,browseCollection,bulk,library,storage,timeRange){function locationApplyRange(){$location.skipReload().search("start",$scope.startTime?moment($scope.startTime).format(timeFormatRFC3339):null).search("end",$scope.endTime?moment($scope.endTime).format(timeFormatRFC3339):null).search("time",$scope.time?moment($scope.time).format(timeFormatRFC3339):null).search("range",$scope.range||null).replace()}$scope.section=$routeParams.section,$scope.id=$routeParams.id,$scope.state=2,$scope.collections={},$scope.collectionsLoaded=!1,$scope.graphs=[],$scope.startTime=null,$scope.endTime=null,$scope.time=null,$scope.range=null,$scope.form={filter:""},$scope.rangeValues=timeRanges,$scope.refresh=function(){$rootScope.$emit("RefreshGraph")},$scope.resetRange=function(){$scope.startTime=null,$scope.endTime=null,$scope.time=null,$scope.range=null,$rootScope.$emit("ResetTimeRange"),angular.equals($location.search(),{})||locationApplyRange()},$scope.setRange=function(range){if("custom"!=range){if(range="-"+range,$rootScope.$emit("ApplyGraphOptions",{range:range}),$scope.range===range)return;return $scope.startTime=null,$scope.endTime=null,$scope.time=null,$scope.range=range||null,void locationApplyRange()}$rootScope.$emit("PromptTimeRange",function(startTime,endTime,time,range){$scope.startTime===startTime&&$scope.endTime===endTime&&$scope.time===time&&$scope.range===range||($scope.startTime=startTime,$scope.endTime=endTime,$scope.time=time,$scope.range=range,$rootScope.$emit("ApplyGraphOptions",startTime&&endTime?{start_time:startTime,end_time:endTime}:{time:time,range:range}),locationApplyRange())},{start:$scope.startTime,end:$scope.endTime,time:$scope.time,range:$scope.range})},$scope.setRefresh=function(e){e.stopPropagation(),$rootScope.showModal({type:"prompt",message:"label.graphs_refresh",note:"label.refresh_interval_unit",value:$scope.refreshInterval,inputType:"number",labels:{validate:"label.graphs_refresh_set"}},function(data){void 0!==data&&($scope.refreshInterval=parseInt(data.value,10),$rootScope.$emit("ApplyGraphOptions",{refresh_interval:$scope.refreshInterval}),$location.skipReload().search("refresh",$scope.refreshInterval||null).replace())})},$scope.setGrid=function(size){$scope.gridSize=size,storage.set("browse-grid",$scope.section+"-"+$scope.id,size),$timeout(function(){$rootScope.$emit("RedrawGraph")},0)},$scope.toggleLegends=function(state){$rootScope.$emit("ToggleGraphLegend",null,null,state),$scope.showLegends=state},$scope.handleGraphFocus=function(e,index){angular.element("#graph"+index).next().toggleClass("focus","mouseenter"==e.type)},$scope.resetFilter=function(){$scope.form.filter=""},$scope.$watch("form.filter",function(newValue,oldValue){angular.equals(newValue,oldValue)||($scope.filterTimeout&&($timeout.cancel($scope.filterTimeout),$scope.filterTimeout=null),$scope.filterTimeout=$timeout(function(){var pause={},count=0;angular.forEach($scope.graphs,function(entry){entry.hidden=-1==entry.title.toLowerCase().indexOf(newValue.toLowerCase()),entry.hidden||count++,void 0===pause[entry.id]&&(pause[entry.id]=entry.hidden)}),angular.forEach(pause,function(state,id){$rootScope.$emit("PauseGraphDraw",id,state)}),$scope.noMatch=0===count},500))});var unregisterPromptTimerange=$rootScope.$on("PromptTimeRange",function(e,callback,data){timeRange.prompt(callback,data)});if($scope.$on("$destroy",function(){unregisterPromptTimerange()}),$scope.$on("GraphLoaded",function(e,idx,id){var key=$scope.section+"_"+$scope.id,data=storage.get("browse-graph_state",key,{}),state=data[idx+"_"+id]||{};state.legendActive&&$rootScope.$emit("ToggleGraphLegend",idx,id,state)}),$scope.$on("GraphChanged",function(e,idx,id,state){var key=$scope.section+"_"+$scope.id,data=storage.get("browse-graph_state",key,{});data[idx+"_"+id]=state,storage.set("browse-graph_state",key,data)}),$scope.$on("$locationChangeStart",browseCollection.saveTreeState),angular.element($window).on("beforeunload",browseCollection.saveTreeState),$scope.id){var globalOptions=browseCollection.getGlobalOptions($scope),query={type:$scope.section,id:$scope.id,fields:"id,name,entries.graph,entries.options,entries.attributes,options,alias,attributes,parent,template"};"collections"==$scope.section&&(query.expand=1),library.get(query,function(data){if(!data.template){$scope.id=data.id,$scope.alias=data.alias;var title=data.options&&data.options.title?data.options.title:data.name;$rootScope.setTitle([title]),$scope.gridSize=storage.get("browse-grid",$scope.section+"-"+$scope.id,data.options&&data.options.grid_size?data.options.grid_size:1),($scope.gridSize<1||$scope.gridSize>3)&&($scope.gridSize=1),
$scope.refreshInterval||($scope.refreshInterval=data.options&&data.options.refresh_interval?data.options.refresh_interval:null);var graphsState=storage.get("browse-graph_state",$scope.section+"_"+$scope.id,{});if("collections"==$scope.section){$scope.parentID=data.parent;var graphs=[];angular.forEach(data.entries,function(entry,idx){if(!entry.options||!1!==entry.options.enabled){var graph={index:idx,id:entry.graph,options:angular.extend(entry.options||{},globalOptions),hidden:!1};$scope.refreshInterval&&(graph.options.refresh_interval=$scope.refreshInterval);var state=graphsState[idx+"_"+entry.graph];state&&"boolean"==typeof state.folded&&(graph.options.folded=state.folded),entry.options&&entry.options.title&&(graph.title=entry.options.title),graph.attributes=angular.extend({},data.attributes,entry.attributes)||null,graph.options.embeddable_path="collections/"+$scope.id+"/"+idx,graphs.push(graph)}}),$scope.graphs=graphs}else $scope.graphs=[{index:0,id:$scope.id,options:angular.extend({embeddable_path:"graphs/"+$scope.id},globalOptions),hidden:!1,title:title}];$scope.state=1}},function(){$scope.state=3})}browseCollection.injectTree($scope)}),app.controller("BrowseSearchController",function($location,$q,$rootScope,$scope,$window,browseCollection,libraryAction){$scope.collections={},$scope.collectionsLoaded=!1,$rootScope.setTitle(),$scope.searchHandler=function(term){var defer=$q.defer();return libraryAction.search({types:["collections","graphs"],terms:{name:"glob:*"+term+"*",template:!1},limit:20},function(data){defer.resolve(data.map(function(a){return{label:a.name,value:a,note:a.type}}))},function(){defer.reject()}),defer.promise},$scope.searchSelect=function(e,data){$location.path("browse/"+data.type+"/"+data.id)},$scope.$on("$locationChangeStart",browseCollection.saveTreeState),angular.element($window).on("beforeunload",browseCollection.saveTreeState),browseCollection.injectTree($scope)}),app.controller("ShowCollectionController",function($rootScope,$routeParams,$scope,browseCollection,library,timeRange){$scope.id=$routeParams.id,$scope.index=$routeParams.index,library.get({type:"collections",id:$scope.id,fields:"entries.graph,entries.attributes,entries.options,attributes",expand:1},function(data){var entry=data.entries[$scope.index],graph={id:entry.graph,attributes:entry.attributes||{},options:entry.options||{}};angular.extend(graph.options,browseCollection.getGlobalOptions(null)),graph.options.frame=!0,data.attributes&&angular.extend(graph.attributes,data.attributes),$scope.graph=graph,browseCollection.watchGraphOptions($scope,"graph.options");var unregisterPromptTimerange=$rootScope.$on("PromptTimeRange",function(e,callback,data){timeRange.prompt(callback,data)});$scope.$on("$destroy",function(){unregisterPromptTimerange()}),$rootScope.loaded=!0})}),app.controller("ShowGraphController",function($location,$rootScope,$routeParams,$scope,browseCollection,timeRange){$scope.graph={id:$routeParams.id,options:browseCollection.getGlobalOptions(null)},browseCollection.watchGraphOptions($scope,"graph.options");var unregisterPromptTimerange=$rootScope.$on("PromptTimeRange",function(e,callback,data){timeRange.prompt(callback,data)});$scope.$on("$destroy",function(){unregisterPromptTimerange()}),$rootScope.loaded=!0}),app.controller("AdminEditCollectionController",function($q,$routeParams,$scope,$timeout,$translate,adminEdit,bulk,library,libraryAction){function fetchGraphs(){var graphQuery=[],attrsQuery=[];$scope.graphFetched=!1,angular.forEach($scope.item.entries,function(entry){graphQuery.push({endpoint:"library/graphs/"+entry.graph,method:"GET",params:{fields:"id,name,options,template"}})}),bulk.exec(graphQuery,function(data){var graphData={};angular.forEach(data,function(entry){200==entry.status&&(graphData[entry.data.id]=entry.data,entry.data.template&&attrsQuery.push({endpoint:"library/parse",method:"POST",data:{id:entry.data.id,type:"graphs"}}),delete entry.data.id)}),$scope.graphFetched=!0,attrsQuery.length>0&&bulk.exec(attrsQuery,function(data){angular.forEach(data,function(entry,idx){graphData[attrsQuery[idx].data.id].templateKeys=entry.data})}),$scope.graphData=graphData})}function updateTemplate(){if($scope.linked)libraryAction.parse({id:$scope.item.link,type:"collections"},function(data){$scope.item.attributes||($scope.item.attributes={}),$scope.templateKeys=data});else{var keys=[],entries=[];entries.push($scope.item.description),$scope.item.options&&entries.push($scope.item.options.title),angular.forEach(entries,function(input){input&&(keys=keys.concat(input.matchAll(templateRegexp)))}),angular.forEach($scope.item.entries,function(entry){angular.forEach(entry.attributes,function(attr){keys=keys.concat(attr.matchAll(templateRegexp))})}),keys.sort(),keys=jQuery.unique(keys),$scope.templateKeys=keys,$scope.item.template=keys.length>0,$scope.item.template&&delete $scope.item.alias}}function setDefaults(input){return angular.extend({options:{grid_size:1}},input)}$scope.section="collections",$scope.id=$routeParams.id,$scope.linked="link"==$scope.id,$scope.tab=0,$scope.graphFetched=!1,$scope.graphData={},$scope.hasTemplate=!1,$scope.cancel=function(force){adminEdit.cancel($scope,force)},$scope.delete=function(){adminEdit.delete($scope,{id:$scope.id,name:$scope.itemRef.name})},$scope.reset=function(){adminEdit.reset($scope),fetchGraphs()},$scope.save=function(go){adminEdit.save($scope,function(data){angular.forEach(data.entries,function(entry){angular.forEach(entry.attributes,function(value,key){value||delete entry.attributes[key]}),entry.options&&(entry.options.constants&&(entry.options.constants=parseFloatList(entry.options.constants)),entry.options.percentiles&&(entry.options.percentiles=parseFloatList(entry.options.percentiles)))}),angular.forEach(data.attributes,function(value,key){value||delete data.attributes[key]})},function(item){return!($scope.linked&&!item.link)},go)},$scope.remove=function(list,entry){adminEdit.remove($scope,list,entry),updateTemplate()},$scope.selectGraph=function(e,data){angular.extend($scope.graph,data)},$scope.setGraph=function(){if($scope.item.entries||($scope.item.entries=[]),!$scope.graphData[$scope.graph.id]){var id=$scope.graph.id;$scope.graphData[id]=angular.copy($scope.graph),libraryAction.parse({id:id,type:"graphs"},function(data){$scope.graphData[id].templateKeys=data})}var graph={graph:$scope.graph.id,name:$scope.graph.name};void 0!==$scope.graph.index?angular.extend($scope.item.entries[$scope.graph.index],graph):$scope.item.entries.push(graph),updateTemplate(),$scope.resetGraph()},$scope.resetGraph=function(){$scope.graph={},$scope.$applyAsync(function(){angular.element("#graph input").val("").focus()})},$scope.editGraph=function(entry){var idx=$scope.item.entries.indexOf(entry);-1!=idx&&($scope.graph=angular.extend({index:idx,id:entry.graph},$scope.graphData[entry.graph]),$scope.$applyAsync(function(){angular.element("#graph input").val($scope.graphData[entry.graph].name).select()}))},$scope.toggleGraph=function(entry){entry.options?entry.options.enabled=!entry.options.enabled:entry.options={enabled:!1}},$scope.editGraphEntry=function(entry){if(null===entry)return $scope.graphEntryEdit=null,$scope.entryOptions=null,void($scope.entryAttrs=null);var entryAttrs=angular.copy(entry.attributes||{});angular.forEach($scope.graphData[entry.graph].templateKeys,function(key){entryAttrs[key]||(entryAttrs[key]="")}),$scope.entryOptions=angular.copy(entry.options||{}),$scope.entryAttrs=entryAttrs,$scope.graphEntryEdit=entry},$scope.setGraphEntry=function(){var idx=$scope.item.entries.indexOf($scope.graphEntryEdit);if(-1!=idx){var entry=$scope.item.entries[idx];entry.options=angular.extend(entry.options||{},$scope.entryOptions),entry.attributes=angular.extend(entry.attributes||{},$scope.entryAttrs),$scope.editGraphEntry(null)}},$scope.editAttrs=function(entry){if(null===entry)return $scope.attrsEdit=null,void($scope.entryAttrs=null);var entryAttrs=angular.copy($scope.item.attributes||{});angular.forEach($scope.graphData,function(entry){angular.forEach(entry.templateKeys,function(key){entryAttrs[key]||(entryAttrs[key]="")})}),$scope.entryAttrs=entryAttrs,$scope.attrsEdit=entry,$timeout(function(){angular.element(".pane .keylist .value:first :input").select()},0)},$scope.setAttrs=function(){$scope.item.attributes=angular.copy($scope.entryAttrs),$scope.editAttrs(null)},$scope.selectParent=function(e,data){$scope.item.parent=data.id},$scope.removeParent=function(){$scope.item.parent=null,$scope.$applyAsync(function(){angular.element("#parent input").val("")})},$scope.selectTemplate=function(e,data){$scope.item.link=data},$scope.switchTab=function(idx){$scope.tab=idx,1==idx&&library.list({type:"collections",kind:"raw",link:$scope.id,fields:"id,name"},function(data){$scope.instances=data})},adminEdit.watch($scope,function(newValue,oldValue){2!=$scope.step||$scope.linked?$scope.linked&&(oldValue&&newValue.link===oldValue.link||library.get({type:"collections",id:newValue.link,fields:"name"},function(data){oldValue||$scope.$applyAsync(function(){angular.element("#template input").val(data.name)}),updateTemplate()})):updateTemplate()}),$scope.$watch("graphData",function(newValue,oldValue){if(newValue!==oldValue){var hasTemplate=!1;angular.forEach(newValue,function(entry){entry.template&&(hasTemplate=!0)}),hasTemplate!==$scope.hasTemplate&&($scope.hasTemplate=hasTemplate)}},!0),adminEdit.load($scope,function(){if($scope.item.link&&($scope.linked=!0),$scope.linked||($scope.item=setDefaults($scope.item)),$scope.itemRef=angular.copy($scope.item),$scope.linked)$scope.templateSources=function(term){var defer=$q.defer();return library.list({type:"collections",kind:"template",fields:"id,name",filter:"glob:*"+term+"*"},function(data){defer.resolve(data.map(function(a){return{label:a.name,value:a.id}}))},function(){defer.reject()}),defer.promise},$scope.$applyAsync(function(){angular.element(".pane :input:visible:first").select()});else{$scope.selectedOptions={},$scope.$watch("selectedOptions",function(newValue,oldValue){angular.equals(newValue,oldValue)||angular.forEach(newValue,function(entry,key){$scope.item.options[key]=entry.value})},!0),$scope.graphsList=function(term){var defer=$q.defer();return library.list({type:"graphs",fields:"id,name,options,template",filter:"glob:*"+term+"*"},function(data){defer.resolve(data.map(function(a){return{label:a.name,value:a}}))},function(){defer.reject()}),defer.promise},$translate(["label.page_grid_1","label.page_grid_2","label.page_grid_3"]).then(function(data){for(var gridSizes=[],i=1;i<=3;i++)gridSizes.push({name:data["label.page_grid_"+i],value:i});$scope.collectionsGridSizes=gridSizes,applyOptions($scope.collectionsGridSizes,"grid_size")}),$scope.resetGraph();var applyOptions=function(list,key){angular.forEach(list,function(entry){entry.value===$scope.item.options[key]&&($scope.selectedOptions[key]=entry)}),$scope.selectedOptions[key]||($scope.selectedOptions[key]=list[0])};fetchGraphs()}$scope.collectionsList=function(term){var defer=$q.defer();return library.list({type:"collections",kind:"raw",fields:"id,name,parent",filter:"glob:*"+term+"*"}).$promise.then(function(data){var collections={},assocs={};angular.forEach(data,function(entry){entry.parent&&(assocs[entry.parent]||(assocs[entry.parent]=[]),assocs[entry.parent].push(entry.id)),collections[entry.id]=entry});for(var stack=[$scope.id],cur=null;stack.length>0;)cur=stack.shift(),assocs[cur]&&(stack=stack.concat(assocs[cur])),delete collections[cur];var result=[];angular.forEach(collections,function(entry){result.push({label:entry.name,value:entry})}),defer.resolve(result)}),defer.promise},$scope.item.parent&&library.get({type:"collections",id:$scope.item.parent,fields:"name"},function(data){$scope.$applyAsync(function(){angular.element("#parent input").val(data.name)})})})}),app.controller("AdminEditGraphController",function($q,$rootScope,$routeParams,$scope,$timeout,adminEdit,bulk,catalog,library,ngDialog,series){function fetchGroups(callback){var groupQuery=[],expandQuery=[];$scope.groupNames={},angular.forEach($scope.item.groups,function(group){angular.forEach(group.series,function(series){angular.forEach([series.source,series.metric],function(entry,idx){entry.startsWith(groupPrefix)&&groupQuery.push({endpoint:"library/"+(0===idx?"source":"metric")+"groups/"+entry.substr(groupPrefix.length),method:"GET",params:{fields:"id,name"}})}),series.template||(series.source.startsWith(groupPrefix)||series.metric.startsWith(groupPrefix))&&(series.expansion=expandQuery.length,expandQuery.push(series))})}),$scope.expandData=[];var queries=[];groupQuery.length>0&&queries.push(bulk.exec(groupQuery).$promise),expandQuery.length>0&&queries.push(series.expand(expandQuery).$promise),queries&&$q.all(queries).then(function(data){angular.forEach(data[0],function(entry){200==entry.status&&($scope.groupNames[entry.data.id]=entry.data.name)});var out=[];angular.forEach(data[1],function(entry,idx){out[idx]=[],angular.forEach(entry,function(a){out[idx].push(a)})}),$scope.expandData=out,callback&&callback()})}function updateItemDef(){var def=angular.copy($scope.item);$scope.cleanProperties(def),def.attributes=angular.copy($scope.item.attributes),$scope.itemDef&&angular.equals(def.groups,$scope.itemDef.groups)&&angular.equals(def.options,$scope.itemDef.options)&&angular.equals(def.attributes,$scope.itemDef.attributes)||($scope.itemDef=def)}function updateTemplate(item){var attrs={},keys=[],entries=[];item=item||$scope.item,entries.push(item.description),item.options&&entries.push(item.options.title),angular.forEach(entries,function(input){input&&(keys=keys.concat(input.matchAll(templateRegexp)))}),angular.forEach(item.groups,function(group){angular.forEach(group.series,function(series){var subkeys=(series.origin+""+series.source+""+series.metric).matchAll(templateRegexp);subkeys.length>0&&(series.template=!0),keys=keys.concat(subkeys)})}),keys.sort(),keys=jQuery.unique(keys),angular.forEach(keys,function(key,idx){void 0===attrs[key]&&(attrs[key]=item.attributes&&item.attributes[key]?item.attributes[key]:null)}),$scope.templateKeys=keys,$scope.linked?item.attributes=attrs:(item.template=keys.length>0,item.template?(item.attributes=attrs,delete item.alias):delete item.attributes)}function setDefaults(input){return angular.extend({options:{type:graphTypeArea,stack_mode:graphStackModeNone,yaxis_unit:graphYAxisUnitFixed}},input)}$scope.section="graphs",$scope.id=$routeParams.id,$scope.linked="link"==$scope.id,$scope.tab=0,$scope.seriesTemplate={},$scope.cancel=function(force){adminEdit.cancel($scope,force)},$scope.delete=function(){adminEdit.delete($scope,{id:$scope.id,name:$scope.itemRef.name})},$scope.reset=function(){adminEdit.reset($scope),fetchGroups(),updateItemDef()},$scope.save=function(go){adminEdit.save($scope,function(data){data.options&&(data.options.constants&&(data.options.constants=parseFloatList(data.options.constants)),data.options.percentiles&&(data.options.percentiles=parseFloatList(data.options.percentiles)))},function(item){return!($scope.linked&&!item.link)},go)},$scope.remove=function(list,entry){adminEdit.remove($scope,list,entry),angular.forEach($scope.item.groups,function(group,idx){0===group.series.length&&$scope.item.groups.splice(idx,1)}),updateTemplate()},$scope.cleanProperties=function(data){$scope.linked||delete data.attributes,angular.forEach(data.groups,function(group){delete group.selected,angular.forEach(group.series,function(series){delete series.autoname,delete series.expanded,delete series.expansion,delete series.template})})},$scope.selectSeries=function(e,data){if("string"==typeof data?$scope.series.entries[$scope.seriesCurrent][this.id]=data:($scope.groupNames[data.id]=data.name,$scope.series.entries[$scope.seriesCurrent][this.id]=groupPrefix+data.id),"blur"!=e.type){var next;switch(this.id){case"origin":next="#source input";break;case"source":next="#metric input"}next&&$scope.$applyAsync(function(){angular.element(next).focus()})}},$scope.selectTemplate=function(e,data){$scope.item.link=data},$scope.selectOption=function(option,data){if(!$scope.completing)return void angular.element('.ngdialog-content button[type="submit"]').trigger("click");if($scope.completing=!1,data&&data.originalObject&&("object"!=typeof data.originalObject||data.originalObject.value))if($scope.groupEdit)$scope.groupItem.options||($scope.groupItem.options={}),$scope.groupItem.options[option]="string"==typeof data.originalObject?data.originalObject:data.originalObject.value;else{var series=$scope.groupItem.series[$scope.seriesCurrent];series.options||(series.options={}),series.options[option]="string"==typeof data.originalObject?data.originalObject:data.originalObject.value}},$scope.selectScale=function(data){return $scope.selectOption("scale",data)},$scope.selectUnit=function(data){return $scope.selectOption("unit",data)},$scope.setSeries=function(){$scope.item.groups||($scope.item.groups=[]),$scope.series.entries.map(function(entry){return entry.autoname=!0,entry}),void 0!==$scope.series.index?($scope.item.groups[$scope.series.index].series=angular.copy($scope.series.entries),$scope.resetSeries(!1,!0)):($scope.item.groups.push({series:angular.copy($scope.series.entries)}),$scope.resetSeries(!1,!1)),updateTemplate(),$scope.series.hasGroups?fetchGroups(function(){$scope.autonameSeries(!1)}):$scope.autonameSeries(!1)},$scope.editOptions=function(state){$scope.options=angular.copy($scope.item.options),$scope.optionsEdit=state},$scope.setOptions=function(){angular.extend($scope.item.options,$scope.options),$scope.optionsEdit=!1},$scope.editGroup=function(group){$scope.groupItem=angular.copy(group),$scope.seriesCurrent=0,$scope.seriesTotal=group.series.length,$scope.completing=!1,$scope.switchEdit=function(isGroup,delta){$scope.groupEdit=isGroup,!$scope.groupEdit&&delta&&($scope.seriesCurrent+=delta),$timeout(function(){angular.element(".ngdialog-content :input:visible:first").select()},50)},0===$scope.groupItem.consolidate&&($scope.groupItem.consolidate=1),$scope.groupItem.options||($scope.groupItem.options={}),void 0===$scope.groupItem.options.interpolate&&($scope.groupItem.options.interpolate=!0),$scope.selectedOptions.group={operator:$scope.groupOperators[$scope.groupItem.operator],consolidate:$scope.groupConsolidations[$scope.groupItem.consolidate-1]},ngDialog.open({template:"templates/admin/edit-graphs-groups.html",scope:$scope,controller:function($scope){$timeout(function(){$scope.switchEdit($scope.seriesTotal>1||void 0!==$scope.groupItem.series[0].expansion)},0)},showClose:!1}).closePromise.then(function(scope){if(scope.$dialog.remove(),-1==[void 0,"$document","$escape"].indexOf(scope.value)){var data=scope.value,idx=$scope.item.groups.indexOf(group);data.options&&data.options.scale&&(data.options.scale=parseFloat(data.options.scale));for(var i in data.series)$scope.item.groups[idx].series[i].name!==data.series[i].name&&(data.series[i].autoname=!1),data.series[i].options&&data.series[i].options.scale&&(data.series[i].options.scale=parseFloat(data.series[i].options.scale));angular.extend(group,data)}})},$scope.editSeries=function(group){var idx=$scope.item.groups.indexOf(group);-1!=idx&&($scope.series={index:idx,entries:angular.copy($scope.item.groups[idx].series)},$scope.seriesCurrent=0,$scope.seriesTotal=group.series.length,$scope.switchSeries(0))},$scope.switchSeries=function(delta){$scope.seriesCurrent+=delta;var series=$scope.series.entries[$scope.seriesCurrent];angular.element("#origin input").val(series.origin),angular.element("#source input").val($scope.resolveGroup(series.source)),angular.element("#metric input").val($scope.resolveGroup(series.metric)),$timeout(function(){angular.element("#metric input").select()},0)},$scope.autonameSeries=function(force){force="boolean"==typeof force&&force;var originRef=null,sourceRef=null,originMany=!1,sourceMany=!1;angular.forEach($scope.item.groups,function(group){angular.forEach(group.series,function(series){null===originRef&&null===sourceRef?(originRef=series.origin,sourceRef=series.source):(originMany||originRef===series.origin||(originMany=!0),sourceMany||sourceRef===series.source||(sourceMany=!0))})}),angular.forEach($scope.item.groups,function(group){angular.forEach(group.series,function(series){if(force||series.autoname){var name=$scope.resolveGroup(series.metric);sourceMany&&(name=series.source+"/"+name),originMany&&(name=series.origin+"/"+name),series.name=name,series.autoname=!0}})})},$scope.mergeGroup=function(state){if(state){angular.forEach($scope.selected.slice(1),function(group){$scope.selected[0].series=$scope.selected[0].series.concat(group.series),$scope.item.groups.splice($scope.item.groups.indexOf(group),1)});var maxId=0;angular.forEach($scope.item.groups,function(group){group.name&&group.name.startsWith("group")&&(maxId=Math.max(maxId,parseInt(group.name.substr(5),10)))}),$scope.selected[0].name||($scope.selected[0].name="group"+(maxId+1))}else angular.forEach($scope.selected,function(group){var items=[];angular.forEach(group.series,function(series){items.push({name:series.name,series:[series]})}),$scope.item.groups.splice.apply($scope.item.groups,[$scope.item.groups.indexOf(group),1].concat(items))})},$scope.expandGroup=function(group,state){if(state){var items=[],seriesList=[];angular.forEach($scope.expandData[group.series[0].expansion],function(entry){var series={origin:entry.origin,source:entry.source,metric:entry.metric,autoname:!0,expanded:$scope.groupTmp.length};items.push({series:[series]}),seriesList.push(series)}),group.expanded=seriesList,$scope.groupTmp.push($scope.item.groups.splice($scope.item.groups.indexOf(group),1)[0]),$scope.item.groups.splice.apply($scope.item.groups,[$scope.item.groups.indexOf(group)+1,0].concat(items)),$scope.autonameSeries(!1)}else $rootScope.showModal({type:dialogTypeConfirm,message:"mesg.groups_collapse",labels:{validate:"label.groups_collapse"},danger:!0},function(data){void 0!==data&&angular.forEach($scope.groupTmp[group.series[0].expanded].expanded,function(item,i){angular.forEach($scope.item.groups,function(group,j){var idx=group.series.indexOf(item);if(-1!=idx){if(0===i){var groupOrig=$scope.groupTmp.splice(group.series[0].expanded,1)[0];delete groupOrig.expanded,$scope.item.groups.splice(j,0,groupOrig),j++}group.series.splice(idx,1),0===group.series.length&&$scope.item.groups.splice(j,1)}})})})},$scope.resolveGroup=function(input){if(input&&input.startsWith(groupPrefix)&&$scope.groupNames){var id=input.substr(groupPrefix.length);return $scope.groupNames[id]?groupPrefix+$scope.groupNames[id]:input}return input},$scope.resetSeries=function(init,update){init="boolean"==typeof init&&init,update="boolean"==typeof update&&update,$scope.seriesCurrent=0,(init||update)&&($scope.series={entries:[{origin:null,source:null,metric:null}]}),init||(delete $scope.series.index,delete $scope.seriesTotal,update?(angular.element("#origin input").val(""),angular.element("#source input").val("")):delete $scope.series.entries[0].metric,$scope.series.valid=!1,$scope.$applyAsync(function(){angular.element("#metric input").val("").focus()}))},$scope.getSeriesColor=function(idx){try{if(1==$scope.item.groups[idx].series.length&&$scope.item.groups[idx].series[0].options.color)return $scope.item.groups[idx].series[0].options.color}catch(e){}return chart.colors[idx%chart.colors.length]},$scope.validateOptionsClose=function(){return!$scope.completing},$scope.switchTab=function(idx){$scope.tab=idx,1==idx&&library.list({type:"graphs",kind:"raw",link:$scope.id,fields:"id,name"},function(data){$scope.instances=data})},adminEdit.watch($scope,function(newValue,oldValue){2!=$scope.step||$scope.linked?$scope.linked&&(oldValue&&newValue.link===oldValue.link?newValue.link&&updateItemDef():library.get({type:"graphs",id:newValue.link},function(data){oldValue||$scope.$applyAsync(function(){angular.element("#template input").val(data.name)}),updateTemplate(data),updateItemDef()})):(updateTemplate(),updateItemDef())}),$scope.$watch("item.groups",function(newValue,oldValue){if(newValue!==oldValue){var selected=[],selectedGroup=[];angular.forEach($scope.item.groups,function(group){group.selected&&(selected.push(group),group.series.length>1&&selectedGroup.push(group))}),$scope.selected=selected,$scope.selectedGroup=selectedGroup}},!0),$scope.$watch("series",function(newValue,oldValue){newValue!==oldValue&&$scope.series.entries&&(angular.extend($scope.series,{hasGroups:!1,valid:!0}),$scope.series.entries.forEach(function(entry){(entry.source&&entry.source.startsWith(groupPrefix)||entry.metric&&entry.metric.startsWith(groupPrefix))&&($scope.series.hasGroups=!0),entry.origin&&entry.source&&entry.metric||($scope.series.valid=!1)}))},!0),adminEdit.load($scope,function(){if($scope.item.link&&($scope.linked=!0),$scope.linked||($scope.item=setDefaults($scope.item)),$scope.itemRef=angular.copy($scope.item),$scope.linked)$scope.templateSources=function(term){var defer=$q.defer();return library.list({type:"graphs",kind:"template",fields:"id,name",filter:"glob:*"+term+"*"},function(data){defer.resolve(data.map(function(a){return{label:a.name,value:a.id}}))},function(){defer.reject()}),defer.promise},$scope.$applyAsync(function(){angular.element(".pane :input:visible:first").select()});else{$scope.selected=[],$scope.selectedGroup=[],$scope.selectedOptions={main:{},group:{}},$scope.groupTmp=[],$scope.options=$scope.item.options?angular.copy($scope.item.options):{},$scope.$watch("step",function(newValue,oldValue){angular.equals(newValue,oldValue)||2!=newValue||(updateTemplate(),$scope.item.template&&"add"!=$scope.id&&library.list({type:"graphs",kind:"raw",link:$scope.id,fields:"attributes",limit:1},function(data){data&&data.length>0&&($scope.item.attributes=data[0].attributes)}),updateItemDef())}),$scope.$watch("selectedOptions",function(newValue,oldValue){angular.equals(newValue.main,oldValue.main)||angular.forEach(newValue.main,function(entry,key){$scope.item.options[key]=entry.value}),angular.equals(newValue.group,oldValue.group)||angular.forEach(newValue.group,function(entry,key){$scope.groupItem[key]=entry.value})},!0),$scope.listSortControl.orderChanged=function(e){angular.forEach($scope.groupTmp,function(group){angular.forEach(e.source.itemScope.modelValue.series,function(series,i){var idx=group.expanded.indexOf(series);-1!=idx&&group.expanded.splice(idx,1,$scope.item.groups[e.dest.index].series[i])})})},$scope.seriesOrigins=function(term){var defer=$q.defer();return catalog.list({type:"origins",filter:"glob:*"+term+"*"},function(data){defer.resolve(data.map(function(a){return{label:a,value:a}}))},function(){defer.reject()}),defer.promise},$scope.seriesSources=function(term){var defer=$q.defer();return bulk.exec([{endpoint:"library/sourcegroups/",method:"GET",params:{fields:"id,name",filter:"glob:*"+term+"*"}},{endpoint:"catalog/sources/",method:"GET",params:{filter:"glob:*"+term+"*"}}],function(data){var result=[];data[0].data&&(result=result.concat(data[0].data.map(function(a){return{label:a.name,value:a,note:"group"}}))),data[1].data&&(result=result.concat(data[1].data.map(function(a){return{label:a,value:a}}))),defer.resolve(result)},function(){defer.reject()}),defer.promise},$scope.seriesMetrics=function(term){var defer=$q.defer();return bulk.exec([{endpoint:"library/metricgroups/",method:"GET",params:{fields:"id,name",filter:"glob:*"+term+"*"}},{endpoint:"catalog/metrics/",method:"GET",params:{filter:"glob:*"+term+"*"}}],function(data){var result=[];data[0].data&&(result=result.concat(data[0].data.map(function(a){return{label:a.name,value:a,note:"group"}}))),data[1].data&&(result=result.concat(data[1].data.map(function(a){return{label:a,value:a}}))),defer.resolve(result)},function(){defer.reject()}),defer.promise},$scope.groupOperators=[{name:"None",value:0},{name:"Average",value:1},{name:"Sum",value:2}],$scope.groupConsolidations=[{name:"Average",value:1},{name:"First",value:2},{name:"Last",value:3},{name:"Max",value:4},{name:"Min",value:5},{name:"Sum",value:6}],$scope.graphTypes=[{name:"Area",value:graphTypeArea},{name:"Line",value:"line"}],$scope.graphStackModes=[{name:"None",value:graphStackModeNone},{name:"Normal",value:"normal"},{name:"Percent",value:"percent"}],$scope.resetSeries(!0,!0);var applyOptions=function(list,key){angular.forEach(list,function(entry){entry.value===$scope.item.options[key]&&($scope.selectedOptions.main[key]=entry)}),$scope.selectedOptions.main[key]||($scope.selectedOptions.main[key]=list[0])};applyOptions($scope.graphTypes,"type"),applyOptions($scope.graphStackModes,"stack_mode"),$scope.$applyAsync(function(){angular.element("#origin input").focus()}),updateTemplate(),fetchGroups()}})}),app.controller("AdminEditGroupController",function($q,$route,$routeParams,$scope,$translate,adminEdit,catalog){$scope.section=$route.current.$$route._type,$scope.id=$routeParams.id,$scope.patternsData={},$scope.cancel=function(force){adminEdit.cancel($scope,force)},$scope.delete=function(){adminEdit.delete($scope,{id:$scope.id,name:$scope.itemRef.name})},$scope.reset=function(){adminEdit.reset($scope)},$scope.save=function(){adminEdit.save($scope)},$scope.remove=function(list,entry){adminEdit.remove($scope,list,entry)},$scope.selectPattern=function(e,data){angular.extend($scope.pattern,{type:$scope.patternTypes[0],value:data})},$scope.setPattern=function(){var pattern;switch($scope.pattern.type.value){case 2:pattern="glob:"+$scope.pattern.value;break;case 3:pattern="regexp:"+$scope.pattern.value;break;default:pattern=$scope.pattern.value}$scope.item.patterns||($scope.item.patterns=[]),void 0!==$scope.pattern.index?$scope.item.patterns[$scope.pattern.index]=pattern:$scope.item.patterns.push(pattern),$scope.resetPattern()},$scope.editPattern=function(entry){var idx=$scope.item.patterns.indexOf(entry);if(-1!=idx){var focus="#value";0===entry.indexOf("glob:")?$scope.pattern={type:$scope.patternTypes[1],value:entry.substr("glob:".length)}:0===entry.indexOf("regexp:")?$scope.pattern={type:$scope.patternTypes[2],value:entry.substr("regexp:".length)}:($scope.pattern={type:$scope.patternTypes[0],value:entry},focus+=" input"),$scope.pattern.index=idx,$scope.$applyAsync(function(){angular.element(focus).val($scope.pattern.value).select()})}},$scope.testPattern=function(pattern){$q.all([$translate(["label.patterns_matches","label.patterns_matches_total","label.patterns_matches_none"]),catalog.list({type:"sourcegroups"==$scope.section?"sources":"metrics",limit:10,filter:pattern}).$promise]).then(function(data){0===data[1].$totalRecords&&data[1].push(data[0]["label.patterns_matches_none"]);var content='<span class="label">'+data[0]["label.patterns_matches"]+"</span><br>\n"+data[1].join("<br>\n");data[1].$totalRecords>10&&(content+='<br>\n…<br>\n<span class="label">'+data[0]["label.patterns_matches_total"]+"</span> "+data[1].$totalRecords),$scope.patternsData[pattern]=content})},$scope.resetPattern=function(){$scope.pattern={type:$scope.patternTypes[0],value:null},$scope.$applyAsync(function(){angular.element("#value input").val("").focus()})},adminEdit.watch($scope),adminEdit.load($scope,function(){var type=$scope.section.replace(/groups$/,"s");$scope.patternTypes=[{name:"Single",value:1},{name:"Glob",value:2},{name:"Regexp",value:3}],$scope.patternValues=function(term){var defer=$q.defer();return catalog.list({type:type,filter:"glob:*"+term+"*"}).$promise.then(function(data){defer.resolve(data.map(function(a){return{label:a,value:a}}))}),defer.promise},$scope.resetPattern()})}),app.controller("AdminEditProviderController",function($routeParams,$scope,adminEdit,info){$scope.section="providers",$scope.id=$routeParams.id,$scope.cancel=function(force){adminEdit.cancel($scope,force)},$scope.delete=function(){adminEdit.delete($scope,{id:$scope.id,name:$scope.itemRef.name})},$scope.reset=function(){adminEdit.reset($scope)},$scope.save=function(){adminEdit.save($scope,null,function(item){return Boolean(item.connector)})},$scope.remove=function(list,entry){adminEdit.remove($scope,list,entry)},$scope.addFilter=function(){
var actionIdx=0,targetIdx=0;if($scope.item.filters){var last=$scope.item.filters[$scope.item.filters.length-1];actionIdx=$scope.filterActions.indexOf(last.action),targetIdx=$scope.filterTargets.indexOf(last.target)}else $scope.item.filters=[];$scope.item.filters.push({action:$scope.filterActions[actionIdx],target:$scope.filterTargets[targetIdx]})},adminEdit.watch($scope),adminEdit.load($scope,function(){$scope.$applyAsync(function(){angular.element(".pane :input:visible:first").select()}),$scope.connectorTypes=[],info.get(null,function(data){data.connectors&&($scope.connectorTypes=data.connectors)}),$scope.filterActions=filterActions,$scope.filterTargets=filterTargets})}),app.factory("adminEdit",function($location,$rootScope,$timeout,$translate,adminHelpers){function confirmDelete(scope,item,message,args){args=args||{},args.name=item.name,$rootScope.showModal({type:dialogTypeConfirm,message:message,args:args,labels:{validate:"label."+scope.section+"_delete"},danger:!0},function(data){void 0!==data&&adminHelpers.getFactory(scope).delete({type:scope.section,id:item.id},function(){if(scope.id){var locSearch={};return scope.item&&scope.item.template&&(locSearch.templates=1),void $location.path("admin/"+scope.section+"/").search(locSearch)}scope.refresh()})})}return{cancel:function(scope,force){(force="boolean"==typeof force&&force)&&$rootScope.preventUnload(!1);var locSearch={};scope.item&&scope.item.template&&(locSearch.templates=1),$location.path("admin/"+scope.section+"/").search(locSearch),force&&$location.replace()},delete:function(scope,item){scope.templates?adminHelpers.getFactory(scope).listPeek({type:scope.section,kind:"raw",link:item.id,fields:"id"},function(data,headers){var count=parseInt(headers("X-Total-Records"),10);count>0?confirmDelete(scope,item,"mesg.templates_delete",{count:count}):confirmDelete(scope,item,"mesg.items_delete")}):confirmDelete(scope,item,"mesg.items_delete")},reset:function(scope,callback){$rootScope.showModal({type:dialogTypeConfirm,message:"mesg.items_reset",labels:{validate:scope.section.endsWith("groups")?"label.groups_reset":"label."+scope.section+"_reset"},danger:!0},function(data){void 0!==data&&(scope.item=angular.copy(scope.itemRef),callback&&callback())})},save:function(scope,transform,validate,go){if(go="boolean"==typeof go&&go,!scope.item.name||validate&&!validate(scope.item))return void(scope.validated=!0);var locSearch={};scope.item.template&&(locSearch.templates=1);var data=angular.extend({type:scope.section},scope.item);"add"!=scope.id&&"link"!=scope.id&&(data.id=scope.id),scope.cleanProperties&&scope.cleanProperties(data),transform&&transform(data),scope.conflict={name:!1,alias:name},scope.validated=!0,data=angular.fromJson(angular.toJson(data));var factory=adminHelpers.getFactory(scope);("add"!=scope.id&&"link"!=scope.id?factory.update:factory.append)(data,function(_,header){if(scope.itemTimeout&&($timeout.cancel(scope.itemTimeout),scope.itemTimeout=null),$rootScope.preventUnload(!1),go){var id=scope.id;if("add"==scope.id||"link"==scope.id){var location=header("Location");id=location.substr(location.lastIndexOf("/")+1)}$location.path("browse/"+scope.section+"/"+id).search(locSearch)}else $location.path("admin/"+scope.section+"/").search(locSearch);$timeout(function(){$translate(["mesg.saved"]).then(function(data){$rootScope.$emit("Notify",data["mesg.saved"],{type:"success",icon:"check-circle"})})},500)})},remove:function(scope,list,entry){var index=list.indexOf(entry);-1!=index&&list.splice(index,1)},watch:function(scope,callback){scope.aliasable="collections"==scope.section||"graphs"==scope.section,scope.$watch("item",function(newValue,oldValue){if(1==scope.state&&!angular.equals(newValue,oldValue)){var item=angular.copy(scope.item);scope.cleanProperties&&scope.cleanProperties(item),scope.modified=!angular.equals(item,scope.itemRef),scope.itemTimeout&&($timeout.cancel(scope.itemTimeout),scope.itemTimeout=null),scope.itemTimeout=$timeout(function(){$rootScope.preventUnload(scope.modified),callback&&callback(newValue,oldValue),newValue.name&&newValue.name!==scope.itemRef.name||(scope.conflict.name=!1),newValue.alias&&newValue.alias!==scope.itemRef.alias||(scope.conflict.alias=!1),oldValue&&(newValue.name&&newValue.name!==oldValue.name&&newValue.name!==scope.itemRef.name&&adminHelpers.getFactory(scope).list({type:scope.section,filter:newValue.name},function(data){scope.conflict.name=data.length>0}),scope.aliasable&&newValue.alias&&newValue.alias!==oldValue.alias&&newValue.alias!==scope.itemRef.alias&&adminHelpers.getFactory(scope).getPeek({type:scope.section,id:newValue.alias},function(data){scope.conflict.alias=!0},function(data){scope.conflict.alias=!1}))},500)}},!0)},load:function(scope,callback){if(scope.conflict={name:!1,alias:!1},scope.validated=!1,$rootScope.setTitle(["label."+scope.section+("add"==scope.id||"link"==scope.id?"_new":"_edit"),"label.admin_panel"]),scope.listSortControl={allowDuplicates:!0,containment:"tbody"},"add"==scope.id||"link"==scope.id)return scope.item={},scope.itemRef={},scope.state=1,void(callback&&callback());scope.state=2;var query={id:scope.id};"providers"!=scope.section&&(query.type=scope.section),adminHelpers.getFactory(scope).get(query,function(data){data=data.toJSON(),delete data.id,scope.item=angular.copy(data),scope.itemRef=data,scope.state=1,callback&&callback()},function(response){scope.state=3,scope.notFound=404==response.status})}}}),app.factory("adminHelpers",function($rootScope,catalog,library,providers){var catalogSections=["origins","sources","metrics"],librarySections=["collections","graphs","sourcegroups","metricgroups"];return{getFactory:function(scope){return-1!=catalogSections.indexOf(scope.section)?catalog:-1!=librarySections.indexOf(scope.section)?library:"providers"==scope.section?providers:null}}}),app.controller("AdminInfoController",function($rootScope,$scope,info){$rootScope.setTitle(["label.info","label.admin_panel"]),$scope.info={},info.get(null,function(data){$scope.info=data})}),app.controller("AdminListController",function($location,$q,$rootScope,$route,$routeParams,$scope,$timeout,$translate,adminEdit,adminHelpers,catalog,providersAction){$scope.section=$route.current.$$route._type,$scope.state=2,$scope.items=[],$scope.templates=("collections"==$scope.section||"graphs"==$scope.section)&&void 0!==$routeParams.templates,$scope.form={search:$routeParams.search||""},$scope.page=1,$scope.limit=20,$scope.providersData={};var factory=adminHelpers.getFactory($scope);$rootScope.setTitle(["label."+$scope.section,"label.admin_panel"]),$scope.refresh=function(page){var query;if(void 0!==page&&($scope.page=page),query={type:$scope.section,offset:($scope.page-1)*$scope.limit,limit:$scope.limit},$scope.form.search){var parts=[];angular.forEach($scope.form.search.split(" "),function(part){part.startsWith("origin:")?query.origin=part.substr(7):part.startsWith("source:")?query.source=part.substr(7):parts.push(part)}),query.filter="glob:*"+parts.join(" ")+"*"}factory!==catalog&&(query.fields="id,name,description,created,modified","collections"==$scope.section||"graphs"==$scope.section?(query.kind=$routeParams.templates?"template":"raw",query.fields+=",link,alias"):"providers"==$scope.section&&(query.fields+=",enabled")),factory.list(query,function(data,headers){$scope.items=data,$scope.total=parseInt(headers("X-Total-Records"),10),$scope.state=1},function(){$scope.state=3})},$scope.reset=function(){$scope.form.search=""},$scope.clone=function(item){$rootScope.showModal({type:"prompt",message:"label."+$scope.section+"_name",value:item.name+"-clone",labels:{validate:"label."+$scope.section+"_clone"}},function(data){void 0!==data&&factory.append({inherit:item.id},{type:$scope.section,name:data.value},function(){$scope.refresh()})})},$scope.delete=function(item){adminEdit.delete($scope,item)},$scope.toggle=function(entry){factory.update({type:$scope.section,id:entry.id,enabled:!entry.enabled},function(){entry.enabled=!entry.enabled})},$scope.getProviders=function(name){catalog.get({type:$scope.section,name:name},function(data){$scope.providersData[name]=data.providers})},$scope.refreshProvider=function(entry){providersAction.refresh({id:entry.id},function(){entry.refreshing=!0,$timeout(function(){entry.refreshing=!1},3e3)})},$scope.$watch("form.search",function(newValue,oldValue){angular.equals(newValue,oldValue)||($scope.searchTimeout&&($timeout.cancel($scope.searchTimeout),$scope.searchTimeout=null),newValue||($scope.state=2),$scope.searchTimeout=$timeout(function(){$location.skipReload().search("search",newValue||null).replace(),$scope.refresh()},500))}),$scope.refresh()}),angular.module("facette").run(["$templateCache",function($templateCache){$templateCache.put("templates/autocomplete.html",'<div class="autocomplete" ng-class="{focus: focus}"><input autocomplete="off" type="search" ng-blur="handleFocus($event)" ng-focus="handleFocus($event)" ng-keydown="handleKey($event)" ng-model="value"><ul class="autocomplete-dropdown" ng-show="entries && entries.length > 0"><li class="autocomplete-row" ng-class="{active: index == $index}" ng-mousedown="$event.preventDefault()" ng-click="select($event, e)" ng-mouseenter="activate($index)" ng-repeat="e in entries"><span class="label" ng-bind-html="highlight(e.label, value)"></span> <span class="note" ng-if="e.note">{{ e.note }}</span></li></ul></div>'),$templateCache.put("templates/color.html",'<div class="ui-color" tabindex="0" ng-keydown="handleKey($event)" ng-keypress="handleKey($event)"><div class="inner" colorpicker="hex" colorpicker-parent="true" colorpicker-position="{{ position || \'bottom\' }}" colorpicker-with-input="true" style="background-color: {{ value }}" title="{{ value }}" ng-class="{\'fa fa-ban\': !value}" ng-model="value"></div></div>'),$templateCache.put("templates/datetimepicker.html",'<div class="datetimepicker table-responsive"><table class="table table-condensed {{ data.currentView }}-view"><thead><tr><th class="left" ng-click="changeView(data.currentView, data.leftDate, $event)" ng-show="data.leftDate.selectable"><span class="fa fa-arrow-left"></span></th><th class="switch" colspan="5" ng-show="data.previousViewDate.selectable" ng-click="changeView(data.previousView, data.previousViewDate, $event)">{{ data.previousViewDate.display }}</th><th class="right" ng-click="changeView(data.currentView, data.rightDate, $event)" ng-show="data.rightDate.selectable"><span class="fa fa-arrow-right"></span></th></tr><tr><th class="dow" ng-repeat="day in data.dayNames">{{ day }}</th></tr></thead><tbody><tr ng-if="data.currentView !== \'day\'"><td colspan="7"><span class="{{ data.currentView }}" ng-repeat="dateObject in data.dates" ng-class="{active: dateObject.active, past: dateObject.past, future: dateObject.future, disabled: !dateObject.selectable}" ng-click="changeView(data.nextView, dateObject, $event)">{{ dateObject.display }}</span></td></tr><tr ng-if="data.currentView === \'day\'" ng-repeat="week in data.weeks"><td class="day" ng-repeat="dateObject in week.dates" ng-class="{active: dateObject.active, past: dateObject.past, future: dateObject.future, disabled: !dateObject.selectable}" ng-click="changeView(data.nextView, dateObject, $event)">{{ dateObject.display }}</td></tr></tbody></table></div>'),$templateCache.put("templates/dialog.html",'<div class="dialog" ng-mousedown="handleMouse($event)"><div class="content" ng-transclude=""></div></div>'),$templateCache.put("templates/graph.html",'<div class="graph" in-view="handleView($inview, $inviewInfo)" ng-class="{empty: empty, error: error, focus: focus, folded: folded, frame: frame, loading: loading, zooming: zooming}"><message class="clickable" icon="eye-slash" ng-click="toggleFold(false)" ng-show="folded">{{ \'mesg.graphs_folded\' | translate }}</message><div class="graph-control" ng-if="controls && !folded"><menu class="graph-menu"><menuitem href="{{ ::baseURL }}admin/graphs/{{ graphId }}" icon="pencil" info="{{ \'label.graphs_edit\' | translate }}" type="button" ng-if="!$root.readOnly"></menuitem><menuitem type="separator" ng-if="!$root.readOnly"></menuitem><menuitem icon="refresh" info="{{ \'label.graphs_refresh\' | translate }}" type="button" ng-click="refresh()"></menuitem><menuitem icon="clock-o" info="{{ \'label.range_modify\' | translate }}" type="button"><menu><menuitem icon="history" label="{{ \'label.range_reset\' | translate }}" type="button" ng-click="reset()" ng-disabled="!modified"></menuitem><menuitem type="separator"></menuitem><menuitem label="{{ range }}" type="button" ng-click="setRange(range)" ng-repeat="range in rangeValues"></menuitem><menuitem type="separator"></menuitem><menuitem icon="calendar" label="{{ \'label.range_custom\' | translate }}" type="button" ng-click="setRange(\'custom\')"></menuitem></menu></menuitem><menuitem icon="arrows-v" info="{{ \'label.range_propagate\' | translate }}" type="button" ng-click="propagate()"></menuitem><menuitem icon="search-minus" info="{{ \'label.graphs_zoom_out\' | translate }}" type="button" ng-click="zoom(false)"></menuitem><menuitem icon="search-plus" info="{{ \'label.graphs_zoom_in\' | translate }}" type="button" ng-click="zoom(true)"></menuitem><menuitem type="separator"></menuitem><menuitem icon="download" info="{{ \'label.graphs_export\' | translate }}" type="button"><menu><menuitem label="{{ \'label.graphs_export_png\' | translate }}" type="button" ng-click="export($event, \'png\')" ng-disabled="error"></menuitem><menuitem type="separator"></menuitem><menuitem label="{{ \'label.graphs_export_summary_csv\' | translate }}" type="button" ng-click="export($event, \'summary_csv\')"></menuitem><menuitem label="{{ \'label.graphs_export_summary_json\' | translate }}" type="button" ng-click="export($event, \'summary_json\')"></menuitem></menu></menuitem><menuitem href="{{ ::baseURL }}show/{{ embeddablePath }}" target="_blank" icon="window-maximize" info="{{ \'label.graphs_goto_embeddable\' | translate }}" info-direction="bottom-left" type="button" ng-if="!frame && embeddablePath"></menuitem></menu><div class="graph-slides"><div class="graph-fold" ng-class="{active: foldActive}" ng-if="!frame"><div ng-click="toggleFold(true)" ng-show="!folded"><span class="fa fa-chevron-up"></span> {{ \'label.graphs_fold\' | translate }}</div></div><div class="graph-step"><div class="graph-step-backward fa fa-arrow-left" ng-click="moveStep(false)" ng-class="{active: stepActive == \'backward\'}"></div><div class="graph-step-forward fa fa-arrow-right" ng-click="moveStep(true)" ng-class="{active: stepActive == \'forward\'}"></div></div><div class="graph-legend" ng-show="!error"><div ng-click="toggleLegend(true)" ng-show="!legendActive"><span class="fa fa-chevron-down"></span> {{ \'label.graphs_show_legend\' | translate }}</div><div ng-click="toggleLegend(false)" ng-show="legendActive"><span class="fa fa-chevron-up"></span> {{ \'label.graphs_hide_legend\' | translate }}</div></div></div></div><div class="graph-container" ng-if="!folded"><message class="float" icon="warning" type="warning" ng-show="partial">{{ \'mesg.points_partial\' | translate }}</message><message icon="clock-o" ng-class="{float: data}" ng-show="loading">{{ \'mesg.points_fetch\' | translate }}</message><message icon="info-circle" ng-show="empty">{{ \'mesg.points_empty\' | translate }}</message><message icon="times-circle" ng-show="error">{{ \'mesg.points_error\' | translate }}</message></div></div>'),$templateCache.put("templates/list.html",'<div class="list" ng-transclude=""></div>'),$templateCache.put("templates/listcolumn.html",'<div class="listcolumn" ng-transclude=""></div>'),$templateCache.put("templates/listrow.html",'<a class="listrow" ng-href="{{ href }}" ng-transclude=""></a>'),$templateCache.put("templates/menu.html",'<div class="menu" ng-transclude=""></div>'),$templateCache.put("templates/menuitem.html",'<div class="menuitem" ng-class="{active: type == \'button\' && (active || focus), \'{{ type }}\': type, icon: icon && !label, \'has-content\': hasContent}"><a class="content" tabindex="0" target="{{ target }}" ng-href="{{ href }}" ng-class="{active: tooltipActive}" ng-mouseenter="toggleTooltip($event)" ng-mouseleave="toggleTooltip($event)" ng-blur="handleFocus($event)" ng-focus="handleFocus($event)" ng-keypress="handleKey($event)" ng-if="type == \'button\'"><span class="fa fa-{{ icon }}" title="{{ info }}" title-direction="{{ infoDirection }}" ng-if="icon"></span> <span class="badge" ng-if="badge">{{ badge }}</span> <span class="label" ng-if="label">{{ label }}</span></a><div class="content" ng-mouseenter="toggleTooltip($event)" ng-mouseleave="toggleTooltip($event)" ng-if="type == \'label\'"><span class="fa fa-{{ icon }}" ng-if="icon"></span> <span class="badge" ng-if="badge">{{ badge }}</span> <span class="label" ng-if="label">{{ label }}</span></div><div class="content" ng-if="type == \'placeholder\'"><span class="fa fa-{{ icon }}" ng-if="icon"></span> <span class="badge" ng-if="badge">{{ badge }}</span> <span class="label" ng-if="label">{{ label }}</span></div><div class="subcontent" ng-transclude="" ng-if="hasContent"></div></div>'),$templateCache.put("templates/message.html",'<p class="message {{ type }}"><span class="fa fa-{{ icon.replace(\' \', \' fa-\') }}" ng-if="icon"></span> <span class="content" ng-transclude></span></p>'),$templateCache.put("templates/notify.html",'<div class="notify{{ type ? \' \' + type : \'\' }}{{ active ? \' active\' : \'\' }}"><div class="icon"><span class="fa fa-{{ icon || \'exclamation-circle\' }}"></span></div><div class="content" ng-show="type == \'error\'">{{ \'mesg.error\' | translate:{msg: message} }}</div><div class="content" ng-show="type != \'error\'">{{ message }}</div><div class="action" ng-click="reset()"><span class="fa fa-times"></span></div></div>'),$templateCache.put("templates/search.html",'<div class="search" ng-class="{focus: hasFocus}"><label class="fa fa-{{ icon || \'search\' }}"></label> <input placeholder="{{ placeholder }}" type="text" ng-blur="handleFocus($event)" ng-focus="handleFocus($event)" ng-keydown="handleKey($event)" ng-model="ngModel"></div>'),$templateCache.put("templates/tab.html",'<li class="tab" ng-class="{active: active}"><a class="tabanchor" tabindex="0" ng-href="{{ href }}" ng-keydown="handleKey($event)">{{ label }}</a></li>'),$templateCache.put("templates/tabset.html",'<div class="tabset" ng-transclude=""></div>'),$templateCache.put("templates/treeitem.html",'<a class="treelabel" href="browse/collections/{{ ::c.id }}" ng-style="{paddingLeft: \'calc(2rem * \' + depth() + \')\'}"><span class="toggle fa" ng-class="{\'fa-folder\': collapsed, \'fa-folder-open\': !collapsed}" ng-click="$event.preventDefault(); c.children && c.children.length > 0 ? toggle(this) : \'\'"><span class="fa fa-plus extra" ng-show="collapsed && c.children && c.children.length > 0"></span> </span>{{ ::c.label }}</a><ul class="tree" ui-tree-nodes="" ng-model="c.children" ng-if="!collapsed"><li class="treeitem" ui-tree-node="" ng-repeat="c in c.children" ng-include="\'templates/treeitem.html\'"></li></ul>'),$templateCache.put("templates/error/404.html",'<aside><header><a class="logo" href="{{ ::baseURL }}"><img src="assets/images/logo-nav-f5c7f823c6.png" alt="Facette"></a></header><nav><menu><menuitem href="{{ ::baseURL }}" icon="arrow-left" label="{{ \'label.goto_home\' | translate }}" type="button"></menuitem></menu></nav></aside><article><header><h1 title="{{ \'label.error\' | translate }}">{{ \'label.error\' | translate }}</h1></header><section><message icon="times-circle" type="error">{{ \'mesg.page_not_found\' | translate }}</message></section></article>'),
$templateCache.put("templates/admin/edit-collections.html",'<ng-include src="\'templates/admin/layout.html\'" ng-include-replace="true"></ng-include><article ng-class="{hastab: id != \'add\' && item.template}" ng-pane="" ng-show="state == stateOK" ng-if="!linked"><header><h1 class="expand">{{ \'label.admin_panel\' | translate }} – {{ (id == \'add\' ? \'label.collections_new\' : \'label.collections_edit\') | translate }}</h1><ng-include src="\'templates/common/extra-menu.html\'" ng-include-replace="true"></ng-include></header><tabset ng-if="id != \'add\' && item.template"><tab active="tab === 0" label="{{ \'label.items_properties\' | translate }}" ng-click="switchTab(0)"></tab><tab active="tab == 1" label="{{ \'label.templates_instances\' | translate }}" ng-click="switchTab(1)"></tab></tabset><div ng-show="tab === 0"><section ng-pane-step="1"><h1>{{ \'label.collections_definition\' | translate }}</h1><columns ng-class="{split: graphEntryEdit}"><column class="main flexible"><h2>{{ \'label.graphs_list\' | translate }}</h2><message icon="clock-o" type="placeholder" ng-show="state == stateLoading">{{ \'mesg.wait\' | translate }}</message><message icon="info-circle" type="info" ng-show="state == stateOK && (!item.entries || item.entries.length === 0)">{{ \'mesg.graphs_empty\' | translate }}</message><list ng-show="state == stateOK && item.entries && item.entries.length > 0"><div as-sortable="listSortControl" ng-model="item.entries"><listrow as-sortable-item="" ng-class="{active: graph.index === $index || graphEntryEdit === e, disabled: e.options && e.options.enabled === false, locked: graph.index !== undefined && graph.index !== $index || graphEntryEdit && graphEntryEdit !== e}" ng-click="editGraph(e)" ng-repeat="e in item.entries"><listcolumn class="handle"><span as-sortable-item-handle="" class="fa fa-ellipsis-v"></span></listcolumn><listcolumn class="toggle"><span class="toggle fa" ng-class="{\'fa-toggle-on\': !e.options || e.options.enabled === true || e.options.enabled === undefined, \'fa-toggle-off\': e.options && e.options.enabled === false}" ng-click="$event.stopPropagation(); toggleGraph(e)"></span></listcolumn><listcolumn class="main expand"><div class="row"><div class="name">{{ graphData[e.graph].name || e.graph }}</div><div class="note error" ng-if="graphFetched && !graphData[e.graph]"><span class="fa fa-warning"></span> {{ \'mesg.items_not_found\' | translate }}</div><div class="actions"><menu><menuitem icon="cog" info="{{ \'label.graphs_manage\' | translate }}" type="button" ng-click="$event.stopPropagation(); editGraphEntry(e)"></menuitem><menuitem href="{{ ::baseURL }}admin/graphs/{{ e.graph }}" icon="arrow-circle-right" info="{{ \'label.graphs_goto\' | translate }}" type="button" ng-click="$event.stopPropagation()"></menuitem></menu></div></div><div class="description"><div class="info" ng-if="graphData[e.graph] && graphData[e.graph].template && e.attributes"><span class="attrinfo" ng-repeat="k in graphData[e.graph].templateKeys" ng-if="e.attributes[k]">{{ k }}: <strong>{{ e.attributes[k] }}</strong></span></div></div></listcolumn><listcolumn class="actions"><menu><menuitem icon="times-circle" info="{{ \'label.graphs_remove\' | translate }}" type="button" ng-click="$event.stopPropagation(); remove(item.entries, e)"></menuitem></menu></listcolumn></listrow></div></list></column><column class="side" ng-if="!graphEntryEdit"><h2>{{ \'label.graphs_define\' | translate }}</h2><div class="formblock"><label>{{ \'label.graph\' | translate }}</label><autocomplete id="graph" delay="250" source="graphsList" on-select="selectGraph"></autocomplete></div><div class="formblock"><button ng-click="setGraph()" ng-disabled="!graph.id">{{ (graph.index === undefined ? \'label.graphs_add\' : \'label.graphs_update\') | translate }}</button> <button ng-click="resetGraph()" ng-show="graph.index !== undefined">{{ \'label.cancel\' | translate }}</button></div></column><column class="side" ng-if="graphEntryEdit"><h2 ng-if="graphData[graphEntryEdit.graph].template">{{ \'label.templates_attrs\' | translate }}</h2><div class="formblock" ng-if="graphData[graphEntryEdit.graph].template"><table class="keylist"><tbody><tr ng-repeat="(key, _) in entryAttrs"><td class="key"><input type="text" disabled="disabled" ng-model="key"></td><td class="value"><input type="text" ng-model="entryAttrs[key]"></td></tr></tbody></table></div><h2>{{ \'label.graphs_options\' | translate }}</h2><div class="formblock"><label>{{ \'label.range\' | translate }}</label> <input class="small" type="text" placeholder="{{ graphData[graphEntryEdit.graph].options.range }}" ng-model="entryOptions.range"> <label>{{ \'label.graphs_sample\' | translate }}</label> <input class="small" type="number" placeholder="{{ graphData[graphEntryEdit.graph].options.sample }}" ng-model="entryOptions.sample"> <label>{{ \'label.graphs_constants\' | translate }} <span class="note">{{ \'label.separator_comma\' | translate }}</span></label> <input class="small" type="text" placeholder="{{ graphData[graphEntryEdit.graph].options.constants.join(\',\') }}" ng-list=", " ng-model="entryOptions.constants"> <label>{{ \'label.graphs_percentiles\' | translate }} <span class="note">{{ \'label.separator_comma\' | translate }}</span></label> <input class="small" type="text" placeholder="{{ graphData[graphEntryEdit.graph].options.percentiles.join(\',\') }}" ng-list=", " ng-model="entryOptions.percentiles"> <label>{{ \'label.refresh_interval\' | translate }} <span class="note">{{ \'label.refresh_interval_unit\' | translate }}</span></label> <input class="small" type="number" placeholder="{{ graphData[graphEntryEdit.graph].options.refresh_interval }}" ng-model="entryOptions.refresh_interval"> <label>{{ \'label.graphs_misc\' | translate }}</label> <input id="fold" type="checkbox" tabindex="0" ng-model="entryOptions.folded"> <label for="fold">{{ \'label.graphs_fold_default\' | translate }}</label></div></column></columns></section><section ng-pane-step="2"><h1>{{ \'label.collections_definition\' | translate }}</h1><columns class="split"><column class="main" ng-if="!attrsEdit"><h2>{{ \'label.general_info\' | translate }}</h2><div class="formblock"><label>{{ \'label.name\' | translate }} <span class="info fa fa-question-circle" title="{{ \'mesg.name_pattern\' | translate }}" title-direction="right"></span> <span class="warn" ng-show="conflict.name"><span class="fa fa-warning"></span> {{ \'mesg.name_unique\' | translate }}</span> <span class="warn" ng-show="validated && !item.name"><span class="fa fa-warning"></span> {{ \'mesg.name_invalid\' | translate }}</span></label> <input type="text" pattern="[a-zA-Z0-9](?:[a-zA-Z0-9\\-_\\.]*[a-zA-Z0-9])?" ng-class="{danger: conflict.name || validated && !item.name}" ng-model="item.name"> <label>{{ \'label.desc\' | translate }}</label> <textarea type="text" ng-model="item.description"></textarea></div><h2>{{ \'label.collections_params\' | translate }}</h2><div class="formblock"><label>{{ \'label.title\' | translate }}</label> <input type="text" ng-model="item.options.title"> <label>{{ \'label.alias\' | translate }} <span class="info fa fa-question-circle" title="{{ \'mesg.name_pattern\' | translate }}" title-direction="right"></span> <span class="warn" ng-show="conflict.alias"><span class="fa fa-warning"></span> {{ \'mesg.alias_unique\' | translate }}</span></label> <input type="text" pattern="[a-zA-Z0-9](?:[a-zA-Z0-9\\-_\\.]*[a-zA-Z0-9])?" ng-class="{danger: conflict.alias}" ng-model="item.alias" ng-disabled="item.template"><columns><column><label>{{ \'label.refresh_interval\' | translate }}</label> <input type="number" ng-model="item.options.refresh_interval"></column><column><label>{{ \'label.collections_grid_size\' | translate }}</label><ui-select theme="selectize" ng-model="selectedOptions.grid_size"><ui-select-match placeholder="{{ \'label.collections_grid_size_select\' | translate }}"><span ng-bind="$select.selected.name"></span></ui-select-match><ui-select-choices repeat="s in (collectionsGridSizes | filter: $select.search)"><span ng-bind="s.name"></span></ui-select-choices></ui-select></column></columns><label>{{ \'label.collections_parent\' | translate }}</label><autocomplete class="small" id="parent" delay="250" source="collectionsList" on-select="selectParent"></autocomplete><button ng-click="removeParent()" ng-disabled="!item.parent">{{ \'label.remove\' | translate }}</button></div><div class="formblock" ng-if="hasTemplate"><button ng-click="editAttrs(item, true)"><span class="fa fa-file-code-o"></span> {{ \'label.templates_attrs_manage\' | translate }}</button></div></column><column class="main" ng-if="attrsEdit"><h2>{{ \'label.templates_attrs\' | translate }}</h2><div class="formblock"><table class="keylist"><tbody><tr ng-repeat="(key, _) in entryAttrs"><td class="key"><input type="text" disabled="disabled" ng-model="key"></td><td class="value"><input type="text" ng-model="entryAttrs[key]"></td></tr></tbody></table></div></column></columns></section><footer><div ng-show="graphEntryEdit"><button class="danger" ng-click="editGraphEntry(null)">{{ \'label.cancel\' | translate }}</button> <button ng-click="setGraphEntry()">{{ \'label.ok\' | translate }}</button></div><div ng-show="attrsEdit"><button class="danger" ng-click="editAttrs(null)">{{ \'label.cancel\' | translate }}</button> <button ng-click="setAttrs()">{{ \'label.ok\' | translate }}</button></div><div ng-show="!graphEntryEdit && !attrsEdit"><button class="extra" ng-click="reset()" ng-disabled="!modified" ng-if="id != \'add\'"><span class="fa fa-undo"></span> {{ \'label.collections_reset\' | translate }}</button> <button class="danger" ng-click="cancel()" ng-show="id == \'add\' || !altMode">{{ \'label.cancel\' | translate }}</button> <button class="danger" ng-click="delete()" ng-show="id != \'add\' && altMode"><span class="fa fa-trash-o"></span> {{ \'label.collections_delete\' | translate }}</button> <button ng-click="switch(step - 1)" ng-disabled="step == 1"><span class="fa fa-chevron-circle-left"></span> {{ \'label.prev\' | translate }}</button> <button ng-click="switch(step + 1)" ng-disabled="step == 2 || graph.index || graphEntryEdit">{{ \'label.next\' | translate }} <span class="fa fa-chevron-circle-right"></span></button> <button ng-click="save()" ng-disabled="step != 2" ng-show="!item.template && !altMode">{{ \'label.collections_save\' | translate }}</button> <button ng-click="save(true)" ng-disabled="step != 2" ng-show="!item.template && altMode">{{ \'label.save_go\' | translate }}</button> <button ng-click="save()" ng-disabled="step != 2" ng-show="item.template">{{ \'label.templates_save\' | translate }}</button></div></footer></div><div ng-show="tab == 1"><section><h1>{{ \'label.templates_instances\' | translate }}</h1><message icon="clock-o" type="placeholder" ng-show="!instances">{{ \'mesg.wait\' | translate }}</message><message icon="info-circle" type="info" ng-show="instances.length === 0">{{ \'mesg.templates_no_instance\' | translate }}</message><list ng-if="instances.length > 0"><listrow ng-repeat="i in instances"><listcolumn class="main"><div class="row"><div class="name">{{ i.name }}</div><div class="actions"><menu><menuitem href="{{ ::baseURL }}admin/{{ section }}/{{ i.id }}" icon="arrow-circle-right" info="{{ \'label.\' + section + \'_goto\' | translate }}" type="button"></menuitem></menu></div></div></listcolumn></listrow></list></section><footer><button ng-click="switchTab(0)">{{ \'label.go_back\' | translate }}</button></footer></div></article><article ng-pane="" ng-show="state == stateOK" ng-if="linked"><header><h1>{{ \'label.admin_panel\' | translate }} – {{ (id == \'link\' ? \'label.collections_new\' : \'label.collections_edit\') | translate }}</h1><menu ng-if="id != \'add\' && item.link"><menuitem href="{{ ::baseURL }}admin/{{ section }}/{{ item.link }}" icon="pencil" info="{{ \'label.\' + section + \'_edit_template\' | translate }}" type="button"></menuitem></menu></header><section ng-pane-step="1"><h1>{{ \'label.collections_definition\' | translate }}</h1><columns><column class="main"><h2>{{ \'label.general_info\' | translate }}</h2><label>{{ \'label.name\' | translate }} <span class="info fa fa-question-circle" title="{{ \'mesg.name_pattern\' | translate }}" title-direction="right"></span> <span class="warn" ng-show="conflict.name"><span class="fa fa-warning"></span> {{ \'mesg.name_unique\' | translate }}</span> <span class="warn" ng-show="validated && !item.name"><span class="fa fa-warning"></span> {{ \'mesg.name_invalid\' | translate }}</span></label> <input type="text" pattern="[a-zA-Z0-9](?:[a-zA-Z0-9\\-_\\.]*[a-zA-Z0-9])?" ng-class="{danger: conflict.name || validated && !item.name}" ng-model="item.name"> <label>{{ \'label.alias\' | translate }} <span class="info fa fa-question-circle" title="{{ \'mesg.name_pattern\' | translate }}" title-direction="right"></span> <span class="warn" ng-show="conflict.alias"><span class="fa fa-warning"></span> {{ \'mesg.alias_unique\' | translate }}</span></label> <input type="text" pattern="[a-zA-Z0-9](?:[a-zA-Z0-9\\-_\\.]*[a-zA-Z0-9])?" ng-class="{danger: conflict.alias}" ng-model="item.alias"> <label>{{ \'label.templates_source\' | translate }}</label><autocomplete class="small" id="template" delay="250" source="templateSources" on-select="selectTemplate"></autocomplete><label>{{ \'label.collections_parent\' | translate }}</label><autocomplete class="small" id="parent" delay="250" source="collectionsList" on-select="selectParent"></autocomplete><button ng-click="removeParent()" ng-disabled="!item.parent">{{ \'label.remove\' | translate }}</button><h2>{{ \'label.templates_attrs\' | translate }}</h2><message icon="info-circle" type="info" ng-show="!item.link">{{ \'mesg.templates_empty\' | translate }}</message><message icon="clock-o" type="placeholder" ng-show="item.link && templateKeys === undefined">{{ \'mesg.wait\' | translate }}</message><message icon="exclamation-circle" type="warning" ng-show="item.link && templateKeys && templateKeys.length === 0">{{ \'mesg.templates_no_key\' | translate }}</message><table class="keylist" ng-show="templateKeys"><tbody><tr ng-repeat="key in templateKeys"><td class="key"><input type="text" disabled="disabled" ng-model="key"></td><td class="value"><input type="text" ng-model="item.attributes[key]"></td></tr></tbody></table></column></columns></section><footer><button class="extra" ng-click="reset()" ng-disabled="!modified" ng-if="id != \'link\'"><span class="fa fa-undo"></span> {{ \'label.collections_reset\' | translate }}</button> <button class="danger" ng-click="cancel()" ng-show="id == \'link\' || !altMode">{{ \'label.cancel\' | translate }}</button> <button class="danger" ng-click="delete()" ng-show="id != \'link\' && altMode"><span class="fa fa-trash-o"></span> {{ \'label.collections_delete\' | translate }}</button> <button ng-click="save()" ng-disabled="!item.name || !item.link" ng-show="!altMode">{{ \'label.collections_save\' | translate }}</button> <button ng-click="save(true)" ng-disabled="!item.name || !item.link" ng-show="altMode">{{ \'label.save_go\' | translate }}</button></footer></article><article ng-show="state == stateError"><header><h1>{{ \'label.admin_panel\' | translate }} – {{ \'label.collections_edit\' | translate }}</h1></header><section><message icon="times-circle" type="error" ng-if="!notFound">{{ \'mesg.fetch_error\' | translate }}</message><message icon="times-circle" type="error" ng-if="notFound">{{ \'mesg.items_not_found\' | translate }}</message></section><footer><button ng-click="cancel(true)"><span class="fa fa-arrow-left"></span> {{ \'label.collections_back\' | translate }}</button></footer></article>'),$templateCache.put("templates/admin/edit-graphs-groups.html",'<tabset><tab active="groupEdit" label="{{ \'label.group\' | translate }}" ng-click="switchEdit(true, null)"></tab><tab active="!groupEdit" label="{{ \'label.series_paging\' | translate:{current: seriesCurrent + 1, total: seriesTotal} }}" ng-click="switchEdit(false, null)"></tab></tabset><form><div class="formblock" ng-if="groupEdit"><columns><column class="main"><label>{{ \'label.name\' | translate }}</label> <input type="text" ng-model="groupItem.name"></column><column><label>{{ \'label.color\' | translate }}</label><colorpicker position="left" value="groupItem.options.color"></colorpicker></column></columns><label>{{ \'label.scale\' | translate }}</label> <input type="number" step="any" ng-model="groupItem.options.scale"> <label>{{ \'label.series_operator\' | translate }}</label><ui-select theme="selectize" ng-model="selectedOptions.group.operator"><ui-select-match placeholder="{{ \'label.series_operator_select\' | translate }}"><span ng-bind="$select.selected.name"></span></ui-select-match><ui-select-choices repeat="o in (groupOperators | filter: $select.search)"><span ng-bind="o.name"></span></ui-select-choices></ui-select><label>{{ \'label.series_consolidate\' | translate }}</label><ui-select theme="selectize" ng-model="selectedOptions.group.consolidate"><ui-select-match placeholder="{{ \'label.series_consolidate_select\' | translate }}"><span ng-bind="$select.selected.name"></span></ui-select-match><ui-select-choices repeat="c in (groupConsolidations | filter: $select.search)"><span ng-bind="c.name"></span></ui-select-choices></ui-select><input id="interpolate" type="checkbox" tabindex="0" ng-model="groupItem.options.interpolate"> <label for="interpolate">{{ \'label.series_consolidate_interpolate\' | translate }}</label></div><div class="formblock" ng-if="!groupEdit"><columns><column class="main"><label>{{ \'label.name\' | translate }}</label> <input type="text" ng-model="groupItem.series[seriesCurrent].name"></column><column><label>{{ \'label.color\' | translate }}</label><colorpicker position="left" value="groupItem.series[seriesCurrent].options.color"></colorpicker></column></columns><label>{{ \'label.scale\' | translate }}</label> <input type="number" step="any" ng-model="groupItem.series[seriesCurrent].options.scale"></div><div class="formblock actions"><div class="switch" ng-if="!groupEdit"><button type="button" ng-click="switchEdit(false, -1)" ng-disabled="seriesCurrent === 0"><span class="fa fa-chevron-left"></span></button> <button type="button" ng-click="switchEdit(false, 1)" ng-disabled="seriesCurrent === (seriesTotal - 1)"><span class="fa fa-chevron-right"></span></button></div><button class="cancel danger" type="button" ng-click="closeThisDialog()">{{ \'label.cancel\' | translate }}</button> <button class="validate" type="submit" ng-click="closeThisDialog(groupItem)">{{ \'label.validate\' | translate }}</button></div></form>'),
$templateCache.put("templates/admin/edit-graphs.html",'<ng-include src="\'templates/admin/layout.html\'" ng-include-replace="true"></ng-include><article ng-class="{hastab: id != \'add\' && item.template}" ng-pane="" ng-show="state == stateOK" ng-if="!linked"><header><h1 class="expand">{{ \'label.admin_panel\' | translate }} – {{ (id == \'add\' ? \'label.graphs_new\' : \'label.graphs_edit\') | translate }}</h1><ng-include src="\'templates/common/extra-menu.html\'" ng-include-replace="true"></ng-include></header><tabset ng-if="id != \'add\' && item.template"><tab active="tab === 0" label="{{ \'label.items_properties\' | translate }}" ng-click="switchTab(0)"></tab><tab active="tab == 1" label="{{ \'label.templates_instances\' | translate }}" ng-click="switchTab(1)"></tab></tabset><div ng-show="tab === 0"><section ng-pane-step="1"><h1>{{ \'label.graphs_definition\' | translate }}</h1><columns><column class="main flexible"><div class="titlerow"><h2>{{ \'label.series_list\' | translate }}</h2><div class="formblock"><button ng-click="mergeGroup(true)" ng-disabled="selected.length <= 1" ng-show="selectedGroup.length === 0 || selectedGroup.length != selected.length"><span class="fa fa-object-group"></span> {{ \'label.series_group\' | translate }}</button> <button ng-click="mergeGroup(false)" ng-show="selectedGroup.length > 0 && selectedGroup.length === selected.length"><span class="fa fa-object-ungroup"></span> {{ \'label.series_ungroup\' | translate }}</button></div></div><message icon="clock-o" type="placeholder" ng-show="state == stateLoading">{{ \'mesg.wait\' | translate }}</message><message icon="info-circle" type="info" ng-show="state == stateOK && (!item.groups || item.groups.length === 0)">{{ \'mesg.series_empty\' | translate }}</message><list ng-show="state == stateOK && item.groups && item.groups.length > 0"><div as-sortable="listSortControl" ng-model="item.groups"><listrow as-sortable-item="" ng-class="{active: series.index === $index, locked: series.index !== undefined && series.index !== $index, selected: g.selected}" ng-click="editSeries(g)" ng-repeat="g in item.groups"><listcolumn class="handle"><span as-sortable-item-handle="" class="fa fa-ellipsis-v"></span></listcolumn><listcolumn class="checkbox" ng-click="$event.stopPropagation()"><input id="item{{ $index }}" type="checkbox" ng-model="g.selected"> <label class="empty" for="item{{ $index }}" tabindex="0"></label></listcolumn><listcolumn class="main expand"><div class="row"><div class="color"><span class="fa fa-circle" ng-style="{color: getSeriesColor($index)}"></span></div><div class="name">{{ g.name || (g.series.length == 1 ? g.series[0].name : \'&nbsp;\') }}</div><div class="actions"><menu><menuitem icon="cog" info="{{ \'label.series_group_edit\' | translate }}" type="button" ng-click="$event.stopPropagation(); editGroup(g)"></menuitem></menu></div></div><div class="row description bullet" ng-repeat="s in g.series track by $index"><div class="info">{{ \'label.name_alt\' | translate }} <strong>{{ s.name }}</strong>, {{ \'label.metric_alt\' | translate }} <strong>{{ s.origin }}/{{ resolveGroup(s.source) }}/{{ resolveGroup(s.metric) }}</strong></div><div><span class="count" ng-show="s.expansion !== undefined">{{ expandData[s.expansion].length }}</span></div><div class="actions"><menu><menuitem icon="times" info="{{ \'label.series_remove\' | translate }}" type="button" ng-click="$event.stopPropagation(); remove(g.series, s)"></menuitem></menu></div></div></listcolumn><listcolumn class="actions"><menu><menuitem icon="caret-square-o-down" info="{{ \'label.groups_expand\' | translate }}" type="button" ng-click="$event.stopPropagation(); expandGroup(g, true)" ng-disabled="expandData[g.series[0].expansion].length === 0" ng-show="g.series.length == 1 && g.series[0].expansion !== undefined"></menuitem><menuitem icon="caret-square-o-up" info="{{ \'label.groups_collapse\' | translate }}" type="button" ng-click="$event.stopPropagation(); expandGroup(g, false)" ng-show="g.series.length == 1 && g.series[0].expanded !== undefined"></menuitem><menuitem icon="times-circle" info="{{ \'label.groups_remove\' | translate }}" type="button" ng-click="$event.stopPropagation(); remove(item.groups, g)"></menuitem></menu></listcolumn></listrow></div></list></column><column class="side"><h2>{{ \'label.series_define\' | translate }} <span ng-show="series.index !== undefined && seriesTotal > 1">– {{ \'label.series_paging\' | translate:{current: seriesCurrent + 1, total: seriesTotal} }}</span></h2><div class="formblock"><label>{{ \'label.origin\' | translate }}</label><autocomplete id="origin" delay="250" allow-override="true" source="seriesOrigins" on-select="selectSeries"></autocomplete><label>{{ \'label.source\' | translate }}</label><autocomplete id="source" delay="250" allow-override="true" source="seriesSources" on-select="selectSeries"></autocomplete><label>{{ \'label.metric\' | translate }}</label><autocomplete id="metric" delay="250" allow-override="true" source="seriesMetrics" on-select="selectSeries"></autocomplete></div><div class="formblock" ng-class="{actions: series.index !== undefined && seriesTotal > 1}"><button ng-click="setSeries()" ng-disabled="!series.valid">{{ (series.index === undefined ? \'label.series_add\' : \'label.series_update\') | translate }}</button> <button class="danger" ng-click="resetSeries(false, true)" ng-show="series.index !== undefined">{{ \'label.cancel\' | translate }}</button><div class="switch" ng-show="series.index !== undefined && seriesTotal > 1"><button type="button" ng-click="switchSeries(-1)" ng-disabled="seriesCurrent === 0"><span class="fa fa-chevron-left"></span></button> <button type="button" ng-click="switchSeries(1)" ng-disabled="seriesCurrent === (seriesTotal - 1)"><span class="fa fa-chevron-right"></span></button></div></div></column></columns></section><section ng-pane-step="2"><h1>{{ \'label.graphs_definition\' | translate }}</h1><columns class="split"><column class="main" ng-if="!optionsEdit"><h2>{{ \'label.general_info\' | translate }}</h2><div class="formblock"><label>{{ \'label.name\' | translate }} <span class="info fa fa-question-circle" title="{{ \'mesg.name_pattern\' | translate }}" title-direction="right"></span> <span class="warn" ng-show="conflict.name"><span class="fa fa-warning"></span> {{ \'mesg.name_unique\' | translate }}</span> <span class="warn" ng-show="validated && !item.name"><span class="fa fa-warning"></span> {{ \'mesg.name_invalid\' | translate }}</span></label> <input type="text" pattern="[a-zA-Z0-9](?:[a-zA-Z0-9\\-_\\.]*[a-zA-Z0-9])?" ng-class="{danger: conflict.name || validated && !item.name}" ng-model="item.name"> <label>{{ \'label.desc\' | translate }}</label> <textarea type="text" ng-model="item.description"></textarea></div><h2>{{ \'label.graphs_params\' | translate }}</h2><div class="formblock"><label>{{ \'label.title\' | translate }}</label> <input type="text" ng-model="item.options.title"> <label>{{ \'label.alias\' | translate }} <span class="info fa fa-question-circle" title="{{ \'mesg.name_pattern\' | translate }}" title-direction="right"></span> <span class="warn" ng-show="conflict.alias"><span class="fa fa-warning"></span> {{ \'mesg.alias_unique\' | translate }}</span></label> <input type="text" pattern="[a-zA-Z0-9](?:[a-zA-Z0-9\\-_\\.]*[a-zA-Z0-9])?" ng-class="{danger: conflict.alias}" ng-model="item.alias" ng-disabled="item.template"><columns><column><label>{{ \'label.graphs_type\' | translate }}</label><ui-select theme="selectize" ng-model="selectedOptions.main.type"><ui-select-match placeholder="{{ \'label.graphs_type_select\' | translate }}"><span ng-bind="$select.selected.name"></span></ui-select-match><ui-select-choices repeat="t in (graphTypes | filter: $select.search)"><span ng-bind="t.name"></span></ui-select-choices></ui-select></column><column><label>{{ \'label.graphs_stack_mode\' | translate }}</label><ui-select theme="selectize" ng-model="selectedOptions.main.stack_mode"><ui-select-match placeholder="{{ \'label.graphs_stack_mode_select\' | translate }}"><span ng-bind="$select.selected.name"></span></ui-select-match><ui-select-choices repeat="t in (graphStackModes | filter: $select.search)"><span ng-bind="t.name"></span></ui-select-choices></ui-select></column></columns><columns><column><label>{{ \'label.graphs_yaxis_label\' | translate }}</label> <input type="text" ng-model="item.options.yaxis_label"></column><column><label>{{ \'label.graphs_yaxis_unit\' | translate }} <span class="info fa fa-question-circle" title="{{ \'mesg.graphs_yaxis_unit_fixed\' | translate }}<br>{{ \'mesg.graphs_yaxis_unit_metric\' | translate }}<br>{{ \'mesg.graphs_yaxis_unit_binary\' | translate }}" title-direction="right"></span></label> <input id="axis-unit-fixed" name="axis-unit" type="radio" value="fixed" ng-model="item.options.yaxis_unit"> <label for="axis-unit-fixed" tabindex="0">{{ \'label.graphs_yaxis_unit_fixed\' | translate }}</label> <input id="axis-unit-metric" name="axis-unit" type="radio" value="metric" ng-model="item.options.yaxis_unit"> <label for="axis-unit-metric" tabindex="0">{{ \'label.graphs_yaxis_unit_metric\' | translate }}</label> <input id="axis-unit-binary" name="axis-unit" type="radio" value="binary" ng-model="item.options.yaxis_unit"> <label for="axis-unit-binary" tabindex="0">{{ \'label.graphs_yaxis_unit_binary\' | translate }}</label></column></columns></div><div class="formblock"><button ng-click="editOptions(true)"><span class="fa fa-cog"></span> {{ \'label.options_manage\' | translate }}</button></div></column><column class="side" ng-if="!optionsEdit"><h2>{{ \'label.graphs_preview\' | translate }}</h2><graph class="preview" def="itemDef" controls="false"></graph><div ng-show="item.template"><h3>{{ \'label.templates_attrs\' | translate }} <span class="note">{{ \'label.templates_attrs_note\' | translate }}</span></h3><table class="keylist"><tbody><tr ng-repeat="key in templateKeys"><td class="key"><input type="text" disabled="disabled" ng-model="key"></td><td class="value"><input type="text" ng-model="item.attributes[key]"></td></tr></tbody></table></div></column><column class="main" ng-if="optionsEdit"><h2>{{ \'label.graphs_options\' | translate }}</h2><form ng-entersubmit="setOptions()"><label>{{ \'label.range\' | translate }}</label> <input class="small" type="text" placeholder="-1h" ng-model="options.range"> <label>{{ \'label.graphs_sample\' | translate }}</label> <input class="small" type="number" placeholder="400" ng-model="options.sample"> <label>{{ \'label.graphs_constants\' | translate }} <span class="note">{{ \'label.separator_comma\' | translate }}</span></label> <input class="small" type="text" ng-list=", " ng-model="options.constants"> <label>{{ \'label.graphs_percentiles\' | translate }} <span class="note">{{ \'label.separator_comma\' | translate }}</span></label> <input class="small" type="text" ng-list=", " ng-model="options.percentiles"> <label>{{ \'label.refresh_interval\' | translate }} <span class="note">{{ \'label.refresh_interval_unit\' | translate }}</span></label> <input class="small" type="number" ng-model="options.refresh_interval"></form></column></columns></section><footer><div ng-if="!optionsEdit"><button class="extra" ng-click="reset()" ng-disabled="!modified" ng-if="id != \'add\'"><span class="fa fa-undo"></span> {{ \'label.graphs_reset\' | translate }}</button> <button class="danger" ng-click="cancel()" ng-show="id == \'add\' || !altMode">{{ \'label.cancel\' | translate }}</button> <button class="danger" ng-click="delete()" ng-show="id != \'add\' && altMode"><span class="fa fa-trash-o"></span> {{ \'label.graphs_delete\' | translate }}</button> <button ng-click="switch(step - 1)" ng-disabled="step == 1 || optionsEdit"><span class="fa fa-chevron-circle-left"></span> {{ \'label.prev\' | translate }}</button> <button ng-click="switch(step + 1)" ng-disabled="!item.groups || item.groups.length === 0 || step == 2 || optionsEdit">{{ \'label.next\' | translate }} <span class="fa fa-chevron-circle-right"></span></button> <button ng-click="save()" ng-disabled="step != 2 || optionsEdit" ng-show="!item.template && !altMode">{{ \'label.graphs_save\' | translate }}</button> <button ng-click="save(true)" ng-disabled="step != 2 || optionsEdit" ng-show="!item.template && altMode">{{ \'label.save_go\' | translate }}</button> <button ng-click="save()" ng-disabled="step != 2 || optionsEdit" ng-show="item.template">{{ \'label.templates_save\' | translate }}</button></div><div ng-if="optionsEdit"><button class="danger" ng-click="editOptions(false)">{{ \'label.cancel\' | translate }}</button> <button ng-click="setOptions()">{{ \'label.ok\' | translate }}</button></div></footer></div><div ng-show="tab == 1"><section><h1>{{ \'label.templates_instances\' | translate }}</h1><message icon="clock-o" type="placeholder" ng-show="!instances">{{ \'mesg.wait\' | translate }}</message><message icon="info-circle" type="info" ng-show="instances.length === 0">{{ \'mesg.templates_no_instance\' | translate }}</message><list ng-if="instances.length > 0"><listrow ng-repeat="i in instances"><listcolumn class="main"><div class="row"><div class="name">{{ i.name }}</div><div class="actions"><menu><menuitem href="{{ ::baseURL }}admin/{{ section }}/{{ i.id }}" icon="arrow-circle-right" info="{{ \'label.\' + section + \'_goto\' | translate }}" type="button"></menuitem></menu></div></div></listcolumn></listrow></list></section><footer><button ng-click="switchTab(0)">{{ \'label.go_back\' | translate }}</button></footer></div></article><article ng-pane="" ng-show="state == stateOK" ng-if="linked"><header><h1>{{ \'label.admin_panel\' | translate }} – {{ (id == \'link\' ? \'label.graphs_new\' : \'label.graphs_edit\') | translate }}</h1><menu ng-if="id != \'add\' && item.link"><menuitem href="{{ ::baseURL }}admin/{{ section }}/{{ item.link }}" icon="pencil" info="{{ \'label.\' + section + \'_edit_template\' | translate }}" type="button"></menuitem></menu></header><section ng-pane-step="1"><h1>{{ \'label.graphs_definition\' | translate }}</h1><columns class="split"><column class="main"><h2>{{ \'label.general_info\' | translate }}</h2><label>{{ \'label.name\' | translate }} <span class="info fa fa-question-circle" title="{{ \'mesg.name_pattern\' | translate }}" title-direction="right"></span> <span class="warn" ng-show="conflict.name"><span class="fa fa-warning"></span> {{ \'mesg.name_unique\' | translate }}</span> <span class="warn" ng-show="validated && !item.name"><span class="fa fa-warning"></span> {{ \'mesg.name_invalid\' | translate }}</span></label> <input type="text" pattern="[a-zA-Z0-9](?:[a-zA-Z0-9\\-_\\.]*[a-zA-Z0-9])?" ng-class="{danger: conflict.name || validated && !item.name}" ng-model="item.name"> <label>{{ \'label.alias\' | translate }} <span class="info fa fa-question-circle" title="{{ \'mesg.name_pattern\' | translate }}" title-direction="right"></span> <span class="warn" ng-show="conflict.alias"><span class="fa fa-warning"></span> {{ \'mesg.alias_unique\' | translate }}</span></label> <input type="text" pattern="[a-zA-Z0-9](?:[a-zA-Z0-9\\-_\\.]*[a-zA-Z0-9])?" ng-class="{danger: conflict.alias}" ng-model="item.alias"> <label>{{ \'label.templates_source\' | translate }}</label><autocomplete class="small" id="template" delay="250" source="templateSources" on-select="selectTemplate"></autocomplete><h2>{{ \'label.templates_attrs\' | translate }}</h2><message icon="info-circle" type="info" ng-show="!item.link">{{ \'mesg.templates_empty\' | translate }}</message><message icon="clock-o" type="placeholder" ng-show="item.link && templateKeys === undefined">{{ \'mesg.wait\' | translate }}</message><message icon="exclamation-circle" type="warning" ng-show="item.link && templateKeys && templateKeys.length === 0">{{ \'mesg.templates_no_key\' | translate }}</message><table class="keylist" ng-show="templateKeys"><tbody><tr ng-repeat="key in templateKeys"><td class="key"><input type="text" disabled="disabled" ng-model="key"></td><td class="value"><input type="text" ng-model="item.attributes[key]"></td></tr></tbody></table></column><column class="side"><h2>{{ \'label.graphs_preview\' | translate }}</h2><graph class="preview" def="itemDef" controls="false"></graph></column></columns></section><footer><button class="extra" ng-click="reset()" ng-disabled="!modified" ng-if="id != \'link\'"><span class="fa fa-undo"></span> {{ \'label.graphs_reset\' | translate }}</button> <button class="danger" ng-click="cancel()" ng-show="id == \'link\' || !altMode">{{ \'label.cancel\' | translate }}</button> <button class="danger" ng-click="delete()" ng-show="id != \'link\' && altMode"><span class="fa fa-trash-o"></span> {{ \'label.graphs_delete\' | translate }}</button> <button ng-click="save()" ng-disabled="!item.name || !item.link" ng-show="!altMode">{{ \'label.graphs_save\' | translate }}</button> <button ng-click="save(true)" ng-disabled="!item.name || !item.link" ng-show="altMode">{{ \'label.save_go\' | translate }}</button></footer></article><article ng-show="state == stateError"><header><h1>{{ \'label.admin_panel\' | translate }} – {{ \'label.graphs_edit\' | translate }}</h1></header><section><message icon="times-circle" type="error" ng-if="!notFound">{{ \'mesg.fetch_error\' | translate }}</message><message icon="times-circle" type="error" ng-if="notFound">{{ \'mesg.items_not_found\' | translate }}</message></section><footer><button ng-click="cancel(true)"><span class="fa fa-arrow-left"></span> {{ \'label.graphs_back\' | translate }}</button></footer></article>'),$templateCache.put("templates/admin/edit-groups.html",'<ng-include src="\'templates/admin/layout.html\'" ng-include-replace="true"></ng-include><article ng-pane="" ng-show="state == stateOK"><header><h1 class="expand">{{ \'label.admin_panel\' | translate }} – {{ (id == \'add\' ? \'label.\' + section + \'_new\' : \'label.\' + section + \'_edit\') | translate }}</h1><ng-include src="\'templates/common/extra-menu.html\'" ng-include-replace="true"></ng-include></header><section ng-pane-step="1"><h1>{{ \'label.groups_definition\' | translate }}</h1><columns><column class="main flexible"><h2>{{ \'label.patterns_list\' | translate }}</h2><message icon="clock-o" type="placeholder" ng-show="state == stateLoading">{{ \'mesg.wait\' | translate }}</message><message icon="info-circle" type="info" ng-show="state == stateOK && (!item.patterns || item.patterns.length === 0)">{{ \'mesg.patterns_empty\' | translate }}</message><list ng-show="state == stateOK && item.patterns && item.patterns.length > 0"><div as-sortable="listSortControl" ng-model="item.patterns"><listrow as-sortable-item="" ng-class="{active: pattern.index === $index, locked: pattern.index !== undefined && pattern.index !== $index}" ng-click="editPattern(p)" ng-repeat="(idx, p) in item.patterns track by unique(idx, p)"><listcolumn class="handle"><span as-sortable-item-handle="" class="fa fa-ellipsis-v"></span></listcolumn><listcolumn class="main expand"><div class="row"><div class="name">{{ p }}</div><div class="actions"><menu><menuitem icon="info-circle" type="button" info="{{ patternsData[p] || (\'mesg.wait\' | translate) }}" info-direction="bottom-right" ng-mouseenter="patternsData[p] || testPattern(p)" ng-if="p.indexOf(\'glob:\') === 0 || p.indexOf(\'regexp:\') === 0"></menuitem></menu></div></div></listcolumn><listcolumn class="actions"><menu><menuitem icon="times-circle" info="{{ \'label.patterns_remove\' | translate }}" type="button" ng-click="$event.stopPropagation(); remove(item.patterns, p)"></menuitem></menu></listcolumn></listrow></div></list></column><column class="side"><h2>{{ \'label.patterns_define\' | translate }}</h2><div class="formblock"><label>{{ \'label.patterns_type\' | translate }}</label><ui-select theme="selectize" ng-model="pattern.type"><ui-select-match placeholder="{{ \'label.patterns_type_select\' | translate }}"><span ng-bind="$select.selected.name"></span></ui-select-match><ui-select-choices repeat="t in (patternTypes | filter: $select.search)"><span ng-bind="t.name"></span></ui-select-choices></ui-select><label>{{ \'label.patterns_value\' | translate }}</label><autocomplete id="value" delay="250" allow-override="true" source="patternValues" on-select="selectPattern" ng-if="pattern.type.value == 1"></autocomplete><input type="text" ng-model="pattern.value" ng-if="pattern.type.value != 1"></div><div class="formblock"><button ng-click="setPattern()" ng-disabled="!pattern.value">{{ (pattern.index === undefined ? \'label.patterns_add\' : \'label.patterns_update\') | translate }}</button> <button class="danger" ng-click="resetPattern()" ng-show="pattern.index !== undefined">{{ \'label.cancel\' | translate }}</button></div></column></columns></section><section ng-pane-step="2"><h1>{{ \'label.groups_definition\' | translate }}</h1><columns><column class="main"><h2>{{ \'label.general_info\' | translate }}</h2><label>{{ \'label.name\' | translate }} <span class="info fa fa-question-circle" title="{{ \'mesg.name_pattern\' | translate }}" title-direction="right"></span> <span class="warn" ng-show="conflict.name"><span class="fa fa-warning"></span> {{ \'mesg.name_unique\' | translate }}</span> <span class="warn" ng-show="validated && !item.name"><span class="fa fa-warning"></span> {{ \'mesg.name_invalid\' | translate }}</span></label> <input type="text" pattern="[a-zA-Z0-9](?:[a-zA-Z0-9\\-_\\.]*[a-zA-Z0-9])?" ng-class="{danger: conflict.name || validated && !item.name}" ng-model="item.name"> <label>{{ \'label.desc\' | translate }}</label> <textarea type="text" ng-model="item.description"></textarea></column></columns></section><footer><button class="extra" ng-click="reset()" ng-disabled="!modified" ng-if="id != \'add\'"><span class="fa fa-undo"></span> {{ \'label.groups_reset\' | translate }}</button> <button class="danger" ng-click="cancel()" ng-show="id == \'add\' || !altMode">{{ \'label.cancel\' | translate }}</button> <button class="danger" ng-click="delete()" ng-show="id != \'add\' && altMode"><span class="fa fa-trash-o"></span> {{ \'label.\' + section + \'_delete\' | translate }}</button> <button ng-click="switch(step - 1)" ng-disabled="step == 1"><span class="fa fa-chevron-circle-left"></span> {{ \'label.prev\' | translate }}</button> <button ng-click="switch(step + 1)" ng-disabled="!item.patterns || item.patterns.length === 0 || step == 2">{{ \'label.next\' | translate }} <span class="fa fa-chevron-circle-right"></span></button> <button ng-click="save()" ng-disabled="step != 2">{{ \'label.groups_save\' | translate }}</button></footer></article><article ng-show="state == stateError"><header><h1>{{ \'label.admin_panel\' | translate }} – {{ \'label.\' + section + \'_edit\' | translate }}</h1></header><section><message icon="times-circle" type="error" ng-if="!notFound">{{ \'mesg.fetch_error\' | translate }}</message><message icon="times-circle" type="error" ng-if="notFound">{{ \'mesg.items_not_found\' | translate }}</message></section><footer><button ng-click="cancel(true)"><span class="fa fa-arrow-left"></span> {{ \'label.\' + section + \'_back\' | translate }}</button></footer></article>'),$templateCache.put("templates/admin/edit-providers-facette.html",'<h1>{{ \'label.providers_definition\' | translate }}</h1><columns><column class="main"><h2>{{ \'label.connectors_settings\' | translate }}</h2><label>{{ \'label.connectors_instance_url\' | translate }}</label> <input type="text" ng-model="item.settings.url"> <label>{{ \'label.connectors_timeout\' | translate }}</label> <input class="small" type="number" placeholder="10" ng-model="item.settings.timeout"> <label>{{ \'label.connectors_tls\' | translate }}</label> <input id="allow-insecure" type="checkbox" ng-model="item.settings.allow_insecure_tls"> <label for="allow-insecure" tabindex="0">{{ \'label.connectors_allow_insecure\' | translate }}</label></column></columns>'),$templateCache.put("templates/admin/edit-providers-graphite.html",'<h1>{{ \'label.providers_definition\' | translate }}</h1><columns><column class="main"><h2>{{ \'label.connectors_settings\' | translate }}</h2><label>{{ \'label.connectors_instance_url\' | translate }}</label> <input type="text" ng-model="item.settings.url"> <label>{{ \'label.connectors_timeout\' | translate }}</label> <input class="small" id="timeout" type="number" placeholder="10" ng-model="item.settings.timeout"> <label>{{ \'label.connectors_tls\' | translate }}</label> <input id="allow-insecure" type="checkbox" tabindex="0" ng-model="item.settings.allow_insecure_tls"> <label for="allow-insecure">{{ \'label.connectors_allow_insecure\' | translate }}</label> <label>{{ \'label.connectors_match_pattern\' | translate }}</label> <input type="text" ng-model="item.settings.pattern"></column></columns>'),$templateCache.put("templates/admin/edit-providers-influxdb.html",'<h1>{{ \'label.providers_definition\' | translate }}</h1><columns><column class="main" ng-init="matchType = item.settings.mapping ? \'mapping\' : \'pattern\'"><h2>{{ \'label.connectors_settings\' | translate }}</h2><label>{{ \'label.connectors_instance_url\' | translate }}</label> <input type="text" ng-model="item.settings.url"> <label>{{ \'label.connectors_timeout\' | translate }}</label> <input class="small" id="timeout" type="number" placeholder="10" ng-model="item.settings.timeout"> <label>{{ \'label.connectors_tls\' | translate }}</label> <input id="allow-insecure" type="checkbox" tabindex="0" ng-model="item.settings.allow_insecure_tls"> <label for="allow-insecure" tabindex="0">{{ \'label.connectors_allow_insecure\' | translate }}</label> <label>{{ \'label.connectors_influxdb_username\' | translate }}</label> <input type="text" ng-model="item.settings.username"> <label>{{ \'label.connectors_influxdb_password\' | translate }}</label> <input type="password" ng-model="item.settings.password"> <label>{{ \'label.connectors_influxdb_database\' | translate }}</label> <input type="text" ng-model="item.settings.database"> <label>{{ \'label.connectors_influxdb_match_type\' | translate }}</label> <input id="match-pattern" name="match" type="radio" value="pattern" ng-model="matchType"> <label for="match-pattern" tabindex="0">{{ \'label.connectors_influxdb_match_pattern\' | translate }}</label> <input id="match-mapping" name="match" type="radio" value="mapping" ng-model="matchType"> <label for="match-mapping" tabindex="0">{{ \'label.connectors_influxdb_match_mapping\' | translate }}</label><div ng-if="matchType == \'pattern\'"><label>{{ \'label.connectors_match_pattern\' | translate }}</label> <input type="text" ng-model="item.settings.pattern"></div><div ng-if="matchType == \'mapping\'"><label>{{ \'label.connectors_match_mapping_source\' | translate }} <span class="note">{{ \'label.separator_comma\' | translate }}</span></label> <input type="text" ng-list=", " ng-model="item.settings.mapping.source"> <label>{{ \'label.connectors_match_mapping_metric\' | translate }} <span class="note">{{ \'label.separator_comma\' | translate }}</span></label> <input type="text" ng-list=", " ng-model="item.settings.mapping.metric"> <label>{{ \'label.connectors_match_mapping_glue\' | translate }}</label> <input type="text" ng-model="item.settings.mapping.glue"></div></column></columns>'),$templateCache.put("templates/admin/edit-providers-kairosdb.html",'<h1>{{ \'label.providers_definition\' | translate }}</h1><columns><column class="main"><h2>{{ \'label.connectors_settings\' | translate }}</h2><label>{{ \'label.connectors_instance_url\' | translate }}</label> <input type="text" ng-model="item.settings.url"> <label>{{ \'label.connectors_timeout\' | translate }}</label> <input class="small" id="timeout" type="number" placeholder="10" ng-model="item.settings.timeout"> <label>{{ \'label.connectors_tls\' | translate }}</label> <input id="allow-insecure" type="checkbox" tabindex="0" ng-model="item.settings.allow_insecure_tls"> <label for="allow-insecure">{{ \'label.connectors_allow_insecure\' | translate }}</label> <label>{{ \'label.connectors_kairosdb_aggregators\' | translate }}</label> <select multiple="multiple" size="7" ng-model="item.settings.aggregators"><option>avg</option><option>count</option><option>dev</option><option>first</option><option>last</option><option>max</option><option>min</option></select></column></columns>'),$templateCache.put("templates/admin/edit-providers-rrd.html",'<h1>{{ \'label.providers_definition\' | translate }}</h1><columns><column class="main"><h2>{{ \'label.connectors_settings\' | translate }}</h2><label>{{ \'label.connectors_rrd_path\' | translate }}</label> <input type="text" ng-model="item.settings.path"> <label>{{ \'label.connectors_rrd_daemon\' | translate }}</label> <input type="text" ng-model="item.settings.daemon"> <label>{{ \'label.connectors_match_pattern\' | translate }}</label> <input type="text" ng-model="item.settings.pattern"></column></columns>'),
$templateCache.put("templates/admin/edit-providers.html",'<ng-include src="\'templates/admin/layout.html\'" ng-include-replace="true"></ng-include><article class="pane" ng-pane="" ng-show="state == stateOK"><header><h1 class="expand">{{ \'label.admin_panel\' | translate }} – {{ (id == \'add\' ? \'label.providers_new\' : \'label.providers_edit\') | translate }}</h1><ng-include src="\'templates/common/extra-menu.html\'" ng-include-replace="true"></ng-include></header><section ng-pane-step="1"><h1>{{ \'label.providers_definition\' | translate }}</h1><columns><column class="main"><h2>{{ \'label.general_info\' | translate }}</h2><label>{{ \'label.name\' | translate }} <span class="info fa fa-question-circle" title="{{ \'mesg.name_pattern\' | translate }}" title-direction="right"></span> <span class="warn" ng-show="conflict.name"><span class="fa fa-warning"></span> {{ \'mesg.name_unique\' | translate }}</span> <span class="warn" ng-show="validated && !item.name"><span class="fa fa-warning"></span> {{ \'mesg.name_invalid\' | translate }}</span></label> <input type="text" pattern="[a-zA-Z0-9](?:[a-zA-Z0-9\\-_\\.]*[a-zA-Z0-9])?" ng-class="{danger: conflict.name || validated && !item.name}" ng-model="item.name"> <label>{{ \'label.desc\' | translate }}</label> <textarea type="text" ng-model="item.description"></textarea><h2>{{ \'label.providers_params\' | translate }}</h2><label>{{ \'label.connectors_type\' | translate }}</label><ui-select class="small" theme="selectize" ng-class="{danger: validated && !item.connector}" ng-model="item.connector"><ui-select-match placeholder="{{ \'label.connectors_type_select\' | translate }}"><span ng-bind="$select.selected"></span></ui-select-match><ui-select-choices repeat="t in (connectorTypes | filter: $select.search)"><span ng-bind="t"></span></ui-select-choices></ui-select><button type="button" ng-click="switch(\'settings\')" ng-show="item.connector"><span class="fa fa-cog"></span> {{ \'label.connectors_configure\' | translate }}</button> <label>{{ \'label.refresh_interval\' | translate }}</label> <input class="small" type="number" ng-model="item.refresh_interval"> <label>{{ \'label.providers_priority\' | translate }}</label> <input class="small" type="number" ng-model="item.priority"> <label>{{ \'label.filters\' | translate }}</label> <button type="button" ng-click="switch(\'filters\')"><span class="fa fa-cog"></span> {{ \'label.filters_manage\' | translate }}</button> <span class="note">{{ \'mesg.filters_count\' | translate:{count: (item.filters.length || 0)} }}</span></column></columns></section><section ng-pane-step="settings"><ng-include src="\'templates/admin/edit-providers-\' + item.connector + \'.html\'" ng-if="item.connector"></ng-include></section><section ng-pane-step="filters"><h1>{{ \'label.providers_definition\' | translate }}</h1><div class="titlerow"><h2>{{ \'label.filters_list\' | translate }}</h2><div class="formblock"><button ng-click="addFilter()"><span class="fa fa-plus"></span> {{ \'label.filters_add\' | translate }}</button></div></div><message icon="info-circle" type="info" ng-show="!item.filters || item.filters.length === 0">{{ \'mesg.filters_empty\' | translate }}</message><table class="list" ng-show="item.filters.length > 0"><thead><tr class="listrow"><th class="listcolumn heading"></th><th class="listcolumn action heading">{{ \'label.filters_action\' | translate }}</th><th class="listcolumn target heading">{{ \'label.filters_target\' | translate }}</th><th class="listcolumn pattern heading">{{ \'label.filters_pattern\' | translate }}</th><th class="listcolumn heading"></th></tr></thead><tbody as-sortable="listSortControl" ng-model="item.filters"><tr class="listrow" as-sortable-item="" ng-repeat="f in item.filters"><td class="listcolumn handle"><span as-sortable-item-handle="" class="fa fa-ellipsis-v"></span></td><td class="listcolumn action"><ui-select theme="selectize" ng-model="f.action"><ui-select-match placeholder="{{ \'label.filters_action_select\' | translate }}"><span ng-bind="$select.selected"></span></ui-select-match><ui-select-choices repeat="a in (filterActions | filter: $select.search)"><span ng-bind="a"></span></ui-select-choices></ui-select></td><td class="listcolumn target"><ui-select theme="selectize" ng-model="f.target"><ui-select-match placeholder="{{ \'label.filters_target_select\' | translate }}"><span ng-bind="$select.selected"></span></ui-select-match><ui-select-choices repeat="t in (filterTargets | filter: $select.search)"><span ng-bind="t"></span></ui-select-choices></ui-select></td><td class="listcolumn pattern expand"><div class="row"><input type="text" ng-model="f.pattern"> <span class="fa fa-arrow-right" ng-show="f.action == \'rewrite\'"></span> <input type="text" ng-model="f.into" ng-show="f.action == \'rewrite\'"></div></td><td class="listcolumn actions"><menu><menuitem icon="times-circle" info="{{ \'label.filters_remove\' | translate }}" type="button" ng-click="remove(item.filters, f)"></menuitem></menu></td></tr></tbody></table></section><footer ng-switch="step"><div ng-switch-when="settings|filters" ng-switch-when-separator="|"><button ng-click="switch(1)">{{ \'label.ok\' | translate }}</button></div><div ng-switch-default=""><button class="extra" ng-click="reset()" ng-disabled="!modified"><span class="fa fa-undo"></span> {{ \'label.providers_reset\' | translate }}</button> <button class="danger" ng-click="cancel()" ng-show="id == \'add\' || !altMode">{{ \'label.cancel\' | translate }}</button> <button class="danger" ng-click="delete()" ng-show="id != \'add\' && altMode"><span class="fa fa-trash-o"></span> {{ \'label.providers_delete\' | translate }}</button> <button ng-click="save()">{{ \'label.providers_save\' | translate }}</button></div></footer></article><article ng-show="state == stateError"><header><h1>{{ \'label.admin_panel\' | translate }} – {{ \'label.providers_edit\' | translate }}</h1></header><section><message icon="times-circle" type="error" ng-if="!notFound">{{ \'mesg.fetch_error\' | translate }}</message><message icon="times-circle" type="error" ng-if="notFound">{{ \'mesg.items_not_found\' | translate }}</message></section><footer><button ng-click="cancel(true)"><span class="fa fa-arrow-left"></span> {{ \'label.providers_back\' | translate }}</button></footer></article>'),$templateCache.put("templates/admin/info.html",'<ng-include src="\'templates/admin/layout.html\'" ng-include-replace="true"></ng-include><article><header><h1 class="expand">{{ \'label.admin_panel\' | translate }} – {{ \'label.info\' | translate }}</h1><ng-include src="\'templates/common/extra-menu.html\'" ng-include-replace="true"></ng-include></header><section><h1>{{ \'label.build_info\' | translate }}</h1><table class="list"><tbody><tr class="listrow" ng-if="info.version"><th class="listcolumn heading">{{ \'label.version\' | translate }}</th><td class="listcolumn main expand">{{ info.version }}</td></tr><tr class="listrow" ng-if="info.build_date"><th class="listcolumn heading">{{ \'label.build_date\' | translate }}</th><td class="listcolumn main expand">{{ info.build_date }}</td></tr><tr class="listrow" ng-if="info.build_hash"><th class="listcolumn heading">{{ \'label.build_hash\' | translate }}</th><td class="listcolumn main expand">{{ info.build_hash }}</td></tr><tr class="listrow" ng-if="info.compiler"><th class="listcolumn heading">{{ \'label.compiler\' | translate }}</th><td class="listcolumn main expand">{{ info.compiler }}</td></tr><tr class="listrow"><th class="listcolumn heading">{{ \'label.drivers\' | translate }}</th><td class="listcolumn main expand pre">{{ info.drivers.join(\'\\n\') }}</td></tr><tr class="listrow"><th class="listcolumn heading">{{ \'label.connectors\' | translate }}</th><td class="listcolumn main expand pre">{{ info.connectors.join(\'\\n\') }}</td></tr><tr class="listrow"><th class="listcolumn heading">{{ \'label.website\' | translate }}</th><td class="listcolumn main expand"><a href="https://facette.io/" rel="external" target="_blank">https://facette.io/ <span class="fa fa-external-link-square"></span></a></td></tr></tbody></table></section></article>'),$templateCache.put("templates/admin/layout.html",'<notify ng-class="{full: sidebarCollapse}"></notify><aside ng-class="{collapse: sidebarCollapse, expand: !sidebarCollapse}"><header><a class="logo" href="{{ ::baseURL }}"><img src="assets/images/logo-nav-f5c7f823c6.png" alt="Facette"></a><menu><menuitem icon="bars" type="button" info="{{ \'label.toggle_sidebar\' | translate }}" info-direction="{{ sidebarCollapse ? \'bottom-right\' : \'bottom\' }}" ng-click="toggleSidebar()"></menuitem></menu></header><nav><menu><menuitem href="{{ ::baseURL }}" icon="arrow-left" label="{{ \'label.goto_home\' | translate }}" type="button"></menuitem><menuitem label="{{ \'label.library\' | translate }}" type="label"></menuitem><menuitem href="{{ ::baseURL }}admin/collections/" icon="th" label="{{ \'label.collections\' | translate }}" type="button"></menuitem><menuitem href="{{ ::baseURL }}admin/graphs/" icon="area-chart" label="{{ \'label.graphs\' | translate }}" type="button"></menuitem><menuitem href="{{ ::baseURL }}admin/sourcegroups/" icon="dot-circle-o" label="{{ \'label.sourcegroups\' | translate }}" type="button"></menuitem><menuitem href="{{ ::baseURL }}admin/metricgroups/" icon="bullseye" label="{{ \'label.metricgroups\' | translate }}" type="button"></menuitem><menuitem label="{{ \'label.catalog\' | translate }}" type="label"></menuitem><menuitem href="{{ ::baseURL }}admin/origins/" icon="circle-o" label="{{ \'label.origins\' | translate }}" type="button"></menuitem><menuitem href="{{ ::baseURL }}admin/sources/" icon="dot-circle-o" label="{{ \'label.sources\' | translate }}" type="button"></menuitem><menuitem href="{{ ::baseURL }}admin/metrics/" icon="bullseye" label="{{ \'label.metrics\' | translate }}" type="button"></menuitem><menuitem label="{{ \'label.system\' | translate }}" type="label"></menuitem><menuitem href="{{ ::baseURL }}admin/providers/" icon="plug" label="{{ \'label.providers\' | translate }}" type="button"></menuitem><menuitem href="{{ ::baseURL }}admin/info/" icon="info-circle" label="{{ \'label.info\' | translate }}" type="button"></menuitem></menu><message icon="exclamation-circle" type="warning" ng-show="readOnly">{{ \'mesg.read_only\' | translate }}</message></nav></aside>'),$templateCache.put("templates/admin/list-catalog.html",'<ng-include src="\'templates/admin/layout.html\'" ng-include-replace="true"></ng-include><article class="with-actions"><header><h1>{{ \'label.admin_panel\' | translate }} – {{ \'label.\' + section | translate }}</h1><menu class="main expand"><menuitem icon="refresh" info="{{ \'label.list_refresh\' | translate }}" type="button" ng-click="refresh()"></menuitem></menu><search name="search" placeholder="{{ \'label.\' + section + \'_search\' | translate }}" ng-model="form.search"></search><ng-include src="\'templates/common/extra-menu.html\'" ng-include-replace="true"></ng-include></header><section><h1>{{ \'label.\' + section + \'_list\' | translate }} <span class="count" ng-if="total">{{ total }}</span></h1><message icon="clock-o" type="placeholder" ng-if="state == stateLoading">{{ \'mesg.wait\' | translate }}</message><message icon="info-circle" type="info" ng-if="state == stateOK && !form.search && items.length === 0">{{ \'mesg.items_none\' | translate }}</message><message icon="info-circle" type="warning" ng-if="state == stateOK && form.search && items.length === 0">{{ \'mesg.no_search_match\' | translate }} <a href="" ng-click="reset()">{{ \'label.reset\' | translate }}</a></message><message icon="times-circle" type="error" ng-if="state == stateError">{{ \'mesg.fetch_error\' | translate }} <a href="" ng-click="refresh()">{{ \'label.retry\' | translate }}</a></message><list ng-show="state == stateOK && items.length > 0"><listrow ng-repeat="name in items"><listcolumn class="main"><div class="row"><div class="name">{{ name }}</div><div class="actions"><menu><menuitem icon="info-circle" type="button" info="<table><tr><th class=\'label\'>{{ \'label.providers\' | translate }}</th><td>{{ providersData[name].join(\', \') || (\'mesg.wait\' | translate) }}</td></tr></table>" info-direction="bottom-right" ng-mouseenter="providersData[name] || getProviders(name)"></menuitem></menu></div></div></listcolumn></listrow></list><paging page="page" page-size="limit" total="total" paging-action="refresh(page)" hide-if-empty="true" show-prev-next="true"></paging></section></article>'),$templateCache.put("templates/admin/list-library.html",'<ng-include src="\'templates/admin/layout.html\'" ng-include-replace="true"></ng-include><article class="with-actions" ng-class="{hastab: section == \'collections\' || section == \'graphs\'}"><header><h1>{{ \'label.admin_panel\' | translate }} – {{ \'label.\' + section | translate }}</h1><menu class="main expand"><menuitem icon="refresh" info="{{ \'label.list_refresh\' | translate }}" type="button" ng-click="refresh()"></menuitem><menuitem href="{{ ::baseURL }}admin/{{ section }}/add" icon="plus" info="{{ \'label.\' + section + \'_create\' | translate }}" type="button" ng-if="!readOnly && section != \'collections\' && section != \'graphs\'"></menuitem><menuitem icon="plus" type="button" ng-if="!readOnly && (section == \'collections\' || section == \'graphs\')"><menu><menuitem href="{{ ::baseURL }}admin/{{ section }}/add" label="{{ \'label.\' + section + \'_create\' | translate }}" type="button"></menuitem><menuitem href="{{ ::baseURL }}admin/{{ section }}/link" label="{{ \'label.items_create_linked\' | translate }}" type="button"></menuitem></menu></menuitem></menu><search name="search" placeholder="{{ \'label.\' + section + \'_search\' | translate }}" ng-model="form.search"></search><ng-include src="\'templates/common/extra-menu.html\'" ng-include-replace="true"></ng-include></header><tabset ng-if="section == \'collections\' || section == \'graphs\'"><tab active="!templates" label="{{ \'label.\' + section | translate }}" href="{{ ::baseURL }}admin/{{ section }}/"></tab><tab active="templates" label="{{ \'label.templates\' | translate }}" href="{{ ::baseURL }}admin/{{ section }}/?templates=1"></tab></tabset><section><h1>{{ \'label.\' + section + \'_list\' | translate }} <span class="count" ng-if="total">{{ total }}</span></h1><message icon="clock-o" type="placeholder" ng-if="state == stateLoading">{{ \'mesg.wait\' | translate }}</message><message icon="info-circle" type="info" ng-if="state == stateOK && !form.search && items.length === 0">{{ \'mesg.\' + section + \'_empty\' | translate }}</message><message icon="info-circle" type="warning" ng-if="state == stateOK && form.search && items.length === 0">{{ \'mesg.no_search_match\' | translate }} <a href="" ng-click="reset()">{{ \'label.reset\' | translate }}</a></message><message icon="times-circle" type="error" ng-if="state == stateError">{{ \'mesg.fetch_error\' | translate }} <a href="" ng-click="refresh()">{{ \'label.retry\' | translate }}</a></message><list ng-show="state == stateOK && items.length > 0"><listrow href="{{ !readOnly ? baseURL + \'admin/\' + section + \'/\' + i.id : \'\' }}" ng-repeat="i in items"><listcolumn class="main"><div class="row"><div class="name">{{ i.name }} <span class="fa fa-link" ng-if="i.link"></span></div><div class="actions"><menu><menuitem icon="info-circle" type="button" info="<table><tr><th class=\'label\'>{{ \'label.identifier\' | translate }}</th><td>{{ i.id }}</td></tr><tr ng-if=\'{{ section == \'collections\' || section == \'graphs\' }}\'><th class=\'label\'>{{ \'label.alias\' | translate }}</th><td>{{ i.alias || \'-\' }}</td></tr></table>" info-direction="bottom-right"></menuitem><menuitem icon="clone" info="{{ \'label.\' + section + \'_clone\' | translate }}" type="button" ng-click="$event.preventDefault(); clone(i)" ng-if="!readOnly"></menuitem><menuitem href="{{ ::baseURL }}browse/{{ section }}/{{ i.id }}" icon="arrow-circle-right" info="{{ \'label.\' + section + \'_goto\' | translate }}" type="button" ng-if="!templates && (section == \'collections\' || section == \'graphs\')"></menuitem></menu></div></div><div class="description" ng-class="{placeholder: !i.description}">{{ i.description || (\'mesg.no_desc\' | translate) }}</div></listcolumn><listcolumn class="date expand">{{ \'mesg.last_update\' | translate }} <span class="value">{{ i.modified | date:\'medium\' }}</span></listcolumn><listcolumn class="actions" ng-if="!readOnly"><menu><menuitem icon="times-circle" info="{{ \'label.\' + section + \'_delete\' | translate }}" type="button" ng-click="$event.preventDefault(); delete(i)"></menuitem></menu></listcolumn></listrow></list><paging page="page" page-size="limit" total="total" paging-action="refresh(page)" hide-if-empty="true" show-prev-next="true"></paging></section></article>'),$templateCache.put("templates/admin/list-providers.html",'<ng-include src="\'templates/admin/layout.html\'" ng-include-replace="true"></ng-include><article class="with-actions"><header><h1>{{ \'label.admin_panel\' | translate }} – {{ \'label.providers\' | translate }}</h1><menu class="main expand"><menuitem icon="refresh" info="{{ \'label.list_refresh\' | translate }}" type="button" ng-click="refresh()"></menuitem><menuitem href="{{ ::baseURL }}admin/providers/add" icon="plus" info="{{ \'label.providers_add\' | translate }}" type="button" ng-if="!readOnly"></menuitem></menu><search name="search" placeholder="{{ \'label.providers_search\' | translate }}" ng-model="form.search"></search><ng-include src="\'templates/common/extra-menu.html\'" ng-include-replace="true"></ng-include></header><section><h1>{{ \'label.providers_list\' | translate }} <span class="count" ng-if="total">{{ total }}</span></h1><message icon="clock-o" type="placeholder" ng-if="state == stateLoading">{{ \'mesg.wait\' | translate }}</message><message icon="info-circle" type="info" ng-if="state == stateOK && !search && items.length === 0">{{ \'mesg.items_empty\' | translate }}</message><message icon="info-circle" type="warning" ng-if="state == stateOK && search && items.length === 0">{{ \'mesg.no_search_match\' | translate }} <a href="" ng-click="reset()">{{ \'label.reset\' | translate }}</a></message><message icon="times-circle" type="error" ng-if="state == stateError">{{ \'mesg.fetch_error\' | translate }} <a href="" ng-click="refresh()">{{ \'label.retry\' | translate }}</a></message><list ng-show="state == stateOK && items.length > 0"><listrow href="{{ !readOnly ? baseURL + \'admin/providers/\' + i.id : \'\' }}" ng-class="{disabled: !i.enabled}" ng-repeat="i in items"><listcolumn class="toggle" ng-if="!readOnly"><span class="toggle fa" ng-class="{\'fa-toggle-on\': i.enabled, \'fa-toggle-off\': !i.enabled}" ng-click="$event.preventDefault(); toggle(i)"></span></listcolumn><listcolumn class="main"><div class="row"><div class="name">{{ i.name }}</div><div class="actions"><menu><menuitem icon="info-circle" type="button" info="<table><tr><th class=\'label\'>{{ \'label.identifier\' | translate }}</th><td>{{ i.id }}</td></tr></table>" info-direction="bottom-right"></menuitem><menuitem icon="clone" info="{{ \'label.providers_clone\' | translate }}" type="button" ng-click="$event.preventDefault(); clone(i)" ng-if="!readOnly"></menuitem><menuitem icon="refresh" info="{{ \'label.providers_refresh\' | translate }}" type="button" ng-click="$event.preventDefault(); refreshProvider(i)" ng-disabled="i.refreshing" ng-show="i.enabled"></menuitem></menu></div></div><div class="description" ng-class="{placeholder: !i.description}" ng-show="!i.refreshing">{{ i.description || (\'mesg.no_desc\' | translate) }}</div><div class="description" ng-show="i.refreshing"><span class="fa fa-refresh fa-spin"></span> {{ \'label.providers_refreshing\' | translate }}</div></listcolumn><listcolumn class="date expand">{{ \'mesg.last_update\' | translate }} <span class="value">{{ i.modified | date:\'medium\' }}</span></listcolumn><listcolumn class="actions" ng-if="!readOnly"><menu><menuitem icon="times-circle" info="{{ \'label.providers_delete\' | translate }}" type="button" ng-click="$event.preventDefault(); delete(i)"></menuitem></menu></listcolumn></listrow></list></section></article>'),$templateCache.put("templates/browse/graphs.html",'<ng-include src="\'templates/browse/layout.html\'" ng-include-replace="true"></ng-include><article class="with-actions"><header><h1 title="{{ title }}">{{ title }}</h1><menu class="main expand"><menuitem href="{{ ::baseURL }}admin/{{ section }}/{{ id }}" icon="pencil" info="{{ \'label.\' + section + \'_edit\' | translate }}" type="button" ng-if="!readOnly"></menuitem><menuitem icon="refresh" badge="{{ refreshInterval || \'\' }}" info="{{ \'label.\' + section + \'_refresh\' | translate }}" type="button"><menu><menuitem label="{{ \'label.\' + section + \'_refresh\' | translate }}" type="button" ng-click="refresh()"></menuitem><menuitem type="separator"></menuitem><menuitem label="{{ \'label.graphs_refresh_set_alt\' | translate }}" type="button" ng-click="setRefresh($event)"></menuitem></menu></menuitem><menuitem icon="clock-o" info="{{ \'label.range_set\' | translate }}" type="button"><menu><menuitem icon="history" label="{{ \'label.range_reset\' | translate }}" type="button" ng-click="resetRange()"></menuitem><menuitem type="separator"></menuitem><menuitem label="{{ range }}" type="button" ng-click="setRange(range)" ng-repeat="range in rangeValues"></menuitem><menuitem type="separator"></menuitem><menuitem icon="calendar" label="{{ \'label.range_custom\' | translate }}" type="button" ng-click="setRange(\'custom\')"></menuitem></menu></menuitem><menuitem icon="columns" info="{{ \'label.page_grid_set\' | translate }}" type="button"><menu><menuitem label="{{ \'label.page_grid_1\' | translate }}" ng-click="setGrid(1)" type="button"></menuitem><menuitem label="{{ \'label.page_grid_2\' | translate }}" ng-click="setGrid(2)" type="button"></menuitem><menuitem label="{{ \'label.page_grid_3\' | translate }}" ng-click="setGrid(3)" type="button"></menuitem></menu></menuitem></menu><menu><menuitem icon="toggle-off" label="{{ \'label.graphs_show_legends\' | translate }}" type="button" ng-click="toggleLegends(true)" ng-show="!showLegends"></menuitem><menuitem icon="toggle-on" label="{{ \'label.graphs_show_legends\' | translate }}" type="button" ng-click="toggleLegends(false)" ng-show="showLegends"></menuitem></menu><search name="filter" icon="filter" placeholder="{{ \'label.graphs_filter\' | translate }}" ng-model="form.filter" ng-if="section == \'collections\'"></search><ng-include src="\'templates/common/extra-menu.html\'" ng-include-replace="true"></ng-include></header><section><message icon="info-circle" type="info" ng-if="state == stateOK && graphs.length === 0">{{ \'mesg.graphs_empty\' | translate }}</message><message icon="info-circle" type="warning" ng-show="state == stateOK && graphs.length > 0 && noMatch">{{ \'mesg.no_search_match\' | translate }} <a href="" ng-click="resetFilter()">{{ \'label.reset\' | translate }}</a></message><message icon="times-circle" type="error" ng-show="state == stateError">{{ \'mesg.fetch_error\' | translate }}</message><div class="grid grid{{ gridSize }}"><div class="grid-item" ng-repeat="g in graphs" ng-if="graphs.length > 0"><a id="graph{{ g.index }}"></a><graph index="{{ g.index }}" graph-id="{{ g.id }}" options="g.options" attributes="g.attributes" controls="true" ng-show="!g.hidden"></graph></div></div></section></article>'),$templateCache.put("templates/browse/layout.html",'<notify ng-class="{full: sidebarCollapse}"></notify><aside ng-class="{collapse: sidebarCollapse, expand: !sidebarCollapse}"><header><a class="logo" href="{{ ::baseURL }}"><img src="assets/images/logo-nav-f5c7f823c6.png" alt="Facette"></a><menu><menuitem icon="bars" type="button" info="{{ \'label.toggle_sidebar\' | translate }}" info-direction="{{ sidebarCollapse ? \'bottom-right\' : \'bottom\' }}" ng-click="toggleSidebar()"></menuitem></menu></header><nav><menu><menuitem label="{{ \'label.browse\' | translate }}" type="label"></menuitem><menuitem href="{{ ::baseURL }}browse/collections/{{ parentID }}" icon="arrow-left" label="{{ \'label.goto_parent\' | translate }}" type="button" ng-show="parentID" ng-if="section"></menuitem><menuitem href="{{ ::baseURL }}browse/" icon="arrow-left" label="{{ \'label.goto_home\' | translate }}" type="button" ng-show="!parentID" ng-if="section"></menuitem><menuitem ng-if="collections && collections.length > 0 || !collectionsLoaded"><div class="placeholder" ng-if="!collectionsLoaded">{{ \'mesg.wait\' | translate }}</div><div class="placeholder" ng-if="collectionsLoaded && collections.length === 0 && graphs.length === 0"><span class="fa fa-info-circle"></span> {{ \'mesg.collections_empty\' | translate }}</div><div ui-tree="" ng-show="collectionsLoaded"><ul id="collections-tree" class="tree" ui-tree-nodes="" ng-model="collections"><li class="treeitem" ui-tree-node="" ng-repeat="c in collections" ng-include="\'templates/treeitem.html\'"></li></ul></div></menuitem><menuitem href="{{ ::baseURL }}browse/{{ section }}/{{ alias || id }}#graph{{ g.index }}" label="{{ g.title }}" type="button" ng-mouseenter="handleGraphFocus($event, g.index)" ng-mouseleave="handleGraphFocus($event, g.index)" ng-repeat="g in graphs" ng-show="!g.hidden"></menuitem><menuitem icon="info-circle" label="{{ \'mesg.collections_empty\' | translate }}" ng-if="!graphs && (!collections || collections.length === 0)" type="placeholder"></menuitem></menu></nav></aside>'),$templateCache.put("templates/browse/search.html",'<ng-include src="\'templates/browse/layout.html\'" ng-include-replace="true"></ng-include><article><header><h1 class="expand">{{ \'label.search\' | translate }}</h1><ng-include src="\'templates/common/extra-menu.html\'" ng-include-replace="true"></ng-include></header><section><div class="logo"><img src="assets/images/logo-main-e327a302b8.png" alt="logo" height="80"></div><div class="search"><autocomplete id="search" delay="250" source="searchHandler" on-select="searchSelect"></autocomplete><button><span class="fa fa-search"></span></button></div></section></article>'),$templateCache.put("templates/common/dialog.html",'<form><div class="formblock" ng-if="data.type == \'confirm\'">{{ data.message | translate:data.args }}</div><div class="formblock" ng-if="data.type == \'prompt\'"><label>{{ data.message | translate:data.args }} <span class="note" ng-if="data.note">{{ data.note | translate }}</span></label> <input type="{{ data.inputType || \'text\' }}" ng-model="data.value"></div><div class="formblock actions"><button class="cancel" type="button" ng-class="{danger: !data.danger}" ng-click="closeThisDialog()">{{ (data.labels.cancel || \'label.cancel\') | translate }}</button> <button class="validate" type="submit" ng-class="{danger: data.danger}" ng-click="closeThisDialog(data)">{{ (data.labels.validate || \'label.validate\') | translate }}</button></div></form>'),$templateCache.put("templates/common/extra-menu.html",'<menu class="extra"><menuitem class="left" icon="ellipsis-v" type="button"><menu class="icons"><menuitem href="{{ ::baseURL }}admin/" icon="cog" label="{{ \'label.admin_panel\' | translate }}" type="button" ng-if="!inAdmin"></menuitem><menuitem href="{{ ::baseURL }}" icon="sign-out" label="{{ \'label.admin_panel_exit\' | translate }}" type="button" ng-if="inAdmin"></menuitem><menuitem type="separator"></menuitem><menuitem icon="language" label="{{ \'label.language\' | translate }}" type="button"><menu><menuitem label="{{ label }}" type="button" ng-click="changeLocale(code)" ng-repeat="(code, label) in locales"></menuitem></menu></menuitem><menuitem label="{{ \'label.reset_local_prefs\' | translate }}" ng-click="resetLocalPrefs()" type="button"></menuitem></menu></menuitem></menu>'),$templateCache.put("templates/common/timerange.html",'<form class="ngdialog-event" ng-click="hideDatetime($event)"><tabset><tab active="!data.absolute" label="{{ \'label.graphs_time_relative\' | translate }}" ng-click="switchAbsolute(data, false)"></tab><tab active="data.absolute" label="{{ \'label.graphs_time_absolute\' | translate }}" ng-click="switchAbsolute(data, true)"></tab></tabset><div class="formblock" ng-show="!data.absolute"><label>{{ \'label.graphs_time_reference\' | translate }}</label><div class="datetimepicker-holder"><input type="text" placeholder="default: now" date-time-input="YYYY-MM-DD HH:mm:ss" ng-click="toggleDatetime(\'time\', true)" ng-model="data.time"><datetimepicker on-set-time="toggleDatetime(\'time\', false)" ng-model="data.time" ng-show="datetime.time"></datetimepicker></div><label>{{ \'label.range\' | translate }}</label> <input type="text" ng-model="data.range"></div><div class="formblock" ng-show="data.absolute"><label>{{ \'label.graphs_time_start\' | translate }}</label><div class="datetimepicker-holder"><input type="text" date-time-input="YYYY-MM-DD HH:mm:ss" ng-click="toggleDatetime(\'start\', true)" ng-model="data.start"><datetimepicker on-set-time="toggleDatetime(\'start\', false)" ng-model="data.start" ng-show="datetime.start"></datetimepicker></div><label>{{ \'label.graphs_time_end\' | translate }}</label><div class="datetimepicker-holder"><input type="text" date-time-input="YYYY-MM-DD HH:mm:ss" ng-click="toggleDatetime(\'end\', true)" ng-model="data.end"><datetimepicker on-set-time="toggleDatetime(\'end\', false)" ng-model="data.end" ng-show="datetime.end"></datetimepicker></div></div><div class="formblock actions"><button class="cancel danger" type="button" ng-click="closeThisDialog()">{{ \'label.cancel\' | translate }}</button> <button class="validate" type="submit" ng-click="closeThisDialog(data)">{{ \'label.range_set\' | translate }}</button></div></form>'),$templateCache.put("templates/show/collections.html",'<graph index="0" graph-id="{{ graph.id }}" options="graph.options" attributes="graph.attributes" controls="true" frame="true" ng-if="graph"></graph>'),$templateCache.put("templates/show/graphs.html",'<graph index="0" graph-id="{{ graph.id }}" options="graph.options" controls="true" frame="true" ng-if="graph"></graph>')}])}();