# This file was automatically generated by bifcl from /usr/obj/ports/bro-2.6.1/bro-2.6.1/src/file_analysis/analyzer/x509/functions.bif (plugin mode).

export {


## Parses a certificate into an X509::Certificate structure.
##
## cert: The X509 certificate opaque handle.
##
## Returns: A X509::Certificate structure.
##
## .. bro:see:: x509_certificate x509_extension x509_ext_basic_constraints
##              x509_ext_subject_alternative_name x509_verify
##              x509_get_certificate_string
global x509_parse: function(cert: opaque of x509 ): X509::Certificate ;


## Returns the string form of a certificate.
##
## cert: The X509 certificate opaque handle.
##
## pem: A boolean that specifies if the certificate is returned
##      in pem-form (true), or as the raw ASN1 encoded binary
##      (false).
##
## Returns: X509 certificate as a string.
##
## .. bro:see:: x509_certificate x509_extension x509_ext_basic_constraints
##              x509_ext_subject_alternative_name x509_parse x509_verify
global x509_get_certificate_string: function(cert: opaque of x509 , pem: bool &default=F): string ;


## Verifies an OCSP reply.
##
## certs: Specifies the certificate chain to use. Server certificate first.
##
## ocsp_reply: the ocsp reply to validate.
##
## root_certs: A list of root certificates to validate the certificate chain.
##
## verify_time: Time for the validity check of the certificates.
##
## Returns: A record of type X509::Result containing the result code of the
##          verify operation.
##
## .. bro:see:: x509_certificate x509_extension x509_ext_basic_constraints
##              x509_ext_subject_alternative_name x509_parse
##              x509_get_certificate_string x509_verify
global x509_ocsp_verify: function(certs: x509_opaque_vector , ocsp_reply: string , root_certs: table_string_of_string , verify_time: time &default=network_time()): X509::Result ;


## Verifies a certificate.
##
## certs: Specifies a certificate chain that is being used to validate
##        the given certificate against the root store given in *root_certs*.
##        The host certificate has to be at index 0.
##
## root_certs: A list of root certificates to validate the certificate chain.
##
## verify_time: Time for the validity check of the certificates.
##
## Returns: A record of type X509::Result containing the result code of the
##          verify operation. In case of success also returns the full
##          certificate chain.
##
## .. bro:see:: x509_certificate x509_extension x509_ext_basic_constraints
##              x509_ext_subject_alternative_name x509_parse
##              x509_get_certificate_string x509_ocsp_verify sct_verify
global x509_verify: function(certs: x509_opaque_vector , root_certs: table_string_of_string , verify_time: time &default=network_time()): X509::Result ;


## Verifies a Signed Certificate Timestamp as used for Certificate Transparency.
## See RFC6962 for more details.
##
## cert: Certificate against which the SCT should be validated.
##
## logid: Log id of the SCT.
##
## log_key: Public key of the Log that issued the SCT proof.
##
## timestamp: Timestamp at which the proof was generated.
##
## hash_algorithm: Hash algorithm that was used for the SCT proof.
##
## issuer_key_hash: The SHA-256 hash of the certificate issuer's public key.
##                  This only has to be provided if the SCT was encountered in an X.509
##                  certificate extension; in that case, it is necessary for validation.
##
## Returns: T if the validation could be performed succesfully, F otherwhise.
##
## .. bro:see:: ssl_extension_signed_certificate_timestamp
##              x509_ocsp_ext_signed_certificate_timestamp
##              x509_verify
global sct_verify: function(cert: opaque of x509 , logid: string , log_key: string , signature: string , timestamp: count , hash_algorithm: count , issuer_key_hash: string &default=""): bool ;





## Get the hash of the subject's distinguished name.
##
## cert: The X509 certificate opaque handle.
##
## hash_alg: the hash algorithm to use, according to the IANA mapping at
##           https://www.iana.org/assignments/tls-parameters/tls-parameters.xhtml#tls-parameters-18
##
## Returns: The hash as a string.
##
## .. bro:see:: x509_issuer_name_hash x509_spki_hash
##              x509_verify sct_verify
global x509_subject_name_hash: function(cert: opaque of x509 , hash_alg: count ): string ;


## Get the hash of the issuer's distinguished name.
##
## cert: The X509 certificate opaque handle.
##
## hash_alg: the hash algorithm to use, according to the IANA mapping at
##           https://www.iana.org/assignments/tls-parameters/tls-parameters.xhtml#tls-parameters-18
##
## Returns: The hash as a string.
##
## .. bro:see:: x509_subject_name_hash x509_spki_hash
##              x509_verify sct_verify
global x509_issuer_name_hash: function(cert: opaque of x509 , hash_alg: count ): string ;


## Get the hash of the Subject Public Key Information of the certificate.
##
## cert: The X509 certificate opaque handle.
##
## hash_alg: the hash algorithm to use, according to the IANA mapping at
##           https://www.iana.org/assignments/tls-parameters/tls-parameters.xhtml#tls-parameters-18
##
## Returns: The hash as a string.
##
## .. bro:see:: x509_subject_name_hash x509_issuer_name_hash
##              x509_verify sct_verify
global x509_spki_hash: function(cert: opaque of x509 , hash_alg: count ): string ;

} # end of export section
module GLOBAL;
