# A plugin that creates an On Screen Display popup on song change.
import gtk
import gobject
import sys
import pango
from gnomeosd import gosd

__name = 'Gnome-OSD'
__version = '0.01'
__author = "Natan 'whatah' Zohar"
__class = 'Gosd'
__blurb = 'Pops up a little osd thing in the top right corner on song change'

def show_then_hide(window, interval):
    window.move(gtk.gdk.screen_width() - window.width - 10, 10)
    window.show()
    gobject.timeout_add(interval, window.destroy)

class Gosd:

    # called when we load the plugin. we get passed the mainWindow, plugin menu
    # item as well as a connection to mpd.
    def _init(self, data, get):
        self.xml, self.pluginMenu, self.pympd, self.base_dir, self.parser = data
        self.mainWindow = self.xml.get_widget("mainWindow")
        self.data = data
        self.fontdesc = pango.FontDescription("sans 24")
        self.first_loaded = True


    def _conf(self, hasConf=False):
        return False

    # update plugin, data is of type mpdclient.Status
    def _spin(self, data, songChanged=False):
        if songChanged or self.first_loaded:
            song = self.pympd.getCurrentSong()
            win = gosd.osd("%s - %s" % (song.artist, song.title), 'red', 'lightblue', self.fontdesc)
            show_then_hide(win, 2000)
            if self.first_loaded:
                self.first_loaded = False
        
            
    # called on plugin unloaded
    def _unload(self):
        return

