/*
 * Decompiled with CFR 0.152.
 */
package net.n3.nanoxml;

import java.io.IOException;
import java.io.Reader;
import java.util.Stack;
import net.n3.nanoxml.IXMLBuilder;
import net.n3.nanoxml.IXMLElement;
import net.n3.nanoxml.XMLElement;
import net.n3.nanoxml.XMLParseException;

public class StdXMLBuilder
implements IXMLBuilder {
    private Stack stack = null;
    private IXMLElement root = null;
    private IXMLElement prototype;

    public StdXMLBuilder() {
        this(new XMLElement());
    }

    public StdXMLBuilder(IXMLElement iXMLElement) {
        this.prototype = iXMLElement;
    }

    protected void finalize() throws Throwable {
        this.prototype = null;
        this.root = null;
        this.stack.clear();
        this.stack = null;
        super.finalize();
    }

    @Override
    public void startBuilding(String string, int n) {
        this.stack = new Stack();
        this.root = null;
    }

    @Override
    public void newProcessingInstruction(String string, Reader reader) {
    }

    @Override
    public void startElement(String string, String string2, String string3, String string4, int n) {
        String string5 = string;
        if (string2 != null) {
            string5 = string2 + ':' + string;
        }
        IXMLElement iXMLElement = this.prototype.createElement(string5, string3, string4, n);
        if (this.stack.empty()) {
            this.root = iXMLElement;
        } else {
            IXMLElement iXMLElement2 = (IXMLElement)this.stack.peek();
            iXMLElement2.addChild(iXMLElement);
        }
        this.stack.push(iXMLElement);
    }

    @Override
    public void elementAttributesProcessed(String string, String string2, String string3) {
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        IXMLElement iXMLElement;
        IXMLElement iXMLElement2 = (IXMLElement)this.stack.pop();
        if (iXMLElement2.getChildrenCount() == 1 && (iXMLElement = iXMLElement2.getChildAtIndex(0)).getName() == null) {
            iXMLElement2.setContent(iXMLElement.getContent());
            iXMLElement2.removeChildAtIndex(0);
        }
    }

    @Override
    public void addAttribute(String string, String string2, String string3, String string4, String string5) throws Exception {
        IXMLElement iXMLElement;
        String string6 = string;
        if (string2 != null) {
            string6 = string2 + ':' + string;
        }
        if ((iXMLElement = (IXMLElement)this.stack.peek()).hasAttribute(string6)) {
            throw new XMLParseException(iXMLElement.getSystemID(), iXMLElement.getLineNr(), "Duplicate attribute: " + string);
        }
        if (string2 != null) {
            iXMLElement.setAttribute(string6, string3, string4);
        } else {
            iXMLElement.setAttribute(string6, string4);
        }
    }

    @Override
    public void addPCData(Reader reader, String string, int n) {
        int n2 = 2048;
        int n3 = 0;
        StringBuffer stringBuffer = new StringBuffer(n2);
        char[] cArray = new char[n2];
        while (true) {
            int n4;
            if (n3 >= n2) {
                stringBuffer.ensureCapacity(n2 *= 2);
            }
            try {
                n4 = reader.read(cArray);
            }
            catch (IOException iOException) {
                break;
            }
            if (n4 < 0) break;
            stringBuffer.append(cArray, 0, n4);
            n3 += n4;
        }
        IXMLElement iXMLElement = this.prototype.createElement(null, string, n);
        iXMLElement.setContent(stringBuffer.toString());
        if (!this.stack.empty()) {
            IXMLElement iXMLElement2 = (IXMLElement)this.stack.peek();
            iXMLElement2.addChild(iXMLElement);
        }
    }

    @Override
    public Object getResult() {
        return this.root;
    }
}

