/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.css.StyleManager;
import com.sun.javafx.css.StyleableProperty;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.control.Labeled;

public class Cell<T>
extends Labeled {
    private ObjectProperty<T> item = new SimpleObjectProperty(this, "item");
    private ReadOnlyBooleanWrapper empty = new ReadOnlyBooleanWrapper(true){

        @Override
        protected void invalidated() {
            Cell.this.impl_pseudoClassStateChanged(Cell.PSEUDO_CLASS_EMPTY);
            Cell.this.impl_pseudoClassStateChanged(Cell.PSEUDO_CLASS_FILLED);
        }

        @Override
        public Object getBean() {
            return Cell.this;
        }

        @Override
        public String getName() {
            return Cell.PSEUDO_CLASS_EMPTY;
        }
    };
    private ReadOnlyBooleanWrapper selected = new ReadOnlyBooleanWrapper(){

        @Override
        protected void invalidated() {
            Cell.this.impl_pseudoClassStateChanged(Cell.PSEUDO_CLASS_SELECTED);
        }

        @Override
        public Object getBean() {
            return Cell.this;
        }

        @Override
        public String getName() {
            return Cell.PSEUDO_CLASS_SELECTED;
        }
    };
    private ReadOnlyBooleanWrapper editing;
    private BooleanProperty editable;
    private static final String DEFAULT_STYLE_CLASS = "cell";
    private static final String PSEUDO_CLASS_SELECTED = "selected";
    private static final String PSEUDO_CLASS_FOCUSED = "focused";
    private static final String PSEUDO_CLASS_EMPTY = "empty";
    private static final String PSEUDO_CLASS_FILLED = "filled";
    private static final long SELECTED_PSEUDOCLASS_STATE = StyleManager.getInstance().getPseudoclassMask("selected");
    private static final long EMPTY_PSEUDOCLASS_STATE = StyleManager.getInstance().getPseudoclassMask("empty");
    private static final long FILLED_PSEUDOCLASS_STATE = StyleManager.getInstance().getPseudoclassMask("filled");

    public Cell() {
        this.setText(null);
        StyleableProperty styleableProperty = StyleableProperty.getStyleableProperty(this.focusTraversableProperty());
        styleableProperty.set(this, Boolean.FALSE);
        this.getStyleClass().addAll((String[])new String[]{DEFAULT_STYLE_CLASS});
        super.focusedProperty().addListener(new InvalidationListener(){

            @Override
            public void invalidated(Observable observable) {
                Cell.this.impl_pseudoClassStateChanged(Cell.PSEUDO_CLASS_FOCUSED);
                if (!Cell.this.isFocused() && Cell.this.isEditing()) {
                    Cell.this.cancelEdit();
                }
            }
        });
    }

    public final ObjectProperty<T> itemProperty() {
        return this.item;
    }

    public final void setItem(T t) {
        this.itemProperty().set(t);
    }

    public final T getItem() {
        return this.itemProperty().get();
    }

    public final ReadOnlyBooleanProperty emptyProperty() {
        return this.empty.getReadOnlyProperty();
    }

    private void setEmpty(boolean bl) {
        this.empty.set(bl);
    }

    public final boolean isEmpty() {
        return this.emptyProperty().get();
    }

    public final ReadOnlyBooleanProperty selectedProperty() {
        return this.selected.getReadOnlyProperty();
    }

    void setSelected(boolean bl) {
        this.selected.set(bl);
    }

    public final boolean isSelected() {
        return this.selectedProperty().get();
    }

    private void setEditing(boolean bl) {
        this.editingPropertyImpl().set(bl);
    }

    public final boolean isEditing() {
        return this.editing == null ? false : this.editing.get();
    }

    public final ReadOnlyBooleanProperty editingProperty() {
        return this.editingPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyBooleanWrapper editingPropertyImpl() {
        if (this.editing == null) {
            this.editing = new ReadOnlyBooleanWrapper(this, "editing");
        }
        return this.editing;
    }

    public final void setEditable(boolean bl) {
        this.editableProperty().set(bl);
    }

    public final boolean isEditable() {
        return this.editable == null ? true : this.editable.get();
    }

    public final BooleanProperty editableProperty() {
        if (this.editable == null) {
            this.editable = new SimpleBooleanProperty(this, "editable", true);
        }
        return this.editable;
    }

    public void startEdit() {
        if (this.isEditable() && !this.isEditing() && !this.isEmpty()) {
            this.setEditing(true);
        }
    }

    public void cancelEdit() {
        if (this.isEditing()) {
            this.setEditing(false);
        }
    }

    public void commitEdit(T t) {
        if (this.isEditing()) {
            this.setEditing(false);
        }
    }

    protected void updateItem(T t, boolean bl) {
        if (this.isEditing()) {
            this.cancelEdit();
        }
        this.setItem(t);
        this.setEmpty(bl);
        if (bl && this.isSelected()) {
            this.updateSelected(false);
        }
    }

    public void updateSelected(boolean bl) {
        if (bl && this.isEmpty()) {
            return;
        }
        this.setSelected(bl);
    }

    @Override
    @Deprecated
    public long impl_getPseudoClassState() {
        long l = super.impl_getPseudoClassState();
        if (this.isSelected()) {
            l |= SELECTED_PSEUDOCLASS_STATE;
        }
        return l |= this.isEmpty() ? EMPTY_PSEUDOCLASS_STATE : FILLED_PSEUDOCLASS_STATE;
    }

    @Override
    @Deprecated
    protected Boolean impl_cssGetFocusTraversableInitialValue() {
        return Boolean.FALSE;
    }
}

