/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.uitoolkit.impl.fx.ui;

import com.sun.javafx.css.StyleManager;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ToolBar;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import javafx.stage.Modality;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;

class FXDialog
extends Stage {
    private BorderPane root;
    private RootPane decoratedRoot;
    private ToolBar toolBar;
    private HBox windowBtns;
    private Button minButton;
    private Button maxButton;
    private Rectangle resizeCorner;
    private double mouseDragOffsetX = 0.0;
    private double mouseDragOffsetY = 0.0;
    protected Label titleLabel;
    private static final int HEADER_HEIGHT = 28;

    FXDialog(String title) {
        this(title, null, false);
    }

    FXDialog(String title, Window owner, boolean modal) {
        this(title, owner, modal, StageStyle.TRANSPARENT);
    }

    FXDialog(String title, Window owner, boolean modal, StageStyle stageStyle) {
        super(stageStyle);
        this.setTitle(title);
        if (owner != null) {
            this.initOwner(owner);
        }
        if (modal) {
            this.initModality(Modality.WINDOW_MODAL);
        }
        this.resizableProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable valueModel) {
                FXDialog.this.resizeCorner.setVisible(FXDialog.this.isResizable());
                FXDialog.this.maxButton.setVisible(FXDialog.this.isResizable());
            }
        });
        this.root = new BorderPane();
        if (stageStyle == StageStyle.DECORATED) {
            Scene scene = new Scene(this.root);
            scene.getStylesheets().addAll((String[])new String[]{FXDialog.class.getResource("deploydialogs.css").toExternalForm()});
            this.setScene(scene);
            return;
        }
        this.decoratedRoot = new RootPane(){

            protected void layoutChildren() {
                super.layoutChildren();
                if (FXDialog.this.resizeCorner != null) {
                    FXDialog.this.resizeCorner.relocate(this.getWidth() - 20.0, this.getHeight() - 20.0);
                }
            }
        };
        this.decoratedRoot.getChildren().add(this.root);
        Scene scene = new Scene(this.decoratedRoot);
        String css = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                URL u = FXDialog.class.getResource("deploydialogs.css");
                return u.toExternalForm();
            }
        });
        scene.getStylesheets().addAll((String[])new String[]{css});
        scene.setFill(Color.TRANSPARENT);
        this.setScene(scene);
        this.decoratedRoot.getStyleClass().add("decorated-root");
        this.focusedProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable valueModel) {
                FXDialog.this.decoratedRoot.pseudoClassStateChanged("active");
            }
        });
        this.toolBar = new ToolBar();
        this.toolBar.setId("window-header");
        this.toolBar.setPrefHeight(28.0);
        this.toolBar.setMinHeight(28.0);
        this.toolBar.setMaxHeight(28.0);
        this.addDragHandlers(this.toolBar);
        this.titleLabel = new Label();
        this.titleLabel.setId("window-title");
        this.titleLabel.setText(this.getTitle());
        this.titleProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable valueModel) {
                FXDialog.this.titleLabel.setText(FXDialog.this.getTitle());
            }
        });
        Region spacer = new Region();
        HBox.setHgrow(spacer, Priority.ALWAYS);
        WindowButton closeButton = new WindowButton("close");
        closeButton.setOnAction(new EventHandler(){

            public void handle(Event event) {
                FXDialog.this.hide();
            }
        });
        this.minButton = new WindowButton("minimize");
        this.minButton.setOnAction(new EventHandler(){

            public void handle(Event event) {
                FXDialog.this.setIconified(!FXDialog.this.isIconified());
            }
        });
        this.maxButton = new WindowButton("maximize");
        this.maxButton.setOnAction(new EventHandler(){
            private double restoreX;
            private double restoreY;
            private double restoreW;
            private double restoreH;

            public void handle(Event event) {
                Screen screen = Screen.getPrimary();
                double minX = screen.getVisualBounds().getMinX();
                double minY = screen.getVisualBounds().getMinY();
                double maxW = screen.getVisualBounds().getWidth();
                double maxH = screen.getVisualBounds().getHeight();
                if (this.restoreW == 0.0 || FXDialog.this.getX() != minX || FXDialog.this.getY() != minY || FXDialog.this.getWidth() != maxW || FXDialog.this.getHeight() != maxH) {
                    this.restoreX = FXDialog.this.getX();
                    this.restoreY = FXDialog.this.getY();
                    this.restoreW = FXDialog.this.getWidth();
                    this.restoreH = FXDialog.this.getHeight();
                    FXDialog.this.setX(minX);
                    FXDialog.this.setY(minY);
                    FXDialog.this.setWidth(maxW);
                    FXDialog.this.setHeight(maxH);
                } else {
                    FXDialog.this.setX(this.restoreX);
                    FXDialog.this.setY(this.restoreY);
                    FXDialog.this.setWidth(this.restoreW);
                    FXDialog.this.setHeight(this.restoreH);
                }
            }
        });
        this.windowBtns = new HBox(3.0);
        this.windowBtns.getChildren().addAll((Node[])new Node[]{this.minButton, this.maxButton, closeButton});
        this.toolBar.getItems().addAll((Node[])new Node[]{this.titleLabel, spacer, this.windowBtns});
        this.root.setTop(this.toolBar);
        this.resizeCorner = new Rectangle(10.0, 10.0);
        this.resizeCorner.setId("window-resize-corner");
        EventHandler<MouseEvent> resizeHandler = new EventHandler<MouseEvent>(){
            private double width;
            private double height;
            private Point2D dragAnchor;

            @Override
            public void handle(MouseEvent event) {
                EventType<? extends Event> type = event.getEventType();
                if (type == MouseEvent.MOUSE_PRESSED) {
                    this.width = FXDialog.this.getWidth();
                    this.height = FXDialog.this.getHeight();
                    this.dragAnchor = new Point2D(event.getSceneX(), event.getSceneY());
                } else if (type == MouseEvent.MOUSE_DRAGGED) {
                    FXDialog.this.setWidth(Math.max(FXDialog.this.decoratedRoot.minWidth(-1.0), this.width + (event.getSceneX() - this.dragAnchor.getX())));
                    FXDialog.this.setHeight(Math.max(FXDialog.this.decoratedRoot.minHeight(-1.0), this.height + (event.getSceneY() - this.dragAnchor.getY())));
                }
            }
        };
        this.resizeCorner.setOnMousePressed((EventHandler<? super MouseEvent>)resizeHandler);
        this.resizeCorner.setOnMouseDragged((EventHandler<? super MouseEvent>)resizeHandler);
        this.resizeCorner.setManaged(false);
        this.decoratedRoot.getChildren().add(this.resizeCorner);
    }

    void setContentPane(Pane pane) {
        if (pane.getId() == null) {
            pane.setId("content-pane");
        }
        this.root.setCenter(pane);
    }

    public void setIconifiable(boolean iconifiable) {
        this.minButton.setVisible(iconifiable);
    }

    public void hideWindowTitle() {
        if (this.toolBar != null) {
            this.root.setTop(null);
            this.sizeToScene();
            this.addDragHandlers(this.root);
        }
    }

    private void addDragHandlers(Node node) {
        node.setOnMousePressed((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent event) {
                FXDialog.this.mouseDragOffsetX = event.getSceneX();
                FXDialog.this.mouseDragOffsetY = event.getSceneY();
            }
        });
        node.setOnMouseDragged((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent event) {
                FXDialog.this.setX(event.getScreenX() - FXDialog.this.mouseDragOffsetX);
                FXDialog.this.setY(event.getScreenY() - FXDialog.this.mouseDragOffsetY);
            }
        });
    }

    public static Button createCloseButton() {
        return new WindowButton("black-close");
    }

    private static class RootPane
    extends StackPane {
        private static final String PSEUDO_CLASS_ACTIVE = "active";
        private static final long PSEUDO_CLASS_ACTIVE_MASK = StyleManager.getInstance().getPseudoclassMask("active");

        private RootPane() {
        }

        public long impl_getPseudoClassState() {
            long mask = super.impl_getPseudoClassState();
            if (this.getScene().getWindow().isFocused()) {
                mask |= PSEUDO_CLASS_ACTIVE_MASK;
            }
            return mask;
        }

        private void pseudoClassStateChanged(String pseudoClass) {
            this.impl_pseudoClassStateChanged(pseudoClass);
        }
    }

    private static class WindowButton
    extends Button {
        WindowButton(String name) {
            this.getStyleClass().setAll((String[])new String[]{"window-button"});
            this.setId("window-" + name + "-button");
            StackPane graphic = new StackPane();
            graphic.getStyleClass().setAll((String[])new String[]{"graphic"});
            this.setGraphic(graphic);
            this.setMinSize(17.0, 17.0);
            this.setPrefSize(17.0, 17.0);
        }
    }
}

