/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.ascan;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.httpclient.HttpException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.core.scanner.AbstractAppParamPlugin;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.ascan.ActiveScript;
import org.zaproxy.zap.extension.ascan.ActiveScript2;
import org.zaproxy.zap.extension.script.ExtensionScript;
import org.zaproxy.zap.extension.script.ScriptWrapper;

public class ScriptsActiveScanner
extends AbstractAppParamPlugin {
    private ExtensionScript extension = null;
    private static Logger logger = Logger.getLogger(ScriptsActiveScanner.class);
    private Set<ScriptWrapper> scriptsNoInterface = new HashSet<ScriptWrapper>();

    @Override
    public int getId() {
        return 50000;
    }

    @Override
    public String getName() {
        return Constant.messages.getString("ascan.scripts.activescanner.title");
    }

    @Override
    public String[] getDependency() {
        return null;
    }

    @Override
    public String getDescription() {
        return "N/A";
    }

    @Override
    public int getCategory() {
        return 3;
    }

    @Override
    public String getSolution() {
        return "N/A";
    }

    @Override
    public String getReference() {
        return "N/A";
    }

    @Override
    public void init() {
        if (this.shouldSkipScan()) {
            this.getParent().pluginSkipped(this, Constant.messages.getString("ascan.scripts.skip.reason"));
        }
    }

    private boolean shouldSkipScan() {
        if (this.getExtension() == null) {
            return true;
        }
        List<ScriptWrapper> scripts = this.getActiveScripts();
        if (scripts.isEmpty()) {
            return true;
        }
        for (ScriptWrapper script : scripts) {
            if (!script.isEnabled()) continue;
            return false;
        }
        return true;
    }

    private List<ScriptWrapper> getActiveScripts() {
        return this.getExtension().getScripts("active");
    }

    private ExtensionScript getExtension() {
        if (this.extension == null) {
            this.extension = Control.getSingleton().getExtensionLoader().getExtension(ExtensionScript.class);
        }
        return this.extension;
    }

    @Override
    public void scan() {
        List<ScriptWrapper> scripts = this.getActiveScripts();
        Iterator<ScriptWrapper> it = scripts.iterator();
        while (it.hasNext() && !this.isStop()) {
            ScriptWrapper script = it.next();
            try {
                if (!script.isEnabled()) continue;
                ActiveScript2 s = this.extension.getInterface(script, ActiveScript2.class);
                if (s != null) {
                    HttpMessage msg = this.getNewMsg();
                    logger.debug((Object)("Calling script " + script.getName() + " scanNode for " + msg.getRequestHeader().getURI()));
                    s.scanNode(this, msg);
                    continue;
                }
                this.scriptsNoInterface.add(script);
            }
            catch (Exception e) {
                this.extension.handleScriptException(script, e);
            }
        }
        if (!this.isStop()) {
            super.scan();
        }
        this.scriptsNoInterface.clear();
    }

    @Override
    public void scan(HttpMessage msg, String param, String value) {
        List<ScriptWrapper> scripts = this.getActiveScripts();
        Iterator<ScriptWrapper> it = scripts.iterator();
        while (it.hasNext() && !this.isStop()) {
            ScriptWrapper script = it.next();
            try {
                if (!script.isEnabled()) continue;
                ActiveScript s = this.extension.getInterface(script, ActiveScript.class);
                if (s != null) {
                    logger.debug((Object)("Calling script " + script.getName() + " scan for " + msg.getRequestHeader().getURI() + "param=" + param + " value=" + value));
                    s.scan(this, msg, param, value);
                    continue;
                }
                if (!this.scriptsNoInterface.contains(script)) continue;
                this.extension.handleFailedScriptInterface(script, Constant.messages.getString("ascan.scripts.interface.active.error", script.getName()));
            }
            catch (Exception e) {
                this.extension.handleScriptException(script, e);
            }
        }
    }

    @Override
    public boolean isStop() {
        return super.isStop();
    }

    public String setParam(HttpMessage msg, String param, String value) {
        return super.setParameter(msg, param, value);
    }

    @Override
    public void sendAndReceive(HttpMessage msg) throws HttpException, IOException {
        super.sendAndReceive(msg);
    }

    @Override
    public void sendAndReceive(HttpMessage msg, boolean isFollowRedirect) throws HttpException, IOException {
        super.sendAndReceive(msg, isFollowRedirect);
    }

    @Override
    public void sendAndReceive(HttpMessage msg, boolean isFollowRedirect, boolean handleAntiCSRF) throws HttpException, IOException {
        super.sendAndReceive(msg, isFollowRedirect, handleAntiCSRF);
    }

    public void raiseAlert(int risk, int confidence, String name, String description, String uri, String param, String attack, String otherInfo, String solution, String evidence, int cweId, int wascId, HttpMessage msg) {
        super.bingo(risk, confidence, name, description, uri, param, attack, otherInfo, solution, evidence, cweId, wascId, msg);
    }

    @Override
    public int getRisk() {
        return 0;
    }

    @Override
    public int getCweId() {
        return 0;
    }

    @Override
    public int getWascId() {
        return 0;
    }
}

