/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.api;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.zaproxy.zap.extension.api.AbstractAPIGenerator;
import org.zaproxy.zap.extension.api.ApiElement;
import org.zaproxy.zap.extension.api.ApiImplementor;

public class DotNetAPIGenerator
extends AbstractAPIGenerator {
    private final String HEADER = "/* Zed Attack Proxy (ZAP) and its related class files.\n *\n * ZAP is an HTTP/HTTPS proxy for assessing web application security.\n *\n * Copyright the ZAP development team\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *   http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n";
    private static final Map<String, String> nameMap;

    public DotNetAPIGenerator() {
        super("../zap-api-dotnet/src/OWASPZAPDotNetAPI/OWASPZAPDotNetAPI/Generated");
    }

    public DotNetAPIGenerator(String path, boolean optional) {
        super(path, optional);
    }

    @Deprecated
    public void generateCSharpFiles(List<ApiImplementor> implementors) throws IOException {
        this.generateAPIFiles((List)implementors);
    }

    private void generateCSharpElement(ApiElement element, String component, String type, Writer out) throws IOException {
        boolean hasParams;
        block35: {
            hasParams = false;
            String descTag = element.getDescriptionTag();
            if (descTag == null) {
                descTag = component + ".api." + type + "." + element.getName();
            }
            try {
                String desc = this.getMessages().getString(descTag);
                out.write("\t\t/// <summary>\n");
                out.write("\t\t///" + desc + "\n");
                if (this.isOptional()) {
                    out.write("\t\t///This component is optional and therefore the API will only work if it is installed\n");
                }
                out.write("\t\t/// </summary>\n");
                out.write("\t\t/// <returns></returns>\n");
            }
            catch (Exception e) {
                System.out.println("No i18n for: " + descTag);
                if (!this.isOptional()) break block35;
                out.write("\t\t/// <summary>\n");
                out.write("\t\t///This component is optional and therefore the API will only work if it is installed\n");
                out.write("\t\t/// </summary>\n");
                out.write("\t\t/// <returns></returns>\n");
            }
        }
        if (type.equals("other")) {
            out.write("\t\tpublic byte[] " + DotNetAPIGenerator.createMethodName(element.getName()) + "(");
        } else {
            out.write("\t\tpublic IApiResponse " + DotNetAPIGenerator.createMethodName(element.getName()) + "(");
        }
        if (type.equals("action") || type.equals("other")) {
            hasParams = true;
            out.write("string ");
            out.write("apikey");
        }
        if (element.getMandatoryParamNames() != null) {
            for (String param : element.getMandatoryParamNames()) {
                if (!hasParams) {
                    hasParams = true;
                } else {
                    out.write(", ");
                }
                if (param.toLowerCase().equals("boolean")) {
                    out.write("bool boolean");
                    continue;
                }
                if (param.toLowerCase().equals("integer")) {
                    out.write("int i");
                    continue;
                }
                out.write("string ");
                out.write(DotNetAPIGenerator.createParameterName(param.toLowerCase()));
            }
        }
        if (element.getOptionalParamNames() != null) {
            for (String param : element.getOptionalParamNames()) {
                if (!hasParams) {
                    hasParams = true;
                } else {
                    out.write(", ");
                }
                if (param.toLowerCase().equals("boolean")) {
                    out.write("bool boolean");
                    continue;
                }
                if (param.toLowerCase().equals("integer")) {
                    out.write("int i");
                    continue;
                }
                out.write("string ");
                out.write(DotNetAPIGenerator.createParameterName(param.toLowerCase()));
            }
        }
        out.write(")\n\t\t{\n");
        out.write("\t\t\tDictionary<string, string> parameters = null;\n");
        if (hasParams) {
            out.write("\t\t\tparameters = new Dictionary<string, string>();\n");
            if (type.equals("action") || type.equals("other")) {
                out.write("\t\t\tif (!string.IsNullOrWhiteSpace(apikey)){\n");
                out.write("\t\t\t\tparameters.Add(\"apikey\", apikey);\n");
                out.write("\t\t\t}\n");
            }
            if (element.getMandatoryParamNames() != null) {
                for (String param : element.getMandatoryParamNames()) {
                    out.write("\t\t\tparameters.Add(\"" + param + "\", ");
                    if (param.toLowerCase().equals("boolean")) {
                        out.write("Convert.ToString(boolean)");
                    } else if (param.toLowerCase().equals("integer")) {
                        out.write("Convert.ToString(i)");
                    } else {
                        out.write(DotNetAPIGenerator.createParameterName(param.toLowerCase()));
                    }
                    out.write(");\n");
                }
            }
            if (element.getOptionalParamNames() != null) {
                for (String param : element.getOptionalParamNames()) {
                    out.write("\t\t\tparameters.Add(\"" + param + "\", ");
                    if (param.toLowerCase().equals("boolean")) {
                        out.write("Convert.ToString(boolean)");
                    } else if (param.toLowerCase().equals("integer")) {
                        out.write("Convert.ToString(i)");
                    } else {
                        out.write(DotNetAPIGenerator.createParameterName(param.toLowerCase()));
                    }
                    out.write(");\n");
                }
            }
        }
        if (type.equals("other")) {
            out.write("\t\t\treturn api.CallApiOther(\"" + component + "\", \"" + type + "\", \"" + element.getName() + "\", parameters);\n");
        } else {
            out.write("\t\t\treturn api.CallApi(\"" + component + "\", \"" + type + "\", \"" + element.getName() + "\", parameters);\n");
        }
        out.write("\t\t}\n\n");
    }

    private static String createMethodName(String name) {
        if (nameMap.containsKey(name)) {
            name = nameMap.get(name);
        }
        return DotNetAPIGenerator.removeAllFullStopCharacters(name);
    }

    private static String removeAllFullStopCharacters(String string) {
        return string.replaceAll("\\.", "");
    }

    private static String createParameterName(String name) {
        if (nameMap.containsKey(name)) {
            name = nameMap.get(name);
        }
        return DotNetAPIGenerator.removeAllFullStopCharacters(name);
    }

    @Override
    protected void generateAPIFiles(ApiImplementor imp) throws IOException {
        String className = imp.getPrefix().substring(0, 1).toUpperCase() + imp.getPrefix().substring(1);
        Path file = this.getDirectory().resolve(className + ".cs");
        System.out.println("Generating " + file.toAbsolutePath());
        try (BufferedWriter out = Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]);){
            out.write("/* Zed Attack Proxy (ZAP) and its related class files.\n *\n * ZAP is an HTTP/HTTPS proxy for assessing web application security.\n *\n * Copyright the ZAP development team\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *   http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n");
            out.write("\n\n");
            out.write("using System;\n");
            out.write("using System.Collections.Generic;\n");
            out.write("using System.Text;\n");
            out.write("\n");
            out.write("\n");
            out.write("/*\n");
            out.write(" * This file was automatically generated.\n");
            out.write(" */\n");
            out.write("namespace OWASPZAPDotNetAPI.Generated\n");
            out.write("{\n");
            out.write("\tpublic class " + className + " \n\t{");
            out.write("\n\t\tprivate ClientApi api = null;\n\n");
            out.write("\t\tpublic " + className + "(ClientApi api) \n\t\t{\n");
            out.write("\t\t\tthis.api = api;\n");
            out.write("\t\t}\n\n");
            for (ApiElement apiElement : imp.getApiViews()) {
                this.generateCSharpElement(apiElement, imp.getPrefix(), "view", out);
            }
            for (ApiElement apiElement : imp.getApiActions()) {
                this.generateCSharpElement(apiElement, imp.getPrefix(), "action", out);
            }
            for (ApiElement apiElement : imp.getApiOthers()) {
                this.generateCSharpElement(apiElement, imp.getPrefix(), "other", out);
            }
            out.write("\t}\n");
            out.write("}\n");
        }
    }

    public static void main(String[] args) throws Exception {
        DotNetAPIGenerator dnapi = new DotNetAPIGenerator("../zap-api-dotnet/src/OWASPZAPDotNetAPI/OWASPZAPDotNetAPI/Generated", false);
        dnapi.generateCoreAPIFiles();
    }

    static {
        HashMap<String, String> initMap = new HashMap<String, String>();
        initMap.put("break", "brk");
        initMap.put("continue", "cont");
        initMap.put("string", "str");
        initMap.put("params", "parameters");
        nameMap = Collections.unmodifiableMap(initMap);
    }
}

