/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.alert;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.extension.ExtensionPopupMenuItem;
import org.zaproxy.zap.extension.alert.ExtensionAlert;

public abstract class PopupMenuItemAlert
extends ExtensionPopupMenuItem {
    private static final long serialVersionUID = 1L;
    private final boolean multiSelect;
    private final ExtensionAlert extAlert;
    private static final Logger log = Logger.getLogger(PopupMenuItemAlert.class);

    public PopupMenuItemAlert(String label) {
        this(label, false);
    }

    public PopupMenuItemAlert(String label, boolean multiSelect) {
        super(label);
        this.multiSelect = multiSelect;
        this.addActionListener(new PerformActionsActionListener());
        this.extAlert = Control.getSingleton().getExtensionLoader().getExtension(ExtensionAlert.class);
    }

    public final boolean isMultiSelect() {
        return this.multiSelect;
    }

    private Set<Alert> getAlertNodes() {
        if (!this.isMultiSelect()) {
            return this.extAlert.getAlertPanel().getSelectedAlert();
        }
        return this.extAlert.getAlertPanel().getSelectedAlerts();
    }

    protected abstract void performAction(Alert var1);

    protected void performActions(Set<Alert> alerts) {
        for (Alert alert : alerts) {
            this.performAction(alert);
        }
    }

    protected boolean isButtonEnabledForNumberOfSelectedAlerts(int count) {
        if (count == 0) {
            return false;
        }
        return this.isMultiSelect() || count <= 1;
    }

    @Override
    public boolean isEnableForComponent(Component invoker) {
        if (this.extAlert == null) {
            return false;
        }
        if ("treeAlert".equals(invoker.getName())) {
            this.setEnabled(!this.extAlert.getAlertPanel().getTreeAlert().isRowSelected(0) && this.isButtonEnabledForNumberOfSelectedAlerts(this.getNumberOfSelectedAlerts()));
            return true;
        }
        return false;
    }

    private int getNumberOfSelectedAlerts() {
        JTree treeAlert = this.extAlert.getAlertPanel().getTreeAlert();
        int count = treeAlert.getSelectionCount();
        if (count == 0) {
            return 0;
        }
        if (count == 1) {
            DefaultMutableTreeNode alertNode = (DefaultMutableTreeNode)treeAlert.getSelectionPath().getLastPathComponent();
            if (alertNode.getChildCount() == 0 || !this.isMultiSelect()) {
                return 1;
            }
            return alertNode.getChildCount();
        }
        count = 0;
        TreePath[] paths = treeAlert.getSelectionPaths();
        for (int i = 0; i < paths.length; ++i) {
            TreePath nodePath = paths[i];
            int childCount = ((DefaultMutableTreeNode)nodePath.getLastPathComponent()).getChildCount();
            count += childCount != 0 ? childCount : (treeAlert.isPathSelected(nodePath.getParentPath()) ? 0 : 1);
        }
        return count;
    }

    protected ExtensionAlert getExtensionAlert() {
        return this.extAlert;
    }

    private class PerformActionsActionListener
    implements ActionListener {
        private PerformActionsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                Set alerts = PopupMenuItemAlert.this.getAlertNodes();
                PopupMenuItemAlert.this.performActions(alerts);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }
}

