/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.view;

import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.view.AbstractParamDialog;
import org.parosproxy.paros.view.AbstractParamPanel;
import org.parosproxy.paros.view.View;

public class OptionsDialog
extends AbstractParamDialog {
    private static final long serialVersionUID = -4374132178769109917L;
    private static final Logger logger = Logger.getLogger(OptionsDialog.class);
    private JButton[] extraButtons = null;

    public OptionsDialog() {
        this.initialize();
    }

    public OptionsDialog(Frame parent, boolean modal, String title) throws HeadlessException {
        super((Window)parent, modal, title, Constant.messages.getString("options.dialog.rootName"));
        this.initialize();
    }

    private void initialize() {
        this.setSize(750, 584);
    }

    @Override
    public JButton[] getExtraButtons() {
        if (this.extraButtons == null) {
            JButton resetButton = new JButton(Constant.messages.getString("options.dialog.reset.button"));
            resetButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (View.getSingleton().showConfirmDialog(OptionsDialog.this, Constant.messages.getString("options.dialog.reset.warn")) == 0) {
                        try {
                            OptionsParam params = Model.getSingleton().getOptionsParam();
                            Constant.getInstance().copyDefaultConfigs(new File(Constant.getInstance().FILE_CONFIG), true);
                            params.load(Constant.getInstance().FILE_CONFIG);
                            params.reloadConfigParamSets();
                            params.resetAll();
                            OptionsDialog.this.resetAllPanels();
                            OptionsDialog.this.initParam(params);
                        }
                        catch (Exception e1) {
                            logger.error((Object)"Failed to reset to defaults:", (Throwable)e1);
                            View.getSingleton().showWarningDialog(Constant.messages.getString("options.dialog.reset.error", e1.getMessage()));
                        }
                    }
                }
            });
            this.extraButtons = new JButton[]{resetButton};
        }
        return this.extraButtons;
    }

    private void resetAllPanels() {
        for (AbstractParamPanel panel : this.getPanels()) {
            try {
                panel.reset();
            }
            catch (Exception e) {
                logger.error((Object)("Failed to reset " + panel.getName() + " options panel:"), (Throwable)e);
                View.getSingleton().showWarningDialog(Constant.messages.getString("options.dialog.reset.error.panel", panel.getName(), e.getMessage()));
            }
        }
    }
}

