/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.view;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.utils.DisplayUtils;

public class MainFooterPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JToolBar footerToolbarLeft = null;
    private JToolBar footerToolbarRight = null;
    private JLabel alertHigh = null;
    private JLabel alertMedium = null;
    private JLabel alertLow = null;
    private JLabel alertInfo = null;

    public MainFooterPanel() {
        this.initialise();
    }

    public void initialise() {
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(DisplayUtils.getScaledDimension(this.getMaximumSize().width, 20));
        this.setMaximumSize(DisplayUtils.getScaledDimension(this.getMaximumSize().width, 20));
        this.setBorder(BorderFactory.createEtchedBorder());
        GridBagConstraints gbcToolbarLeft = new GridBagConstraints();
        GridBagConstraints gbcToolbarRight = new GridBagConstraints();
        GridBagConstraints gbcDummyToFillSpace = new GridBagConstraints();
        gbcToolbarLeft.gridx = 0;
        gbcToolbarLeft.gridy = 0;
        gbcToolbarLeft.insets = new Insets(0, 5, 0, 0);
        gbcToolbarLeft.anchor = 17;
        gbcDummyToFillSpace.gridx = 1;
        gbcDummyToFillSpace.gridy = 0;
        gbcDummyToFillSpace.weightx = 1.0;
        gbcDummyToFillSpace.weighty = 1.0;
        gbcDummyToFillSpace.anchor = 13;
        gbcDummyToFillSpace.fill = 2;
        gbcToolbarRight.gridx = 2;
        gbcToolbarRight.gridy = 0;
        gbcToolbarRight.insets = new Insets(0, 5, 0, 0);
        gbcToolbarRight.anchor = 13;
        JLabel dummyLabel = new JLabel();
        this.add((Component)this.getToolbarLeft(), gbcToolbarLeft);
        this.add((Component)dummyLabel, gbcDummyToFillSpace);
        this.add((Component)this.getToolbarRight(), gbcToolbarRight);
        this.footerToolbarLeft.add(new JLabel(Constant.messages.getString("footer.alerts.label")));
        this.footerToolbarLeft.add(this.getAlertHigh());
        this.footerToolbarLeft.add(this.getAlertMedium());
        this.footerToolbarLeft.add(this.getAlertLow());
        this.footerToolbarLeft.add(this.getAlertInfo());
        this.footerToolbarRight.add(new JLabel(Constant.messages.getString("footer.scans.label")));
    }

    private JToolBar getToolbarLeft() {
        if (this.footerToolbarLeft == null) {
            this.footerToolbarLeft = new JToolBar();
            this.footerToolbarLeft.setEnabled(true);
            this.footerToolbarLeft.setFloatable(false);
            this.footerToolbarLeft.setRollover(true);
            this.footerToolbarLeft.setName("Footer Toolbar Left");
            this.footerToolbarLeft.setBorder(BorderFactory.createEmptyBorder());
        }
        return this.footerToolbarLeft;
    }

    private JToolBar getToolbarRight() {
        if (this.footerToolbarRight == null) {
            this.footerToolbarRight = new JToolBar();
            this.footerToolbarRight.setEnabled(true);
            this.footerToolbarRight.setFloatable(false);
            this.footerToolbarRight.setRollover(true);
            this.footerToolbarRight.setName("Footer Toolbar Right");
            this.footerToolbarRight.setBorder(BorderFactory.createEmptyBorder());
        }
        return this.footerToolbarRight;
    }

    public void addAlertFlag(JButton button) {
        this.getToolbarLeft().add(button);
    }

    public void addSeparator() {
        this.getToolbarLeft().addSeparator();
    }

    private JLabel getAlertHigh() {
        if (this.alertHigh == null) {
            this.alertHigh = this.createAlertLabel(Constant.messages.getString("footer.alerts.high.tooltip"), Constant.HIGH_FLAG_IMAGE_URL);
        }
        return this.alertHigh;
    }

    public void setAlertHigh(int alert) {
        this.getAlertHigh().setText(Integer.toString(alert));
    }

    private JLabel getAlertMedium() {
        if (this.alertMedium == null) {
            this.alertMedium = this.createAlertLabel(Constant.messages.getString("footer.alerts.medium.tooltip"), Constant.MED_FLAG_IMAGE_URL);
        }
        return this.alertMedium;
    }

    public void setAlertMedium(int alert) {
        this.getAlertMedium().setText(Integer.toString(alert));
    }

    private JLabel getAlertLow() {
        if (this.alertLow == null) {
            this.alertLow = this.createAlertLabel(Constant.messages.getString("footer.alerts.low.tooltip"), Constant.LOW_FLAG_IMAGE_URL);
        }
        return this.alertLow;
    }

    public void setAlertLow(int alert) {
        this.getAlertLow().setText(Integer.toString(alert));
    }

    private JLabel getAlertInfo() {
        if (this.alertInfo == null) {
            this.alertInfo = this.createAlertLabel(Constant.messages.getString("footer.alerts.info.tooltip"), Constant.INFO_FLAG_IMAGE_URL);
        }
        return this.alertInfo;
    }

    public void setAlertInfo(int alert) {
        this.getAlertInfo().setText(Integer.toString(alert));
    }

    private JLabel createAlertLabel(String toolTipText, URL imageUrl) throws NullPointerException {
        JLabel label = new JLabel("0", DisplayUtils.getScaledIcon(new ImageIcon(imageUrl)), 10);
        label.setToolTipText(toolTipText);
        label.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        return label;
    }

    public void addFooterToolbarRightLabel(JLabel label) {
        DisplayUtils.scaleIcon(label);
        this.footerToolbarRight.add(label);
        this.validate();
    }

    public void removeFooterToolbarRightLabel(JLabel label) {
        this.footerToolbarRight.remove(label);
        this.validate();
    }

    public void addFooterToolbarRightComponent(JComponent comp) {
        if (comp instanceof JLabel) {
            DisplayUtils.scaleIcon((JLabel)comp);
        } else if (comp instanceof JButton) {
            DisplayUtils.scaleIcon((JButton)comp);
        }
        this.footerToolbarRight.add(comp);
        this.validate();
    }

    public void removeFooterToolbarRightComponent(JComponent comp) {
        this.footerToolbarRight.remove(comp);
        this.validate();
    }

    public void addFooterToolbarLeftComponent(JComponent comp) {
        if (comp instanceof JLabel) {
            DisplayUtils.scaleIcon((JLabel)comp);
        } else if (comp instanceof JButton) {
            DisplayUtils.scaleIcon((JButton)comp);
        }
        this.footerToolbarLeft.add(comp);
        this.validate();
    }

    public void removeFooterToolbarLeftComponent(JComponent comp) {
        this.footerToolbarLeft.remove(comp);
        this.validate();
    }

    public void removeFooterToolbarLeftLabel(JLabel label) {
        this.footerToolbarLeft.remove(label);
        this.validate();
    }

    public void addFooterSeparator() {
        this.footerToolbarRight.addSeparator();
    }
}

