/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.cloud.autoscaling;

import java.io.IOException;
import java.util.List;
import org.apache.solr.client.solrj.cloud.autoscaling.ReplicaInfo;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.util.Utils;

class ReplicaCount
implements MapWriter {
    long nrt;
    long tlog;
    long pull;

    public ReplicaCount() {
        this.pull = 0L;
        this.tlog = 0L;
        this.nrt = 0L;
    }

    public ReplicaCount(long nrt, long tlog, long pull) {
        this.nrt = nrt;
        this.tlog = tlog;
        this.pull = pull;
    }

    public long total() {
        return this.nrt + this.tlog + this.pull;
    }

    @Override
    public void writeMap(MapWriter.EntryWriter ew) throws IOException {
        if (this.nrt > 0L) {
            ew.put(Replica.Type.NRT.name(), this.nrt);
        }
        if (this.pull > 0L) {
            ew.put(Replica.Type.PULL.name(), this.pull);
        }
        if (this.tlog > 0L) {
            ew.put(Replica.Type.TLOG.name(), this.tlog);
        }
        ew.put("count", this.total());
    }

    public Long getVal(Replica.Type type) {
        if (type == null) {
            return this.total();
        }
        switch (type) {
            case NRT: {
                return this.nrt;
            }
            case PULL: {
                return this.pull;
            }
            case TLOG: {
                return this.tlog;
            }
        }
        return this.total();
    }

    public void increment(List<ReplicaInfo> infos) {
        if (infos == null) {
            return;
        }
        for (ReplicaInfo info : infos) {
            this.increment(info);
        }
    }

    void increment(ReplicaInfo info) {
        switch (info.getType()) {
            case NRT: {
                ++this.nrt;
                break;
            }
            case PULL: {
                ++this.pull;
                break;
            }
            case TLOG: {
                ++this.tlog;
                break;
            }
            default: {
                ++this.nrt;
            }
        }
    }

    public String toString() {
        return Utils.toJSONString(this);
    }

    public ReplicaCount copy() {
        return new ReplicaCount(this.nrt, this.tlog, this.pull);
    }

    public void reset() {
        this.pull = 0L;
        this.tlog = 0L;
        this.nrt = 0L;
    }
}

