/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.util.Locale;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.update.processor.AbstractDefaultValueUpdateProcessorFactory;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessorFactory;

public class UUIDUpdateProcessorFactory
extends UpdateRequestProcessorFactory {
    private static final String PREFIX_PARAM = "uuid.";
    public static final String NAME = "uuid";
    private static final String FIELD_PARAM = "fieldName";
    protected String fieldName = null;

    @Override
    public void init(NamedList args) {
        Object obj = args.remove(FIELD_PARAM);
        if (null != obj) {
            this.fieldName = obj.toString();
        }
    }

    @Override
    public UpdateRequestProcessor getInstance(SolrQueryRequest req, SolrQueryResponse rsp, UpdateRequestProcessor next) {
        String fieldName = this.fieldName;
        String fname = req.getParams().get("uuid.fieldName");
        if (!StringUtils.isEmpty((String)fname)) {
            fieldName = fname;
        }
        if (StringUtils.isEmpty((String)fieldName)) {
            SchemaField schemaField = req.getSchema().getUniqueKeyField();
            fieldName = schemaField.getName();
        }
        return new AbstractDefaultValueUpdateProcessorFactory.DefaultValueUpdateProcessor(fieldName, next){

            @Override
            public Object getDefaultValue() {
                return UUID.randomUUID().toString().toLowerCase(Locale.ROOT);
            }
        };
    }
}

