/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.text.ParseException;
import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.cloud.api.collections.MaintainRoutedAliasCmd;
import org.apache.solr.cloud.api.collections.TimeRoutedAlias;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.SolrCmdDistributor;
import org.apache.solr.update.processor.DistributedUpdateProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.util.DateMathParser;
import org.apache.solr.util.DefaultSolrThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeRoutedAliasUpdateProcessor
extends UpdateRequestProcessor {
    private static final String ALIAS_DISTRIB_UPDATE_PARAM = "alias.update.distrib";
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final SolrQueryRequest req;
    private final SolrCmdDistributor cmdDistrib;
    private final CollectionsHandler collHandler;
    private final ZkController zkController;
    private final String thisCollection;
    private final TimeRoutedAlias timeRoutedAlias;
    private final SolrParams outParamsToLeader;
    private List<Map.Entry<Instant, String>> parsedCollectionsDesc;
    private Aliases parsedCollectionsAliases;
    private volatile ExecutorService preemptiveCreationExecutor;

    public static UpdateRequestProcessor wrap(SolrQueryRequest req, UpdateRequestProcessor next) {
        String aliasName = req.getCore().getCoreDescriptor().getCoreProperty("routedAliasName", null);
        DistributedUpdateProcessor.DistribPhase shardDistribPhase = DistributedUpdateProcessor.DistribPhase.parseParam(req.getParams().get("update.distrib"));
        DistributedUpdateProcessor.DistribPhase aliasDistribPhase = DistributedUpdateProcessor.DistribPhase.parseParam(req.getParams().get(ALIAS_DISTRIB_UPDATE_PARAM));
        if (aliasName == null || aliasDistribPhase != DistributedUpdateProcessor.DistribPhase.NONE || shardDistribPhase != DistributedUpdateProcessor.DistribPhase.NONE) {
            return next;
        }
        return new TimeRoutedAliasUpdateProcessor(req, next, aliasName, aliasDistribPhase);
    }

    private TimeRoutedAliasUpdateProcessor(SolrQueryRequest req, UpdateRequestProcessor next, String aliasName, DistributedUpdateProcessor.DistribPhase aliasDistribPhase) {
        super(next);
        assert (aliasDistribPhase == DistributedUpdateProcessor.DistribPhase.NONE);
        SolrCore core = req.getCore();
        this.thisCollection = core.getCoreDescriptor().getCloudDescriptor().getCollectionName();
        this.req = req;
        CoreContainer cc = core.getCoreContainer();
        this.zkController = cc.getZkController();
        this.cmdDistrib = new SolrCmdDistributor(cc.getUpdateShardHandler());
        this.collHandler = cc.getCollectionsHandler();
        Map aliasProperties = this.zkController.getZkStateReader().getAliases().getCollectionAliasProperties(aliasName);
        if (aliasProperties == null) {
            throw this.newAliasMustExistException();
        }
        try {
            this.timeRoutedAlias = new TimeRoutedAlias(aliasName, aliasProperties);
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Routed alias has invalid properties: " + e, (Throwable)e);
        }
        ModifiableSolrParams outParams = new ModifiableSolrParams(req.getParams());
        outParams.remove("optimize");
        outParams.remove("commit");
        outParams.remove("softCommit");
        outParams.remove("prepareCommit");
        outParams.remove("rollback");
        outParams.set("update.distrib", new String[]{DistributedUpdateProcessor.DistribPhase.NONE.toString()});
        outParams.set(ALIAS_DISTRIB_UPDATE_PARAM, new String[]{DistributedUpdateProcessor.DistribPhase.TOLEADER.toString()});
        outParams.set("distrib.from", new String[]{ZkCoreNodeProps.getCoreUrl((String)this.zkController.getBaseUrl(), (String)core.getName())});
        this.outParamsToLeader = outParams;
    }

    private String getAliasName() {
        return this.timeRoutedAlias.getAliasName();
    }

    @Override
    public void processAdd(AddUpdateCommand cmd) throws IOException {
        Instant docTimestamp = this.parseRouteKey(cmd.getSolrInputDocument().getFieldValue(this.timeRoutedAlias.getRouteField()));
        if (docTimestamp.isAfter(Instant.now().plusMillis(this.timeRoutedAlias.getMaxFutureMs()))) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The document's time routed key of " + docTimestamp + " is too far in the future given " + "router.maxFutureMs" + "=" + this.timeRoutedAlias.getMaxFutureMs());
        }
        this.updateParsedCollectionAliases();
        String targetCollection = this.createCollectionsIfRequired(docTimestamp, cmd);
        if (this.thisCollection.equals(targetCollection)) {
            super.processAdd(cmd);
        } else {
            SolrCmdDistributor.Node targetLeaderNode = this.routeDocToSlice(targetCollection, cmd.getSolrInputDocument());
            this.cmdDistrib.distribAdd(cmd, Collections.singletonList(targetLeaderNode), new ModifiableSolrParams(this.outParamsToLeader));
        }
    }

    private String createCollectionsIfRequired(Instant docTimestamp, AddUpdateCommand cmd) {
        Map.Entry<Instant, String> candidateCollectionDesc = this.findCandidateGivenTimestamp(docTimestamp, cmd.getPrintableId());
        String candidateCollectionName = candidateCollectionDesc.getValue();
        try {
            switch (this.typeOfCreationRequired(docTimestamp, candidateCollectionDesc.getKey())) {
                case SYNCHRONOUS: {
                    return this.createAllRequiredCollections(docTimestamp, cmd.getPrintableId(), candidateCollectionDesc);
                }
                case ASYNC_PREEMPTIVE: {
                    if (this.preemptiveCreationExecutor == null) {
                        String mostRecentCollName = this.parsedCollectionsDesc.get(0).getValue();
                        this.preemptiveAsync(() -> this.createNextCollection(mostRecentCollName));
                    }
                    return candidateCollectionName;
                }
                case NONE: {
                    return candidateCollectionName;
                }
            }
            throw this.unknownCreateType();
        }
        catch (SolrException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    private void preemptiveAsync(Runnable r) {
        DefaultSolrThreadFactory threadFactory = new DefaultSolrThreadFactory("TRA-preemptive-creation");
        this.preemptiveCreationExecutor = ExecutorUtil.newMDCAwareSingleThreadExecutor((ThreadFactory)threadFactory);
        this.preemptiveCreationExecutor.execute(() -> {
            r.run();
            this.preemptiveCreationExecutor.shutdown();
            this.preemptiveCreationExecutor = null;
        });
    }

    private CreationType typeOfCreationRequired(Instant docTimeStamp, Instant targetCollectionTimestamp) {
        Instant preemptNextColCreateTime;
        Instant nextCollTimestamp = this.timeRoutedAlias.computeNextCollTimestamp(targetCollectionTimestamp);
        if (!docTimeStamp.isBefore(nextCollTimestamp)) {
            return CreationType.SYNCHRONOUS;
        }
        if (StringUtils.isNotBlank((CharSequence)this.timeRoutedAlias.getPreemptiveCreateWindow()) && !docTimeStamp.isBefore(preemptNextColCreateTime = this.calcPreemptNextColCreateTime(this.timeRoutedAlias.getPreemptiveCreateWindow(), nextCollTimestamp))) {
            return CreationType.ASYNC_PREEMPTIVE;
        }
        return CreationType.NONE;
    }

    private Instant calcPreemptNextColCreateTime(String preemptiveCreateMath, Instant nextCollTimestamp) {
        DateMathParser dateMathParser = new DateMathParser();
        dateMathParser.setNow(Date.from(nextCollTimestamp));
        try {
            return dateMathParser.parseMath(preemptiveCreateMath).toInstant();
        }
        catch (ParseException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid Preemptive Create Window Math:'" + preemptiveCreateMath + '\'', (Throwable)e);
        }
    }

    private Instant parseRouteKey(Object routeKey) {
        Instant docTimestamp;
        if (routeKey instanceof Instant) {
            docTimestamp = (Instant)routeKey;
        } else if (routeKey instanceof Date) {
            docTimestamp = ((Date)routeKey).toInstant();
        } else if (routeKey instanceof CharSequence) {
            docTimestamp = Instant.parse((CharSequence)routeKey);
        } else {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unexpected type of routeKey: " + routeKey);
        }
        return docTimestamp;
    }

    private boolean updateParsedCollectionAliases() {
        Aliases aliases = this.zkController.getZkStateReader().getAliases();
        if (this.parsedCollectionsAliases != aliases) {
            if (this.parsedCollectionsAliases != null) {
                log.debug("Observing possibly updated alias: {}", (Object)this.getAliasName());
            }
            this.parsedCollectionsDesc = this.timeRoutedAlias.parseCollections(aliases, this::newAliasMustExistException);
            this.parsedCollectionsAliases = aliases;
            return true;
        }
        return false;
    }

    private Map.Entry<Instant, String> findCandidateGivenTimestamp(Instant docTimestamp, String printableId) {
        for (Map.Entry<Instant, String> entry : this.parsedCollectionsDesc) {
            Instant colStartTime = entry.getKey();
            if (docTimestamp.isBefore(colStartTime)) continue;
            return entry;
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Doc " + printableId + " couldn't be routed with " + this.timeRoutedAlias.getRouteField() + "=" + docTimestamp);
    }

    private void createNextCollection(String mostRecentCollName) {
        try {
            MaintainRoutedAliasCmd.remoteInvoke(this.collHandler, this.getAliasName(), mostRecentCollName);
            this.zkController.getZkStateReader().aliasesManager.update();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    private SolrException newAliasMustExistException() {
        throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Collection " + this.thisCollection + " created for use with alias " + this.getAliasName() + " which doesn't exist anymore. You cannot write to this unless the alias exists.");
    }

    @Override
    public void processDelete(DeleteUpdateCommand cmd) throws IOException {
        List<SolrCmdDistributor.Node> nodes = this.lookupShardLeadersOfCollections();
        this.cmdDistrib.distribDelete(cmd, nodes, new ModifiableSolrParams(this.outParamsToLeader));
    }

    @Override
    public void processCommit(CommitUpdateCommand cmd) throws IOException {
        List<SolrCmdDistributor.Node> nodes = this.lookupShardLeadersOfCollections();
        this.cmdDistrib.distribCommit(cmd, nodes, new ModifiableSolrParams(this.outParamsToLeader));
        this.cmdDistrib.blockAndDoRetries();
    }

    @Override
    public void finish() throws IOException {
        try {
            this.cmdDistrib.finish();
            List<SolrCmdDistributor.Error> errors = this.cmdDistrib.getErrors();
            if (!errors.isEmpty()) {
                throw new DistributedUpdateProcessor.DistributedUpdatesAsyncException(errors);
            }
        }
        finally {
            super.finish();
        }
    }

    @Override
    protected void doClose() {
        try {
            this.cmdDistrib.close();
        }
        finally {
            super.doClose();
        }
    }

    private SolrCmdDistributor.Node routeDocToSlice(String collection, SolrInputDocument doc) {
        SchemaField uniqueKeyField = this.req.getSchema().getUniqueKeyField();
        String idFieldName = uniqueKeyField == null ? null : uniqueKeyField.getName();
        String idValue = uniqueKeyField == null ? null : doc.getFieldValue(idFieldName).toString();
        DocCollection coll = this.zkController.getClusterState().getCollection(collection);
        Slice slice = coll.getRouter().getTargetSlice(idValue, doc, null, this.req.getParams(), coll);
        return this.getLeaderNode(collection, slice);
    }

    private List<SolrCmdDistributor.Node> lookupShardLeadersOfCollections() {
        Aliases aliases = this.zkController.getZkStateReader().getAliases();
        List collections = (List)aliases.getCollectionAliasListMap().get(this.getAliasName());
        if (collections == null) {
            throw this.newAliasMustExistException();
        }
        return collections.stream().map(this::lookupShardLeaderOfCollection).collect(Collectors.toList());
    }

    private SolrCmdDistributor.Node lookupShardLeaderOfCollection(String collection) {
        Slice[] activeSlices = this.zkController.getClusterState().getCollection(collection).getActiveSlicesArr();
        if (activeSlices.length == 0) {
            throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Cannot route to collection " + collection);
        }
        Slice slice = activeSlices[0];
        return this.getLeaderNode(collection, slice);
    }

    private SolrCmdDistributor.Node getLeaderNode(String collection, Slice slice) {
        Replica leader = slice.getLeader();
        if (leader == null) {
            throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "No 'leader' replica available for shard " + slice.getName() + " of collection " + collection);
        }
        return new SolrCmdDistributor.ForwardNode(new ZkCoreNodeProps((ZkNodeProps)leader), this.zkController.getZkStateReader(), collection, slice.getName(), 25);
    }

    private String createAllRequiredCollections(Instant docTimestamp, String printableId, Map.Entry<Instant, String> targetCollectionDesc) {
        block5: while (true) {
            switch (this.typeOfCreationRequired(docTimestamp, targetCollectionDesc.getKey())) {
                case NONE: {
                    return targetCollectionDesc.getValue();
                }
                case ASYNC_PREEMPTIVE: {
                    String mostRecentCollName = this.parsedCollectionsDesc.get(0).getValue();
                    this.preemptiveAsync(() -> this.createNextCollection(mostRecentCollName));
                    return targetCollectionDesc.getValue();
                }
                case SYNCHRONOUS: {
                    this.createNextCollection(targetCollectionDesc.getValue());
                    if (!this.updateParsedCollectionAliases()) {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "We need to create a new time routed collection but for unknown reasons were unable to do so.");
                    }
                    targetCollectionDesc = this.findCandidateGivenTimestamp(docTimestamp, printableId);
                    continue block5;
                }
            }
            break;
        }
        throw this.unknownCreateType();
    }

    private SolrException unknownCreateType() {
        return new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown creation type while adding document to a Time Routed Alias! This is a bug caused when a creation type has been added but not all code has been updated to handle it.");
    }

    static enum CreationType {
        NONE,
        ASYNC_PREEMPTIVE,
        SYNCHRONOUS;

    }
}

