/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.servlet;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FileCleaningTracker;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.lucene.util.IOUtils;
import org.apache.solr.api.V2HttpCall;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.MultiMapSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.CommandOperation;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.ContentStreamBase;
import org.apache.solr.common.util.FastInputStream;
import org.apache.solr.core.RequestHandlers;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrQueryRequestBase;
import org.apache.solr.servlet.HttpSolrCall;
import org.apache.solr.util.RTimerTree;
import org.apache.solr.util.SolrFileCleaningTracker;

public class SolrRequestParsers {
    public static final String MULTIPART = "multipart";
    public static final String FORMDATA = "formdata";
    public static final String RAW = "raw";
    public static final String SIMPLE = "simple";
    public static final String STANDARD = "standard";
    private static final Charset CHARSET_US_ASCII = Charset.forName("US-ASCII");
    public static final String INPUT_ENCODING_KEY = "ie";
    private static final byte[] INPUT_ENCODING_BYTES = "ie".getBytes(CHARSET_US_ASCII);
    public static final String REQUEST_TIMER_SERVLET_ATTRIBUTE = "org.apache.solr.RequestTimer";
    private final HashMap<String, SolrRequestParser> parsers = new HashMap();
    private final boolean enableRemoteStreams;
    private final boolean enableStreamBody;
    private StandardRequestParser standard;
    private boolean handleSelect = true;
    private boolean addHttpRequestToContext;
    public static final SolrRequestParsers DEFAULT = new SolrRequestParsers();
    public static volatile SolrFileCleaningTracker fileCleaningTracker;
    private static final long WS_MASK = 140776143070721L;

    public SolrRequestParsers(SolrConfig globalConfig) {
        int multipartUploadLimitKB;
        int formUploadLimitKB;
        if (globalConfig == null) {
            formUploadLimitKB = Integer.MAX_VALUE;
            multipartUploadLimitKB = Integer.MAX_VALUE;
            this.enableRemoteStreams = false;
            this.enableStreamBody = false;
            this.handleSelect = false;
            this.addHttpRequestToContext = false;
        } else {
            multipartUploadLimitKB = globalConfig.getMultipartUploadLimitKB();
            formUploadLimitKB = globalConfig.getFormUploadLimitKB();
            this.enableRemoteStreams = globalConfig.isEnableRemoteStreams();
            this.enableStreamBody = globalConfig.isEnableStreamBody();
            this.handleSelect = globalConfig.isHandleSelect();
            this.addHttpRequestToContext = globalConfig.isAddHttpRequestToContext();
        }
        this.init(multipartUploadLimitKB, formUploadLimitKB);
    }

    private SolrRequestParsers() {
        this.enableRemoteStreams = false;
        this.enableStreamBody = false;
        this.handleSelect = false;
        this.addHttpRequestToContext = false;
        this.init(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    private void init(int multipartUploadLimitKB, int formUploadLimitKB) {
        MultipartRequestParser multi = new MultipartRequestParser(multipartUploadLimitKB);
        RawRequestParser raw = new RawRequestParser();
        FormDataRequestParser formdata = new FormDataRequestParser(formUploadLimitKB);
        this.standard = new StandardRequestParser(multi, raw, formdata);
        this.parsers.put(MULTIPART, multi);
        this.parsers.put(FORMDATA, formdata);
        this.parsers.put(RAW, raw);
        this.parsers.put(SIMPLE, new SimpleRequestParser());
        this.parsers.put(STANDARD, this.standard);
        this.parsers.put("", this.standard);
    }

    private static RTimerTree getRequestTimer(HttpServletRequest req) {
        Object reqTimer = req.getAttribute(REQUEST_TIMER_SERVLET_ATTRIBUTE);
        if (reqTimer != null && reqTimer instanceof RTimerTree) {
            return (RTimerTree)reqTimer;
        }
        return new RTimerTree();
    }

    public SolrQueryRequest parse(SolrCore core, String path, HttpServletRequest req) throws Exception {
        StandardRequestParser parser = this.standard;
        ArrayList<ContentStream> streams = new ArrayList<ContentStream>(1);
        SolrParams params = parser.parseParamsAndFillStreams(req, streams);
        SolrQueryRequest sreq = this.buildRequestFrom(core, params, streams, SolrRequestParsers.getRequestTimer(req), req);
        sreq.getContext().put("path", RequestHandlers.normalize(path));
        sreq.getContext().put("httpMethod", req.getMethod());
        if (this.addHttpRequestToContext) {
            sreq.getContext().put("httpRequest", req);
        }
        return sreq;
    }

    public SolrQueryRequest buildRequestFrom(SolrCore core, SolrParams params, Collection<ContentStream> streams) throws Exception {
        return this.buildRequestFrom(core, params, streams, new RTimerTree(), null);
    }

    private SolrQueryRequest buildRequestFrom(SolrCore core, SolrParams params, Collection<ContentStream> streams, RTimerTree requestTimer, final HttpServletRequest req) throws Exception {
        ContentStreamBase.URLStream stream;
        String contentType = params.get("stream.contentType");
        String[] strs = params.getParams("stream.url");
        if (strs != null) {
            if (!this.enableRemoteStreams) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Remote Streaming is disabled.");
            }
            for (String url : strs) {
                stream = new ContentStreamBase.URLStream(new URL(url));
                if (contentType != null) {
                    stream.setContentType(contentType);
                }
                streams.add((ContentStream)stream);
            }
        }
        if ((strs = params.getParams("stream.file")) != null) {
            if (!this.enableRemoteStreams) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Remote Streaming is disabled. See http://lucene.apache.org/solr/guide/requestdispatcher-in-solrconfig.html for help");
            }
            for (String file : strs) {
                stream = new ContentStreamBase.FileStream(new File(file));
                if (contentType != null) {
                    stream.setContentType(contentType);
                }
                streams.add((ContentStream)stream);
            }
        }
        if ((strs = params.getParams("stream.body")) != null) {
            if (!this.enableStreamBody) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Stream Body is disabled. See http://lucene.apache.org/solr/guide/requestdispatcher-in-solrconfig.html for help");
            }
            for (String body : strs) {
                stream = new ContentStreamBase.StringStream(body);
                if (contentType != null) {
                    stream.setContentType(contentType);
                }
                streams.add((ContentStream)stream);
            }
        }
        final HttpSolrCall httpSolrCall = req == null ? null : (HttpSolrCall)req.getAttribute(HttpSolrCall.class.getName());
        SolrQueryRequestBase q = new SolrQueryRequestBase(core, params, requestTimer){

            @Override
            public Principal getUserPrincipal() {
                return req == null ? null : req.getUserPrincipal();
            }

            @Override
            public List<CommandOperation> getCommands(boolean validateInput) {
                if (httpSolrCall != null) {
                    return httpSolrCall.getCommands(validateInput);
                }
                return super.getCommands(validateInput);
            }

            @Override
            public Map<String, String> getPathTemplateValues() {
                if (httpSolrCall != null && httpSolrCall instanceof V2HttpCall) {
                    return ((V2HttpCall)httpSolrCall).getUrlParts();
                }
                return super.getPathTemplateValues();
            }

            @Override
            public HttpSolrCall getHttpSolrCall() {
                return httpSolrCall;
            }
        };
        if (streams != null && streams.size() > 0) {
            q.setContentStreams(streams);
        }
        return q;
    }

    public static MultiMapSolrParams parseQueryString(String queryString) {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        SolrRequestParsers.parseQueryString(queryString, map);
        return new MultiMapSolrParams(map);
    }

    static void parseQueryString(final String queryString, Map<String, String[]> map) {
        if (queryString != null && queryString.length() > 0) {
            try {
                final int len = queryString.length();
                InputStream in = new InputStream(){
                    int pos = 0;

                    @Override
                    public int read() {
                        if (this.pos < len) {
                            char ch = queryString.charAt(this.pos);
                            if (ch > '\u007f') {
                                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "URLDecoder: The query string contains a not-%-escaped byte > 127 at position " + this.pos);
                            }
                            ++this.pos;
                            return ch;
                        }
                        return -1;
                    }
                };
                SolrRequestParsers.parseFormDataContent(in, Long.MAX_VALUE, StandardCharsets.UTF_8, map, true);
            }
            catch (IOException ioe) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)ioe);
            }
        }
    }

    static long parseFormDataContent(InputStream postContent, long maxLen, Charset charset, Map<String, String[]> map, boolean supportCharsetParam) throws IOException {
        long len;
        LinkedList<Object> buffer;
        CharsetDecoder charsetDecoder;
        block18: {
            charsetDecoder = supportCharsetParam ? null : SolrRequestParsers.getCharsetDecoder(charset);
            buffer = supportCharsetParam ? new LinkedList<Object>() : null;
            len = 0L;
            long keyPos = 0L;
            long valuePos = 0L;
            ByteArrayOutputStream keyStream = new ByteArrayOutputStream();
            ByteArrayOutputStream valueStream = new ByteArrayOutputStream();
            ByteArrayOutputStream currentStream = keyStream;
            do {
                int b = postContent.read();
                switch (b) {
                    case -1: 
                    case 38: {
                        if (keyStream.size() > 0) {
                            byte[] keyBytes = keyStream.toByteArray();
                            byte[] valueBytes = valueStream.toByteArray();
                            if (Arrays.equals(keyBytes, INPUT_ENCODING_BYTES)) {
                                if (charsetDecoder != null) {
                                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, supportCharsetParam ? "Query string invalid: duplicate 'ie' (input encoding) key." : "Key 'ie' (input encoding) cannot be used in POSTed application/x-www-form-urlencoded form data. To set the input encoding of POSTed form data, use the 'Content-Type' header and provide a charset!");
                                }
                                charset = Charset.forName(SolrRequestParsers.decodeChars(valueBytes, keyPos, SolrRequestParsers.getCharsetDecoder(CHARSET_US_ASCII)));
                                charsetDecoder = SolrRequestParsers.getCharsetDecoder(charset);
                                SolrRequestParsers.decodeBuffer(buffer, map, charsetDecoder);
                            } else if (charsetDecoder == null) {
                                buffer.add(keyBytes);
                                buffer.add(keyPos);
                                buffer.add(valueBytes);
                                buffer.add(valuePos);
                            } else {
                                String key = SolrRequestParsers.decodeChars(keyBytes, keyPos, charsetDecoder);
                                String value = SolrRequestParsers.decodeChars(valueBytes, valuePos, charsetDecoder);
                                MultiMapSolrParams.addParam((String)key.trim(), (String)value, map);
                            }
                        } else if (valueStream.size() > 0) {
                            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "application/x-www-form-urlencoded invalid: missing key");
                        }
                        keyStream.reset();
                        valueStream.reset();
                        keyPos = valuePos = len + 1L;
                        currentStream = keyStream;
                        break;
                    }
                    case 43: {
                        currentStream.write(32);
                        break;
                    }
                    case 37: {
                        b = postContent.read();
                        int upper = SolrRequestParsers.digit16(b);
                        ++len;
                        b = postContent.read();
                        int lower = SolrRequestParsers.digit16(b);
                        ++len;
                        currentStream.write((upper << 4) + lower);
                        break;
                    }
                    case 61: {
                        if (currentStream == keyStream) {
                            valuePos = len + 1L;
                            currentStream = valueStream;
                            break;
                        }
                    }
                    default: {
                        currentStream.write(b);
                    }
                }
                if (b == -1) break block18;
            } while (++len <= maxLen);
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "application/x-www-form-urlencoded content exceeds upload limit of " + maxLen / 1024L + " KB");
        }
        if (buffer != null && !buffer.isEmpty()) {
            assert (charsetDecoder == null);
            SolrRequestParsers.decodeBuffer(buffer, map, SolrRequestParsers.getCharsetDecoder(charset));
        }
        return len;
    }

    private static CharsetDecoder getCharsetDecoder(Charset charset) {
        return charset.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
    }

    private static String decodeChars(byte[] bytes, long position, CharsetDecoder charsetDecoder) {
        try {
            return charsetDecoder.decode(ByteBuffer.wrap(bytes)).toString();
        }
        catch (CharacterCodingException cce) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "URLDecoder: Invalid character encoding detected after position " + position + " of query string / form data (while parsing as " + charsetDecoder.charset().name() + ")");
        }
    }

    private static void decodeBuffer(LinkedList<Object> input, Map<String, String[]> map, CharsetDecoder charsetDecoder) {
        Iterator it = input.iterator();
        while (it.hasNext()) {
            byte[] keyBytes = (byte[])it.next();
            it.remove();
            Long keyPos = (Long)it.next();
            it.remove();
            byte[] valueBytes = (byte[])it.next();
            it.remove();
            Long valuePos = (Long)it.next();
            it.remove();
            MultiMapSolrParams.addParam((String)SolrRequestParsers.decodeChars(keyBytes, keyPos, charsetDecoder).trim(), (String)SolrRequestParsers.decodeChars(valueBytes, valuePos, charsetDecoder), map);
        }
    }

    private static int digit16(int b) {
        if (b == -1) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "URLDecoder: Incomplete trailing escape (%) pattern");
        }
        if (b >= 48 && b <= 57) {
            return b - 48;
        }
        if (b >= 65 && b <= 70) {
            return b - 55;
        }
        if (b >= 97 && b <= 102) {
            return b - 87;
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "URLDecoder: Invalid digit (" + (char)b + ") in escape (%) pattern");
    }

    public boolean isHandleSelect() {
        return this.handleSelect;
    }

    public void setHandleSelect(boolean handleSelect) {
        this.handleSelect = handleSelect;
    }

    public boolean isAddRequestHeadersToContext() {
        return this.addHttpRequestToContext;
    }

    public void setAddRequestHeadersToContext(boolean addRequestHeadersToContext) {
        this.addHttpRequestToContext = addRequestHeadersToContext;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static SolrParams autodetect(HttpServletRequest req, ArrayList<ContentStream> streams, FastInputStream in) throws IOException {
        MultiMapSolrParams multiMapSolrParams;
        String detectedContentType = null;
        boolean shouldClose = true;
        try {
            in.peek();
            byte[] arr = in.getBuffer();
            int pos = in.getPositionInBuffer();
            int end = in.getEndInBuffer();
            for (int i = pos; i < end - 1; ++i) {
                boolean isWhitespace;
                byte ch = arr[i];
                boolean bl = isWhitespace = (140776143070721L >> ch & 1L) != 0L && (ch <= 32 || ch == 160);
                if (isWhitespace) continue;
                if (ch == 35 || ch == 47 && (arr[i + 1] == 47 || arr[i + 1] == 42) || ch == 123 || ch == 91) {
                    detectedContentType = "application/json";
                }
                if (ch != 60) break;
                detectedContentType = "text/xml";
                break;
            }
            if (detectedContentType == null) {
                return null;
            }
        }
        catch (IOException ioe) {
            try {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)ioe);
                catch (IllegalStateException ise) {
                    throw (SolrException)FormDataRequestParser.getParameterIncompatibilityException().initCause((Throwable)ise);
                }
            }
            catch (Throwable throwable) {
                if (!shouldClose) throw throwable;
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{in});
                throw throwable;
            }
        }
        {
            Long size = null;
            String v = req.getHeader("Content-Length");
            if (v != null) {
                size = Long.valueOf(v);
            }
            streams.add((ContentStream)new InputStreamContentStream((InputStream)in, detectedContentType, size));
            HashMap<String, String[]> map = new HashMap<String, String[]>();
            String qs = req.getQueryString();
            if (qs != null) {
                SolrRequestParsers.parseQueryString(qs, map);
            }
            multiMapSolrParams = new MultiMapSolrParams(map);
            if (!shouldClose) return multiMapSolrParams;
        }
        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{in});
        return multiMapSolrParams;
    }

    static class InputStreamContentStream
    extends ContentStreamBase {
        private final InputStream is;

        public InputStreamContentStream(InputStream is, String detectedContentType, Long size) {
            this.is = is;
            this.contentType = detectedContentType;
            this.size = size;
        }

        public InputStream getStream() throws IOException {
            return this.is;
        }
    }

    static class StandardRequestParser
    implements SolrRequestParser {
        MultipartRequestParser multipart;
        RawRequestParser raw;
        FormDataRequestParser formdata;

        StandardRequestParser(MultipartRequestParser multi, RawRequestParser raw, FormDataRequestParser formdata) {
            this.multipart = multi;
            this.raw = raw;
            this.formdata = formdata;
        }

        @Override
        public SolrParams parseParamsAndFillStreams(HttpServletRequest req, ArrayList<ContentStream> streams) throws Exception {
            String contentType = req.getContentType();
            String method = req.getMethod();
            String uri = req.getRequestURI();
            boolean isPost = "POST".equals(method);
            if (!isPost) {
                if (contentType == null) {
                    return SolrRequestParsers.parseQueryString(req.getQueryString());
                }
                boolean restletPath = false;
                int idx = uri.indexOf("/schema");
                if (idx >= 0 && uri.endsWith("/schema") || uri.contains("/schema/")) {
                    restletPath = true;
                }
                if (restletPath) {
                    return SolrRequestParsers.parseQueryString(req.getQueryString());
                }
                if ("PUT".equals(method) || "DELETE".equals(method)) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unsupported method: " + method + " for request " + req);
                }
            }
            if (this.formdata.isFormData(req)) {
                SolrParams params;
                String userAgent = req.getHeader("User-Agent");
                boolean isCurl = userAgent != null && userAgent.startsWith("curl/");
                FastInputStream input = FastInputStream.wrap((InputStream)req.getInputStream());
                if (isCurl && (params = SolrRequestParsers.autodetect(req, streams, input)) != null) {
                    return params;
                }
                return this.formdata.parseParamsAndFillStreams(req, streams, (InputStream)input);
            }
            if (ServletFileUpload.isMultipartContent((HttpServletRequest)req)) {
                return this.multipart.parseParamsAndFillStreams(req, streams);
            }
            return this.raw.parseParamsAndFillStreams(req, streams);
        }
    }

    static class FormDataRequestParser
    implements SolrRequestParser {
        private static final long WS_MASK = 140776143070721L;
        private final int uploadLimitKB;

        public FormDataRequestParser(int limit) {
            this.uploadLimitKB = limit;
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public SolrParams parseParamsAndFillStreams(HttpServletRequest req, ArrayList<ContentStream> streams, InputStream in) throws Exception {
            long maxLength;
            long totalLength;
            HashMap<String, String[]> map = new HashMap<String, String[]>();
            String qs = req.getQueryString();
            if (qs != null) {
                SolrRequestParsers.parseQueryString(qs, map);
            }
            if ((totalLength = (long)req.getContentLength()) > (maxLength = (long)this.uploadLimitKB * 1024L)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "application/x-www-form-urlencoded content length (" + totalLength + " bytes) exceeds upload limit of " + this.uploadLimitKB + " KB");
            }
            String cs = ContentStreamBase.getCharsetFromContentType((String)req.getContentType());
            Charset charset = cs == null ? StandardCharsets.UTF_8 : Charset.forName(cs);
            try {
                in = FastInputStream.wrap((InputStream)(in == null ? new CloseShieldInputStream((InputStream)req.getInputStream()) : in));
                long bytesRead = SolrRequestParsers.parseFormDataContent(in, maxLength, charset, map, false);
                if (bytesRead == 0L && totalLength > 0L) {
                    throw FormDataRequestParser.getParameterIncompatibilityException();
                }
            }
            catch (IOException ioe) {
                try {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)ioe);
                    catch (IllegalStateException ise) {
                        throw (SolrException)FormDataRequestParser.getParameterIncompatibilityException().initCause((Throwable)ise);
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{in});
                    throw throwable;
                }
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{in});
            return new MultiMapSolrParams(map);
        }

        @Override
        public SolrParams parseParamsAndFillStreams(HttpServletRequest req, ArrayList<ContentStream> streams) throws Exception {
            if (!this.isFormData(req)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Not application/x-www-form-urlencoded content: " + req.getContentType());
            }
            return this.parseParamsAndFillStreams(req, streams, null);
        }

        public static SolrException getParameterIncompatibilityException() {
            return new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Solr requires that request parameters sent using application/x-www-form-urlencoded content-type can be read through the request input stream. Unfortunately, the stream was empty / not available. This may be caused by another servlet filter calling ServletRequest.getParameter*() before SolrDispatchFilter, please remove it.");
        }

        public boolean isFormData(HttpServletRequest req) {
            String contentType = req.getContentType();
            if (contentType != null) {
                int idx = contentType.indexOf(59);
                if (idx > 0) {
                    contentType = contentType.substring(0, idx);
                }
                if ("application/x-www-form-urlencoded".equalsIgnoreCase(contentType = contentType.trim())) {
                    return true;
                }
            }
            return false;
        }
    }

    static class MultipartRequestParser
    implements SolrRequestParser {
        private final int uploadLimitKB;
        private DiskFileItemFactory factory = new DiskFileItemFactory();

        public MultipartRequestParser(int limit) {
            this.uploadLimitKB = limit;
            SolrFileCleaningTracker fct = fileCleaningTracker;
            if (fct != null) {
                this.factory.setFileCleaningTracker((FileCleaningTracker)fileCleaningTracker);
            }
        }

        @Override
        public SolrParams parseParamsAndFillStreams(HttpServletRequest req, ArrayList<ContentStream> streams) throws Exception {
            if (!ServletFileUpload.isMultipartContent((HttpServletRequest)req)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Not multipart content! " + req.getContentType());
            }
            MultiMapSolrParams params = SolrRequestParsers.parseQueryString(req.getQueryString());
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)this.factory);
            upload.setSizeMax((long)this.uploadLimitKB * 1024L);
            List items = upload.parseRequest(req);
            for (FileItem item : items) {
                if (item.isFormField()) {
                    MultiMapSolrParams.addParam((String)item.getFieldName().trim(), (String)item.getString(), (Map)params.getMap());
                    continue;
                }
                streams.add((ContentStream)new FileItemContentStream(item));
            }
            return params;
        }
    }

    static class RawRequestParser
    implements SolrRequestParser {
        RawRequestParser() {
        }

        @Override
        public SolrParams parseParamsAndFillStreams(HttpServletRequest req, ArrayList<ContentStream> streams) throws Exception {
            streams.add((ContentStream)new HttpRequestContentStream(req));
            return SolrRequestParsers.parseQueryString(req.getQueryString());
        }
    }

    static class FileItemContentStream
    extends ContentStreamBase {
        private final FileItem item;

        public FileItemContentStream(FileItem f) {
            this.item = f;
            this.contentType = this.item.getContentType();
            this.name = this.item.getName();
            this.sourceInfo = this.item.getFieldName();
            this.size = this.item.getSize();
        }

        public InputStream getStream() throws IOException {
            return this.item.getInputStream();
        }
    }

    static class HttpRequestContentStream
    extends ContentStreamBase {
        private final HttpServletRequest req;

        public HttpRequestContentStream(HttpServletRequest req) {
            this.req = req;
            this.contentType = req.getContentType();
            String v = req.getHeader("Content-Length");
            if (v != null) {
                this.size = Long.valueOf(v);
            }
        }

        public InputStream getStream() throws IOException {
            return new CloseShieldInputStream((InputStream)this.req.getInputStream());
        }
    }

    static class SimpleRequestParser
    implements SolrRequestParser {
        SimpleRequestParser() {
        }

        @Override
        public SolrParams parseParamsAndFillStreams(HttpServletRequest req, ArrayList<ContentStream> streams) throws Exception {
            return SolrRequestParsers.parseQueryString(req.getQueryString());
        }
    }

    static interface SolrRequestParser {
        public SolrParams parseParamsAndFillStreams(HttpServletRequest var1, ArrayList<ContentStream> var2) throws Exception;
    }
}

