/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.randomizedtesting.rules;

import com.carrotsearch.randomizedtesting.RandomizedTest;
import com.carrotsearch.randomizedtesting.SysGlobals;
import com.carrotsearch.randomizedtesting.annotations.SuppressForbidden;
import com.carrotsearch.randomizedtesting.rules.TestRuleAdapter;
import java.util.Objects;

public class RequireAssertionsRule
extends TestRuleAdapter {
    public static final boolean TEST_ASSERTS_ENABLED = RandomizedTest.systemPropertyAsBoolean(SysGlobals.SYSPROP_ASSERTS(), true);
    private final Class<?> targetClass;

    public RequireAssertionsRule(Class<?> targetClass) {
        this.targetClass = Objects.requireNonNull(targetClass);
    }

    @Override
    @SuppressForbidden(value="Permitted sysout.")
    protected void before() throws Throwable {
        boolean assertsEnabled = this.targetClass.desiredAssertionStatus();
        if (assertsEnabled != TEST_ASSERTS_ENABLED) {
            String msg = "Assertion state mismatch on " + this.targetClass.getSimpleName() + ": ";
            msg = assertsEnabled ? msg + "-ea was specified" : msg + "-ea was not specified";
            msg = msg + " but -Dtests.asserts=" + TEST_ASSERTS_ENABLED;
            System.err.println(msg);
            throw new Exception(msg);
        }
    }
}

