/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.validate;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.SqlWindow;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.util.SqlBasicVisitor;
import org.apache.calcite.sql.validate.AggregatingScope;
import org.apache.calcite.sql.validate.AggregatingSelectScope;
import org.apache.calcite.sql.validate.SqlQualified;
import org.apache.calcite.sql.validate.SqlValidatorImpl;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.Static;

class AggChecker
extends SqlBasicVisitor<Void> {
    private final Deque<SqlValidatorScope> scopes = new ArrayDeque<SqlValidatorScope>();
    private final List<SqlNode> extraExprs;
    private final List<SqlNode> groupExprs;
    private boolean distinct;
    private SqlValidatorImpl validator;

    AggChecker(SqlValidatorImpl validator, AggregatingScope scope, List<SqlNode> extraExprs, List<SqlNode> groupExprs, boolean distinct) {
        this.validator = validator;
        this.extraExprs = extraExprs;
        this.groupExprs = groupExprs;
        this.distinct = distinct;
        this.scopes.push(scope);
    }

    boolean isGroupExpr(SqlNode expr) {
        for (SqlNode groupExpr : this.groupExprs) {
            if (!groupExpr.equalsDeep(expr, Litmus.IGNORE)) continue;
            return true;
        }
        for (SqlNode extraExpr : this.extraExprs) {
            if (!extraExpr.equalsDeep(expr, Litmus.IGNORE)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Void visit(SqlIdentifier id) {
        if (this.isGroupExpr(id) || id.isStar()) {
            return null;
        }
        SqlCall call = SqlUtil.makeCall(this.validator.getOperatorTable(), id);
        if (call != null) {
            return call.accept(this);
        }
        SqlQualified fqId = this.scopes.peek().fullyQualify(id);
        if (this.isGroupExpr(fqId.identifier)) {
            return null;
        }
        SqlNode originalExpr = this.validator.getOriginal(id);
        String exprString = originalExpr.toString();
        throw this.validator.newValidationError(originalExpr, this.distinct ? Static.RESOURCE.notSelectDistinctExpr(exprString) : Static.RESOURCE.notGroupExpr(exprString));
    }

    @Override
    public Void visit(SqlCall call) {
        SqlValidatorScope scope = this.scopes.peek();
        if (call.getOperator().isAggregator()) {
            if (this.distinct) {
                if (scope instanceof AggregatingSelectScope) {
                    SqlNodeList selectList = ((SqlSelect)scope.getNode()).getSelectList();
                    for (SqlNode sqlNode : selectList) {
                        if (sqlNode.getKind() == SqlKind.AS) {
                            sqlNode = ((SqlCall)sqlNode).operand(0);
                        }
                        if (!this.validator.expand(sqlNode, scope).equalsDeep((SqlNode)call, Litmus.IGNORE)) continue;
                        return null;
                    }
                }
                SqlNode originalExpr = this.validator.getOriginal(call);
                String exprString = originalExpr.toString();
                throw this.validator.newValidationError(call, Static.RESOURCE.notSelectDistinctExpr(exprString));
            }
            return null;
        }
        if (call.getKind() == SqlKind.FILTER) {
            ((SqlNode)call.operand(0)).accept(this);
            return null;
        }
        if (call.getKind() == SqlKind.OVER) {
            for (SqlNode operand : ((SqlCall)call.operand(0)).getOperandList()) {
                operand.accept(this);
            }
            Object over = call.operand(1);
            if (over instanceof SqlCall) {
                ((SqlNode)over).accept(this);
            } else if (over instanceof SqlIdentifier) {
                SqlWindow window = scope.lookupWindow(((SqlIdentifier)over).getSimple());
                window.getPartitionList().accept(this);
                window.getOrderList().accept(this);
            }
        }
        if (this.isGroupExpr(call)) {
            return null;
        }
        SqlCall groupCall = SqlStdOperatorTable.convertAuxiliaryToGroupCall(call);
        if (groupCall != null) {
            if (this.isGroupExpr(groupCall)) {
                return null;
            }
            throw this.validator.newValidationError(groupCall, Static.RESOURCE.auxiliaryWithoutMatchingGroupCall(call.getOperator().getName(), groupCall.getOperator().getName()));
        }
        if (call.isA(SqlKind.QUERY)) {
            return null;
        }
        SqlValidatorScope newScope = scope.getOperandScope(call);
        this.scopes.push(newScope);
        call.getOperator().acceptCall(this, call, true, SqlBasicVisitor.ArgHandlerImpl.instance());
        this.scopes.pop();
        return null;
    }
}

