/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.util.Map;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.util.RTimer;

public class RTimerTree
extends RTimer {
    protected SimpleOrderedMap<RTimerTree> children = new SimpleOrderedMap();

    @Override
    public double stop() {
        double time = super.stop();
        for (Map.Entry entry : this.children) {
            RTimer child = (RTimer)entry.getValue();
            if (child.state != 0 && child.state != 2) continue;
            child.stop();
        }
        return time;
    }

    protected RTimerTree newTimer() {
        return new RTimerTree();
    }

    public RTimerTree sub(String desc) {
        RTimerTree child = (RTimerTree)this.children.get(desc);
        if (child == null) {
            child = this.newTimer();
            this.children.add(desc, (Object)child);
        }
        return child;
    }

    public String toString() {
        return this.asNamedList().toString();
    }

    public NamedList asNamedList() {
        SimpleOrderedMap m = new SimpleOrderedMap();
        m.add("time", (Object)this.getTime());
        if (this.children.size() > 0) {
            for (Map.Entry entry : this.children) {
                m.add((String)entry.getKey(), (Object)((RTimerTree)entry.getValue()).asNamedList());
            }
        }
        return m;
    }

    public SimpleOrderedMap<RTimerTree> getChildren() {
        return this.children;
    }
}

