/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.rest.schema.analysis;

import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.core.StopFilter;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.rest.ManagedResource;
import org.apache.solr.rest.schema.analysis.BaseManagedTokenFilterFactory;
import org.apache.solr.rest.schema.analysis.ManagedWordSetResource;

public class ManagedStopFilterFactory
extends BaseManagedTokenFilterFactory {
    private CharArraySet stopWords = null;

    public ManagedStopFilterFactory(Map<String, String> args) {
        super(args);
    }

    @Override
    public String getResourceId() {
        return "/schema/analysis/stopwords/" + this.handle;
    }

    @Override
    protected Class<? extends ManagedResource> getManagedResourceImplClass() {
        return ManagedWordSetResource.class;
    }

    @Override
    public void onManagedResourceInitialized(NamedList<?> args, ManagedResource res) throws SolrException {
        Set<String> managedWords = ((ManagedWordSetResource)res).getWordSet();
        boolean ignoreCase = args.getBooleanArg("ignoreCase");
        this.stopWords = new CharArraySet(managedWords.size(), ignoreCase);
        this.stopWords.addAll(managedWords);
    }

    public TokenStream create(TokenStream input) {
        if (this.stopWords == null) {
            throw new IllegalStateException("Managed stopwords not initialized correctly!");
        }
        return new StopFilter(input, this.stopWords);
    }
}

