/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.metrics.reporters;

import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.graphite.Graphite;
import com.codahale.metrics.graphite.GraphiteReporter;
import com.codahale.metrics.graphite.GraphiteSender;
import com.codahale.metrics.graphite.PickledGraphite;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.solr.metrics.FilteringSolrMetricReporter;
import org.apache.solr.metrics.SolrMetricManager;
import org.apache.solr.metrics.reporters.ReporterClientCache;

public class SolrGraphiteReporter
extends FilteringSolrMetricReporter {
    private String host = null;
    private int port = -1;
    private boolean pickled = false;
    private String instancePrefix = null;
    private GraphiteReporter reporter = null;
    private static final ReporterClientCache<GraphiteSender> serviceRegistry = new ReporterClientCache();

    public SolrGraphiteReporter(SolrMetricManager metricManager, String registryName) {
        super(metricManager, registryName);
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setPrefix(String prefix) {
        this.instancePrefix = prefix;
    }

    public void setPickled(boolean pickled) {
        this.pickled = pickled;
    }

    @Override
    protected void doInit() {
        if (this.reporter != null) {
            throw new IllegalStateException("Already started once?");
        }
        String id = this.host + ":" + this.port + ":" + this.pickled;
        Object graphite = this.pickled ? new PickledGraphite(this.host, this.port) : new Graphite(this.host, this.port);
        this.instancePrefix = this.instancePrefix == null ? this.registryName : this.instancePrefix + "." + this.registryName;
        GraphiteReporter.Builder builder = GraphiteReporter.forRegistry((MetricRegistry)this.metricManager.registry(this.registryName)).prefixedWith(this.instancePrefix).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS);
        MetricFilter filter = this.newMetricFilter();
        builder = builder.filter(filter);
        this.reporter = builder.build((GraphiteSender)graphite);
        this.reporter.start((long)this.period, TimeUnit.SECONDS);
    }

    @Override
    protected void validate() throws IllegalStateException {
        if (this.host == null) {
            throw new IllegalStateException("Init argument 'host' must be set to a valid Graphite server name.");
        }
        if (this.port == -1) {
            throw new IllegalStateException("Init argument 'port' must be set to a valid Graphite server port.");
        }
        if (this.period < 1) {
            throw new IllegalStateException("Init argument 'period' is in time unit 'seconds' and must be at least 1.");
        }
    }

    @Override
    public void close() throws IOException {
        if (this.reporter != null) {
            this.reporter.close();
        }
    }
}

