/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.openapi.util.TextRange;
import com.intellij.util.text.CharArrayCharSequence;
import com.intellij.util.text.CharArrayExternalizable;
import com.intellij.util.text.CharSequenceBackedByArray;
import com.intellij.util.text.CharSequenceReader;
import com.intellij.util.text.ImmutableCharSequence;
import com.intellij.util.text.ImmutableText;
import com.intellij.util.text.UnsyncCharArrayReader;
import java.io.Reader;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CharArrayUtil {
    private static final int GET_CHARS_THRESHOLD = 10;

    private CharArrayUtil() {
    }

    public static void getChars(@NotNull CharSequence src, @NotNull char[] dst, int dstOffset) {
        if (src == null) {
            CharArrayUtil.$$$reportNull$$$0(0);
        }
        if (dst == null) {
            CharArrayUtil.$$$reportNull$$$0(1);
        }
        CharArrayUtil.getChars(src, dst, dstOffset, src.length());
    }

    public static void getChars(@NotNull CharSequence src, @NotNull char[] dst, int dstOffset, int len) {
        if (src == null) {
            CharArrayUtil.$$$reportNull$$$0(2);
        }
        if (dst == null) {
            CharArrayUtil.$$$reportNull$$$0(3);
        }
        CharArrayUtil.getChars(src, dst, 0, dstOffset, len);
    }

    public static void getChars(@NotNull CharSequence src, @NotNull char[] dst, int srcOffset, int dstOffset, int len) {
        if (src == null) {
            CharArrayUtil.$$$reportNull$$$0(4);
        }
        if (dst == null) {
            CharArrayUtil.$$$reportNull$$$0(5);
        }
        if (src instanceof CharArrayExternalizable) {
            ((CharArrayExternalizable)src).getChars(srcOffset, srcOffset + len, dst, dstOffset);
            return;
        }
        if (len >= 10) {
            if (src instanceof String) {
                ((String)src).getChars(srcOffset, srcOffset + len, dst, dstOffset);
                return;
            }
            if (src instanceof CharBuffer) {
                CharBuffer buffer = (CharBuffer)src;
                int i = buffer.position();
                buffer.position(i + srcOffset);
                buffer.get(dst, dstOffset, len);
                buffer.position(i);
                return;
            }
            if (src instanceof CharSequenceBackedByArray) {
                ((CharSequenceBackedByArray)src.subSequence(srcOffset, srcOffset + len)).getChars(dst, dstOffset);
                return;
            }
            if (src instanceof StringBuffer) {
                ((StringBuffer)src).getChars(srcOffset, srcOffset + len, dst, dstOffset);
                return;
            }
            if (src instanceof StringBuilder) {
                ((StringBuilder)src).getChars(srcOffset, srcOffset + len, dst, dstOffset);
                return;
            }
        }
        int i = 0;
        int max = srcOffset + len;
        for (int j = srcOffset; j < max && i < dst.length; ++i, ++j) {
            dst[i + dstOffset] = src.charAt(j);
        }
    }

    @NotNull
    public static char[] fromSequenceStrict(@NotNull CharSequence seq) {
        if (seq == null) {
            CharArrayUtil.$$$reportNull$$$0(6);
        }
        char[] cArray = CharArrayUtil.fromSequence(seq);
        if (cArray == null) {
            CharArrayUtil.$$$reportNull$$$0(7);
        }
        return cArray;
    }

    @Nullable
    public static char[] fromSequenceWithoutCopying(@Nullable CharSequence seq) {
        CharBuffer buffer;
        if (seq instanceof CharSequenceBackedByArray) {
            return ((CharSequenceBackedByArray)seq).getChars();
        }
        if (seq instanceof CharBuffer && (buffer = (CharBuffer)seq).hasArray() && !buffer.isReadOnly() && buffer.arrayOffset() == 0 && buffer.position() == 0) {
            return buffer.array();
        }
        return null;
    }

    @NotNull
    public static char[] fromSequence(@NotNull CharSequence seq) {
        char[] underlying;
        if (seq == null) {
            CharArrayUtil.$$$reportNull$$$0(8);
        }
        char[] cArray = (underlying = CharArrayUtil.fromSequenceWithoutCopying(seq)) != null ? Arrays.copyOf(underlying, underlying.length) : CharArrayUtil.fromSequence(seq, 0, seq.length());
        if (cArray == null) {
            CharArrayUtil.$$$reportNull$$$0(9);
        }
        return cArray;
    }

    @NotNull
    public static char[] fromSequence(@NotNull CharSequence seq, int start, int end) {
        if (seq == null) {
            CharArrayUtil.$$$reportNull$$$0(10);
        }
        char[] result = new char[end - start];
        CharArrayUtil.getChars(seq, result, start, 0, end - start);
        if (result == null) {
            CharArrayUtil.$$$reportNull$$$0(11);
        }
        return result;
    }

    public static int shiftForward(@NotNull CharSequence buffer, int offset, @NotNull String chars) {
        if (buffer == null) {
            CharArrayUtil.$$$reportNull$$$0(12);
        }
        if (chars == null) {
            CharArrayUtil.$$$reportNull$$$0(13);
        }
        return CharArrayUtil.shiftForward(buffer, offset, buffer.length(), chars);
    }

    public static int shiftForward(@NotNull CharSequence buffer, int startOffset, int endOffset, @NotNull String chars) {
        if (buffer == null) {
            CharArrayUtil.$$$reportNull$$$0(14);
        }
        if (chars == null) {
            CharArrayUtil.$$$reportNull$$$0(15);
        }
        int limit = Math.min(endOffset, buffer.length());
        for (int offset = startOffset; offset < limit; ++offset) {
            int i;
            char c = buffer.charAt(offset);
            for (i = 0; i < chars.length() && c != chars.charAt(i); ++i) {
            }
            if (i < chars.length()) continue;
            return offset;
        }
        return endOffset;
    }

    public static int shiftForwardCarefully(@NotNull CharSequence buffer, int offset, @NotNull String chars) {
        if (buffer == null) {
            CharArrayUtil.$$$reportNull$$$0(16);
        }
        if (chars == null) {
            CharArrayUtil.$$$reportNull$$$0(17);
        }
        if (offset + 1 >= buffer.length()) {
            return offset;
        }
        if (!CharArrayUtil.isSuitable(chars, buffer.charAt(offset))) {
            return offset;
        }
        ++offset;
        while (offset < buffer.length()) {
            char c = buffer.charAt(offset);
            if (!CharArrayUtil.isSuitable(chars, c)) {
                return offset - 1;
            }
            ++offset;
        }
        return offset - 1;
    }

    private static boolean isSuitable(@NotNull String chars, char c) {
        if (chars == null) {
            CharArrayUtil.$$$reportNull$$$0(18);
        }
        for (int i = 0; i < chars.length(); ++i) {
            if (c != chars.charAt(i)) continue;
            return true;
        }
        return false;
    }

    public static int shiftForward(@NotNull char[] buffer, int offset, @NotNull String chars) {
        if (buffer == null) {
            CharArrayUtil.$$$reportNull$$$0(19);
        }
        if (chars == null) {
            CharArrayUtil.$$$reportNull$$$0(20);
        }
        return CharArrayUtil.shiftForward(new CharArrayCharSequence(buffer), offset, chars);
    }

    public static int shiftBackward(@NotNull CharSequence buffer, int offset, @NotNull String chars) {
        if (buffer == null) {
            CharArrayUtil.$$$reportNull$$$0(21);
        }
        if (chars == null) {
            CharArrayUtil.$$$reportNull$$$0(22);
        }
        return CharArrayUtil.shiftBackward(buffer, 0, offset, chars);
    }

    public static int shiftBackward(@NotNull CharSequence buffer, int minOffset, int maxOffset, @NotNull String chars) {
        int offset;
        if (buffer == null) {
            CharArrayUtil.$$$reportNull$$$0(23);
        }
        if (chars == null) {
            CharArrayUtil.$$$reportNull$$$0(24);
        }
        if (maxOffset >= buffer.length()) {
            return maxOffset;
        }
        for (offset = maxOffset; offset >= minOffset; --offset) {
            int i;
            char c = buffer.charAt(offset);
            for (i = 0; i < chars.length() && c != chars.charAt(i); ++i) {
            }
            if (i == chars.length()) break;
        }
        return offset;
    }

    public static int shiftBackward(@NotNull char[] buffer, int offset, @NotNull String chars) {
        if (buffer == null) {
            CharArrayUtil.$$$reportNull$$$0(25);
        }
        if (chars == null) {
            CharArrayUtil.$$$reportNull$$$0(26);
        }
        return CharArrayUtil.shiftBackward(new CharArrayCharSequence(buffer), offset, chars);
    }

    public static int shiftForwardUntil(@NotNull CharSequence buffer, int offset, @NotNull String chars) {
        if (buffer == null) {
            CharArrayUtil.$$$reportNull$$$0(27);
        }
        if (chars == null) {
            CharArrayUtil.$$$reportNull$$$0(28);
        }
        while (offset < buffer.length()) {
            int i;
            char c = buffer.charAt(offset);
            for (i = 0; i < chars.length() && c != chars.charAt(i); ++i) {
            }
            if (i < chars.length()) break;
            ++offset;
        }
        return offset;
    }

    public static int shiftBackwardUntil(@NotNull CharSequence buffer, int offset, @NotNull String chars) {
        if (buffer == null) {
            CharArrayUtil.$$$reportNull$$$0(29);
        }
        if (chars == null) {
            CharArrayUtil.$$$reportNull$$$0(30);
        }
        if (offset >= buffer.length()) {
            return offset;
        }
        while (offset >= 0) {
            int i;
            char c = buffer.charAt(offset);
            for (i = 0; i < chars.length() && c != chars.charAt(i); ++i) {
            }
            if (i < chars.length()) break;
            --offset;
        }
        return offset;
    }

    public static boolean regionMatches(@NotNull char[] buffer, int start, int end, @NotNull CharSequence s) {
        int len;
        if (buffer == null) {
            CharArrayUtil.$$$reportNull$$$0(31);
        }
        if (s == null) {
            CharArrayUtil.$$$reportNull$$$0(32);
        }
        if (start + (len = s.length()) > end) {
            return false;
        }
        if (start < 0) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (buffer[start + i] == s.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean regionMatches(@NotNull CharSequence buffer, int start, int end, @NotNull CharSequence s) {
        int len;
        if (buffer == null) {
            CharArrayUtil.$$$reportNull$$$0(33);
        }
        if (s == null) {
            CharArrayUtil.$$$reportNull$$$0(34);
        }
        if (start + (len = s.length()) > end) {
            return false;
        }
        if (start < 0) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (buffer.charAt(start + i) == s.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean regionMatches(@NotNull CharSequence s1, int start1, int end1, @NotNull CharSequence s2, int start2, int end2) {
        if (s1 == null) {
            CharArrayUtil.$$$reportNull$$$0(35);
        }
        if (s2 == null) {
            CharArrayUtil.$$$reportNull$$$0(36);
        }
        if (end1 - start1 != end2 - start2) {
            return false;
        }
        int i = start1;
        int j = start2;
        while (i < end1) {
            if (s1.charAt(i) != s2.charAt(j)) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public static boolean regionMatches(@NotNull CharSequence buffer, int offset, @NotNull CharSequence s) {
        if (buffer == null) {
            CharArrayUtil.$$$reportNull$$$0(37);
        }
        if (s == null) {
            CharArrayUtil.$$$reportNull$$$0(38);
        }
        if (offset + s.length() > buffer.length()) {
            return false;
        }
        if (offset < 0) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (buffer.charAt(offset + i) == s.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(@NotNull char[] buffer1, int start1, int end1, @NotNull char[] buffer2, int start2, int end2) {
        if (buffer1 == null) {
            CharArrayUtil.$$$reportNull$$$0(39);
        }
        if (buffer2 == null) {
            CharArrayUtil.$$$reportNull$$$0(40);
        }
        if (end1 - start1 != end2 - start2) {
            return false;
        }
        for (int i = start1; i < end1; ++i) {
            if (buffer1[i] == buffer2[i - start1 + start2]) continue;
            return false;
        }
        return true;
    }

    public static int indexOf(@NotNull char[] buffer, @NotNull String pattern, int fromIndex) {
        if (buffer == null) {
            CharArrayUtil.$$$reportNull$$$0(41);
        }
        if (pattern == null) {
            CharArrayUtil.$$$reportNull$$$0(42);
        }
        char[] chars = pattern.toCharArray();
        int limit = buffer.length - chars.length + 1;
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        block0: for (int i = fromIndex; i < limit; ++i) {
            for (int j = 0; j < chars.length; ++j) {
                if (chars[j] != buffer[i + j]) continue block0;
            }
            return i;
        }
        return -1;
    }

    public static int indexOf(@NotNull CharSequence buffer, @NotNull CharSequence pattern, int fromIndex) {
        if (buffer == null) {
            CharArrayUtil.$$$reportNull$$$0(43);
        }
        if (pattern == null) {
            CharArrayUtil.$$$reportNull$$$0(44);
        }
        return CharArrayUtil.indexOf(buffer, pattern, fromIndex, buffer.length());
    }

    public static int indexOf(@NotNull CharSequence buffer, @NotNull CharSequence pattern, int fromIndex, int toIndex) {
        if (buffer == null) {
            CharArrayUtil.$$$reportNull$$$0(45);
        }
        if (pattern == null) {
            CharArrayUtil.$$$reportNull$$$0(46);
        }
        int patternLength = pattern.length();
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        int limit = toIndex - patternLength + 1;
        block0: for (int i = fromIndex; i < limit; ++i) {
            for (int j = 0; j < patternLength; ++j) {
                if (pattern.charAt(j) != buffer.charAt(i + j)) continue block0;
            }
            return i;
        }
        return -1;
    }

    public static int indexOf(@NotNull char[] buffer, char symbol, int fromIndex, int toIndex) {
        if (buffer == null) {
            CharArrayUtil.$$$reportNull$$$0(47);
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        for (int i = fromIndex; i < toIndex; ++i) {
            if (buffer[i] != symbol) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(@NotNull char[] buffer, char symbol, int fromIndex, int toIndex) {
        if (buffer == null) {
            CharArrayUtil.$$$reportNull$$$0(48);
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        for (int i = toIndex - 1; i >= fromIndex; --i) {
            if (buffer[i] != symbol) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(@NotNull CharSequence buffer, @NotNull String pattern, int maxIndex) {
        if (buffer == null) {
            CharArrayUtil.$$$reportNull$$$0(49);
        }
        if (pattern == null) {
            CharArrayUtil.$$$reportNull$$$0(50);
        }
        char[] chars = pattern.toCharArray();
        int end = buffer.length() - chars.length;
        if (maxIndex > end) {
            maxIndex = end;
        }
        block0: for (int i = maxIndex; i >= 0; --i) {
            for (int j = 0; j < chars.length; ++j) {
                if (chars[j] != buffer.charAt(i + j)) continue block0;
            }
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(@NotNull char[] buffer, @NotNull String pattern, int maxIndex) {
        char[] chars;
        int end;
        if (buffer == null) {
            CharArrayUtil.$$$reportNull$$$0(51);
        }
        if (pattern == null) {
            CharArrayUtil.$$$reportNull$$$0(52);
        }
        if (maxIndex > (end = buffer.length - (chars = pattern.toCharArray()).length)) {
            maxIndex = end;
        }
        block0: for (int i = maxIndex; i >= 0; --i) {
            for (int j = 0; j < chars.length; ++j) {
                if (chars[j] != buffer[i + j]) continue block0;
            }
            return i;
        }
        return -1;
    }

    public static boolean containsOnlyWhiteSpaces(@Nullable CharSequence chars) {
        if (chars == null) {
            return true;
        }
        for (int i = 0; i < chars.length(); ++i) {
            char c = chars.charAt(i);
            if (c == ' ' || c == '\t' || c == '\n' || c == '\r') continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static TextRange[] getIndents(@NotNull CharSequence charsSequence, int shift) {
        if (charsSequence == null) {
            CharArrayUtil.$$$reportNull$$$0(53);
        }
        List result = new ArrayList<TextRange>();
        int whitespaceEnd = -1;
        int lastTextFound = 0;
        for (int i = charsSequence.length() - 1; i >= 0; --i) {
            char charAt = charsSequence.charAt(i);
            boolean isWhitespace = Character.isWhitespace(charAt);
            if (charAt == '\n') {
                result.add(new TextRange(i, (whitespaceEnd >= 0 ? whitespaceEnd : i) + 1).shiftRight(shift));
                whitespaceEnd = -1;
                continue;
            }
            if (whitespaceEnd >= 0) {
                if (isWhitespace) continue;
                lastTextFound = result.size();
                whitespaceEnd = -1;
                continue;
            }
            if (isWhitespace) {
                whitespaceEnd = i;
                continue;
            }
            lastTextFound = result.size();
        }
        if (whitespaceEnd > 0) {
            result.add(new TextRange(0, whitespaceEnd + 1).shiftRight(shift));
        }
        if (lastTextFound < result.size()) {
            result = result.subList(0, lastTextFound);
        }
        TextRange[] textRangeArray = result.toArray(new TextRange[0]);
        if (textRangeArray == null) {
            CharArrayUtil.$$$reportNull$$$0(54);
        }
        return textRangeArray;
    }

    public static boolean containLineBreaks(@NotNull CharSequence seq) {
        if (seq == null) {
            CharArrayUtil.$$$reportNull$$$0(55);
        }
        return CharArrayUtil.containLineBreaks(seq, 0, seq.length());
    }

    public static boolean containLineBreaks(@Nullable CharSequence seq, int fromOffset, int endOffset) {
        if (seq == null) {
            return false;
        }
        for (int i = fromOffset; i < endOffset; ++i) {
            char c = seq.charAt(i);
            if (c != '\n' && c != '\r') continue;
            return true;
        }
        return false;
    }

    public static boolean isEmptyOrSpaces(@NotNull CharSequence text, int start, int end) {
        if (text == null) {
            CharArrayUtil.$$$reportNull$$$0(56);
        }
        for (int i = start; i < end; ++i) {
            char c = text.charAt(i);
            if (c == ' ' || c == '\t' || c == '\n') continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static Reader readerFromCharSequence(@NotNull CharSequence text) {
        char[] chars;
        if (text == null) {
            CharArrayUtil.$$$reportNull$$$0(57);
        }
        Reader reader = (chars = CharArrayUtil.fromSequenceWithoutCopying(text)) == null ? new CharSequenceReader(text.toString()) : new UnsyncCharArrayReader(chars, 0, text.length());
        if (reader == null) {
            CharArrayUtil.$$$reportNull$$$0(58);
        }
        return reader;
    }

    @NotNull
    public static ImmutableCharSequence createImmutableCharSequence(@NotNull CharSequence sequence) {
        if (sequence == null) {
            CharArrayUtil.$$$reportNull$$$0(59);
        }
        ImmutableText immutableText = ImmutableText.valueOf((Object)sequence);
        if (immutableText == null) {
            CharArrayUtil.$$$reportNull$$$0(60);
        }
        return immutableText;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 54: 
            case 58: 
            case 60: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 54: 
            case 58: 
            case 60: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "src";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dst";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "seq";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 54: 
            case 58: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/text/CharArrayUtil";
                break;
            }
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 37: 
            case 41: 
            case 43: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars";
                break;
            }
            case 32: 
            case 34: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s1";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s2";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer1";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer2";
                break;
            }
            case 42: 
            case 44: 
            case 46: 
            case 50: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charsSequence";
                break;
            }
            case 56: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/text/CharArrayUtil";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "fromSequenceStrict";
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "fromSequence";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndents";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "readerFromCharSequence";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "createImmutableCharSequence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getChars";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fromSequenceStrict";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 54: 
            case 58: 
            case 60: {
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "fromSequence";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "shiftForward";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "shiftForwardCarefully";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isSuitable";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "shiftBackward";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "shiftForwardUntil";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "shiftBackwardUntil";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "regionMatches";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "equals";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "indexOf";
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOf";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getIndents";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "containLineBreaks";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "isEmptyOrSpaces";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "readerFromCharSequence";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "createImmutableCharSequence";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 54: 
            case 58: 
            case 60: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

