/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.ui;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.intellij.images.ImagesBundle;
import org.intellij.images.editor.ImageDocument;
import org.intellij.images.options.GridOptions;
import org.intellij.images.options.TransparencyChessboardOptions;
import org.intellij.images.ui.ImageComponentUI;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class ImageComponent
extends JComponent {
    public static final int IMAGE_INSETS = 2;
    @NonNls
    public static final String TRANSPARENCY_CHESSBOARD_CELL_SIZE_PROP = "TransparencyChessboard.cellSize";
    @NonNls
    public static final String TRANSPARENCY_CHESSBOARD_WHITE_COLOR_PROP = "TransparencyChessboard.whiteColor";
    @NonNls
    public static final String TRANSPARENCY_CHESSBOARD_BLACK_COLOR_PROP = "TransparencyChessboard.blackColor";
    @NonNls
    private static final String TRANSPARENCY_CHESSBOARD_VISIBLE_PROP = "TransparencyChessboard.visible";
    @NonNls
    private static final String GRID_LINE_ZOOM_FACTOR_PROP = "Grid.lineZoomFactor";
    @NonNls
    private static final String GRID_LINE_SPAN_PROP = "Grid.lineSpan";
    @NonNls
    private static final String GRID_LINE_COLOR_PROP = "Grid.lineColor";
    @NonNls
    private static final String GRID_VISIBLE_PROP = "Grid.visible";
    @NonNls
    private static final String FILE_SIZE_VISIBLE_PROP = "FileSize.visible";
    @NonNls
    private static final String FILE_NAME_VISIBLE_PROP = "FileName.visible";
    @NonNls
    private static final String uiClassID = "ImageComponentUI";
    private final ImageDocument document = new ImageDocumentImpl(this);
    private final Grid grid = new Grid();
    private final Chessboard chessboard = new Chessboard();
    private boolean myFileSizeVisible = true;
    private boolean myFileNameVisible = true;
    private double zoomFactor = 1.0;

    public ImageComponent() {
        this.updateUI();
    }

    public ImageDocument getDocument() {
        return this.document;
    }

    public double getZoomFactor() {
        return this.zoomFactor;
    }

    public void setZoomFactor(double zoomFactor) {
        this.zoomFactor = zoomFactor;
    }

    public void setTransparencyChessboardCellSize(int cellSize) {
        int oldValue = this.chessboard.getCellSize();
        if (oldValue != cellSize) {
            this.chessboard.setCellSize(cellSize);
            this.firePropertyChange(TRANSPARENCY_CHESSBOARD_CELL_SIZE_PROP, oldValue, cellSize);
        }
    }

    public void setTransparencyChessboardWhiteColor(Color color) {
        Color oldValue = this.chessboard.getWhiteColor();
        if (oldValue != null && !oldValue.equals(color) || oldValue == null && color != null) {
            this.chessboard.setWhiteColor(color);
            this.firePropertyChange(TRANSPARENCY_CHESSBOARD_WHITE_COLOR_PROP, oldValue, color);
        }
    }

    public void setTransparencyChessboardBlankColor(Color color) {
        Color oldValue = this.chessboard.getBlackColor();
        if (oldValue != null && !oldValue.equals(color) || oldValue == null && color != null) {
            this.chessboard.setBlackColor(color);
            this.firePropertyChange(TRANSPARENCY_CHESSBOARD_BLACK_COLOR_PROP, oldValue, color);
        }
    }

    public void setTransparencyChessboardVisible(boolean visible) {
        boolean oldValue = this.chessboard.isVisible();
        if (oldValue != visible) {
            this.chessboard.setVisible(visible);
            this.firePropertyChange(TRANSPARENCY_CHESSBOARD_VISIBLE_PROP, oldValue, visible);
        }
    }

    public int getTransparencyChessboardCellSize() {
        return this.chessboard.getCellSize();
    }

    public Color getTransparencyChessboardWhiteColor() {
        return this.chessboard.getWhiteColor();
    }

    public Color getTransparencyChessboardBlackColor() {
        return this.chessboard.getBlackColor();
    }

    public boolean isTransparencyChessboardVisible() {
        return this.chessboard.isVisible();
    }

    public boolean isFileSizeVisible() {
        return this.myFileSizeVisible;
    }

    public void setFileSizeVisible(boolean fileSizeVisible) {
        boolean oldValue = this.myFileSizeVisible;
        this.myFileSizeVisible = fileSizeVisible;
        this.firePropertyChange(FILE_SIZE_VISIBLE_PROP, oldValue, fileSizeVisible);
    }

    public boolean isFileNameVisible() {
        return this.myFileNameVisible;
    }

    public void setFileNameVisible(boolean fileNameVisible) {
        boolean oldValue = this.myFileNameVisible;
        this.myFileNameVisible = fileNameVisible;
        this.firePropertyChange(FILE_NAME_VISIBLE_PROP, oldValue, fileNameVisible);
    }

    public void setGridLineZoomFactor(int lineZoomFactor) {
        int oldValue = this.grid.getLineZoomFactor();
        if (oldValue != lineZoomFactor) {
            this.grid.setLineZoomFactor(lineZoomFactor);
            this.firePropertyChange(GRID_LINE_ZOOM_FACTOR_PROP, oldValue, lineZoomFactor);
        }
    }

    public void setGridLineSpan(int lineSpan) {
        int oldValue = this.grid.getLineSpan();
        if (oldValue != lineSpan) {
            this.grid.setLineSpan(lineSpan);
            this.firePropertyChange(GRID_LINE_SPAN_PROP, oldValue, lineSpan);
        }
    }

    public void setGridLineColor(Color color) {
        Color oldValue = this.grid.getLineColor();
        if (oldValue != null && !oldValue.equals(color) || oldValue == null && color != null) {
            this.grid.setLineColor(color);
            this.firePropertyChange(GRID_LINE_COLOR_PROP, oldValue, color);
        }
    }

    public void setGridVisible(boolean visible) {
        boolean oldValue = this.grid.isVisible();
        if (oldValue != visible) {
            this.grid.setVisible(visible);
            this.firePropertyChange(GRID_VISIBLE_PROP, oldValue, visible);
        }
    }

    public int getGridLineZoomFactor() {
        return this.grid.getLineZoomFactor();
    }

    public int getGridLineSpan() {
        return this.grid.getLineSpan();
    }

    public Color getGridLineColor() {
        return this.grid.getLineColor();
    }

    public boolean isGridVisible() {
        return this.grid.isVisible();
    }

    @Nullable
    public String getDescription() {
        BufferedImage image = this.getDocument().getValue();
        if (image != null) {
            return ImagesBundle.message("icon.dimensions", image.getWidth(), image.getHeight(), image.getColorModel().getPixelSize());
        }
        return null;
    }

    public void setCanvasSize(int width, int height) {
        this.setSize(width + 4, height + 4);
    }

    public void setCanvasSize(Dimension dimension) {
        this.setCanvasSize(dimension.width, dimension.height);
    }

    public Dimension getCanvasSize() {
        Dimension size = this.getSize();
        return new Dimension(size.width - 4, size.height - 4);
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public void updateUI() {
        this.setUI(UIManager.getUI(this));
    }

    static {
        UIManager.getDefaults().put(uiClassID, ImageComponentUI.class.getName());
    }

    private static final class Grid {
        private int lineZoomFactor = 3;
        private int lineSpan = 1;
        private Color lineColor = GridOptions.DEFAULT_LINE_COLOR;
        private boolean visible = false;

        private Grid() {
        }

        public int getLineZoomFactor() {
            return this.lineZoomFactor;
        }

        public void setLineZoomFactor(int lineZoomFactor) {
            this.lineZoomFactor = lineZoomFactor;
        }

        public int getLineSpan() {
            return this.lineSpan;
        }

        public void setLineSpan(int lineSpan) {
            this.lineSpan = lineSpan;
        }

        public Color getLineColor() {
            return this.lineColor;
        }

        public void setLineColor(Color lineColor) {
            this.lineColor = lineColor;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public void setVisible(boolean visible) {
            this.visible = visible;
        }
    }

    private static final class Chessboard {
        private int cellSize = 5;
        private Color whiteColor = TransparencyChessboardOptions.DEFAULT_WHITE_COLOR;
        private Color blackColor = TransparencyChessboardOptions.DEFAULT_BLACK_COLOR;
        private boolean visible = false;

        private Chessboard() {
        }

        public int getCellSize() {
            return this.cellSize;
        }

        public void setCellSize(int cellSize) {
            this.cellSize = cellSize;
        }

        public Color getWhiteColor() {
            return this.whiteColor;
        }

        public void setWhiteColor(Color whiteColor) {
            this.whiteColor = whiteColor;
        }

        public Color getBlackColor() {
            return this.blackColor;
        }

        public void setBlackColor(Color blackColor) {
            this.blackColor = blackColor;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public void setVisible(boolean visible) {
            this.visible = visible;
        }
    }

    private static class ImageDocumentImpl
    implements ImageDocument {
        private final List<ChangeListener> listeners = ContainerUtil.createLockFreeCopyOnWriteList();
        private ImageDocument.CachedScaledImageProvider imageProvider;
        private String format;
        private Image renderer;
        private final Component myComponent;
        private final JBUI.ScaleContext.Cache<Rectangle> cachedBounds = new JBUI.ScaleContext.Cache(ctx -> {
            BufferedImage image = this.getValue(ctx.getScale(JBUI.ScaleType.OBJ_SCALE));
            return image != null ? new Rectangle(image.getWidth(), image.getHeight()) : null;
        });

        public ImageDocumentImpl(Component component) {
            this.myComponent = component;
            this.myComponent.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals("ancestor") && e.getNewValue() == null && imageProvider != null) {
                        imageProvider.clearCache();
                    }
                }
            });
        }

        @Override
        public Image getRenderer() {
            return this.renderer;
        }

        @Override
        public Image getRenderer(double scale) {
            return this.getValue(scale);
        }

        @Override
        @Nullable
        public Rectangle getBounds(double scale) {
            JBUI.ScaleContext ctx = JBUI.ScaleContext.create((Component)this.myComponent);
            ctx.update(JBUI.ScaleType.OBJ_SCALE.of(scale));
            return (Rectangle)this.cachedBounds.getOrProvide((JBUI.BaseScaleContext)ctx);
        }

        @Override
        public BufferedImage getValue() {
            return this.getValue(1.0);
        }

        @Override
        public BufferedImage getValue(double scale) {
            return this.imageProvider != null ? (BufferedImage)this.imageProvider.apply(scale, this.myComponent) : null;
        }

        @Override
        public void setValue(BufferedImage image) {
            this.renderer = image != null ? Toolkit.getDefaultToolkit().createImage(image.getSource()) : null;
            this.setValue(image != null ? (scale, anchor2) -> image : null);
        }

        @Override
        public void setValue(ImageDocument.ScaledImageProvider imageProvider) {
            this.imageProvider = imageProvider instanceof ImageDocument.CachedScaledImageProvider ? (ImageDocument.CachedScaledImageProvider)imageProvider : (imageProvider != null ? (zoom, ancestor) -> (BufferedImage)imageProvider.apply(zoom, ancestor) : null);
            this.cachedBounds.clear();
            this.fireChangeEvent(new ChangeEvent(this));
        }

        @Override
        public String getFormat() {
            return this.format;
        }

        @Override
        public void setFormat(String format) {
            this.format = format;
            this.fireChangeEvent(new ChangeEvent(this));
        }

        private void fireChangeEvent(ChangeEvent e) {
            for (ChangeListener listener2 : this.listeners) {
                listener2.stateChanged(e);
            }
        }

        @Override
        public void addChangeListener(ChangeListener listener2) {
            this.listeners.add(listener2);
        }

        @Override
        public void removeChangeListener(ChangeListener listener2) {
            this.listeners.remove(listener2);
        }
    }
}

