/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.pipenv;

import com.intellij.application.options.ModuleListCellRenderer;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.PlatformUtils;
import com.intellij.util.text.StringKt;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.StatusText;
import com.jetbrains.python.PythonModuleTypeBase;
import com.jetbrains.python.sdk.PyDetectedSdk;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PySdkSettings;
import com.jetbrains.python.sdk.add.PyAddNewEnvPanel;
import com.jetbrains.python.sdk.add.PySdkPathChoosingComboBox;
import com.jetbrains.python.sdk.pipenv.PipenvKt;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.nio.file.Files;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B1\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016J\n\u0010)\u001a\u0004\u0018\u00010\bH\u0016J\b\u0010*\u001a\u00020&H\u0002J\u000e\u0010+\u001a\b\u0012\u0004\u0012\u00020,0\u0007H\u0016J\n\u0010-\u001a\u0004\u0018\u00010,H\u0002J\n\u0010.\u001a\u0004\u0018\u00010,H\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0010\"\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0010R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010 \u001a\u0004\u0018\u00010\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0010R\u0016\u0010\"\u001a\u0004\u0018\u00010\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\u00a8\u0006/"}, d2={"Lcom/jetbrains/python/sdk/pipenv/PyAddPipEnvPanel;", "Lcom/jetbrains/python/sdk/add/PyAddNewEnvPanel;", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "existingSdks", "", "Lcom/intellij/openapi/projectRoots/Sdk;", "newProjectPath", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/module/Module;Ljava/util/List;Ljava/lang/String;)V", "baseSdkField", "Lcom/jetbrains/python/sdk/add/PySdkPathChoosingComboBox;", "envName", "getEnvName", "()Ljava/lang/String;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "installPackagesCheckBox", "Lcom/intellij/ui/components/JBCheckBox;", "moduleField", "Ljavax/swing/JComboBox;", "getNewProjectPath", "setNewProjectPath", "(Ljava/lang/String;)V", "panelName", "getPanelName", "pipEnvPathField", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "projectPath", "getProjectPath", "selectedModule", "getSelectedModule", "()Lcom/intellij/openapi/module/Module;", "addChangeListener", "", "listener", "Ljava/lang/Runnable;", "getOrCreateSdk", "update", "validateAll", "Lcom/intellij/openapi/ui/ValidationInfo;", "validatePipEnvExecutable", "validatePipEnvIsNotAdded", "intellij.python.community.impl"})
public final class PyAddPipEnvPanel
extends PyAddNewEnvPanel {
    @NotNull
    private final String envName = "Pipenv";
    @NotNull
    private final String panelName = "Pipenv Environment";
    @NotNull
    private final Icon icon;
    private final JComboBox<Module> moduleField;
    private final PySdkPathChoosingComboBox baseSdkField;
    private final JBCheckBox installPackagesCheckBox;
    private final TextFieldWithBrowseButton pipEnvPathField;
    private final Project project;
    private final Module module;
    private final List<Sdk> existingSdks;
    @Nullable
    private String newProjectPath;

    @Override
    @NotNull
    public String getEnvName() {
        return this.envName;
    }

    @Override
    @NotNull
    public String getPanelName() {
        return this.panelName;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    @Nullable
    public Sdk getOrCreateSdk() {
        Sdk sdk;
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)propertiesComponent, (String)"PropertiesComponent.getInstance()");
        PipenvKt.setPipEnvPath(propertiesComponent, StringKt.nullize$default((String)this.pipEnvPathField.getText(), (boolean)false, (int)1, null));
        Sdk sdk2 = this.baseSdkField.getSelectedSdk();
        Sdk sdk3 = PipenvKt.setupPipEnvSdkUnderProgress(this.project, this.getSelectedModule(), this.existingSdks, this.getNewProjectPath(), sdk2 != null ? sdk2.getHomePath() : null, this.installPackagesCheckBox.isSelected());
        if (sdk3 != null) {
            Sdk sdk4;
            Sdk $receiver = sdk4 = sdk3;
            Sdk sdk5 = this.baseSdkField.getSelectedSdk();
            PySdkSettings.Companion.getInstance().setPreferredVirtualEnvBaseSdk(sdk5 != null ? sdk5.getHomePath() : null);
            sdk = sdk4;
        } else {
            sdk = null;
        }
        return sdk;
    }

    @Override
    @NotNull
    public List<ValidationInfo> validateAll() {
        return CollectionsKt.listOfNotNull((Object[])new ValidationInfo[]{this.validatePipEnvExecutable(), this.validatePipEnvIsNotAdded()});
    }

    @Override
    public void addChangeListener(@NotNull Runnable listener2) {
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
        JTextField jTextField = this.pipEnvPathField.getTextField();
        Intrinsics.checkExpressionValueIsNotNull((Object)jTextField, (String)"pipEnvPathField.textField");
        jTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(listener2){
            final /* synthetic */ Runnable $listener;

            protected void textChanged(@Nullable DocumentEvent e) {
                this.$listener.run();
            }
            {
                this.$listener = $captured_local_variable$0;
            }
        });
        super.addChangeListener(listener2);
    }

    private final void update() {
        block0: {
            Module module2 = this.getSelectedModule();
            if (module2 == null) break block0;
            Module module3 = module2;
            Module it = module3;
            this.installPackagesCheckBox.setEnabled(PipenvKt.getPipFile(it) != null);
        }
    }

    private final Module getSelectedModule() {
        Module module2 = this.module;
        if (module2 == null) {
            Object object = this.moduleField.getSelectedItem();
            if (!(object instanceof Module)) {
                object = null;
            }
            module2 = (Module)object;
        }
        return module2;
    }

    private final ValidationInfo validatePipEnvExecutable() {
        File file2;
        String string = StringKt.nullize$default((String)this.pipEnvPathField.getText(), (boolean)false, (int)1, null);
        if (string != null) {
            String string2;
            String it = string2 = string;
            file2 = new File(it);
        } else {
            file2 = PipenvKt.detectPipEnvExecutable();
        }
        if (file2 == null) {
            return new ValidationInfo("Pipenv executable is not found");
        }
        File executable = file2;
        return !executable.exists() ? new ValidationInfo("File " + executable.getAbsolutePath() + " is not found") : (!Files.isExecutable(executable.toPath()) || !executable.isFile() ? new ValidationInfo("Cannot execute " + executable.getAbsolutePath()) : null);
    }

    private final ValidationInfo validatePipEnvIsNotAdded() {
        Object v1;
        block3: {
            Iterable iterable;
            String string = this.getProjectPath();
            if (string == null) {
                return null;
            }
            String path = string;
            Iterable iterable2 = iterable = (Iterable)this.existingSdks;
            for (Object t : iterable2) {
                Sdk it = (Sdk)t;
                if (!(Intrinsics.areEqual((Object)PySdkExtKt.getAssociatedModulePath(it), (Object)path) && PipenvKt.isPipEnv(it))) continue;
                v1 = t;
                break block3;
            }
            v1 = null;
        }
        Sdk sdk = v1;
        if (sdk == null) {
            return null;
        }
        Sdk addedPipEnv = sdk;
        return new ValidationInfo("Pipenv interpreter has been already added, select \"" + addedPipEnv.getName() + "\" in your interpreters list");
    }

    private final String getProjectPath() {
        String string;
        String string2 = this.getNewProjectPath();
        if (string2 == null) {
            Module module2 = this.getSelectedModule();
            string2 = string = module2 != null ? PySdkExtKt.getBasePath(module2) : null;
        }
        if (string2 == null) {
            Project project = this.project;
            string = project != null ? project.getBasePath() : null;
        }
        return string;
    }

    @Override
    @Nullable
    public String getNewProjectPath() {
        return this.newProjectPath;
    }

    @Override
    public void setNewProjectPath(@Nullable String string) {
        this.newProjectPath = string;
    }

    public PyAddPipEnvPanel(@Nullable Project project, @Nullable Module module2, @NotNull List<? extends Sdk> existingSdks, @Nullable String newProjectPath) {
        FormBuilder builder2;
        FormBuilder formBuilder;
        Object $receiver$iv;
        JComboBox<Module> jComboBox;
        PySdkPathChoosingComboBox it;
        Sdk sdk;
        Object v0;
        Object object;
        String preferredSdkPath;
        PySdkPathChoosingComboBox $receiver;
        PyAddPipEnvPanel pyAddPipEnvPanel;
        PySdkPathChoosingComboBox pySdkPathChoosingComboBox;
        block14: {
            Intrinsics.checkParameterIsNotNull(existingSdks, (String)"existingSdks");
            this.project = project;
            this.module = module2;
            this.existingSdks = existingSdks;
            this.newProjectPath = newProjectPath;
            this.envName = "Pipenv";
            this.panelName = "Pipenv Environment";
            this.icon = PipenvKt.getPIPENV_ICON();
            pySdkPathChoosingComboBox = new PySdkPathChoosingComboBox(PySdkExtKt.findBaseSdks(this.existingSdks, this.module), null);
            pyAddPipEnvPanel = this;
            $receiver = pySdkPathChoosingComboBox;
            preferredSdkPath = PySdkSettings.Companion.getInstance().getPreferredVirtualEnvBaseSdk();
            Iterable iterable = object = (Iterable)$receiver.getItems();
            for (Object t : iterable) {
                Sdk it2 = (Sdk)t;
                if (!Intrinsics.areEqual((Object)it2.getHomePath(), (Object)preferredSdkPath)) continue;
                v0 = t;
                break block14;
            }
            v0 = null;
        }
        Sdk detectedPreferredSdk = v0;
        PySdkPathChoosingComboBox pySdkPathChoosingComboBox2 = $receiver;
        if (detectedPreferredSdk != null) {
            sdk = detectedPreferredSdk;
        } else if (preferredSdkPath != null) {
            object = new PyDetectedSdk(preferredSdkPath);
            PySdkPathChoosingComboBox pySdkPathChoosingComboBox3 = pySdkPathChoosingComboBox2;
            Object $receiver2 = object;
            ((JComboBox)$receiver.getChildComponent()).insertItemAt($receiver2, 0);
            Object object2 = object;
            pySdkPathChoosingComboBox2 = pySdkPathChoosingComboBox3;
            sdk = (Sdk)object2;
        } else {
            sdk = (Sdk)CollectionsKt.getOrNull($receiver.getItems(), (int)0);
        }
        pySdkPathChoosingComboBox2.setSelectedSdk(sdk);
        Object object3 = pySdkPathChoosingComboBox;
        pyAddPipEnvPanel.baseSdkField = object3;
        pySdkPathChoosingComboBox = new JBCheckBox("Install packages from Pipfile");
        pyAddPipEnvPanel = this;
        $receiver = pySdkPathChoosingComboBox;
        $receiver.setVisible(this.getNewProjectPath() == null);
        $receiver.setSelected($receiver.isVisible());
        object3 = pySdkPathChoosingComboBox;
        pyAddPipEnvPanel.installPackagesCheckBox = object3;
        pySdkPathChoosingComboBox = new TextFieldWithBrowseButton();
        pyAddPipEnvPanel = this;
        $receiver = pySdkPathChoosingComboBox;
        $receiver.addBrowseFolderListener(null, null, null, FileChooserDescriptorFactory.createSingleFileDescriptor());
        JTextField jTextField = $receiver.getTextField();
        if (!(jTextField instanceof JBTextField)) {
            jTextField = null;
        }
        JBTextField jBTextField = (JBTextField)jTextField;
        if (jBTextField == null) {
        } else {
            Object it3;
            JBTextField field = jBTextField;
            File file2 = PipenvKt.detectPipEnvExecutable();
            if (file2 != null) {
                object = file2;
                it3 = object;
                StatusText statusText = field.getEmptyText();
                Intrinsics.checkExpressionValueIsNotNull((Object)statusText, (String)"field.emptyText");
                statusText.setText("Auto-detected: " + ((File)it3).getAbsolutePath());
            }
            PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)propertiesComponent, (String)"PropertiesComponent.getInstance()");
            String string = PipenvKt.getPipEnvPath(propertiesComponent);
            if (string != null) {
                object = string;
                it3 = object;
                field.setText((String)it3);
            }
        }
        object3 = pySdkPathChoosingComboBox;
        pyAddPipEnvPanel.pipEnvPathField = object3;
        this.setLayout(new BorderLayout());
        Object object4 = this.project;
        if (object4 == null || (object4 = ModuleUtil.getModulesOfType((Project)(it = ($receiver = object4)), (ModuleType)PythonModuleTypeBase.getInstance())) == null) {
            object4 = CollectionsKt.emptyList();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"project?.let {\n      Mod\u2026e())\n    } ?: emptyList()");
        Project modules = object4;
        $receiver = modules;
        JComboBox<Module> jComboBox2 = jComboBox;
        object3 = jComboBox;
        pyAddPipEnvPanel = this;
        void v11 = $receiver$iv;
        if (v11 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        void thisCollection$iv = v11;
        Module[] moduleArray = thisCollection$iv.toArray(new Module[0]);
        if (moduleArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Module[] moduleArray2 = moduleArray;
        jComboBox2(moduleArray2);
        Object $receiver3 = $receiver$iv = object3;
        ((JComboBox)$receiver3).setRenderer((ListCellRenderer)((Object)new ModuleListCellRenderer()));
        ((JComponent)$receiver3).setPreferredSize(new Dimension(Integer.MAX_VALUE, ((JComponent)$receiver3).getPreferredSize().height));
        ((JComboBox)$receiver3).addItemListener(new ItemListener(this){
            final /* synthetic */ PyAddPipEnvPanel this$0;
            {
                this.this$0 = pyAddPipEnvPanel;
            }

            public final void itemStateChanged(ItemEvent it) {
                ItemEvent itemEvent = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)itemEvent, (String)"it");
                if (itemEvent.getStateChange() == 1) {
                    PyAddPipEnvPanel.access$update(this.this$0);
                }
            }
        });
        pyAddPipEnvPanel.moduleField = object3 = $receiver$iv;
        JTextField jTextField2 = this.pipEnvPathField.getTextField();
        Intrinsics.checkExpressionValueIsNotNull((Object)jTextField2, (String)"pipEnvPathField.textField");
        jTextField2.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@Nullable DocumentEvent e) {
                this.update();
            }
        });
        FormBuilder $receiver4 = formBuilder = FormBuilder.createFormBuilder();
        if (this.module == null && modules.size() > 1) {
            String associatedObject = PlatformUtils.isPyCharm() ? "project" : "module";
            $receiver4.addLabeledComponent("Associated " + associatedObject + ':', (JComponent)this.moduleField);
        }
        $receiver4.addLabeledComponent("Base interpreter:", (JComponent)((Object)this.baseSdkField));
        $receiver4.addComponent((JComponent)this.installPackagesCheckBox);
        $receiver4.addLabeledComponent("Pipenv executable:", (JComponent)this.pipEnvPathField);
        FormBuilder formBuilder2 = builder2 = formBuilder;
        Intrinsics.checkExpressionValueIsNotNull((Object)formBuilder2, (String)"builder");
        this.add((Component)formBuilder2.getPanel(), "North");
        this.update();
    }
}

