/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.parsing.ExpressionParsing;
import com.jetbrains.python.parsing.FunctionParsing;
import com.jetbrains.python.parsing.ParsingContext;
import com.jetbrains.python.parsing.StatementParsing;
import com.jetbrains.python.psi.PyElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Parsing {
    protected ParsingContext myContext;
    protected PsiBuilder myBuilder;
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.python.parsing.Parsing");

    protected Parsing(ParsingContext context) {
        this.myContext = context;
        this.myBuilder = context.getBuilder();
    }

    public ParsingContext getParsingContext() {
        return this.myContext;
    }

    public ExpressionParsing getExpressionParser() {
        return this.getParsingContext().getExpressionParser();
    }

    public StatementParsing getStatementParser() {
        return this.getParsingContext().getStatementParser();
    }

    public FunctionParsing getFunctionParser() {
        return this.getParsingContext().getFunctionParser();
    }

    protected boolean checkMatches(IElementType token, String message) {
        if (this.myBuilder.getTokenType() == token) {
            this.myBuilder.advanceLexer();
            return true;
        }
        this.myBuilder.error(message);
        return false;
    }

    protected boolean parseIdentifierOrSkip(IElementType ... validSuccessiveTokens) {
        if (validSuccessiveTokens == null) {
            Parsing.$$$reportNull$$$0(0);
        }
        if (this.myBuilder.getTokenType() == PyTokenTypes.IDENTIFIER) {
            this.myBuilder.advanceLexer();
            return true;
        }
        PsiBuilder.Marker nameExpected = this.myBuilder.mark();
        if (this.myBuilder.getTokenType() != PyTokenTypes.STATEMENT_BREAK && !this.atAnyOfTokens(validSuccessiveTokens)) {
            this.myBuilder.advanceLexer();
        }
        nameExpected.error(PyBundle.message("PARSE.expected.identifier", new Object[0]));
        return false;
    }

    protected void assertCurrentToken(PyElementType tokenType) {
        LOG.assertTrue(this.myBuilder.getTokenType() == tokenType);
    }

    protected boolean atToken(@Nullable IElementType tokenType) {
        return this.myBuilder.getTokenType() == tokenType;
    }

    protected boolean atToken(@NotNull IElementType tokenType, @NotNull String tokenText) {
        if (tokenType == null) {
            Parsing.$$$reportNull$$$0(1);
        }
        if (tokenText == null) {
            Parsing.$$$reportNull$$$0(2);
        }
        return this.myBuilder.getTokenType() == tokenType && tokenText.equals(this.myBuilder.getTokenText());
    }

    protected boolean atAnyOfTokens(IElementType ... tokenTypes) {
        IElementType currentTokenType = this.myBuilder.getTokenType();
        for (IElementType tokenType : tokenTypes) {
            if (currentTokenType != tokenType) continue;
            return true;
        }
        return false;
    }

    protected boolean matchToken(IElementType tokenType) {
        if (this.myBuilder.getTokenType() == tokenType) {
            this.myBuilder.advanceLexer();
            return true;
        }
        return false;
    }

    protected void nextToken() {
        this.myBuilder.advanceLexer();
    }

    protected void advanceAsync(boolean falseAsync) {
        if (falseAsync) {
            Parsing.advanceError(this.myBuilder, "'async' keyword is not expected here");
        } else {
            this.myBuilder.advanceLexer();
        }
    }

    protected static void advanceIdentifierLike(@NotNull PsiBuilder builder2) {
        if (builder2 == null) {
            Parsing.$$$reportNull$$$0(3);
        }
        if (Parsing.isFalseIdentifier(builder2)) {
            String tokenText = builder2.getTokenText();
            Parsing.advanceError(builder2, "'" + tokenText + "' keyword can't be used as identifier in Python 2");
        } else {
            builder2.advanceLexer();
        }
    }

    protected static void advanceError(@NotNull PsiBuilder builder2, String message) {
        if (builder2 == null) {
            Parsing.$$$reportNull$$$0(4);
        }
        PsiBuilder.Marker err = builder2.mark();
        builder2.advanceLexer();
        err.error(message);
    }

    protected static boolean isIdentifier(@NotNull PsiBuilder builder2) {
        if (builder2 == null) {
            Parsing.$$$reportNull$$$0(5);
        }
        return builder2.getTokenType() == PyTokenTypes.IDENTIFIER || Parsing.isFalseIdentifier(builder2);
    }

    private static boolean isFalseIdentifier(@NotNull PsiBuilder builder2) {
        if (builder2 == null) {
            Parsing.$$$reportNull$$$0(6);
        }
        return builder2.getTokenType() == PyTokenTypes.EXEC_KEYWORD || builder2.getTokenType() == PyTokenTypes.PRINT_KEYWORD;
    }

    protected static void buildTokenElement(IElementType type, PsiBuilder builder2) {
        PsiBuilder.Marker marker = builder2.mark();
        Parsing.advanceIdentifierLike(builder2);
        marker.done(type);
    }

    protected IElementType getReferenceType() {
        return PyElementTypes.REFERENCE_EXPRESSION;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validSuccessiveTokens";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenText";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/parsing/Parsing";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "parseIdentifierOrSkip";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "atToken";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "advanceIdentifierLike";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "advanceError";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isIdentifier";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isFalseIdentifier";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

