/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.Stack;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.RemoveUnnecessaryBackslashQuickFix;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PyListLiteralExpression;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PySetLiteralExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyUnnecessaryBackslashInspection
extends PyInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.unnecessary.backslash", new Object[0]);
        if (string == null) {
            PyUnnecessaryBackslashInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session2) {
        if (holder == null) {
            PyUnnecessaryBackslashInspection.$$$reportNull$$$0(1);
        }
        if (session2 == null) {
            PyUnnecessaryBackslashInspection.$$$reportNull$$$0(2);
        }
        Visitor visitor2 = new Visitor(holder, session2);
        if (visitor2 == null) {
            PyUnnecessaryBackslashInspection.$$$reportNull$$$0(3);
        }
        return visitor2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PyUnnecessaryBackslashInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PyUnnecessaryBackslashInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Visitor
    extends PyInspectionVisitor {
        public Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session2) {
            if (session2 == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, session2);
        }

        @Override
        public void visitPyParameterList(PyParameterList list2) {
            this.findProblem((PsiElement)list2);
        }

        @Override
        public void visitPyArgumentList(PyArgumentList list2) {
            this.findProblem((PsiElement)list2);
        }

        @Override
        public void visitPyTupleExpression(PyTupleExpression node) {
            if (node.getParent() instanceof PyParenthesizedExpression) {
                this.findProblem((PsiElement)node);
            }
        }

        @Override
        public void visitPyParenthesizedExpression(PyParenthesizedExpression expression) {
            Stack stack = new Stack();
            stack.push((Object)expression);
            while (!stack.isEmpty()) {
                PsiElement element = (PsiElement)stack.pop();
                if (element instanceof PyTupleExpression) continue;
                this.findProblem(element);
                if (element == null) continue;
                for (PsiElement psiElement : element.getChildren()) {
                    stack.push((Object)psiElement);
                }
            }
        }

        @Override
        public void visitPyDictLiteralExpression(PyDictLiteralExpression expression) {
            this.findProblem((PsiElement)expression);
        }

        @Override
        public void visitPyListLiteralExpression(PyListLiteralExpression expression) {
            this.findProblem((PsiElement)expression);
        }

        @Override
        public void visitPySetLiteralExpression(PySetLiteralExpression expression) {
            this.findProblem((PsiElement)expression);
        }

        @Override
        public void visitPyStringLiteralExpression(PyStringLiteralExpression stringLiteralExpression) {
            PsiElement parent = stringLiteralExpression.getParent();
            if (parent instanceof PyListLiteralExpression || parent instanceof PyParenthesizedExpression || parent instanceof PySetLiteralExpression || parent instanceof PyKeyValueExpression || parent instanceof PyNamedParameter || parent instanceof PyArgumentList) {
                this.findProblem(stringLiteralExpression);
            }
        }

        private void findProblem(@Nullable PsiElement expression) {
            PsiWhiteSpace[] children2 = (PsiWhiteSpace[])PsiTreeUtil.getChildrenOfType((PsiElement)expression, PsiWhiteSpace.class);
            if (children2 != null) {
                for (PsiWhiteSpace ws : children2) {
                    if (!ws.getText().contains("\\")) continue;
                    this.registerProblem((PsiElement)ws, "Unnecessary backslash in expression.", new RemoveUnnecessaryBackslashQuickFix());
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyUnnecessaryBackslashInspection$Visitor", "<init>"));
        }
    }
}

