/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.containers.UtilKt;
import com.jetbrains.python.codeInsight.typing.PyProtocolsKt;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.PyProtocolInspection;
import com.jetbrains.python.inspections.PyProtocolInspection$Visitor$checkCompatibility$;
import com.jetbrains.python.inspections.PyProtocolInspection$Visitor$checkMemberCompatibility$;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyKnownDecoratorUtil;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveUtil;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/python/inspections/PyProtocolInspection;", "Lcom/jetbrains/python/inspections/PyInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "Visitor", "intellij.python.community.impl"})
public final class PyProtocolInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session2) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
        return new Visitor(holder, session2);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\fH\u0002J.\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\nH\u0002J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J \u0010\u0017\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\fH\u0002J\u0010\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0012\u0010\u0019\u001a\u00020\b2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\u0012\u0010\u001a\u001a\u00020\b2\b\u0010\u0015\u001a\u0004\u0018\u00010\u001bH\u0016\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/python/inspections/PyProtocolInspection$Visitor;", "Lcom/jetbrains/python/inspections/PyInspectionVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "(Lcom/intellij/codeInspection/ProblemsHolder;Lcom/intellij/codeInspection/LocalInspectionToolSession;)V", "checkCompatibility", "", "type", "Lcom/jetbrains/python/psi/types/PyClassType;", "superClassTypes", "", "Lcom/jetbrains/python/psi/types/PyClassLikeType;", "checkMemberCompatibility", "protocolElement", "Lcom/jetbrains/python/psi/PyTypedElement;", "subclassElements", "Lcom/jetbrains/python/psi/resolve/RatedResolveResult;", "protocol", "checkNewTypeWithProtocols", "node", "Lcom/jetbrains/python/psi/PyCallExpression;", "checkProtocolBases", "checkRuntimeProtocolInIsInstance", "visitPyCallExpression", "visitPyClass", "Lcom/jetbrains/python/psi/PyClass;", "intellij.python.community.impl"})
    private static final class Visitor
    extends PyInspectionVisitor {
        @Override
        public void visitPyClass(@Nullable PyClass node) {
            PyType pyType;
            PyType pyType2;
            super.visitPyClass(node);
            PyClass pyClass = node;
            if (pyClass != null) {
                PyClass pyClass2;
                PyClass it = pyClass2 = pyClass;
                pyType2 = this.myTypeEvalContext.getType(it);
            } else {
                pyType2 = pyType = null;
            }
            if (!(pyType2 instanceof PyClassType)) {
                pyType = null;
            }
            PyClassType pyClassType = (PyClassType)pyType;
            if (pyClassType == null) {
                return;
            }
            PyClassType type = pyClassType;
            List<PyClassLikeType> list2 = type.getSuperClassTypes(this.myTypeEvalContext);
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"type.getSuperClassTypes(myTypeEvalContext)");
            List<PyClassLikeType> superClassTypes = list2;
            this.checkCompatibility(type, superClassTypes);
            this.checkProtocolBases(type, superClassTypes);
        }

        @Override
        public void visitPyCallExpression(@Nullable PyCallExpression node) {
            super.visitPyCallExpression(node);
            if (node == null) {
                return;
            }
            this.checkRuntimeProtocolInIsInstance(node);
            this.checkNewTypeWithProtocols(node);
        }

        private final void checkCompatibility(PyClassType type, List<? extends PyClassLikeType> superClassTypes) {
            Sequence $receiver$iv = CollectionsKt.asSequence((Iterable)superClassTypes);
            Sequence sequence = SequencesKt.filter((Sequence)$receiver$iv, (Function1)Visitor$checkCompatibility$$inlined$filterIsInstance$1.INSTANCE);
            if (sequence == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
            }
            $receiver$iv = SequencesKt.filter((Sequence)sequence, (Function1)((Function1)new Function1<PyClassType, Boolean>(this){
                final /* synthetic */ Visitor this$0;

                public final boolean invoke(@NotNull PyClassType it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    PyClassLikeType pyClassLikeType = it;
                    TypeEvalContext typeEvalContext = this.this$0.myTypeEvalContext;
                    Intrinsics.checkExpressionValueIsNotNull((Object)typeEvalContext, (String)"myTypeEvalContext");
                    return PyProtocolsKt.isProtocol(pyClassLikeType, typeEvalContext);
                }
                {
                    this.this$0 = visitor2;
                    super(1);
                }
            }));
            for (Object element$iv : $receiver$iv) {
                PyClassType protocol = (PyClassType)element$iv;
                TypeEvalContext typeEvalContext = this.myTypeEvalContext;
                Intrinsics.checkExpressionValueIsNotNull((Object)typeEvalContext, (String)"myTypeEvalContext");
                Iterable $receiver$iv2 = PyProtocolsKt.inspectProtocolSubclass(protocol, type, typeEvalContext);
                for (Object element$iv2 : $receiver$iv2) {
                    Pair it = (Pair)element$iv2;
                    List subclassElements = (List)it.getSecond();
                    if (UtilKt.isNullOrEmpty((Collection)subclassElements)) continue;
                    PyTypedElement pyTypedElement = (PyTypedElement)it.getFirst();
                    List list2 = subclassElements;
                    if (list2 == null) {
                        Intrinsics.throwNpe();
                    }
                    this.checkMemberCompatibility(pyTypedElement, list2, type, protocol);
                }
            }
        }

        private final void checkProtocolBases(PyClassType type, List<? extends PyClassLikeType> superClassTypes) {
            boolean bl;
            block5: {
                PyClassLikeType pyClassLikeType = type;
                TypeEvalContext typeEvalContext = this.myTypeEvalContext;
                Intrinsics.checkExpressionValueIsNotNull((Object)typeEvalContext, (String)"myTypeEvalContext");
                if (!PyProtocolsKt.isProtocol(pyClassLikeType, typeEvalContext)) {
                    return;
                }
                Function1 correctBase2 = (Function1)new Function1<PyClassLikeType, Boolean>(this){
                    final /* synthetic */ Visitor this$0;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final boolean invoke(@Nullable PyClassLikeType it) {
                        if (it == null) {
                            return true;
                        }
                        String classQName = it.getClassQName();
                        if (Intrinsics.areEqual((Object)classQName, (Object)"typing.Protocol")) return true;
                        if (Intrinsics.areEqual((Object)classQName, (Object)"typing_extensions.Protocol")) return true;
                        if (!(it instanceof PyClassType)) return false;
                        TypeEvalContext typeEvalContext = this.this$0.myTypeEvalContext;
                        Intrinsics.checkExpressionValueIsNotNull((Object)typeEvalContext, (String)"myTypeEvalContext");
                        if (!PyProtocolsKt.isProtocol(it, typeEvalContext)) return false;
                        return true;
                    }
                    {
                        this.this$0 = visitor2;
                        super(1);
                    }
                };
                Iterable $receiver$iv = superClassTypes;
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        if (((Boolean)correctBase2.invoke(element$iv)).booleanValue()) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
            }
            if (!bl) {
                PyClass pyClass = type.getPyClass();
                Intrinsics.checkExpressionValueIsNotNull((Object)pyClass, (String)"type.pyClass");
                this.registerProblem(pyClass.getNameIdentifier(), "All bases of a protocol must be protocols");
            }
        }

        private final void checkRuntimeProtocolInIsInstance(PyCallExpression node) {
            if (node.isCalleeText("isinstance", "issubclass")) {
                PyType type;
                Object it;
                Object element$iv;
                Iterator iterator;
                Object $receiver$iv;
                Object[] objectArray = node.getArguments();
                Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"node.arguments");
                PyExpression pyExpression = (PyExpression)ArraysKt.getOrNull((Object[])objectArray, (int)1);
                if (pyExpression == null) {
                    return;
                }
                PyExpression base = pyExpression;
                if (base instanceof PyReferenceExpression) {
                    boolean bl;
                    block11: {
                        List<QualifiedName> list2 = PyResolveUtil.resolveImportedElementQNameLocally((PyReferenceExpression)base);
                        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"PyResolveUtil.resolveImp\u2026ElementQNameLocally(base)");
                        Sequence qNames2 = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list2), (Function1)checkRuntimeProtocolInIsInstance.qNames.1.INSTANCE);
                        $receiver$iv = qNames2;
                        iterator = $receiver$iv.iterator();
                        while (iterator.hasNext()) {
                            element$iv = iterator.next();
                            it = (String)element$iv;
                            if (!(Intrinsics.areEqual((Object)it, (Object)"typing.Protocol") || Intrinsics.areEqual((Object)it, (Object)"typing_extensions.Protocol"))) continue;
                            bl = true;
                            break block11;
                        }
                        bl = false;
                    }
                    if (bl) {
                        this.registerProblem((PsiElement)base, "Only @runtime protocols can be used with instance and class checks", ProblemHighlightType.GENERIC_ERROR);
                        return;
                    }
                }
                if ((type = this.myTypeEvalContext.getType(base)) instanceof PyClassType) {
                    PyClassLikeType pyClassLikeType = (PyClassLikeType)type;
                    TypeEvalContext typeEvalContext = this.myTypeEvalContext;
                    Intrinsics.checkExpressionValueIsNotNull((Object)typeEvalContext, (String)"myTypeEvalContext");
                    if (PyProtocolsKt.isProtocol(pyClassLikeType, typeEvalContext)) {
                        boolean bl;
                        block12: {
                            List<PyKnownDecoratorUtil.KnownDecorator> list3 = PyKnownDecoratorUtil.getKnownDecorators(((PyClassType)type).getPyClass(), this.myTypeEvalContext);
                            Intrinsics.checkExpressionValueIsNotNull(list3, (String)"PyKnownDecoratorUtil.get\u2026Class, myTypeEvalContext)");
                            $receiver$iv = list3;
                            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                                bl = false;
                            } else {
                                iterator = $receiver$iv.iterator();
                                while (iterator.hasNext()) {
                                    element$iv = iterator.next();
                                    it = (PyKnownDecoratorUtil.KnownDecorator)((Object)element$iv);
                                    if (!(it == PyKnownDecoratorUtil.KnownDecorator.TYPING_RUNTIME || it == PyKnownDecoratorUtil.KnownDecorator.TYPING_RUNTIME_EXT)) continue;
                                    bl = true;
                                    break block12;
                                }
                                bl = false;
                            }
                        }
                        if (!bl) {
                            this.registerProblem((PsiElement)base, "Only @runtime protocols can be used with instance and class checks", ProblemHighlightType.GENERIC_ERROR);
                        }
                    }
                }
            }
        }

        private final void checkNewTypeWithProtocols(PyCallExpression node) {
            block4: {
                PyType type;
                PyCallable pyCallable;
                Object v2;
                block3: {
                    PyResolveContext resolveContext = PyResolveContext.noImplicits().withTypeEvalContext(this.myTypeEvalContext);
                    List<PyCallable> list2 = node.multiResolveCalleeFunction(resolveContext);
                    Intrinsics.checkExpressionValueIsNotNull(list2, (String)"node\n        .multiResol\u2026eFunction(resolveContext)");
                    Iterable $receiver$iv = list2;
                    for (Object element$iv : $receiver$iv) {
                        PyCallable it;
                        PyCallable pyCallable2 = it = (PyCallable)element$iv;
                        Intrinsics.checkExpressionValueIsNotNull((Object)pyCallable2, (String)"it");
                        if (!Intrinsics.areEqual((Object)pyCallable2.getQualifiedName(), (Object)"typing.NewType")) continue;
                        v2 = element$iv;
                        break block3;
                    }
                    v2 = null;
                }
                PyCallable pyCallable3 = v2;
                if (pyCallable3 == null) break block4;
                PyCallable it = pyCallable = pyCallable3;
                Object[] objectArray = node.getArguments();
                Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"node.arguments");
                PyExpression base = (PyExpression)ArraysKt.getOrNull((Object[])objectArray, (int)1);
                if (base != null && (type = this.myTypeEvalContext.getType(base)) instanceof PyClassLikeType) {
                    PyClassLikeType pyClassLikeType = (PyClassLikeType)type;
                    TypeEvalContext typeEvalContext = this.myTypeEvalContext;
                    Intrinsics.checkExpressionValueIsNotNull((Object)typeEvalContext, (String)"myTypeEvalContext");
                    if (PyProtocolsKt.isProtocol(pyClassLikeType, typeEvalContext)) {
                        this.registerProblem((PsiElement)base, "NewType cannot be used with protocol classes");
                    }
                }
            }
        }

        private final void checkMemberCompatibility(PyTypedElement protocolElement, List<? extends RatedResolveResult> subclassElements, PyClassType type, PyClassType protocol) {
            Sequence $receiver$iv;
            PyType expectedMemberType = this.myTypeEvalContext.getType(protocolElement);
            Sequence sequence = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)subclassElements), (Function1)checkMemberCompatibility.1.INSTANCE);
            Sequence sequence2 = SequencesKt.filter((Sequence)$receiver$iv, (Function1)Visitor$checkMemberCompatibility$$inlined$filterIsInstance$1.INSTANCE);
            if (sequence2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
            }
            $receiver$iv = SequencesKt.filterNot((Sequence)SequencesKt.filter((Sequence)sequence2, (Function1)((Function1)new Function1<PyTypedElement, Boolean>(type){
                final /* synthetic */ PyClassType $type;

                public final boolean invoke(@NotNull PyTypedElement it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    PsiFile psiFile = it.getContainingFile();
                    PyClass pyClass = this.$type.getPyClass();
                    Intrinsics.checkExpressionValueIsNotNull((Object)pyClass, (String)"type.pyClass");
                    return Intrinsics.areEqual((Object)psiFile, (Object)pyClass.getContainingFile());
                }
                {
                    this.$type = pyClassType;
                    super(1);
                }
            })), (Function1)((Function1)new Function1<PyTypedElement, Boolean>(this, expectedMemberType){
                final /* synthetic */ Visitor this$0;
                final /* synthetic */ PyType $expectedMemberType;

                public final boolean invoke(@NotNull PyTypedElement it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return PyTypeChecker.match(this.$expectedMemberType, this.this$0.myTypeEvalContext.getType(it), this.this$0.myTypeEvalContext);
                }
                {
                    this.this$0 = visitor2;
                    this.$expectedMemberType = pyType;
                    super(1);
                }
            }));
            for (Object element$iv : $receiver$iv) {
                PyTypedElement it = (PyTypedElement)element$iv;
                PsiElement place = it instanceof PsiNameIdentifierOwner ? ((PsiNameIdentifierOwner)it).getNameIdentifier() : (PsiElement)it;
                this.registerProblem(place, "Type of '" + it.getName() + "' is incompatible with '" + protocol.getName() + '\'');
            }
        }

        public Visitor(@NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session2) {
            Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
            Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
            super(holder, session2);
        }
    }
}

