/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation.doctest;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.documentation.doctest.PyDocstringTokenTypes;
import com.jetbrains.python.parsing.ExpressionParsing;
import com.jetbrains.python.parsing.ParsingContext;
import com.jetbrains.python.parsing.StatementParsing;
import com.jetbrains.python.psi.LanguageLevel;
import org.jetbrains.annotations.Nullable;

public class PyDocstringParsingContext
extends ParsingContext {
    private final StatementParsing myStatementParser;
    private final ExpressionParsing myExpressionParser;

    public PyDocstringParsingContext(PsiBuilder builder2, LanguageLevel languageLevel, StatementParsing.FUTURE futureFlag) {
        super(builder2, languageLevel, futureFlag);
        this.myStatementParser = new PyDocstringStatementParsing(this, futureFlag);
        this.myExpressionParser = new PyDocstringExpressionParsing(this);
    }

    @Override
    public ExpressionParsing getExpressionParser() {
        return this.myExpressionParser;
    }

    @Override
    public StatementParsing getStatementParser() {
        return this.myStatementParser;
    }

    private static class PyDocstringStatementParsing
    extends StatementParsing {
        protected PyDocstringStatementParsing(ParsingContext context, @Nullable StatementParsing.FUTURE futureFlag) {
            super(context, futureFlag);
        }

        @Override
        protected IElementType getReferenceType() {
            return PyDocstringTokenTypes.DOC_REFERENCE;
        }

        @Override
        public IElementType filter(IElementType source, int start, int end, CharSequence text2) {
            if (source == PyTokenTypes.DOT && CharArrayUtil.regionMatches((CharSequence)text2, (int)start, (int)end, (CharSequence)"...")) {
                return PyDocstringTokenTypes.DOTS;
            }
            if (source == PyTokenTypes.GTGT && CharArrayUtil.regionMatches((CharSequence)text2, (int)start, (int)end, (CharSequence)">>>")) {
                return PyTokenTypes.SPACE;
            }
            return super.filter(source, start, end, text2);
        }
    }

    private static class PyDocstringExpressionParsing
    extends ExpressionParsing {
        public PyDocstringExpressionParsing(ParsingContext context) {
            super(context);
        }

        @Override
        protected IElementType getReferenceType() {
            return PyDocstringTokenTypes.DOC_REFERENCE;
        }
    }
}

