/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.google.common.collect.Lists;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.jetbrains.python.console.PythonDebugLanguageConsoleView;
import com.jetbrains.python.run.PythonTracebackFilter;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyDebugConsoleBuilder
extends TextConsoleBuilder {
    private final Project myProject;
    private final ArrayList<Filter> myFilters = Lists.newArrayList();
    private final Sdk mySdk;

    public PyDebugConsoleBuilder(Project project, @Nullable Sdk sdk) {
        this.myProject = project;
        this.mySdk = sdk;
    }

    public ConsoleView getConsole() {
        ConsoleView consoleView = this.createConsole();
        for (Filter filter : this.myFilters) {
            consoleView.addMessageFilter(filter);
        }
        return consoleView;
    }

    protected ConsoleView createConsole() {
        PythonDebugLanguageConsoleView consoleView = new PythonDebugLanguageConsoleView(this.myProject, this.mySdk);
        consoleView.addMessageFilter(new PythonTracebackFilter(this.myProject));
        return consoleView;
    }

    public void addFilter(@NotNull Filter filter) {
        if (filter == null) {
            PyDebugConsoleBuilder.$$$reportNull$$$0(0);
        }
        this.myFilters.add(filter);
    }

    public void setViewer(boolean isViewer) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/jetbrains/python/console/PyDebugConsoleBuilder", "addFilter"));
    }
}

